/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.enums.VoucherAmortStatus;
import kd.fi.gl.enums.VoucherRelationTypeEnum;
import kd.fi.gl.util.QFBuilder;

public class VoucherAmortStatusChecker
implements IClosePeriodCheckPlugin {
    private static final String KEY_ISADJUSTPERIOD = "isadjustperiod";
    private static final String KEY_BOOKSTYPE = "accountbooks";

    private QFilter getPeriodFilter(long periodTypeId, long periodId) {
        String startPeriodTypeField = "startperiod.periodtype";
        String startPeriodField = "startperiod";
        QFilter startLessCurPeriod = new QFilter(startPeriodTypeField, "=", (Object)periodTypeId).and(new QFilter(startPeriodField, "<=", (Object)periodId));
        return startLessCurPeriod;
    }

    public CheckResult execute(CheckContext context) throws Throwable {
        CheckResult checkResult = new CheckResult();
        checkResult.setIsSuccess(true);
        QFilter idFilter = new QFilter("id", "=", (Object)context.getPeriodId());
        QFilter notAdjustFilter = new QFilter(KEY_ISADJUSTPERIOD, "=", (Object)"0");
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodtype", (QFilter[])new QFilter[]{idFilter, notAdjustFilter});
        if (period != null) {
            QFilter orgFilter = new QFilter("org", "=", (Object)context.getOrgId());
            QFilter bookTypeFilter = new QFilter(KEY_BOOKSTYPE, "=", (Object)Long.valueOf(context.getSubBizAppId()));
            QFilter enableFilter = new QFilter(VoucherAmortStatus.ENABLE.getField(), "=", (Object)VoucherAmortStatus.ENABLE.getValue());
            QFilter ongoingFilter = new QFilter(VoucherAmortStatus.FINISH.getField(), "!=", (Object)VoucherAmortStatus.FINISH.getValue());
            QFilter periodFilter = this.getPeriodFilter(period.getLong("periodtype"), context.getPeriodId());
            List unFinishSchemes = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucheramortacheme", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, enableFilter, ongoingFilter, periodFilter}, null, (int)-1);
            if (!unFinishSchemes.isEmpty()) {
                QFilter typeFilter = new QFilter("type", "=", (Object)VoucherRelationTypeEnum.VOUCHER_AMORTIZATION.getValue());
                QFilter srcEntityFilter = new QFilter("srcentity", "in", (Object)unFinishSchemes);
                QFilter periodLargeFilter = new QFilter("period", ">=", (Object)context.getPeriodId());
                DynamicObjectCollection amortSchemeDyns = QueryServiceHelper.query((String)"gl_voucherrelation", (String)"srcentity", (QFilter[])new QFilter[]{typeFilter, srcEntityFilter, periodLargeFilter});
                List amortSchemes = amortSchemeDyns.stream().map(x -> x.get("srcentity")).distinct().collect(Collectors.toList());
                unFinishSchemes.removeAll(amortSchemes);
                List mayErrPks = unFinishSchemes;
                List<String> errNumbers = this.excludeNormalCustomSchemes(mayErrPks, context.getPeriodId());
                if (!errNumbers.isEmpty()) {
                    ArrayList<String> errorMsg = new ArrayList<String>(1);
                    errorMsg.add(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u65b9\u6848\u672c\u671f\u672a\u751f\u6210\u51ed\u8bc1\uff1a%s\u3002", (String)"VoucherAmortStatusChecker_0", (String)"fi-gl-common", (Object[])new Object[0]), errNumbers));
                    checkResult.setIsSuccess(false);
                    checkResult.setMessages(errorMsg);
                } else {
                    checkResult.setIsSuccess(true);
                }
            }
        }
        return checkResult;
    }

    private List<String> excludeNormalCustomSchemes(Collection<Object> errPks, Long periodId) {
        QFilter[] filters = new QFBuilder("id", "in", errPks).toArray();
        return Arrays.stream(BusinessDataServiceHelper.load((String)"gl_voucheramortacheme", (String)"custompolicies.cperiod,number,amortstyle", (QFilter[])filters)).filter(scheme -> !scheme.getString("amortstyle").equals("4") || scheme.getDynamicObjectCollection("custompolicies").stream().map(row -> row.getLong("cperiod_id")).collect(Collectors.toList()).contains(periodId)).map(scheme -> scheme.getString("number")).collect(Collectors.toList());
    }
}

