/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeperiod.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.closeperiod.ClosePeriodUtils;
import kd.fi.gl.util.GLBreakPointUtil;
import kd.fi.gl.util.voucher.VoucherNumberUtils;

public class VoucherConsistentChecker
implements IClosePeriodCheckPlugin {
    private static final Log LOGGER = LogFactory.getLog(VoucherConsistentChecker.class);

    public CheckResult execute(CheckContext context) throws Throwable {
        CheckResult checkResult = new CheckResult();
        Long orgId = context.getOrgId();
        Long bookTypeId = Long.valueOf(context.getSubBizAppId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        map.put("booktype", bookTypeId);
        DynamicObject accountBook = ClosePeriodUtils.getAccountBook(orgId, bookTypeId, "curperiod");
        if (accountBook == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7ID%1$s\u4e0e\u8d26\u7c3f\u7c7b\u578bID%2$s\u5bf9\u5e94\u7684\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"VoucherConsistentChecker_0", (String)"fi-gl-common", (Object[])new Object[0]), String.valueOf(context.getOrgId()), String.valueOf(Long.valueOf(context.getSubBizAppId()))));
        }
        map.put("period", context.getPeriodId());
        LOGGER.info(ResManager.loadKDString((String)"\u51ed\u8bc1\u65ad\u53f7\u68c0\u67e5\u9879-\u7ed3\u8d26\u671f\u95f4:", (String)"VoucherConsistentChecker_1", (String)"fi-gl-common", (Object[])new Object[0]) + accountBook.getString("curperiod.id"));
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher");
        obj.set("billstatus", (Object)"B");
        obj.set("org", (Object)orgId);
        CodeRuleInfo coderule = VoucherNumberUtils.getCodeRuleInfo(orgId, "B");
        if (coderule == null) {
            checkResult.setIsSuccess(true);
        } else {
            DynamicObjectCollection ruleEntry = GLBreakPointUtil.getCodeRuleEntry(coderule);
            List<HashMap<String, String>> codeRuleEntryAttributes = GLBreakPointUtil.getAttributeFromCodeRuleEntry(ruleEntry);
            String[] consistent = GLBreakPointUtil.checkConsistent(coderule.getId(), codeRuleEntryAttributes, map, 0, coderule.getIsNonBreak());
            String isconsistent = consistent[0];
            LOGGER.info(ResManager.loadKDString((String)"\u51ed\u8bc1\u65ad\u53f7\u68c0\u67e5\u9879-\u662f\u5426\u65ad\u53f7:", (String)"VoucherConsistentChecker_2", (String)"fi-gl-common", (Object[])new Object[0]) + isconsistent);
            if ("0".equals(isconsistent)) {
                checkResult.setIsSuccess(false);
                checkResult.setOnlineViewId("gl_voucherbreakpoint");
                ArrayList<String> errorMsg = new ArrayList<String>(1);
                errorMsg.add(ResManager.loadKDString((String)"\u51ed\u8bc1\u5b58\u5728\u65ad\u53f7", (String)"VoucherConsistentChecker_3", (String)"fi-gl-common", (Object[])new Object[0]));
                checkResult.setMessages(errorMsg);
            } else {
                checkResult.setIsSuccess(true);
            }
        }
        return checkResult;
    }
}

