/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.comassist;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.util.CommonAssistUtil;

public class ComassistMidTransterModel {
    private Map<Integer, Map<Long, Long>> map = new HashMap<Integer, Map<Long, Long>>(10);
    private List<CommonAssist> list;

    public ComassistMidTransterModel(Long tableId) {
        ComAssistTable table = ComAssistTable.get(tableId);
        this.list = table.getCommonAssists();
    }

    public void buildData(Map<Integer, Set<Long>> data) {
        for (int i = 0; i < this.list.size(); ++i) {
            Map<Long, Long> idsMap = ComassistMidTransterModel.queryId2Mid(this.list.get((int)i).valueSource, data.get(i + 1));
            this.map.put(i + 1, idsMap);
        }
    }

    public long convertMid(int i, long id) {
        if (id == 0L) {
            return 0L;
        }
        return this.map.get(i).get(id) == null ? id : this.map.get(i).get(id);
    }

    private static Map<Long, Long> queryId2Mid(String entity, Set<Long> ids) {
        Objects.requireNonNull(entity);
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(100);
        boolean hasMasteridProp = CommonAssistUtil.hasMasteridProp(entity);
        if (!hasMasteridProp) {
            return idMap;
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)"comAssistId2Mid", (String)entity, (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
        ds.forEach(row -> idMap.put(row.getLong("id"), row.getLong("masterid")));
        return idMap;
    }
}

