/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.comassist.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.model.schema.basedata.AccountTableSchema;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.LocalCacheHelper;

public class ComAssistTable {
    private final Long acctTableID;
    private final List<CommonAssist> commonAssists;
    private final Map<String, CommonAssist> comAssistIndexer;
    private static final AccountTableSchema schema = AccountTableSchema.instance;

    private ComAssistTable(Long acctTableID) {
        this.acctTableID = acctTableID;
        DynamicObject acctTableDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)acctTableID, (String)"bd_accounttable", (String)Prop.toSelectFieldStr((Prop[])new Prop[]{ComAssistTable.schema.comAssistNumber, ComAssistTable.schema.comAssistName, ComAssistTable.schema.valueSourceType, ComAssistTable.schema.valueSource, ComAssistTable.schema.assistantValueSource, ComAssistTable.schema.isRequired, ComAssistTable.schema.isBalanced}));
        if (Objects.isNull(acctTableDyn)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u67e5\u8be2\u3002", (String)"ComAssistTable_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        DynamicObjectCollection commonAssistEntry = acctTableDyn.getDynamicObjectCollection("comassistentry");
        this.commonAssists = CommonAssist.createComAssist((DynamicObjectCollection)commonAssistEntry);
        this.comAssistIndexer = this.getCommonAssists().stream().collect(Collectors.toMap(commonAssist -> commonAssist.key, commonAssist -> commonAssist));
    }

    public Optional<CommonAssist> getCommonAssist(String comAssistKey) {
        return Optional.ofNullable(this.comAssistIndexer.get(comAssistKey));
    }

    public List<String> getAllCommonAssistKeys() {
        return this.commonAssists.stream().map(commonAssist -> commonAssist.key).collect(Collectors.toList());
    }

    public List<CommonAssist> getComAssistForGroup(boolean sumComAssist) {
        if (!sumComAssist) {
            return Collections.emptyList();
        }
        if (Boolean.parseBoolean(System.getProperty("fi.gl.balance.sumallcomasist", Boolean.TRUE.toString()))) {
            return this.getCommonAssists();
        }
        return this.commonAssists.stream().filter(commonAssist -> commonAssist.isBalanced).collect(Collectors.toList());
    }

    public List<String> getBalancedCommonAssistKeys() {
        return this.commonAssists.stream().filter(commonAssist -> commonAssist.isBalanced).map(commonAssist -> commonAssist.key).collect(Collectors.toList());
    }

    public static ComAssistTable get(Long acctTableID) {
        return (ComAssistTable)ThreadCache.get((Object)("CommonAssistTable#" + acctTableID), () -> new ComAssistTable(acctTableID), (boolean)true);
    }

    public static Optional<ComAssistTable> get(Long org, Long bookType) {
        AccountBookInfo bookFromAccSys = AccSysUtil.getBookFromAccSys(org, (long)bookType);
        if (bookFromAccSys != null && bookFromAccSys.getId() != 0L) {
            return Optional.ofNullable(ComAssistTable.get(bookFromAccSys.getAccountTableId()));
        }
        return Optional.empty();
    }

    public static List<String> getMaxCommonAssistKeys() {
        List keys = (List)ThreadCache.get((Object)"CommonAssistTable#maxKeys", () -> {
            AccountTableSchema schema = AccountTableSchema.instance;
            int maxSize = BusinessDataServiceHelper.loadFromCache((String)schema.entity, (String)schema.isBalanced.toFullName(), (QFilter[])new QFilter[0]).values().stream().mapToInt(dyo -> dyo.getDynamicObjectCollection(schema.comAssistEntry.toFullName()).size()).max().orElse(0);
            return IntStream.range(1, maxSize + 1).mapToObj(i -> "comassist" + i).collect(Collectors.toList());
        }, (boolean)true);
        return new ArrayList<String>(keys);
    }

    public static synchronized Map<Long, ComAssistTable> getAllFromCache() {
        CacheKey cacheKey = CacheKey.getCacheKey(CacheKeyPrefix.COMMON_ASSIST_CACHE, "getAllFromCache");
        ConcurrentHashMap<Long, ComAssistTable> cache = LocalCacheHelper.get(cacheKey, Map.class);
        if (cache == null) {
            try (DataSet dataSet = DB.queryDataSet((String)ComAssistTable.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (String)"select distinct fid from t_bd_comassistentry");){
                cache = new ConcurrentHashMap<Long, ComAssistTable>(4);
                for (Row row : dataSet) {
                    Long id = row.getLong(0);
                    cache.put(id, ComAssistTable.get(id));
                }
            }
            LocalCacheHelper.put(cacheKey, cache);
        }
        return cache;
    }

    public static Optional<ComAssistTable> tryGetMaxComAssist(Set<Long> orgIds, Set<Long> bookTypeIds) {
        if (CollectionUtils.isEmpty(orgIds) || CollectionUtils.isEmpty(bookTypeIds)) {
            return Optional.empty();
        }
        PerformanceWatch watch = new PerformanceWatch(ComAssistTable.class, "ComAssistTable#tryGetMaxComAssist", true);
        watch.start();
        Set<ComAssistTable> commonAssistTables = ComAssistTable.getCommonAssistTables(orgIds, bookTypeIds);
        if (CollectionUtils.isEmpty(commonAssistTables)) {
            return Optional.empty();
        }
        int maxComAssistCount = -1;
        Optional<ComAssistTable> maxComAssistTable = Optional.empty();
        for (ComAssistTable comAssistTable : commonAssistTables) {
            if (comAssistTable.getCommonAssists().size() <= maxComAssistCount) continue;
            maxComAssistCount = comAssistTable.getCommonAssists().size();
            maxComAssistTable = Optional.of(comAssistTable);
        }
        watch.stop();
        return maxComAssistTable;
    }

    public static Set<ComAssistTable> getCommonAssistTables(Set<Long> orgIds, Set<Long> bookTypeIds) {
        if (CollectionUtils.isEmpty(orgIds) || CollectionUtils.isEmpty(bookTypeIds)) {
            return new HashSet<ComAssistTable>(1);
        }
        PerformanceWatch watch = new PerformanceWatch(ComAssistTable.class, "ComAssistTable#getCommonAssistList", true);
        watch.start();
        Map<Long, ComAssistTable> allFromCache = ComAssistTable.getAllFromCache();
        if (allFromCache.isEmpty()) {
            return new HashSet<ComAssistTable>(1);
        }
        HashMap<Long, ComAssistTable> results = new HashMap<Long, ComAssistTable>();
        if (orgIds.size() <= 1000) {
            try (DataSet bookSet = QueryServiceHelper.queryDataSet((String)ComAssistTable.class.getName(), (String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter("org", "in", orgIds).and("bookstype", "in", bookTypeIds).toArray(), null);){
                for (Row row : bookSet) {
                    Long tableId = row.getLong(0);
                    if (results.containsKey(tableId)) continue;
                    results.put(tableId, allFromCache.get(tableId));
                }
            }
        }
        HashSet<Long> accountTableIds = new HashSet<Long>(allFromCache.keySet());
        try (DataSet bookSet = QueryServiceHelper.queryDataSet((String)ComAssistTable.class.getName(), (String)"gl_accountbook", (String)"org,bookstype,accounttable", (QFilter[])new QFilter("accounttable", "in", accountTableIds).toArray(), null);){
            for (Row row : bookSet) {
                Long tableId = row.getLong(2);
                if (results.containsKey(tableId) || !orgIds.contains(row.getLong(0)) || !bookTypeIds.contains(row.getLong(1))) continue;
                results.put(tableId, allFromCache.get(tableId));
            }
        }
        Set<ComAssistTable> comAssistTables = results.values().stream().filter(Objects::nonNull).collect(Collectors.toSet());
        watch.stop();
        return comAssistTables;
    }

    public Long getAcctTableID() {
        return this.acctTableID;
    }

    public final List<CommonAssist> getCommonAssists() {
        return new LinkedList<CommonAssist>(this.commonAssists);
    }

    public boolean existCommonAssists() {
        return !this.commonAssists.isEmpty();
    }

    public List<CommonAssist> getBalancedCommonAssists() {
        return this.commonAssists.stream().filter(commonAssist -> commonAssist.isBalanced).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComAssistTable that = (ComAssistTable)o;
        return Objects.equals(this.acctTableID, that.acctTableID);
    }

    public int hashCode() {
        return Objects.hash(this.acctTableID);
    }
}

