/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.comassist.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ControlContext;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.util.CommonAssistUtil;

public class ComAssistTableService {
    public static EntityType simpleModifyEntityType(ComAssistTable comAssistTable, EntityType oldType) {
        comAssistTable.getCommonAssists().forEach(commonAssist -> ((MainEntityType)oldType).getAllFields().keySet().stream().filter(k -> k.startsWith(commonAssist.key)).forEach(comAssistKey -> Optional.ofNullable(oldType.findProperty(comAssistKey)).ifPresent(prop -> ComAssistService.modifyCommonAssistProp(commonAssist, prop))));
        return oldType;
    }

    public static EntityType modifyEntityType(ComAssistTable comAssistTable, EntityType oldType) {
        EntityType newType;
        try {
            newType = (EntityType)oldType.clone();
            ((MainEntityType)newType).clearRefEntityTypeVer();
            ((MainEntityType)newType).clearSubEntityTypecache();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        return ComAssistTableService.simpleModifyEntityType(comAssistTable, newType);
    }

    public static List<ListField> modifyListFields(ComAssistTable comAssistTable, List<ListField> fields) {
        fields.stream().filter(field -> field.getKey().contains("comassist")).forEach(field -> {
            Optional<CommonAssist> optionalCommonAssist = comAssistTable.getCommonAssist(field.getKey().split("\\.")[0]);
            if (optionalCommonAssist.isPresent()) {
                ComAssistService.modifyListField(optionalCommonAssist.get(), field);
            } else {
                field.setVisible(false);
            }
        });
        return fields;
    }

    public static void modifyCommonAssistFields(ComAssistTable comAssistTable, IFormView view) {
        boolean isBillView = view instanceof BillView || view instanceof FormView && !(view instanceof ReportView);
        List<String> allComAssistKeys = view.getModel().getDataEntityType().getAllFields().keySet().stream().filter(field -> field.startsWith("comassist")).collect(Collectors.toList());
        int comAssistKeysCount = allComAssistKeys.size();
        if (comAssistTable != null) {
            comAssistTable.getCommonAssists().forEach(commonAssist -> {
                Optional.ofNullable(view.getControl(commonAssist.key)).map(BasedataEdit.class::cast).ifPresent(commonAssistEdit -> {
                    ComAssistService.modifyCommonAssistField(commonAssist, commonAssistEdit);
                    commonAssistEdit.setMustInput(isBillView && commonAssist.isRequired);
                });
                view.setVisible(Boolean.valueOf(true), new String[]{commonAssist.key});
                allComAssistKeys.remove(commonAssist.key);
            });
        }
        view.setVisible(Boolean.valueOf(false), allComAssistKeys.toArray(new String[0]));
        if (view instanceof ReportView) {
            view.setVisible(Boolean.valueOf(comAssistKeysCount != allComAssistKeys.size()), new String[]{"showcomassist"});
        }
    }

    public static void registerF7Listener(ComAssistTable comAssistTable, BillView view) {
        comAssistTable.getCommonAssists().stream().map(commonAssist -> view.getControl(commonAssist.key)).map(BasedataEdit.class::cast).forEach(comAssistEdit -> comAssistEdit.addBeforeF7SelectListener(ComAssistService.F7Listener));
    }

    public static void modifyListColumn(ComAssistTable comAssistTable, List<IListColumn> columns) {
        HashSet toRemove = new HashSet(2);
        columns.stream().filter(ListColumn.class::isInstance).map(ListColumn.class::cast).filter(column -> column.getFieldKey().startsWith("comassist")).forEach(comAssistColumn -> {
            if (comAssistTable != null) {
                Optional<CommonAssist> optionalCommonAssist = comAssistTable.getCommonAssist(comAssistColumn.getFieldKey().split("\\.")[0]);
                if (optionalCommonAssist.isPresent()) {
                    ComAssistService.modifyListColumn(optionalCommonAssist.get(), (IListColumn)comAssistColumn);
                } else {
                    comAssistColumn.setVisible(0);
                    toRemove.add(comAssistColumn);
                }
            } else {
                comAssistColumn.setVisible(0);
                toRemove.add(comAssistColumn);
            }
        });
        columns.removeAll(toRemove);
    }

    public static void modifyReportColumn(ComAssistTable comAssistTable, List<ReportColumn> columns) {
        columns.forEach(column -> {
            String fieldKey = column.getFieldKey();
            if (fieldKey.startsWith("comassist")) {
                String comAssistKey = fieldKey.replace("id", "");
                Optional<CommonAssist> optionalCommonAssist = comAssistTable.getCommonAssist(comAssistKey);
                if (optionalCommonAssist.isPresent()) {
                    column.setHide(false);
                    column.setCaption(optionalCommonAssist.get().getLocaleName());
                } else {
                    column.setHide(true);
                }
            }
        });
    }

    public static List<CommonFilterColumn> getCommonFilterColumns(ComAssistTable comAssistTable, ListView view) {
        FilterContainer filterContainer = (FilterContainer)view.getControl("filtercontainerap");
        MainEntityType entityType = filterContainer.getEntityType();
        ControlContext controlContext = filterContainer.getContext();
        return comAssistTable.getCommonAssists().stream().filter(commonAssist -> CommonAssistUtil.showSpecifyFilter(commonAssist, view.getBillFormId())).map(commonAssist -> ComAssistService.mapToCommonFilterColumn(commonAssist, entityType, view, controlContext)).collect(Collectors.toList());
    }

    private static List<QFilter> getComAssistFilters(ComAssistTable comAssistTable, List<Long> permOrgs, BiFunction<String, CommonAssist, Set<Long>> valueGetter, Function<String, String> propGetter, String pkField) {
        LinkedList<QFilter> res = new LinkedList<QFilter>();
        for (CommonAssist commonAssist : comAssistTable.getCommonAssists()) {
            Set<Long> selectedValues = valueGetter.apply(pkField, commonAssist);
            if (CollectionUtils.isNotEmpty(selectedValues)) {
                res.add(new QFilter(propGetter.apply(commonAssist.key), "in", selectedValues));
                continue;
            }
            ComAssistService.getDataPermIds(commonAssist, permOrgs, pkField).map(pks -> new QFilter((String)propGetter.apply(commonAssist.key), "in", pks)).ifPresent(res::add);
        }
        return res;
    }

    public static List<QFilter> getComAssistFilters(ComAssistTable comAssistTable, List<Long> permOrgs, FilterInfo filterInfo, Function<String, String> propGetter, String pkField) {
        return ComAssistTableService.getComAssistFilters(comAssistTable, permOrgs, (String field, CommonAssist comAssist) -> {
            DynamicObjectCollection dyos = filterInfo.getDynamicObjectCollection(comAssist.key);
            Set<Object> ids = new HashSet();
            if (CollectionUtils.isNotEmpty((Collection)dyos)) {
                ids = dyos.stream().map(o -> o.getLong(field)).collect(Collectors.toSet());
            }
            return ids;
        }, propGetter, pkField);
    }
}

