/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.exception.KDExceptionBuilder;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.VoucherEntryCollection;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.util.DateUtil;

public class VoucherInfo {
    private static final String SUFFIX_ID = "_id";
    private DynamicObject dynObj;
    private VoucherEntryCollection entries;
    private Map<Object, Object> expand;
    private int entrySeq = 1;
    private static final Log logger = LogFactory.getLog(VoucherInfo.class);
    private boolean bigEntryMode = false;

    public VoucherInfo() {
        this((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_voucher"));
    }

    private VoucherInfo(DynamicObjectType dt) {
        this.dynObj = new DynamicObject(dt);
        this.setAndGetPK();
        this.entries = new VoucherEntryCollection(this);
    }

    public DynamicObject toDynamicObject() {
        return this.dynObj;
    }

    public VoucherEntryInfo createNewEntry() {
        try {
            DynamicObjectCollection objColl = this.dynObj.getDynamicObjectCollection("entries");
            VoucherEntryInfo entry = VoucherEntryInfo.newEntryInfo(objColl.getDynamicObjectType());
            this.entries.add(entry);
            entry.setSeq(this.entrySeq++);
            return entry;
        }
        catch (Exception e) {
            logger.error("createNewEntry_error,entries.size(): {}", (Object)this.entries.size(), (Object)e);
            throw e;
        }
    }

    public Map<Object, Object> getExpand() {
        return this.expand;
    }

    public void setExpand(Map<Object, Object> p) {
        this.expand = p;
    }

    public Object getAttr(Object t) {
        if (this.expand == null) {
            return null;
        }
        return this.expand.get(t);
    }

    public void setAttr(Object k, Object v) {
        if (this.expand != null) {
            this.expand.put(k, v);
        }
    }

    public void setPeriod(Long id) {
        this.dynObj.set("period_id", (Object)id);
    }

    public Long getPeriod() {
        return this.dynObj.getLong("period_id");
    }

    public void setOrg(Long id) {
        this.dynObj.set("org_id", (Object)id);
        this.setBook();
    }

    public Long getOrg() {
        return this.dynObj.getLong("org_id");
    }

    public void setBookType(Long id) {
        this.dynObj.set("booktype_id", (Object)id);
        this.setBook();
    }

    public Long getBookType() {
        return this.dynObj.getLong("booktype_id");
    }

    private void setBook() {
        long org = this.getOrg();
        long bookType = this.getBookType();
        if (org != 0L && bookType != 0L) {
            AccountBookInfo book = AccSysUtil.getBookFromAccSys(org, bookType);
            this.dynObj.set("book_id", (Object)book.getId());
            this.dynObj.set("localcur_id", (Object)book.getBaseCurrencyId());
        }
    }

    public Long getBook() {
        return this.dynObj.getLong("book_id");
    }

    public void setStatus(String status) {
        this.dynObj.set("billstatus", (Object)status);
    }

    public String getStatus() {
        return this.dynObj.getString("billstatus");
    }

    public void setVoucherType(Long id) {
        this.dynObj.set("vouchertype_id", (Object)id);
    }

    public void setMulCur(Collection<LocalCurrencyConfigVO> configs) {
        for (LocalCurrencyConfigVO configVO : configs) {
            String curField = configVO.getVoucherField(MCT.CURRENCY).getMetaId();
            this.dynObj.set(curField + SUFFIX_ID, (Object)configVO.getCurrencyId(this.getOrg().longValue(), this.getBookType().longValue()));
        }
    }

    public Long getVoucherType() {
        return this.dynObj.getLong("vouchertype_id");
    }

    public void setCreator(Long id) {
        this.dynObj.set("creator_id", (Object)id);
    }

    public Long getCreator() {
        return this.dynObj.getLong("creator_id");
    }

    public void setAuditor(Long id) {
        this.dynObj.set("auditor_id", (Object)id);
    }

    public Long getAuditor() {
        return this.dynObj.getLong("auditor_id");
    }

    public void setCashier(Long id) {
        this.dynObj.set("cashier_id", (Object)id);
    }

    public Long getCashier() {
        return this.dynObj.getLong("cashier_id");
    }

    public void setPoster(Long id) {
        this.dynObj.set("poster_id", (Object)id);
    }

    public Long getPoster() {
        return this.dynObj.getLong("poster_id");
    }

    public int getAttachMent() {
        return this.dynObj.getInt("attachment");
    }

    public void setAttachMent(int c) {
        this.dynObj.set("attachment", (Object)c);
    }

    public void setBizDate(Date date) {
        this.dynObj.set("bizdate", (Object)DateUtil.makeDateOnDayStrart(date));
    }

    public Date getBizDate() {
        return this.dynObj.getDate("bizdate");
    }

    public void setBookedDate(Date date) {
        this.dynObj.set("bookeddate", (Object)DateUtil.makeDateOnDayStrart(date));
    }

    public Date getBookedDate() {
        return this.dynObj.getDate("bookeddate");
    }

    public String getNum() {
        return this.dynObj.getString("billno");
    }

    public void setNum(String num) {
        this.dynObj.set("billno", (Object)num);
    }

    public void setDesc(String desc) {
        this.dynObj.set("description", (Object)desc);
    }

    public String getDesc() {
        return this.dynObj.getString("description");
    }

    public void setVDesc(String desc) {
        this.dynObj.set("vdescription", (Object)desc);
    }

    public String getVDesc() {
        return this.dynObj.getString("vdescription");
    }

    public void setDebitLocAmt(BigDecimal total) {
        this.dynObj.set("debitlocamount", (Object)total);
    }

    public BigDecimal getDebitLocAmt() {
        return this.dynObj.getBigDecimal("debitlocamount");
    }

    public void setCreditLocAmt(BigDecimal total) {
        this.dynObj.set("creditlocamount", (Object)total);
    }

    public BigDecimal geCreditLocAmt() {
        return this.dynObj.getBigDecimal("creditlocamount");
    }

    public void setSourceBill(Long id) {
        this.dynObj.set("sourcebill", (Object)id);
    }

    public Long getSourceBill() {
        return this.dynObj.getLong("sourcebill");
    }

    public void setSourceType(String t) {
        this.dynObj.set("sourcetype", (Object)t);
    }

    public String getSourceType() {
        return this.dynObj.getString("sourcetype");
    }

    public void setSourceSys(String bizAppId) {
        this.dynObj.set("sourcesys_id", (Object)bizAppId);
    }

    public String getSourceSys() {
        return this.dynObj.getString("sourcesys_id");
    }

    public void setSourceBillType(String t) {
        this.dynObj.set("sourcebilltype_id", (Object)t);
    }

    public String getSourceBillType() {
        return this.dynObj.getString("sourcebilltype_id");
    }

    public void addEntry(VoucherEntryInfo entry) {
        this.entries.add(entry);
    }

    public void addEntries(VoucherEntryCollection entries) {
        this.entries.addAll(entries);
    }

    public VoucherEntryCollection getEntries() {
        return this.entries;
    }

    public void loadRefence() {
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{this.dynObj}, (IDataEntityType)this.dynObj.getDataEntityType());
    }

    public VoucherInfo copy() {
        VoucherInfo newVoucher = new VoucherInfo(this.dynObj.getDynamicObjectType());
        DynamicObject dynObject = newVoucher.toDynamicObject();
        dynObject.set("org", this.dynObj.get("org"));
        dynObject.set("booktype", this.dynObj.get("booktype"));
        dynObject.set("book", this.dynObj.get("book"));
        dynObject.set("period", this.dynObj.get("period"));
        dynObject.set("vouchertype", this.dynObj.get("vouchertype"));
        dynObject.set("bizdate", this.dynObj.get("bizdate"));
        dynObject.set("bookeddate", this.dynObj.get("bookeddate"));
        dynObject.set("billno", this.dynObj.get("billno"));
        dynObject.set("description", this.dynObj.get("description"));
        dynObject.set("attachment", this.dynObj.get("attachment"));
        dynObject.set("localcur", this.dynObj.get("localcur"));
        dynObject.set("sourcesys", this.dynObj.get("sourcesys"));
        dynObject.set("sourcetype", this.dynObj.get("sourcetype"));
        dynObject.set("sourcebill", this.dynObj.get("sourcebill"));
        dynObject.set("debitlocamount", this.dynObj.get("debitlocamount"));
        dynObject.set("creditlocamount", this.dynObj.get("creditlocamount"));
        dynObject.set("vdescription", this.dynObj.get("vdescription"));
        dynObject.set("creator", this.dynObj.get("creator"));
        dynObject.set("auditor", this.dynObj.get("auditor"));
        dynObject.set("poster", this.dynObj.get("poster"));
        dynObject.set("cashier", this.dynObj.get("cashier"));
        dynObject.set("billstatus", this.dynObj.get("billstatus"));
        for (LocalCurrencyConfigVO configVO : LocalCurrencyConfigService.queryEnableCurrencies((long)this.getOrg(), (long)this.getBookType())) {
            String metaId = configVO.getVoucherField(MCT.CURRENCY).getMetaId();
            dynObject.set(metaId, this.dynObj.get(metaId));
        }
        return newVoucher;
    }

    public String getGruopKey() {
        return this.getBook() + this.getPeriod() + this.getVoucherType() + "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("VoucherInfo{\n");
        for (VoucherEntryInfo entry : this.entries) {
            sb.append(entry.toString()).append("\n");
        }
        return sb.append("\n}").toString();
    }

    public Object getPK() {
        return this.dynObj.getPkValue();
    }

    public void setPK(Object pk) {
        IDataEntityType dataEntityType = this.dynObj.getDataEntityType();
        ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
        primaryKey.setValue((Object)this.dynObj, pk);
    }

    public final long setAndGetPK() {
        IDataEntityType dataEntityType = this.dynObj.getDataEntityType();
        ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
        SequenceReader sReader = new SequenceReader(new DBRoute("gl"));
        Long[] sequences = (Long[])sReader.getSequences((Object[])new Long[1], "gl_voucher", 1);
        long id = sequences[0];
        primaryKey.setValue((Object)this.dynObj, (Object)id);
        return id;
    }

    public void copyEntries(VoucherInfo srcVoucherInfo) {
        VoucherEntryCollection entries = srcVoucherInfo.getEntries();
        for (VoucherEntryInfo voucherEntryInfo : entries) {
            VoucherEntryInfo copy = voucherEntryInfo.copy();
            this.getEntries().add(copy);
        }
    }

    public void appendSave() {
        if (this.entries.isEmpty()) {
            return;
        }
        this.touchBigEntryMode();
        this.preSetExpireDate();
        this.preSetRedundantOrgPeriod();
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("forgid", FilterType.eq, (Object)this.getOrg()), new HintCondition("fperiodid", FilterType.eq, (Object)this.getPeriod())}).prepareShardingIndex();){
            logger.info("\u5f00\u59cb\u903b\u8f91\uff0c\u4f18\u5316\u9488\u5bf9XDB\u5206\u533a\u540e\u7684\u6570\u636e\u63d2\u5165\u6027\u80fd");
            try (TXHandle ignore = TX.requiresNew();){
                try {
                    this.saveVoucherEntrys(this.dynObj);
                }
                catch (Exception e) {
                    ignore.markRollback();
                    throw e;
                }
            }
            logger.info("\u7ed3\u675f\u903b\u8f91\uff0c\u4f18\u5316\u9488\u5bf9XDB\u5206\u533a\u540e\u7684\u6570\u636e\u63d2\u5165\u6027\u80fd");
        }
        this.dynObj.getDynamicObjectCollection("entries").clear();
        this.entries.clear();
        DataManagerUtils.getDataManager((IDataEntityType)this.dynObj.getDataEntityType()).commitSnapData(new Object[]{this.dynObj});
    }

    private void preSetRedundantOrgPeriod() {
        Long orgId = this.getOrg();
        Long periodId = this.getPeriod();
        DynamicObjectCollection entryDynCol = this.dynObj.getDynamicObjectCollection("entries");
        DynamicProperty orgProperty = entryDynCol.getDynamicObjectType().getProperty("eorg");
        DynamicProperty periodProperty = entryDynCol.getDynamicObjectType().getProperty("eperiod");
        for (DynamicObject entryRow : entryDynCol) {
            orgProperty.setValueFast((Object)entryRow, (Object)orgId);
            periodProperty.setValueFast((Object)entryRow, (Object)periodId);
        }
    }

    private void preSetExpireDate() {
        Set accountIds = BDUtil.extractToSet((Collection)this.dynObj.getDynamicObjectCollection("entries"), entry -> entry.getLong("account_id"));
        HashSet accheckAccountIds = new HashSet(QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])QFilterBuilder.create((String)"id", (String)"in", (Object)accountIds).addEqual("accheck", (Object)Boolean.TRUE).toArray(new QFilter[0]), (String)"", (int)-1));
        if (accheckAccountIds.isEmpty()) {
            return;
        }
        Date bookedDate = this.getBookedDate();
        for (VoucherEntryInfo entry2 : this.entries) {
            if (!accheckAccountIds.contains(entry2.getAccount())) continue;
            entry2.setExpireDate(bookedDate);
        }
    }

    private void touchBigEntryMode() {
        if (this.bigEntryMode) {
            return;
        }
        this.bigEntryMode = true;
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                if (rollbacked) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"gl_voucher"), (Object[])new Object[]{VoucherInfo.this.getPK()});
                }
            }
        });
    }

    public boolean isBigEntryMode() {
        return this.bigEntryMode;
    }

    private void saveVoucherEntrys(DynamicObject dynObj) {
        Long headerId = dynObj.getLong("id");
        DynamicObjectCollection voucherEntryer = dynObj.getDynamicObjectCollection("entries");
        String dbRoutKey = dynObj.getDynamicObjectType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRoutKey);
        StringBuilder sqlColumns = new StringBuilder();
        Integer objSize = voucherEntryer.getDynamicObjectType().getProperties().getSimpleProperties(true).size();
        sqlColumns.append("insert into ");
        String tableName = voucherEntryer.getDynamicObjectType().getAlias();
        sqlColumns.append(tableName);
        sqlColumns.append(" (");
        List properties = voucherEntryer.getDynamicObjectType().getProperties().getSimpleProperties(true);
        for (ISimpleProperty property : properties) {
            sqlColumns.append(property.getAlias());
            sqlColumns.append(",");
        }
        sqlColumns.append("Fid,");
        sqlColumns.deleteCharAt(sqlColumns.length() - 1);
        sqlColumns.append(") values (");
        for (int i = 0; i < properties.size(); ++i) {
            sqlColumns.append("?,");
        }
        sqlColumns.append("?)");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1);
        long[] longIds1 = DBServiceHelper.genLongIds((String)tableName, (int)voucherEntryer.size());
        int idCount = 0;
        for (DynamicObject item : voucherEntryer) {
            item.set("id", (Object)longIds1[idCount]);
            ++idCount;
            ArrayList<Object> objectList = new ArrayList<Object>(objSize);
            for (ISimpleProperty property : properties) {
                Object obj = item.get(property.getName());
                objectList.add(obj);
            }
            objectList.add(headerId);
            Object[] result = objectList.toArray();
            paramList.add(result);
        }
        logger.info("insert data using DB.executeBatch:" + paramList.size());
        logger.info("Insert SQL is:" + sqlColumns);
        int batchSize = 5000;
        ArrayList<List> batches = new ArrayList<List>(1);
        for (int i = 0; i < paramList.size(); i += batchSize) {
            int end = Math.min(i + batchSize, paramList.size());
            List batch = paramList.subList(i, end);
            batches.add(batch);
        }
        ArrayList<Future> futureList = new ArrayList<Future>(batches.size());
        for (List batch : batches) {
            Future future = ThreadService.submit(() -> {
                Throwable throwable = null;
                try (TXHandle ignore = TX.requiresNew();){
                    int[] results;
                    int[] nArray = results = DB.executeBatch((DBRoute)dbRoute, (String)sqlColumns.toString(), (List)batch);
                    return nArray;
                }
                catch (Exception e) {
                    try {
                        ignore.markRollback();
                        throw e;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }, (TaskType)TaskType.GL_COMMON_ASYNC_TASK);
            futureList.add(future);
        }
        for (Future future : futureList) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("insert voucherentry batches error,", (Throwable)e);
                throw KDExceptionBuilder.buildKDBizException((String)"insert voucherentry batches error,", (Throwable)e, (Object[])new Object[0]);
            }
        }
        boolean isVoucherExists = QueryServiceHelper.exists((String)"gl_voucher", (Object)headerId);
        if (!isVoucherExists) {
            DynamicObjectCollection lines = dynObj.getDynamicObjectCollection("entries");
            lines.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
        }
    }
}

