/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.gl.business.vo.voucher.Amount;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.util.BigDecimalUtil;
import kd.fi.gl.voucher.writeoff.AbstractBalance;
import kd.fi.gl.voucher.writeoff.AmountBalance;
import kd.fi.gl.voucher.writeoff.QuantityBalance;
import kd.fi.gl.voucher.writeoff.WriteOffEntry;

public class WriteOffBalance {
    private Map<AmountField, AbstractBalance<Amount>> amountBalanceMap = new HashMap<AmountField, AbstractBalance<Amount>>(4);
    private AbstractBalance<BigDecimal> quantityBalance = new QuantityBalance();
    private String sourceEntryDC = "-1";

    public void setSourceEntry(WriteOffEntry entry) {
        this.sourceEntryDC = entry.getDc();
        entry.getAmountMap().forEach((k, v) -> this.getAmountBalance((AmountField)k).setInitValue((Amount)v, entry.getDc()));
        this.quantityBalance.setInitValue(entry.getQuantity(), entry.getDc());
    }

    public void addWriteOffEntry(WriteOffEntry entry) {
        entry.getAmountMap().forEach((k, v) -> this.getAmountBalance((AmountField)k).addValue((Amount)v, entry.getDc()));
        this.quantityBalance.addValue(entry.getQuantity(), entry.getDc());
    }

    @Deprecated
    public void setSourceEntry(BigDecimal localDebit, BigDecimal localCredit, BigDecimal originalDebit, BigDecimal originalCredit, BigDecimal quantity) {
        String dc = this.getDirection(localDebit, localCredit, originalDebit);
        this.getAmountBalance(AmountField.LOCAL).addValue(new Amount(localDebit, localCredit), dc);
        this.getAmountBalance(AmountField.ORIGINAL).addValue(new Amount(originalDebit, originalCredit), dc);
        this.quantityBalance.addValue(quantity, dc);
    }

    @Deprecated
    public void addWriteOffEntry(BigDecimal localDebit, BigDecimal localCredit, BigDecimal originalDebit, BigDecimal originalCredit, BigDecimal quantity) {
        String dc = this.getDirection(localDebit, localCredit, originalDebit);
        this.getAmountBalance(AmountField.LOCAL).addValue(new Amount(localDebit, localCredit), dc);
        this.getAmountBalance(AmountField.ORIGINAL).addValue(new Amount(originalDebit, originalCredit), dc);
        this.quantityBalance.addValue(quantity, dc);
    }

    private String getDirection(BigDecimal localDebit, BigDecimal localCredit, BigDecimal originalDebit) {
        if (BigDecimalUtil.nullToZero(localDebit).signum() != 0 || BigDecimalUtil.nullToZero(localCredit).signum() != 0) {
            return localDebit.signum() == 0 ? "-1" : "1";
        }
        return BigDecimalUtil.nullToZero(originalDebit).signum() == 0 ? "-1" : "1";
    }

    public String getSourceEntryDirection() {
        return this.sourceEntryDC;
    }

    public AbstractBalance<Amount> getAmountBalance(AmountField field) {
        return this.amountBalanceMap.computeIfAbsent(field, k -> new AmountBalance());
    }

    public boolean isLocalBalanceBeyond() {
        return this.getAmountBalance(AmountField.LOCAL).isBeyond();
    }

    public boolean isOriginalBalanceBeyond() {
        return this.getAmountBalance(AmountField.ORIGINAL).isBeyond();
    }

    public boolean isQuantityBalanceBeyond() {
        return this.quantityBalance.isBeyond();
    }

    public boolean hasRemainingLocal() {
        return this.getAmountBalance(AmountField.LOCAL).hasRemaining();
    }

    public boolean hasRemainingOriginal() {
        return this.getAmountBalance(AmountField.ORIGINAL).hasRemaining();
    }

    public boolean hasRemainingQuantity() {
        return this.quantityBalance.hasRemaining();
    }

    public boolean hasRemaining() {
        return this.amountBalanceMap.values().stream().anyMatch(AbstractBalance::hasRemaining) || this.hasRemainingQuantity();
    }

    public BigDecimal getOriginalBalance() {
        return this.getAmountBalance(AmountField.ORIGINAL).getBalance();
    }

    public BigDecimal getLocalBalance() {
        return this.getAmountBalance(AmountField.LOCAL).getBalance();
    }

    public BigDecimal getQuantity() {
        return this.quantityBalance.getBalance();
    }

    @Deprecated
    public List<Object> toList() {
        ArrayList<Object> balList = new ArrayList<Object>(4);
        balList.add(this.getLocalBalance());
        balList.add(BigDecimal.ZERO);
        balList.add(this.getOriginalBalance());
        balList.add(this.getQuantity());
        return balList;
    }
}

