/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.enums;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;

public enum TaxReportFetchrule {
    BEGINLOCAL("1"),
    ENDLOCAL("2"),
    YEARBEGINLOCAL("7X"),
    YEARBEGINLOCALX("X"),
    DEBITLOCAL("3"),
    CREDITLOCAL("4"),
    YEARDEBITLOCAL("5"),
    YEARCREDITLOCAL("6"),
    PLDEBITLOCAL("7"),
    PLCREDITLOCAL("8"),
    YEARPLDEBITLOCAL("9"),
    YEARPLCREDITLOCAL("0"),
    LASTSAMEPERIODDEBIT("A"),
    LASTSAMEPERIODCREDIT("B"),
    LASTSAMEPERIODYDEBIT("C"),
    LASTSAMEPERIODYCREDIT("D"),
    LASTYEARDEBITLOCAL("Y"),
    LASTYEARCREDITLOCAL("Z");

    private String type;

    private TaxReportFetchrule(String type) {
        this.type = type;
    }

    public String getType() {
        if ("7X".equals(this.type)) {
            return "7";
        }
        return this.type;
    }

    public String getNameLang() {
        switch (this.type) {
            case "1": {
                return ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"TaxReportFetchrule_0", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d", (String)"TaxReportFetchrule_1", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "X": 
            case "7X": {
                return ResManager.loadKDString((String)"\u5e74\u521d\u4f59\u989d", (String)"TaxReportFetchrule_2", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u672c\u671f\u501f\u65b9\u53d1\u751f\u989d", (String)"TaxReportFetchrule_3", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u672c\u671f\u8d37\u65b9\u53d1\u751f\u989d", (String)"TaxReportFetchrule_4", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u501f\u65b9\u53d1\u751f\u989d", (String)"TaxReportFetchrule_5", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "6": {
                return ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u8d37\u65b9\u53d1\u751f\u989d", (String)"TaxReportFetchrule_6", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "7": {
                return ResManager.loadKDString((String)"\u672c\u671f\u5b9e\u9645\u501f\u65b9\u53d1\u751f\u6570", (String)"TaxReportFetchrule_7", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "8": {
                return ResManager.loadKDString((String)"\u672c\u671f\u5b9e\u9645\u8d37\u65b9\u53d1\u751f\u6570", (String)"TaxReportFetchrule_8", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "9": {
                return ResManager.loadKDString((String)"\u672c\u5e74\u5b9e\u9645\u501f\u65b9\u53d1\u751f\u6570", (String)"TaxReportFetchrule_9", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "0": {
                return ResManager.loadKDString((String)"\u672c\u5e74\u5b9e\u9645\u8d37\u65b9\u53d1\u751f\u6570", (String)"TaxReportFetchrule_10", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "A": {
                return ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u5b9e\u9645\u501f\u65b9\u53d1\u751f\u6570", (String)"TaxReportFetchrule_11", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "B": {
                return ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u5b9e\u9645\u8d37\u65b9\u53d1\u751f\u6570", (String)"TaxReportFetchrule_12", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "C": {
                return ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u7d2f\u8ba1\u5b9e\u9645\u501f\u65b9\u53d1\u751f\u6570", (String)"TaxReportFetchrule_13", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "D": {
                return ResManager.loadKDString((String)"\u4e0a\u5e74\u540c\u671f\u7d2f\u8ba1\u5b9e\u9645\u8d37\u65b9\u53d1\u751f\u6570", (String)"TaxReportFetchrule_14", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "Y": {
                return ResManager.loadKDString((String)"\u4e0a\u5e74\u5b9e\u9645\u501f\u65b9\u53d1\u751f\u6570", (String)"TaxReportFetchrule_15", (String)"fi-gl-common", (Object[])new Object[0]);
            }
            case "Z": {
                return ResManager.loadKDString((String)"\u4e0a\u5e74\u5b9e\u9645\u8d37\u65b9\u53d1\u751f\u6570", (String)"TaxReportFetchrule_16", (String)"fi-gl-common", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public boolean isCurPL() {
        switch (this.type) {
            case "7": 
            case "8": 
            case "9": 
            case "0": {
                return true;
            }
        }
        return false;
    }

    public boolean isLastSamePeriodPL() {
        switch (this.type) {
            case "A": 
            case "B": 
            case "C": 
            case "D": {
                return true;
            }
        }
        return false;
    }

    public boolean isLastYearPL() {
        switch (this.type) {
            case "Y": 
            case "Z": {
                return true;
            }
        }
        return false;
    }

    public static TaxReportFetchrule getValue(String type) {
        TaxReportFetchrule[] values;
        for (TaxReportFetchrule value : values = TaxReportFetchrule.values()) {
            if (!value.type.equals(type)) continue;
            return value;
        }
        return null;
    }

    public static List<String> getLastYaerTypes() {
        ArrayList<String> results = new ArrayList<String>();
        results.add(LASTYEARDEBITLOCAL.getType());
        results.add(LASTYEARCREDITLOCAL.getType());
        return results;
    }

    public static List<String> getNotLastYaerTypes() {
        ArrayList<String> results = new ArrayList<String>();
        List<String> lastYaerTypes = TaxReportFetchrule.getLastYaerTypes();
        List<String> allTypes = TaxReportFetchrule.getAllTypes();
        for (String t : allTypes) {
            if (lastYaerTypes.contains(t)) continue;
            results.add(t);
        }
        return results;
    }

    public static List<String> getAllTypes() {
        TaxReportFetchrule[] values = TaxReportFetchrule.values();
        ArrayList<String> results = new ArrayList<String>(values.length);
        for (TaxReportFetchrule value : values) {
            results.add(value.getType());
        }
        return results;
    }

    public static String getName(String type) {
        TaxReportFetchrule value = TaxReportFetchrule.getValue(type);
        return value == null ? "" : value.getNameLang();
    }
}

