/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.enums;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.common.WriteOffBalance;
import kd.fi.gl.util.GLApp;

public enum WriteOffTypeEnum {
    RED("1", (bal, afs, entry) -> {
        entry.set("oriamount", (Object)bal.getOriginalBalance().negate());
        entry.set("entrydc", (Object)bal.getSourceEntryDirection());
        if ("1".equals(bal.getSourceEntryDirection())) {
            entry.set("debitori", (Object)bal.getOriginalBalance().negate());
            entry.set("debitlocal", (Object)bal.getLocalBalance().negate());
            entry.set("creditlocal", (Object)BigDecimal.ZERO);
            for (AmountField af : afs) {
                entry.set(af.getDebitField(), (Object)bal.getAmountBalance(af).getBalance().negate());
                entry.set(af.getCreditField(), (Object)BigDecimal.ZERO);
            }
        } else {
            entry.set("creditori", (Object)bal.getOriginalBalance().negate());
            entry.set("creditlocal", (Object)bal.getLocalBalance().negate());
            entry.set("debitlocal", (Object)BigDecimal.ZERO);
            for (AmountField af : afs) {
                entry.set(af.getCreditField(), (Object)bal.getAmountBalance(af).getBalance().negate());
                entry.set(af.getDebitField(), (Object)BigDecimal.ZERO);
            }
        }
        entry.set("quantity", (Object)bal.getQuantity().negate());
    }, () -> ResManager.loadKDString((String)"\u7ea2\u5b57\u51b2\u9500", (String)"WriteOffTypeEnum_0", (String)GLApp.instance.commonModule(), (Object[])new Object[0]), (sv, rv) -> {
        if (!sv.getString("entrydc").equals(rv.getString("entrydc"))) {
            return Optional.of(ResManager.loadKDString((String)"\u7ea2\u5b57\u51b2\u9500\u5206\u5f55\u91d1\u989d\u5fc5\u987b\u4e0e\u88ab\u51b2\u9500\u5206\u5f55\u91d1\u989d\u501f\u8d37\u65b9\u5411\u76f8\u540c\u3002", (String)"WriteOffTypeEnum_1", (String)GLApp.instance.commonModule(), (Object[])new Object[0]));
        }
        return Optional.empty();
    }),
    BLUE("2", (bal, afs, entry) -> {
        entry.set("oriamount", (Object)bal.getOriginalBalance());
        entry.set("entrydc", (Object)("1".equals(bal.getSourceEntryDirection()) ? "-1" : "1"));
        if ("1".equals(bal.getSourceEntryDirection())) {
            entry.set("creditori", (Object)bal.getOriginalBalance());
            entry.set("creditlocal", (Object)bal.getLocalBalance());
            entry.set("debitlocal", (Object)BigDecimal.ZERO);
            for (AmountField af : afs) {
                entry.set(af.getCreditField(), (Object)bal.getAmountBalance(af).getBalance());
                entry.set(af.getDebitField(), (Object)BigDecimal.ZERO);
            }
        } else {
            entry.set("debitori", (Object)bal.getOriginalBalance());
            entry.set("debitlocal", (Object)bal.getLocalBalance());
            entry.set("creditlocal", (Object)BigDecimal.ZERO);
            for (AmountField af : afs) {
                entry.set(af.getDebitField(), (Object)bal.getAmountBalance(af).getBalance());
                entry.set(af.getCreditField(), (Object)BigDecimal.ZERO);
            }
        }
        entry.set("quantity", (Object)bal.getQuantity());
    }, () -> ResManager.loadKDString((String)"\u84dd\u5b57\u51b2\u9500", (String)"WriteOffTypeEnum_2", (String)GLApp.instance.commonModule(), (Object[])new Object[0]), (sv, rv) -> {
        if (sv.getString("entrydc").equals(rv.getString("entrydc"))) {
            return Optional.of(ResManager.loadKDString((String)"\u84dd\u5b57\u51b2\u9500\u5206\u5f55\u91d1\u989d\u5fc5\u987b\u4e0e\u88ab\u51b2\u9500\u5206\u5f55\u91d1\u989d\u501f\u8d37\u65b9\u5411\u76f8\u53cd\u3002", (String)"WriteOffTypeEnum_3", (String)GLApp.instance.commonModule(), (Object[])new Object[0]));
        }
        return Optional.empty();
    });

    private final String code;
    private final INewEntrySetter entryAmountSetter;
    private final Supplier<String> operationNameGetter;
    private final BiFunction<DynamicObject, DynamicObject, Optional<String>> dcValidator;

    private WriteOffTypeEnum(String code, INewEntrySetter entryAmountSetter, Supplier<String> operationNameGetter, BiFunction<DynamicObject, DynamicObject, Optional<String>> dcValidator) {
        this.code = code;
        this.entryAmountSetter = entryAmountSetter;
        this.operationNameGetter = operationNameGetter;
        this.dcValidator = dcValidator;
    }

    public String getCode() {
        return this.code;
    }

    public INewEntrySetter getEntryAmountSetter() {
        return this.entryAmountSetter;
    }

    public Supplier<String> getOperationNameGetter() {
        return this.operationNameGetter;
    }

    private BiFunction<DynamicObject, DynamicObject, Optional<String>> getDcValidator() {
        return this.dcValidator;
    }

    public Optional<String> validate(DynamicObject sv, DynamicObject rv, AmountField ... amountFields) {
        Optional<String> error = this.getDcValidator().apply(sv, rv);
        if (error.isPresent()) {
            return error;
        }
        error = this.validateAmount(AmountField.LOCAL, sv, rv);
        if (error.isPresent()) {
            return error;
        }
        error = this.validateAmount(AmountField.ORIGINAL, sv, rv);
        if (error.isPresent()) {
            return error;
        }
        if (amountFields != null) {
            for (AmountField amountField : amountFields) {
                error = this.validateAmount(amountField, sv, rv);
                if (!error.isPresent()) continue;
                return error;
            }
        }
        return this.validateQty(sv, rv);
    }

    private Optional<String> validateAmount(AmountField amountField, DynamicObject sv, DynamicObject rv) {
        BigDecimal sourceDr = sv.getBigDecimal(amountField.getDebitField());
        BigDecimal sourceCr = sv.getBigDecimal(amountField.getCreditField());
        BigDecimal reverseDr = rv.getBigDecimal(amountField.getDebitField());
        BigDecimal reverseCr = rv.getBigDecimal(amountField.getCreditField());
        if (sourceDr.subtract(sourceCr).signum() * reverseDr.subtract(reverseCr).signum() > 0) {
            String sourceDc = sourceDr.signum() > 0 || sourceCr.signum() > 0 ? ResManager.loadKDString((String)"\u6b63", (String)"WriteOffTypeEnum_6", (String)GLApp.instance.commonModule(), (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d1f", (String)"WriteOffTypeEnum_7", (String)GLApp.instance.commonModule(), (Object[])new Object[0]);
            String reverseDc = reverseDr.signum() > 0 || reverseCr.signum() > 0 ? ResManager.loadKDString((String)"\u6b63", (String)"WriteOffTypeEnum_6", (String)GLApp.instance.commonModule(), (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d1f", (String)"WriteOffTypeEnum_7", (String)GLApp.instance.commonModule(), (Object[])new Object[0]);
            return Optional.of(ResManager.loadKDString((String)"\u539f\u51ed\u8bc1%1$s\u91d1\u989d\u4e3a%2$s\uff0c%3$s\u5206\u5f55%4$s\u91d1\u989d\u4e0d\u5141\u8bb8\u4e3a%5$s\u3002", (String)"WriteOffTypeEnum_8", (String)GLApp.instance.commonModule(), (Object[])new Object[]{amountField.getCurrencyField().getDesc(), sourceDc, this.getOperationNameGetter().get(), amountField.getCurrencyField().getDesc(), reverseDc}));
        }
        return Optional.empty();
    }

    private Optional<String> validateQty(DynamicObject sv, DynamicObject rv) {
        String reverseDc;
        BigDecimal sourceQty = sv.getBigDecimal("quantity");
        BigDecimal reverseQty = rv.getBigDecimal("quantity");
        String sourceDc = sv.getString("entrydc");
        if (sourceDc.equals(reverseDc = rv.getString("entrydc")) && sourceQty.signum() * reverseQty.signum() > 0 || !sourceDc.equals(reverseDc) && sourceQty.signum() * reverseQty.signum() < 0) {
            String sourceSigns = sourceQty.signum() > 0 ? ResManager.loadKDString((String)"\u6b63", (String)"WriteOffTypeEnum_6", (String)GLApp.instance.commonModule(), (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d1f", (String)"WriteOffTypeEnum_7", (String)GLApp.instance.commonModule(), (Object[])new Object[0]);
            String reverseSigns = reverseQty.signum() > 0 ? ResManager.loadKDString((String)"\u6b63", (String)"WriteOffTypeEnum_6", (String)GLApp.instance.commonModule(), (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d1f", (String)"WriteOffTypeEnum_7", (String)GLApp.instance.commonModule(), (Object[])new Object[0]);
            return Optional.of(String.format(ResManager.loadKDString((String)"\u539f\u51ed\u8bc1\u6570\u91cf\u4e3a%1$s\uff0c%2$s\u5206\u5f55\u6570\u91cf\u4e0d\u5141\u8bb8\u4e3a%3$s\u3002", (String)"WriteOffTypeEnum_9", (String)GLApp.instance.commonModule(), (Object[])new Object[0]), sourceSigns, this.getOperationNameGetter().get(), reverseSigns, reverseDc));
        }
        return Optional.empty();
    }

    public static WriteOffTypeEnum get(String code) {
        return Arrays.stream(WriteOffTypeEnum.values()).filter(x -> x.getCode().equals(code)).findFirst().orElse(RED);
    }

    @FunctionalInterface
    public static interface INewEntrySetter {
        public void setValue(WriteOffBalance var1, AmountField[] var2, DynamicObject var3);
    }
}

