/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.FinalProcessCommonFieldKey;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;

public abstract class AbstractFinalProcessSchemeInfo {
    private static final String MASTERID = "masterid";
    private DynamicObject schemeDyn;
    private AccountBookInfo accountBookInfo;
    private DynamicObject curPeriodDyn;
    private Date curDate;
    private DynamicObject baseCurrencyDyn;
    private Long voucherTypeId;
    private VoucherInfo voucherInfo;
    private Map<String, VoucherInfo> mulCurVoucherInfo;
    private Collection<LocalCurrencyConfigVO> murCurConfigs;
    private int baseCurrencyAmtPrecision;
    private Map<String, Integer> mulCurBaseCurrencyAmtPrecision;
    private Long curPeriodId;

    public final void makeFinalProcessSchemeInfo(DynamicObject schemeDyn, FinalProcessCommonFieldKey commonFieldKey, Long openPeriodID) {
        if (schemeDyn == null) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u65b9\u6848\u4fe1\u606f\u4e3a\u7a7a", (String)"AbstractFinalProcessSchemeInfo_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        this.schemeDyn = schemeDyn;
        Long orgId = schemeDyn.getLong(GLField.id_("org"));
        Long booksTypeId = schemeDyn.getLong(GLField.id_(commonFieldKey.getBooksTypeFieldKey()));
        this.accountBookInfo = AccSysUtil.getBookFromAccSys(orgId, (long)booksTypeId);
        if (this.accountBookInfo == null) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u65b9\u6848\u7684\u8d26\u7c3f\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"AbstractFinalProcessSchemeInfo_1", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        this.curPeriodId = this.accountBookInfo.getCurPeriodId(openPeriodID);
        this.curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)this.curPeriodId).toArray());
        if (this.curPeriodDyn == null) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u65b9\u6848\u7684\u5f53\u524d\u671f\u95f4\u4e0d\u5b58\u5728", (String)"AbstractFinalProcessSchemeInfo_2", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        this.curDate = new Date();
        Long baseCurrencyId = this.accountBookInfo.getBaseCurrencyId();
        String entityCurrency = "bd_currency";
        this.baseCurrencyDyn = BusinessDataServiceHelper.loadSingleFromCache((String)entityCurrency, (QFilter[])new QFilter("id", "=", (Object)baseCurrencyId).toArray());
        if (this.baseCurrencyDyn == null) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u65b9\u6848\u7684\u672c\u4f4d\u5e01\u4e0d\u5b58\u5728", (String)"AbstractFinalProcessSchemeInfo_3", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        this.baseCurrencyAmtPrecision = this.baseCurrencyDyn.getInt("amtprecision");
        String mulCurAdjust = schemeDyn.getString("mulcuradjust");
        HashSet<String> mulCurChoose = mulCurAdjust == null ? new HashSet<String>() : Arrays.stream(mulCurAdjust.split(",")).collect(Collectors.toSet());
        mulCurChoose.removeIf(StringUtils::isBlank);
        this.murCurConfigs = LocalCurrencyConfigService.queryEnableCurrencies((long)this.getOrgId(), (long)this.accountBookInfo.getBookTypeId()).stream().filter(configVO -> mulCurChoose.contains(configVO.getNumber())).collect(Collectors.toSet());
        this.mulCurBaseCurrencyAmtPrecision = new HashMap<String, Integer>(this.murCurConfigs.size());
        this.mulCurVoucherInfo = new HashMap<String, VoucherInfo>(this.murCurConfigs.size());
        for (LocalCurrencyConfigVO config : this.murCurConfigs) {
            baseCurrencyId = config.getCurrencyId(this.getOrgId().longValue(), this.getAccountBookInfo().getBookTypeId());
            DynamicObject baseCurDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter("id", "=", (Object)baseCurrencyId).toArray());
            if (baseCurDyn == null) {
                throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u65b9\u6848\u7684\u672c\u4f4d\u5e01\u4e0d\u5b58\u5728", (String)"AbstractFinalProcessSchemeInfo_3", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            this.mulCurBaseCurrencyAmtPrecision.put(config.getNumber(), baseCurDyn.getInt("amtprecision"));
            this.mulCurVoucherInfo.put(config.getNumber(), new VoucherInfo());
        }
        this.voucherTypeId = this.getSelfVoucherTypeId(commonFieldKey.getVoucherTypeFieldKey());
        if (this.voucherTypeId == null || this.voucherTypeId <= 0L) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u65b9\u6848\u7684\u51ed\u8bc1\u7c7b\u578b\u4e0d\u5b58\u5728,\u53ef\u80fd\u5b58\u5728\u4e2a\u6027\u5316", (String)"AbstractFinalProcessSchemeInfo_4", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        this.voucherInfo = new VoucherInfo();
    }

    public AbstractFinalProcessSchemeInfo(DynamicObject schemeDyn, FinalProcessCommonFieldKey commonFieldKey, Long openPeriodID) {
        this.makeFinalProcessSchemeInfo(schemeDyn, commonFieldKey, openPeriodID);
    }

    public AbstractFinalProcessSchemeInfo(DynamicObject schemeDyn, FinalProcessCommonFieldKey commonFieldKey, OperateOption option) {
        String openedPeriod = option.getVariableValue("openedperiod", "0");
        Long openedPeriodId = Long.valueOf(openedPeriod);
        this.makeFinalProcessSchemeInfo(schemeDyn, commonFieldKey, openedPeriodId);
    }

    public Collection<LocalCurrencyConfigVO> getMurCurConfigs() {
        return this.murCurConfigs;
    }

    public boolean enableMulCur() {
        return CollectionUtils.isNotEmpty(this.murCurConfigs);
    }

    public Map<String, Integer> getMulCurBaseCurrencyAmtPrecision() {
        return this.mulCurBaseCurrencyAmtPrecision;
    }

    private Long getSelfVoucherTypeId(String fieldVoucherType) {
        String entityVoucherType = "gl_vouchertype";
        Long voucherTypeId = this.getDataEntity().getLong(GLField.id_(fieldVoucherType));
        List<Long> selfBaseDatas = this.getSelfBaseDatas(entityVoucherType, voucherTypeId);
        if (selfBaseDatas.size() > 0) {
            return selfBaseDatas.get(0);
        }
        return null;
    }

    public DynamicObject getDataEntity() {
        return this.schemeDyn;
    }

    public AccountBookInfo getAccountBookInfo() {
        return this.accountBookInfo;
    }

    public DynamicObject getCurPeriodDyn() {
        return this.curPeriodDyn;
    }

    public Date getCurPeriodEndDate() {
        String filedEndDate = "enddate";
        return this.getCurPeriodDyn().getDate(filedEndDate);
    }

    public Date getCurDate() {
        return this.curDate;
    }

    public Date getBizDate() {
        return this.getCurDate();
    }

    public DynamicObject getBaseCurrencyDyn() {
        return this.baseCurrencyDyn;
    }

    public Long getVoucherTypeId() {
        return this.voucherTypeId;
    }

    public abstract String getVoucherDesc();

    public Long getOrgId() {
        return this.getAccountBookInfo().getOrgId();
    }

    public Long getBaseCurrencyId() {
        return this.getAccountBookInfo().getBaseCurrencyId();
    }

    public Long getExchangeTableId() {
        return this.getAccountBookInfo().getExrateTableId();
    }

    public Long getAccountTableId() {
        return this.getAccountBookInfo().getAccountTableId();
    }

    public Long getCurPeriodId() {
        return this.curPeriodId;
    }

    public VoucherInfo getVoucherInfo() {
        return this.voucherInfo;
    }

    public VoucherInfo getVoucherInfo(String mulCurType) {
        if ("BaseCurrency".equals(mulCurType)) {
            return this.getVoucherInfo();
        }
        return this.mulCurVoucherInfo.get(mulCurType);
    }

    public Map<String, VoucherInfo> getMulCurVoucherInfo() {
        return this.mulCurVoucherInfo;
    }

    public List<Long> getSelfBaseDatas(String entity, Long ... pks) {
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)entity, (String)MASTERID, (QFilter[])new QFilter("id", "in", (Object)pks).toArray());
        List masterIds = dyns.stream().map(x -> x.getLong(MASTERID)).collect(Collectors.toList());
        QFilter masterIdFilter = new QFilter(MASTERID, "in", masterIds);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)this.getOrgId());
        DynamicObjectCollection selfBaseDatas = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{baseDataFilter, masterIdFilter});
        return selfBaseDatas.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
    }

    public int getBaseCurrencyAmtPrecision() {
        return this.baseCurrencyAmtPrecision;
    }

    public int getBaseCurrencyAmtPrecision(String mulCurType) {
        if ("BaseCurrency".equals(mulCurType)) {
            return this.getBaseCurrencyAmtPrecision();
        }
        return this.mulCurBaseCurrencyAmtPrecision.get(mulCurType);
    }

    public long getPkValue() {
        return (Long)this.schemeDyn.getPkValue();
    }

    public String getNumber() {
        return this.schemeDyn.getString(((BillEntityType)this.schemeDyn.getDynamicObjectType()).getBillNo());
    }
}

