/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountVersionReplaceParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.AccountType;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.autotrans.FinalProcessAssgrp;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.FinalProcessCommonFieldKey;
import kd.fi.gl.enums.endingprocess.RecordDirection;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.finalprocess.info.AbstractFinalProcessSchemeInfo;
import kd.fi.gl.finalprocess.info.DimensionSumBalacneInfo;
import kd.fi.gl.model.schema.AdjustRateSchema;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public class AdjustSchemeInfo
extends AbstractFinalProcessSchemeInfo {
    private static final Log log = LogFactory.getLog(AdjustSchemeInfo.class);
    private final AdjustRateSchema schema = new AdjustRateSchema();
    private DynamicObject periodDyn;
    private Date bizDate;
    private DimensionSumBalacneInfo sumByCurrencyProfitBalance;
    private Map<String, DimensionSumBalacneInfo> mulCurSumByCurrencyProfitBalance;
    private DimensionSumBalacneInfo sumByCurrencyLossBalance;
    private Map<String, DimensionSumBalacneInfo> mulCurSumByCurrencyLossBalance;
    private VoucherInfo lossVoucherInfo;
    private Map<String, VoucherInfo> mulCurLossVoucherInfo;
    private boolean isSplitProfitAndLoss;
    private boolean isSetAccount;
    private List<Long> accounts;
    private List<String> accountNumbers;
    private boolean isSetCurrency;
    private List<Long> currencys;
    private boolean isSetRate;
    private boolean isNoNegative;
    private boolean isReverse;
    private String accDirectionType;
    private Long exrateTableId;
    private Long profitAccountId;
    private Long lossAccountId;
    private String profitAccountCurrencyType;
    private List<Long> profitAccountCurrencyIds;
    private String lossAccountCurrencyType;
    private List<Long> lossAccountCurrencyIds;
    private Long profitAssgrpId;
    private Long lossAssgrpId;
    private List<String> profitAccountFlexs;
    private List<String> lossAccountFlexs;
    private int adjustStyle;
    private String VOUCHERDATETYPE = "voucherdatetype";
    private String pageId;
    private Map<String, Set<Long>> comAssistIdsMap;
    private int comAssistCount;
    private Map<String, Set<String>> leafAcctNumberMap;
    private final Table<Long, Long, ExchangeRate> curRateConfig = HashBasedTable.create();
    private static final String[] SELECT_FIELDS = new String[]{"account.id accountid", "measureunit", "account.number acctnumber", "account.dc acctdc", "account", "account.isqty acctisqty", "endfor", "endlocal", "currency", "assgrp"};
    private static final String[] OUTPUT_FIELDS = new String[]{"accountid", "measureunit", "acctnumber", "acctdc", "account", "acctisqty", "endfor", "endlocal", "currency", "assgrp"};

    public AdjustSchemeInfo(DynamicObject schemeDyn, OperateOption option) {
        super(schemeDyn, FinalProcessCommonFieldKey.ADJUST, option);
        String dateType = this.getDataEntity().getString(this.VOUCHERDATETYPE);
        String curDateType = "2";
        Date curDate = super.getCurDate();
        DynamicObject curDatePeriodDyn = GLUtil.getPeriodByDate(curDate, this.getAccountBookInfo().getPeriodTypeId());
        if (curDateType.equals(dateType) && Objects.equals(curDatePeriodDyn.getLong("id"), super.getCurPeriodDyn().getLong("id"))) {
            this.bizDate = curDate;
            this.periodDyn = curDatePeriodDyn;
        } else {
            this.periodDyn = super.getCurPeriodDyn();
            this.bizDate = super.getCurPeriodEndDate();
        }
        if (this.periodDyn == null) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u65e5\u671f\u6240\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"AdjustSchemeInfo_0", (String)"fi-gl-common", (Object[])new Object[0]));
        }
        this.sumByCurrencyProfitBalance = new DimensionSumBalacneInfo();
        this.isSplitProfitAndLoss = super.getDataEntity().getBoolean("bypl");
        DynamicObject account = this.getDataEntity().getDynamicObject("placcountid");
        AccountBookInfo accountBookInfo = this.getAccountBookInfo();
        long orgID = accountBookInfo.getOrgId();
        long bookTypeID = accountBookInfo.getBookTypeId();
        long acctTableID = AccSysUtil.getCurPeriodAccountTableId(orgID, bookTypeID, this.getCurPeriodId());
        DynamicObject periodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)this.getCurPeriodId()).toArray());
        AccountVersionReplaceParam accountVersionParam = new AccountVersionReplaceParam(orgID, account.getLong("masterid"), acctTableID, acctTableID, account.getString("number"), periodDy, bookTypeID, account, 0L);
        accountVersionParam.getCustomAccountFilterList().add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        DynamicObject currVersionProfitAccount = AccountRefUtils.getCurVersionAccount((AccountVersionReplaceParam)accountVersionParam);
        if (Objects.isNull(currVersionProfitAccount)) {
            throw new GLException(GLErrorCode.common, String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\uff1a%s\u7684\u79d1\u76ee\u6570\u636e\u3002", (String)"AdjustSchemeInfo_1", (String)"fi-gl-common", (Object[])new Object[0]), new Object[0]), account.getString("number"));
        }
        this.profitAccountId = currVersionProfitAccount.getLong("id");
        this.isSetAccount = "2".equals(super.getDataEntity().getString("setaccountgroup"));
        if (this.isSetAccount) {
            this.accounts = this.getAccountEntries().stream().filter(x -> x.getBoolean("loccheckbox")).map(x -> x.getLong("accountid_id")).collect(Collectors.toList());
            this.accountNumbers = this.getAccountEntries().stream().filter(x -> x.getBoolean("loccheckbox")).map(x -> x.getDynamicObject("accountid").getString("number")).collect(Collectors.toList());
            this.leafAcctNumberMap = this.getLeafAcctNumber(this.getAccountEntries().stream().filter(x -> !x.getDynamicObject("accountid").getBoolean("isleaf")).map(x -> x.getDynamicObject("accountid").getString("number")).collect(Collectors.toSet()));
            HashSet allLeafAcctNumSet = new HashSet(8);
            this.leafAcctNumberMap.values().forEach(allLeafAcctNumSet::addAll);
            this.accountNumbers.addAll(allLeafAcctNumSet);
        } else {
            this.accounts = Collections.emptyList();
            this.accountNumbers = Collections.emptyList();
        }
        DynamicObject org = schemeDyn.getDynamicObject("org");
        DynamicObject booksType = schemeDyn.getDynamicObject("bookstype");
        DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"basecurrency", (QFilter[])new QFilter("org", "=", org.getPkValue()).and("bookstype", "=", booksType.getPkValue()).toArray());
        long dynamicObject = book.getLong("basecurrency");
        this.isSetCurrency = "2".equals(super.getDataEntity().getString("setcuruencygroup"));
        if (this.isSetCurrency) {
            Set locCurSet = this.getCurrencyEntries().stream().map(x -> x.getLong(GLField.id_("loccurrency"))).collect(Collectors.toSet());
            if (!this.enableMulCur()) {
                locCurSet.remove(dynamicObject);
            }
            this.currencys = new ArrayList(locCurSet);
        } else {
            this.currencys = Collections.emptyList();
        }
        this.isSetRate = "2".equals(super.getDataEntity().getString("adjuststyle"));
        this.isNoNegative = super.getDataEntity().getBoolean("nonegative");
        this.accDirectionType = super.getDataEntity().getString("bybalancereverse");
        this.exrateTableId = super.getDataEntity().getLong("exratetable_id");
        if (this.getExrateTableId() <= 0L) {
            this.exrateTableId = super.getExchangeTableId();
        }
        this.profitAssgrpId = super.getDataEntity().getLong("assgrp_id");
        this.parseProfitAccountInfo();
        if (this.isSplitProfitAndLoss()) {
            this.sumByCurrencyLossBalance = new DimensionSumBalacneInfo();
            this.lossAssgrpId = super.getDataEntity().getLong("lossassgrp_id");
            DynamicObject lossAccount = this.getDataEntity().getDynamicObject("lossaccount");
            accountVersionParam.setAccount(lossAccount);
            accountVersionParam.setAccountMasterid(lossAccount.getLong("masterid"));
            accountVersionParam.setAccountNumber(lossAccount.getString("number"));
            DynamicObject currVersionLossAccount = AccountRefUtils.getCurVersionAccount((AccountVersionReplaceParam)accountVersionParam);
            this.lossAccountId = currVersionLossAccount.getLong("id");
            this.parseLossAccountInfos();
        }
        if (this.enableMulCur()) {
            this.mulCurSumByCurrencyProfitBalance = new HashMap<String, DimensionSumBalacneInfo>(this.getMurCurConfigs().size());
            this.mulCurSumByCurrencyLossBalance = new HashMap<String, DimensionSumBalacneInfo>(this.getMurCurConfigs().size());
            for (LocalCurrencyConfigVO curConfig : this.getMurCurConfigs()) {
                this.mulCurSumByCurrencyProfitBalance.put(curConfig.getNumber(), new DimensionSumBalacneInfo());
                if (!this.isSplitProfitAndLoss) continue;
                this.mulCurSumByCurrencyLossBalance.put(curConfig.getNumber(), new DimensionSumBalacneInfo());
            }
        }
        this.adjustStyle = Integer.parseInt(this.getDataEntity().getString("adjuststyle"));
        this.pageId = option.containsVariable("pageId") ? option.getVariableValue("pageId") : "";
        this.initCurrencyToRate();
        this.initComAssist();
    }

    public Table<Long, Long, ExchangeRate> getCurRateConfig() {
        return this.curRateConfig;
    }

    @Override
    public String getVoucherDesc() {
        return super.getDataEntity().getString("voucherdesc");
    }

    public Long getProfitAccountId() {
        return this.profitAccountId;
    }

    public Long getLossAccountId() {
        if (this.lossAccountId > 0L) {
            return this.lossAccountId;
        }
        return this.getProfitAccountId();
    }

    public String getAccountType(long accId) {
        DynamicObject accType = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"accounttype.accounttype", (QFilter[])new QFilter("id", "=", (Object)accId).toArray());
        return accType.getString("accounttype.accounttype");
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getProfitAccountCurrencyType() {
        return this.profitAccountCurrencyType;
    }

    public List<Long> getProfitAccountCurrencyIds() {
        return this.profitAccountCurrencyIds;
    }

    public String getLossAccountCurrencyType() {
        return this.lossAccountCurrencyType;
    }

    public List<Long> getLossAccountCurrencyIds() {
        return this.lossAccountCurrencyIds;
    }

    public DynamicObject getPeriodDyn() {
        return this.periodDyn;
    }

    @Override
    public Date getBizDate() {
        return this.bizDate;
    }

    public VoucherInfo getLossVoucherInfo() {
        if (this.isSplitProfitAndLoss()) {
            if (this.lossVoucherInfo == null) {
                this.lossVoucherInfo = super.getVoucherInfo().copy();
            }
            return this.lossVoucherInfo;
        }
        return super.getVoucherInfo();
    }

    public VoucherInfo getLossVoucherInfo(String mulCurType) {
        if ("BaseCurrency".equals(mulCurType)) {
            return this.getLossVoucherInfo();
        }
        if (this.isSplitProfitAndLoss()) {
            if (this.mulCurLossVoucherInfo == null) {
                this.mulCurLossVoucherInfo = new HashMap<String, VoucherInfo>();
            }
            if (!this.mulCurLossVoucherInfo.containsKey(mulCurType)) {
                this.mulCurLossVoucherInfo.put(mulCurType, super.getVoucherInfo(mulCurType).copy());
            }
            return this.mulCurLossVoucherInfo.get(mulCurType);
        }
        return super.getVoucherInfo(mulCurType);
    }

    public boolean isSetAccount() {
        return this.isSetAccount;
    }

    public final DynamicObjectCollection getAccountEntries() {
        return this.getDataEntity().getDynamicObjectCollection("accountentry");
    }

    public final DynamicObjectCollection getCurrencyEntries() {
        return this.getDataEntity().getDynamicObjectCollection("locentry");
    }

    public List<String> getAccountNumbers() {
        return this.accountNumbers;
    }

    public List<Long> getAccounts() {
        return this.accounts;
    }

    public List<Long> getCurrencys() {
        return this.currencys;
    }

    public boolean isSetRate() {
        return this.isSetRate;
    }

    public boolean isSetCurrency() {
        return this.isSetCurrency;
    }

    public boolean isNoNegative() {
        return this.isNoNegative;
    }

    @Deprecated
    public boolean isReverse() {
        return this.isReverse;
    }

    public String getAccDirectionType() {
        return this.accDirectionType;
    }

    public final Long getExrateTableId() {
        return this.exrateTableId;
    }

    public DimensionSumBalacneInfo getSumByCurrencyProfitBalance() {
        return this.sumByCurrencyProfitBalance;
    }

    public DimensionSumBalacneInfo getSumByCurrencyProfitBalance(String mulCurType) {
        if ("BaseCurrency".equals(mulCurType)) {
            return this.getSumByCurrencyProfitBalance();
        }
        return this.mulCurSumByCurrencyProfitBalance.get(mulCurType);
    }

    public int getComAssistCount() {
        return this.comAssistCount;
    }

    public RecordDirection getPLAccountRecordDirection() {
        String direction = super.getDataEntity().getString(this.schema.plAccountDirectionCtrl.toFullName());
        return RecordDirection.of(direction);
    }

    public DimensionSumBalacneInfo getSumByCurrencyLossBalance() {
        if (this.isSplitProfitAndLoss()) {
            return this.sumByCurrencyLossBalance;
        }
        return this.getSumByCurrencyProfitBalance();
    }

    public DimensionSumBalacneInfo getSumByCurrencyLossBalance(String mulCurType) {
        if ("BaseCurrency".equals(mulCurType)) {
            return this.getSumByCurrencyLossBalance();
        }
        if (this.isSplitProfitAndLoss()) {
            return this.mulCurSumByCurrencyLossBalance.get(mulCurType);
        }
        return this.getSumByCurrencyProfitBalance(mulCurType);
    }

    public final boolean isSplitProfitAndLoss() {
        return this.isSplitProfitAndLoss;
    }

    public Long getProfitAssgrpId() {
        return this.profitAssgrpId;
    }

    public Long getLossAssgrpId() {
        if (this.isSplitProfitAndLoss()) {
            return this.lossAssgrpId;
        }
        return this.getProfitAssgrpId();
    }

    public List<String> getLossAccountFlexs() {
        if (this.isSplitProfitAndLoss()) {
            return this.lossAccountFlexs;
        }
        return this.getProfitAccountFlexs();
    }

    public List<String> getProfitAccountFlexs() {
        return this.profitAccountFlexs;
    }

    public boolean existsCurrencyIdInProfitAccountCurrencyIds(Long currencyId) {
        if ("allcurrency".equals(this.getProfitAccountCurrencyType())) {
            return true;
        }
        if ("nocurrency".equals(this.getProfitAccountCurrencyType())) {
            return false;
        }
        return this.getProfitAccountCurrencyIds().contains(currencyId);
    }

    public boolean existsCurrencyIdInLossAccountCurrencyIds(Long currencyId) {
        if (this.isSplitProfitAndLoss()) {
            if ("allcurrency".equals(this.getLossAccountCurrencyType())) {
                return true;
            }
            if ("nocurrency".equals(this.getLossAccountCurrencyType())) {
                return false;
            }
            return this.getLossAccountCurrencyIds().contains(currencyId);
        }
        return this.existsCurrencyIdInProfitAccountCurrencyIds(currencyId);
    }

    public DataSet getBalance() {
        DataSet result = null;
        HashSet<String> setAcctNumsNotSetAsst = new HashSet<String>(10);
        DynamicObjectCollection accountEntries = this.getAccountEntries();
        ArrayList<Tuple2> pk2assgrpSet = new ArrayList<Tuple2>(accountEntries.size());
        if (this.isSetAccount()) {
            for (DynamicObject accountEntry : accountEntries) {
                DynamicObject adjustAccount = accountEntry.getDynamicObject("accountid");
                adjustAccount = AccountRefUtils.getCurVersionAccount((AccountVersionReplaceParam)new AccountVersionReplaceParam(this.getOrgId().longValue(), adjustAccount.getLong("masterid"), 0L, 0L, adjustAccount.getString("number"), this.getCurPeriodDyn(), this.getAccountBookInfo().getBookTypeId(), adjustAccount, 0L));
                String accountNumber = adjustAccount.getString("number");
                if (accountEntry.getBoolean("accountid.isassist")) {
                    DynamicObjectCollection assgrpEntries = accountEntry.getDynamicObjectCollection("assgrpentry");
                    DataSet assgrpDataSet = this.getAssgrpDataSet(assgrpEntries);
                    if (assgrpDataSet != null) {
                        pk2assgrpSet.add(new Tuple2((Object)accountNumber, (Object)assgrpDataSet));
                        continue;
                    }
                    setAcctNumsNotSetAsst.add(accountNumber);
                    continue;
                }
                setAcctNumsNotSetAsst.add(accountNumber);
            }
            if (setAcctNumsNotSetAsst.size() > 0) {
                if (DebugTrace.enable()) {
                    log.info("AdjustSchemeInfo_getBanlance_setAcctNumsNotSetAsst:{}", (Object)String.join((CharSequence)",", setAcctNumsNotSetAsst));
                }
                QueryParam queryParam = this.buildQueryParam(setAcctNumsNotSetAsst);
                result = this.getBalanceByQueryParam(queryParam, null);
            }
            HashSet<String> accountNumberSingleSet = new HashSet<String>(1);
            if (pk2assgrpSet.size() > 0) {
                for (Tuple2 numberAssgrp : pk2assgrpSet) {
                    accountNumberSingleSet.clear();
                    accountNumberSingleSet.add((String)numberAssgrp.t1);
                    QueryParam param = this.buildQueryParam(accountNumberSingleSet);
                    DataSet balanceDs = this.getBalanceByQueryParam(param, (DataSet)numberAssgrp.t2);
                    if (result == null) {
                        result = balanceDs;
                        continue;
                    }
                    result = result.union(balanceDs);
                }
            }
        } else {
            QueryParam queryParam = this.buildQueryParam(null);
            result = this.getBalanceByQueryParam(queryParam, null);
        }
        if (result != null) {
            if (this.isNoNegative()) {
                result = result.filter("endfor >= 0 and acctdc == '1' or endfor <= 0 and acctdc == '-1'");
            }
            return result.groupBy(result.getRowMeta().getFieldNames()).finish();
        }
        return result;
    }

    private DataSet getAssgrpDataSet(DynamicObjectCollection assgrpEntries) {
        FinalProcessAssgrp finalProcessAssgrp = FinalProcessAssgrp.create(assgrpEntries);
        return finalProcessAssgrp == null ? null : finalProcessAssgrp.getHgIdSet();
    }

    private DataSet getBalanceByQueryParam(QueryParam queryParam, DataSet assgrpDs) {
        AccountBookInfo accountBookInfo = super.getAccountBookInfo();
        long orgId = accountBookInfo.getOrgId();
        long bookStypeId = accountBookInfo.getBookTypeId();
        long periodId = this.getCurPeriodId();
        long accountTableId = AccSysUtil.getCurPeriodAccountTableId(orgId, bookStypeId, periodId);
        queryParam.setZeroBalNoDisplay(true);
        queryParam.setOnlyLeafAcctBal(true);
        List customFilters = queryParam.getCustomFilter() != null ? queryParam.getCustomFilter() : new ArrayList(8);
        for (Map.Entry<String, Set<Long>> comAssistIdsEntry : this.comAssistIdsMap.entrySet()) {
            String comAssistField = comAssistIdsEntry.getKey();
            customFilters.add(new QFilter(comAssistField, "in", comAssistIdsEntry.getValue()));
        }
        StringBuilder selectFields = new StringBuilder(String.join((CharSequence)",", SELECT_FIELDS));
        StringBuilder outputFields = new StringBuilder(String.join((CharSequence)",", OUTPUT_FIELDS));
        for (int index = 0; index < this.comAssistCount; ++index) {
            selectFields.append(", ").append(CommonAssistUtil.getComassistField(index + 1));
            outputFields.append(", ").append(CommonAssistUtil.getComassistField(index + 1));
        }
        for (LocalCurrencyConfigVO config : this.getMurCurConfigs()) {
            selectFields.append(", ").append(config.getBalanceField(MCT.END).getMetaId());
            outputFields.append(", ").append(config.getBalanceField(MCT.END).getMetaId());
        }
        queryParam.setCustomFilter(customFilters);
        if (DebugTrace.enable()) {
            log.info("getBalanceByQueryParam, \nqueryParam: {} \nassgrpDs: {}", (Object)queryParam, null == assgrpDs ? "null" : DataSetHelper.printDataSet(assgrpDs));
        }
        DataSet balanceDs = BalanceQueryExecutor.getInstance().getBalance(selectFields.toString(), new Long[]{orgId}, bookStypeId, accountTableId, periodId, periodId, queryParam);
        if (DebugTrace.enable()) {
            log.info("getBalanceByQueryParam, \nbalanceDs.isEmpty: {}\nbalanceDs: {}", null == balanceDs ? "null" : Boolean.valueOf(balanceDs.copy().isEmpty()), DataSetHelper.printDataSet(balanceDs));
        }
        if (null == balanceDs) {
            return null;
        }
        balanceDs = balanceDs.select(outputFields.toString().split(","));
        if (assgrpDs != null) {
            balanceDs = balanceDs.join(assgrpDs, JoinType.INNER).on("assgrp", "hg").select(outputFields.toString().split(",")).finish();
        }
        return balanceDs;
    }

    private QueryParam buildQueryParam(Set<String> accountNumbers) {
        QueryParam queryParam = new QueryParam();
        QFilter accountFilter = new QFilter("ischangecurrency", "=", (Object)"1");
        if (this.isSetAccount()) {
            if (accountNumbers != null && accountNumbers.size() > 0) {
                HashSet allLeafAccountNumSet = new HashSet(8);
                for (String accountNum : accountNumbers) {
                    allLeafAccountNumSet.addAll(this.leafAcctNumberMap.getOrDefault(accountNum, Collections.singleton(accountNum)));
                }
                accountFilter.and(new QFilter("number", "in", allLeafAccountNumSet));
            } else {
                accountFilter.and(new QFilter("number", "in", this.getAccountNumbers()));
            }
        } else {
            accountFilter.and(AccountUtils.getAccTypeFilter(this.getAccountTableId(), !AccountType.isBudGetType((String)this.getAccountType(this.getProfitAccountId()))));
        }
        QFBuilder filter = AccountUtils.getAccountFilter((long)this.getOrgId(), (long)this.getAccountTableId(), this.getCurPeriodId(), true, accountFilter);
        queryParam.setAccountFilter((QFilter)filter.toList().stream().reduce((x, y) -> x.and(y)).get());
        if (this.isSetCurrency()) {
            queryParam.setCurrencyIds(this.getCurrencys().toArray(new Long[0]));
        }
        if (DebugTrace.enable()) {
            log.info("AdjustSchemeInfo_getBanlance_buildQueryParam:{}", (Object)queryParam.toString());
        }
        return queryParam;
    }

    public Date getRateDate() {
        int assignedDateRateStyle = 3;
        if (assignedDateRateStyle == this.adjustStyle) {
            String curMonthTag = "1";
            String firstDayTag = "1";
            boolean isCurMonth = this.getDataEntity().getString("ratemonthbtngrp").equals(curMonthTag);
            boolean isFirstDay = this.getDataEntity().getString("date").equals(firstDayTag);
            DynamicObject periodDyn = this.getPeriodDyn();
            Date assignedDate = null;
            String beginDate = "beginDate";
            String endDate = "endDate";
            if (isCurMonth) {
                assignedDate = isFirstDay ? (Date)periodDyn.get(beginDate) : (Date)periodDyn.get(endDate);
            } else {
                DynamicObject nextPeriodDyn = GLUtil.getNextPeriod(periodDyn.get("id"), false);
                if (nextPeriodDyn == null) {
                    throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u6240\u6307\u5b9a\u4e0b\u4e00\u671f\u7684\u6c47\u7387\u65e5\u671f\u4e0d\u5b58\u5728,\u8bf7\u4fee\u6539\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"AdjustSchemeInfo_3", (String)"fi-gl-common", (Object[])new Object[0]));
                }
                assignedDate = isFirstDay ? (Date)nextPeriodDyn.get(beginDate) : (Date)nextPeriodDyn.get(endDate);
            }
            return assignedDate;
        }
        return this.getBizDate();
    }

    private void parseProfitAccountInfo() {
        DynamicObject accountDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (QFilter[])new QFilter("id", "=", (Object)this.getProfitAccountId()).toArray());
        this.profitAccountCurrencyType = accountDyn.getString("acctcurrency");
        if ("nocurrency".equals(this.getProfitAccountCurrencyType())) {
            this.profitAccountCurrencyIds = Collections.emptyList();
        } else if ("descurrency".equals(this.getProfitAccountCurrencyType())) {
            this.profitAccountCurrencyIds = accountDyn.getDynamicObjectCollection("currencyentry").stream().map(x -> x.getLong("currency.id")).collect(Collectors.toList());
        }
        boolean isAssist = accountDyn.getBoolean("isassist");
        this.profitAccountFlexs = isAssist ? accountDyn.getDynamicObjectCollection("checkitementry").stream().map(x -> x.getString("asstactitem.flexfield")).collect(Collectors.toList()) : Collections.emptyList();
    }

    private void parseLossAccountInfos() {
        DynamicObject accountDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (QFilter[])new QFilter("id", "=", (Object)this.getLossAccountId()).toArray());
        this.lossAccountCurrencyType = accountDyn.getString("acctcurrency");
        if ("nocurrency".equals(this.getLossAccountCurrencyType())) {
            this.lossAccountCurrencyIds = Collections.emptyList();
        } else if ("descurrency".equals(this.getLossAccountCurrencyType())) {
            this.lossAccountCurrencyIds = accountDyn.getDynamicObjectCollection("currencyentry").stream().map(x -> x.getLong("currency.id")).collect(Collectors.toList());
        }
        boolean isAssist = accountDyn.getBoolean("isassist");
        this.lossAccountFlexs = isAssist ? accountDyn.getDynamicObjectCollection("checkitementry").stream().map(x -> x.getString("asstactitem.flexfield")).collect(Collectors.toList()) : Collections.emptyList();
    }

    private void initCurrencyToRate() {
        this.addCurRateConfigs(this.getBaseCurrencyId(), RateServiceHelper.batchGetExchangeRate(null, (Long)this.getBaseCurrencyId(), (Long)this.getExrateTableId(), (Date)this.getRateDate()));
        for (LocalCurrencyConfigVO config : this.getMurCurConfigs()) {
            this.addCurRateConfigs(config.getCurrencyId(this.getOrgId().longValue(), this.getAccountBookInfo().getBookTypeId()), RateServiceHelper.batchGetExchangeRate(null, (Long)config.getCurrencyId(this.getOrgId().longValue(), this.getAccountBookInfo().getBookTypeId()), (Long)config.getExRateTableId(this.getOrgId().longValue(), this.getAccountBookInfo().getBookTypeId()), (Date)this.getRateDate()));
        }
        this.getAppointExchangeRate();
    }

    private void addCurRateConfigs(Long baseCurId, Map<Long, ExchangeRate> columns) {
        for (Map.Entry<Long, ExchangeRate> entry : columns.entrySet()) {
            this.curRateConfig.put((Object)baseCurId, (Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    private void getAppointExchangeRate() {
        if (this.isSetRate()) {
            this.getCurrencyEntries().forEach(x -> {
                BigDecimal rate;
                long currencyId = x.getLong(GLField.id_("loccurrency"));
                long tarCurId = this.enableMulCur() && StringUtils.isNotBlank((CharSequence)this.getDataEntity().getString("mulcuradjust")) ? x.getLong(GLField.id_("tarcur")) : this.getBaseCurrencyId().longValue();
                ExchangeRate curTimeRate = (ExchangeRate)this.curRateConfig.get((Object)tarCurId, (Object)currencyId);
                int scale = 8;
                if (curTimeRate != null) {
                    scale = curTimeRate.getValue().scale();
                }
                if ((rate = x.getBigDecimal("rate")) != null) {
                    Long baseCurrencyId = this.getBaseCurrencyId();
                    Date rateDate = this.getRateDate();
                    RateType rateType = RateServiceHelper.getRateType((long)currencyId, (long)baseCurrencyId, (Date)rateDate);
                    ExchangeRate exchangeRate = new ExchangeRate();
                    exchangeRate.setRateType(rateType);
                    if (Objects.requireNonNull(rateType) == RateType.DIRECT_RATE) {
                        exchangeRate.setDirectRate(rate.setScale(scale, RoundingMode.HALF_UP));
                    } else {
                        exchangeRate.setIndirectRate(rate.setScale(scale, RoundingMode.HALF_UP));
                    }
                    this.curRateConfig.put((Object)tarCurId, (Object)currencyId, (Object)exchangeRate);
                }
            });
        }
    }

    private void initComAssist() {
        this.comAssistIdsMap = new HashMap<String, Set<Long>>(8);
        DynamicObject schemaDyo = this.getDataEntity();
        Set comAssistKeySet = ((BillEntityType)schemaDyo.getDynamicObjectType()).getAllFields().keySet().stream().filter(key -> key.startsWith("comassist")).collect(Collectors.toSet());
        for (String comAssistKey : comAssistKeySet) {
            Set comAssistIdSet = schemaDyo.getDynamicObjectCollection(comAssistKey).stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (!CollectionUtils.isNotEmpty(comAssistIdSet)) continue;
            this.comAssistIdsMap.put(comAssistKey, comAssistIdSet);
        }
        ComAssistTable comAssistTable = ComAssistTable.get(this.getAccountBookInfo().getAccountTableId());
        this.comAssistCount = comAssistTable != null && CollectionUtils.isNotEmpty(comAssistTable.getCommonAssists()) ? comAssistTable.getCommonAssists().size() : 0;
    }

    private Map<String, Set<String>> getLeafAcctNumber(Set<String> acctNumberSet) {
        ArrayList<QFilter> customFilterList = new ArrayList<QFilter>(3);
        customFilterList.add(new QFilter("startdate", "<=", (Object)this.getCurPeriodEndDate()));
        customFilterList.add(new QFilter("enddate", ">=", (Object)this.getCurPeriodEndDate()));
        customFilterList.add(new QFilter("ischangecurrency", "=", (Object)"1"));
        return AccountUtils.getLeafAcctNumByNum(this.getOrgId(), this.getAccountTableId(), acctNumberSet, customFilterList);
    }
}

