/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info.scheme;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.constant.basedata.CurrencyConstant;
import kd.fi.gl.enums.FinalProcessCommonFieldKey;
import kd.fi.gl.finalprocess.info.scheme.DynamicEntry;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;

public abstract class AbstractEndingProcessScheme {
    private static final String MASTERID = "masterid";
    private DynamicObject schemeDyn;
    private AccountBookInfo accountBookInfo;
    private Date curDate;
    private FinalProcessCommonFieldKey commonFieldKey;

    public final void makeFinalProcessSchemeInfo(DynamicObject schemeDyn, FinalProcessCommonFieldKey commonFieldKey, Long openPeriodID) {
        if (schemeDyn == null) {
            return;
        }
        this.schemeDyn = schemeDyn;
        long orgId = schemeDyn.getLong(GLField.id_("org"));
        long booksTypeId = schemeDyn.getLong(GLField.id_(commonFieldKey.getBooksTypeFieldKey()));
        this.accountBookInfo = AccSysUtil.getBookFromAccSys(orgId, booksTypeId);
        this.curDate = new Date();
        this.commonFieldKey = commonFieldKey;
    }

    public abstract String getEndingProcessType();

    public AbstractEndingProcessScheme(DynamicObject schemeDyn, FinalProcessCommonFieldKey commonFieldKey, Long openPeriodID) {
        this.makeFinalProcessSchemeInfo(schemeDyn, commonFieldKey, openPeriodID);
    }

    public AbstractEndingProcessScheme(AccountBookInfo accountBookInfo) {
        this.accountBookInfo = accountBookInfo;
    }

    private Long getSelfVoucherTypeId(String fieldVoucherType) {
        String entityVoucherType = "gl_vouchertype";
        Long voucherTypeId = this.getDataEntity().getLong(GLField.id_(fieldVoucherType));
        List<Long> selfBaseDatas = this.getSelfBaseDatas(entityVoucherType, voucherTypeId);
        if (selfBaseDatas.size() > 0) {
            return selfBaseDatas.get(0);
        }
        return null;
    }

    public DynamicObject getDataEntity() {
        return this.schemeDyn;
    }

    public AccountBookInfo getAccountBookInfo() {
        return this.accountBookInfo;
    }

    public DynamicObject getCurPeriodDyn() {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)this.getCurPeriodId()).toArray());
    }

    public Date getCurPeriodEndDate() {
        String filedEndDate = "enddate";
        return this.getCurPeriodDyn().getDate(filedEndDate);
    }

    public Date getCurDate() {
        return this.curDate;
    }

    public Date getBizDate() {
        return this.getCurDate();
    }

    public DynamicObject getBaseCurrencyDyn() {
        Long baseCurrencyId = this.accountBookInfo.getBaseCurrencyId();
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter("id", "=", (Object)baseCurrencyId).toArray());
    }

    public Long getVoucherTypeId() {
        return this.getSelfVoucherTypeId(this.commonFieldKey.getVoucherTypeFieldKey());
    }

    public Long getOrgId() {
        return this.getAccountBookInfo().getOrgId();
    }

    public Long getBaseCurrencyId() {
        return this.getAccountBookInfo().getBaseCurrencyId();
    }

    public Long getExchangeTableId() {
        return this.getAccountBookInfo().getExrateTableId();
    }

    public Long getAccountTableId() {
        return this.getAccountBookInfo().getAccountTableId();
    }

    public Long getCurPeriodId() {
        return this.accountBookInfo.getCurPeriodId();
    }

    public List<Long> getSelfBaseDatas(String entity, Long ... pks) {
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)entity, (String)MASTERID, (QFilter[])new QFilter("id", "in", (Object)pks).toArray());
        List masterIds = dyns.stream().map(x -> x.getLong(MASTERID)).collect(Collectors.toList());
        QFilter masterIdFilter = new QFilter(MASTERID, "in", masterIds);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)this.getOrgId());
        DynamicObjectCollection selfBaseDatas = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{baseDataFilter, masterIdFilter});
        return selfBaseDatas.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
    }

    public int getBaseCurrencyAmtPrecision() {
        return this.getBaseCurrencyDyn().getInt(CurrencyConstant.Entity_AMT_Scale.toString());
    }

    public long getPkValue() {
        return (Long)this.schemeDyn.getPkValue();
    }

    public DynamicEntry getDynamicEntry(PropertyKey ... propToInit) {
        return new DynamicEntry(this.getDataEntity(), propToInit);
    }
}

