/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.info.scheme;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.finalprocess.info.scheme.AbstractPropRepository;
import kd.fi.gl.finalprocess.info.scheme.DynamicEntry;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;

public class DynamicEntity
extends AbstractPropRepository {
    private final String key;
    private final Set<PropertyKey> entityProps;
    private final Map<String, DynamicEntry> dynamicEntryRepository;
    private final Map<PropertyKey, Object> entityPropsRepository;

    public DynamicEntity(DynamicObject schemeDyo, PropertyKey ... props) {
        this.key = schemeDyo.getDataEntityType().getName();
        HashSet<PropertyKey> entityPropSet = new HashSet<PropertyKey>(8);
        HashSet entryPropSet = new HashSet(8);
        Arrays.stream(props).forEach(prop -> {
            Set setToAdd;
            PropertyKey.PropType propType = prop.getPropType();
            Set set = propType == PropertyKey.PropType.entityProp ? entityPropSet : (setToAdd = propType == PropertyKey.PropType.entryProp ? entryPropSet : null);
            if (setToAdd != null) {
                setToAdd.add(prop);
            }
        });
        HashMap entry2PropsMap = new HashMap(4);
        entryPropSet.forEach(prop -> {
            Set propSetOnEntry = entry2PropsMap.getOrDefault(prop.entryKey, new HashSet(8));
            propSetOnEntry.add(prop);
            entry2PropsMap.put(prop.entryKey, propSetOnEntry);
        });
        this.dynamicEntryRepository = new HashMap<String, DynamicEntry>(4);
        entry2PropsMap.entrySet().stream().map(entry -> new DynamicEntry(schemeDyo, (String)entry.getKey(), (Set)entry.getValue())).forEach(dynamicEntry -> this.dynamicEntryRepository.put(dynamicEntry.getKey(), (DynamicEntry)dynamicEntry));
        this.entityProps = entityPropSet;
        this.entityPropsRepository = new HashMap<PropertyKey, Object>(8);
        entityPropSet.forEach(prop -> this.entityPropsRepository.put((PropertyKey)prop, schemeDyo.get(prop.toString(this.key))));
    }

    @Override
    public Map<PropertyKey, Object> getPropRepository() {
        return this.entityPropsRepository;
    }

    public DynamicEntry getEntry(PropertyKey entryProp) {
        return this.dynamicEntryRepository.get(entryProp.toString(this.key));
    }

    protected Set<PropertyKey> getEntityProps() {
        return this.entityProps;
    }
}

