/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.amort.amortstyle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.finalprocessing.amort.amortstyle.AbstractAmortInfoGetter;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherAmortSchemeUtils;

public class DateStyleInfoGetter
extends AbstractAmortInfoGetter {
    @Override
    public AmountInfo calAmountForNow() {
        if (this.isLastPeriod()) {
            BigDecimal total = this.schemeDyn.getBigDecimal("totalamount");
            BigDecimal amortAmountVal = this.schemeDyn.getBigDecimal("amortamount");
            return new AmountInfo.Builder().locAmount(total.subtract(amortAmountVal)).build();
        }
        Long bookTypeId = this.schemeDyn.getLong("accountbooks.id");
        Date dateBegin = this.schemeDyn.getDate("begindate");
        Date dateEnd = this.schemeDyn.getDate("enddate");
        BigDecimal curAmortperiod = VoucherAmortSchemeUtils.queryCurPeriodAmortPeriod(this.amortInfo.getOrgId(), bookTypeId, dateBegin, dateEnd, this.schemeDyn.getBigDecimal("planperiod"), this.amortInfo.getCurPeriodId());
        BigDecimal locAmountFowNow = this.getAmountForPerPeriod().multiply(curAmortperiod).setScale(VoucherAmortSchemeUtils.getLocScale(this.schemeDyn), RoundingMode.HALF_UP);
        return new AmountInfo.Builder().locAmount(locAmountFowNow).oriAmount(this.calOriAmountForNow(locAmountFowNow)).build();
    }

    @Override
    public Long getEndPeriodId() {
        Date dateEnd = this.schemeDyn.getDate("enddate");
        DynamicObject endPeriod = GLUtil.getPeriodByDate(dateEnd, this.amortInfo.getAccountBookInfo().getPeriodTypeId());
        return endPeriod.getLong("id");
    }
}

