/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountVersionReplaceParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.finalprocessing.info.FinalProcessingInfo;
import kd.fi.gl.util.CommonAssistUtil;

public class TransPLProgramInfo
extends FinalProcessingInfo {
    private static final long serialVersionUID = 8642280542685580517L;
    private static final String FieldKey_EDesc = "voucherdesc";
    private Map<String, Set<Long>> comAssistMap = new HashMap<String, Set<Long>>();
    private final int comAssistCount;
    private Set<Long> notEnableAccount = null;
    private HashMap<Long, String> flexMap = null;
    private Long yearProfitAcct = 0L;
    private String yearProfitAcctNumber = "";
    private Set<Long> currencySet = new HashSet<Long>();
    private Set<Long> plUnitIdSet = new HashSet<Long>();
    private boolean transPLByBalanceDirection = false;
    public static final String LOC = "loc";
    public static final String ORG = "org";
    public static final String QTY = "qty";
    public static final String TRANSPL_BALANCE_DIRECTION = "istransplbybalance";
    public static final int SPILT_SIZE = 5000;
    private HashMap<Long, Long> hmPLAccount = new HashMap();
    private static final Log logger = LogFactory.getLog(TransPLProgramInfo.class);

    public TransPLProgramInfo(DynamicObject dataEntity, OperateOption option) {
        super(dataEntity, "book", option);
        List<String> comAssistFieldKeys = dataEntity.getDataEntityType().getProperties().stream().filter(iDataEntityProperty -> iDataEntityProperty.getName().startsWith("comassist")).map(comAssist -> comAssist.getName()).collect(Collectors.toList());
        comAssistFieldKeys.forEach(key -> {
            Set comAssistValueIdSet = dataEntity.getDynamicObjectCollection(key).stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(comAssistValueIdSet)) {
                this.comAssistMap.put((String)key, comAssistValueIdSet);
            }
        });
        this.comAssistCount = CommonAssistUtil.getComAssistValSource(this.getAccountBookInfo().getAccountTableId()).size();
        this.transPLByBalanceDirection = dataEntity.getBoolean(TRANSPL_BALANCE_DIRECTION);
    }

    @Override
    public Date getBizDate() {
        return new Date();
    }

    public boolean isByAsstTrans() {
        return true;
    }

    public HashMap<Long, Long> getHmPLAccount() {
        if (this.hmPLAccount.isEmpty()) {
            DynamicObjectCollection transPLProgramEntryCollection = this.getDataEntity().getDynamicObjectCollection("transacct");
            AccountBookInfo accountBookInfo = this.getAccountBookInfo();
            DynamicObject periodDyn = this.getCurPeroid();
            long orgId = accountBookInfo.getOrgId();
            for (DynamicObject acct : transPLProgramEntryCollection) {
                DynamicObject acctObj = acct.getDynamicObject("fbasedataid");
                Date startdate = acctObj.getDate("startdate");
                if (startdate.compareTo(periodDyn.getDate("enddate")) > 0) {
                    AccountVersionReplaceParam accountVersionReplaceParam = new AccountVersionReplaceParam(orgId, acctObj.getLong("masterid"), 0L, 0L, acctObj.getString("number"), periodDyn, accountBookInfo.getBookTypeId(), acctObj, 0L);
                    if (!(acctObj = AccountRefUtils.getCurVersionAccount((AccountVersionReplaceParam)accountVersionReplaceParam)).getBoolean("isleaf")) {
                        throw new GLException(GLErrorCode.common, String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u7684%s\u79d1\u76ee\u4e3a\u975e\u660e\u7ec6\u79d1\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ed3\u8f6c\u79d1\u76ee\u3002", (String)"TransPLProgramInfo_2", (String)"fi-gl-common", (Object[])new Object[0]), acctObj.getString("number")));
                    }
                    this.hmPLAccount.put(acctObj.getLong("id"), this.getYearProfitAcct());
                    continue;
                }
                this.hmPLAccount.put(acct.getLong("fbasedataid_id"), this.getYearProfitAcct());
            }
        }
        return this.hmPLAccount;
    }

    public Long getAssgrpId() {
        return this.getDataEntity().getLong("assgrp_id");
    }

    public Long getYearProfitAcct() {
        if (this.yearProfitAcct <= 0L) {
            DynamicObject yearProfitAccount = this.getDataEntity().getDynamicObject("yearprofitacct");
            AccountBookInfo accountBookInfo = this.getAccountBookInfo();
            long orgId = accountBookInfo.getOrgId();
            DynamicObject periodDyn = this.getCurPeroid();
            logger.info("curPeriodEndDate: {}", (Object)periodDyn.getDate("enddate"));
            AccountVersionReplaceParam accountVersionReplaceParam = new AccountVersionReplaceParam(orgId, yearProfitAccount.getLong("masterid"), 0L, 0L, yearProfitAccount.getString("number"), periodDyn, accountBookInfo.getBookTypeId(), yearProfitAccount, 0L);
            yearProfitAccount = AccountRefUtils.getCurVersionAccount((AccountVersionReplaceParam)accountVersionReplaceParam);
            if (!yearProfitAccount.getBoolean("isleaf")) {
                throw new GLException(GLErrorCode.common, String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u7684%s\u79d1\u76ee\u4e3a\u975e\u660e\u7ec6\u79d1\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u672c\u5e74\u5229\u6da6\u79d1\u76ee\u3002", (String)"TransPLProgramInfo_0", (String)"fi-gl-common", (Object[])new Object[0]), yearProfitAccount.getString("number")));
            }
            this.yearProfitAcct = yearProfitAccount.getLong("id");
            this.yearProfitAcctNumber = yearProfitAccount.getString("number");
            boolean isqty = yearProfitAccount.getBoolean("isqty");
            long unitGroupId = yearProfitAccount.getLong("measureunitgroup_id");
            long unitId = yearProfitAccount.getLong("measureunit_id");
            logger.info("yearProfitAcct: {}", (Object)this.yearProfitAcct);
            if (isqty) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                if (unitGroupId != 0L) {
                    QFilter fgroupId = new QFilter("group", "=", (Object)unitGroupId);
                    qFilters.add(fgroupId);
                    if (unitId != 0L) {
                        QFilter fId = new QFilter("id", "=", (Object)unitId);
                        qFilters.add(fId);
                    }
                }
                DataSet unitSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_measureunits", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), null);
                for (Row row : unitSet) {
                    this.plUnitIdSet.add(row.getLong("id"));
                }
                if (DebugTrace.enable()) {
                    logger.info("plUnitIdSet: {}", this.plUnitIdSet);
                }
            }
        }
        return this.yearProfitAcct;
    }

    public Set<Long> getPLUnitSet() {
        if (this.yearProfitAcct <= 0L) {
            this.getYearProfitAcct();
        }
        return this.plUnitIdSet;
    }

    public boolean isContainPLUnit(long unitId) {
        if (this.yearProfitAcct <= 0L) {
            this.getYearProfitAcct();
        }
        return this.plUnitIdSet.contains(unitId);
    }

    public Set<Long> getYearProfitAcctCurrencyIds() {
        if (this.currencySet != null && this.currencySet.isEmpty()) {
            DynamicObject yearCurrencys = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getYearProfitAcct(), (String)"bd_accountview");
            String acctcurrency = yearCurrencys.getString("acctcurrency");
            if ("descurrency".equals(acctcurrency)) {
                DynamicObjectCollection currencyColl = yearCurrencys.getDynamicObjectCollection("currencyentry");
                currencyColl.forEach(v -> this.currencySet.add(v.getDynamicObject("currency").getLong("id")));
            } else if ("allcurrency".equals(acctcurrency)) {
                return null;
            }
            logger.info("getYearProfitAcctCurrencyIds, acctcurrency: {}, currencySet: {}", (Object)acctcurrency, this.currencySet);
        }
        return this.currencySet;
    }

    public long getVoucherTypeId() {
        return this.getDataEntity().getDynamicObject("vouchertypeid").getLong("id");
    }

    public String getVoucherDesc() {
        String eDesc = this.getDataEntity().getString(FieldKey_EDesc);
        return StringUtils.isNotBlank((CharSequence)eDesc) ? eDesc : ResManager.loadKDString((String)"\u7ed3\u8f6c\u635f\u76ca", (String)"TransPLProgramInfo_1", (String)"fi-gl-common", (Object[])new Object[0]);
    }

    public boolean isYearProfitByOriginal() {
        return true;
    }

    public boolean isTransByBaseCurrency() {
        return this.getDataEntity().getBoolean("basetrans");
    }

    public boolean isByPl() {
        return this.getDataEntity().getBoolean("chkbypl");
    }

    public Set<Long> getNotEnableAccount() {
        if (null == this.notEnableAccount) {
            HashSet<Long> idSet = new HashSet<Long>(8);
            AccountBookInfo bookInfo = this.getAccountBookInfo();
            QFilter orgqf = new QFilter(ORG, "=", (Object)bookInfo.getOrgId());
            QFilter enableqf = new QFilter("enable", "=", (Object)"0");
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{orgqf, enableqf}, null);){
                while (dataSet.hasNext()) {
                    idSet.add(dataSet.next().getLong("id"));
                }
            }
            this.notEnableAccount = idSet;
        }
        return this.notEnableAccount;
    }

    public String getYearProfitAcctNumber() {
        return this.yearProfitAcctNumber;
    }

    public boolean isTransPLByBalanceDirection() {
        return this.transPLByBalanceDirection;
    }

    public HashMap<Long, String> getYearProfitAcctBasedataUsedFlexProperties() {
        if (null == this.flexMap) {
            this.flexMap = this.getBasedataUsedFlexProperties(this.getYearProfitAcct());
        }
        return this.flexMap;
    }

    private HashMap<Long, String> getBasedataUsedFlexProperties(Long accountId) {
        HashMap<Long, String> dataMap = new HashMap<Long, String>();
        if (accountId == null || accountId == 0L) {
            throw new GLException(GLErrorCode.common, ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5229\u6da6\u79d1\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"TransPLProgramsGenVchOperateService_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview");
        DynamicObjectCollection checkitementry = dy.getDynamicObjectCollection("checkitementry");
        for (DynamicObject dynamicObject : checkitementry) {
            dataMap.put(dynamicObject.getLong("asstactitem_id"), dynamicObject.getDynamicObject("asstactitem").getString("flexfield"));
        }
        return dataMap;
    }

    public Map<String, Set<Long>> getComAssistMap() {
        return this.comAssistMap;
    }

    public void setComAssistMap(Map<String, Set<Long>> comAssistMap) {
        this.comAssistMap = comAssistMap;
    }

    public List<QFilter> getComAssistFilters() {
        ArrayList<QFilter> comAssistFilters = new ArrayList<QFilter>(8);
        for (Map.Entry<String, Set<Long>> comAssistEntry : this.comAssistMap.entrySet()) {
            if (!CollectionUtils.isNotEmpty((Collection)comAssistEntry.getValue())) continue;
            comAssistFilters.add(new QFilter(comAssistEntry.getKey(), "in", comAssistEntry.getValue()));
        }
        return comAssistFilters;
    }

    public int getComAssistCount() {
        return this.comAssistCount;
    }
}

