/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.fi.gl.reciprocal.AbstractRcpWriteOffLoginUnit;
import kd.fi.gl.reciprocal.ReciprocalComparator;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalScheme;

public class NegativeVoucherWriteOffLogicUnit
extends AbstractRcpWriteOffLoginUnit {
    private Map<ReciprocalRecord, ReciprocalRecord> againstMap;

    @Override
    protected void beforeWriteOffEvent() {
        this.againstMap = new HashMap<ReciprocalRecord, ReciprocalRecord>();
    }

    @Override
    public Boolean reLoadRecords() {
        return Boolean.FALSE;
    }

    @Override
    protected List<Long> getBatchRecords() {
        List<ReciprocalRecord> lstAllRecords = this.getAllRecords();
        ReciprocalScheme scheme = this.context.getScheme();
        if (scheme.isReverOrderSameDire()) {
            lstAllRecords.sort(new ReciprocalComparator("date", -1));
        } else {
            lstAllRecords.sort(new ReciprocalComparator("date", 1));
        }
        ArrayList<ReciprocalRecord> buyerRecords = new ArrayList<ReciprocalRecord>();
        ArrayList<ReciprocalRecord> writeOffRecords = new ArrayList<ReciprocalRecord>();
        Iterator<ReciprocalRecord> allRecordIterator = lstAllRecords.iterator();
        this.addRecordToList(allRecordIterator, buyerRecords, writeOffRecords);
        HashSet<Long> vchIds = new HashSet<Long>();
        if (buyerRecords.isEmpty() || writeOffRecords.isEmpty()) {
            return new ArrayList<Long>(vchIds);
        }
        Map<String, List<ReciprocalRecord>> writeOffRecordMap = this.buildWriteRecordOffMap(writeOffRecords);
        for (ReciprocalRecord buyerRecord : buyerRecords) {
            List<ReciprocalRecord> lstWriteOffRecords = writeOffRecordMap.get(buyerRecord.groupByKey(this.context, false));
            if (lstWriteOffRecords == null || lstWriteOffRecords.isEmpty() || BigDecimal.ZERO.compareTo(buyerRecord.getAmountFor()) == 0 && BigDecimal.ZERO.compareTo(buyerRecord.getAmountBalFor()) == 0) continue;
            Iterator<ReciprocalRecord> iterator = lstWriteOffRecords.iterator();
            while (iterator.hasNext()) {
                ReciprocalRecord writeOffRecord = iterator.next();
                if (BigDecimal.ZERO.compareTo(writeOffRecord.getAmountFor()) == 0 && BigDecimal.ZERO.compareTo(writeOffRecord.getAmountBalFor()) == 0 || !buyerRecord.compareTo(writeOffRecord, Boolean.FALSE, scheme).booleanValue()) continue;
                this.againstMap.put(buyerRecord, writeOffRecord);
                vchIds.add(buyerRecord.getVoucherId());
                vchIds.add(writeOffRecord.getVoucherId());
                iterator.remove();
                break;
            }
            if (vchIds.size() < 1000) continue;
            break;
        }
        return new ArrayList<Long>(vchIds);
    }

    private Map<String, List<ReciprocalRecord>> buildWriteRecordOffMap(List<ReciprocalRecord> writeOffRecords) {
        HashMap<String, List<ReciprocalRecord>> writeOffRecordMap = new HashMap<String, List<ReciprocalRecord>>();
        for (ReciprocalRecord writeOffRecord : writeOffRecords) {
            String key = writeOffRecord.groupByKey(this.context, false);
            ArrayList<ReciprocalRecord> lstRecords = (ArrayList<ReciprocalRecord>)writeOffRecordMap.get(key);
            if (lstRecords == null) {
                lstRecords = new ArrayList<ReciprocalRecord>();
                writeOffRecordMap.put(key, lstRecords);
            }
            lstRecords.add(writeOffRecord);
        }
        return writeOffRecordMap;
    }

    private void addRecordToList(Iterator<ReciprocalRecord> iterator, List<ReciprocalRecord> buyerRecords, List<ReciprocalRecord> writeOffRecords) {
        while (iterator.hasNext()) {
            ReciprocalRecord p = iterator.next();
            if ("2".equals(p.getStatus())) continue;
            if ("0".equals(p.entryType())) {
                buyerRecords.add(p);
                continue;
            }
            writeOffRecords.add(p);
        }
    }

    @Override
    protected void doEveryWriteOff() {
        for (Map.Entry<ReciprocalRecord, ReciprocalRecord> entrySet : this.againstMap.entrySet()) {
            ReciprocalRecord buyerRecord = entrySet.getKey();
            ReciprocalRecord writeOffRecord = entrySet.getValue();
            this.generateWriteOffLog(buyerRecord, writeOffRecord);
        }
        this.againstMap.clear();
    }

    @Override
    public Boolean isNeedSplit() {
        return Boolean.FALSE;
    }

    @Override
    protected String getQuerySourceType() {
        return "1";
    }

    @Override
    protected String getWriteOffSourceType() {
        return "1";
    }
}

