/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.gl.reciprocal.RcpTask;
import kd.fi.gl.reciprocal.ReciprocalLog;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalScheme;

public class ReciprocalContext {
    private ReciprocalScheme scheme;
    private Map<Long, Set<Long>> vchAndEntryIdMap;
    private Map<Long, ReciprocalRecord> entryAndRecordMap;
    private List<String> errMsgs;
    private List<ReciprocalLog> reciprocalLogs;
    private List<ReciprocalRecord> successRcpRecords;
    private List<ReciprocalRecord> balZeroRecords;
    private Date writeOffDate;
    private Long writer;
    private Boolean bSimulate;
    private RcpTask task;
    private final AtomicInteger successWriteOffSize = new AtomicInteger();
    private static final Log logger = LogFactory.getLog(ReciprocalContext.class);
    private String curUnit;
    private Set<Long> loadedRecordIds;

    public ReciprocalContext(ReciprocalScheme scheme, boolean bIsSimulate) {
        this.scheme = scheme;
        this.errMsgs = new ArrayList<String>();
        this.reciprocalLogs = new ArrayList<ReciprocalLog>();
        this.successRcpRecords = new ArrayList<ReciprocalRecord>();
        this.balZeroRecords = new ArrayList<ReciprocalRecord>();
        this.vchAndEntryIdMap = new LinkedHashMap<Long, Set<Long>>();
        this.entryAndRecordMap = new LinkedHashMap<Long, ReciprocalRecord>();
        this.writeOffDate = TimeServiceHelper.now();
        this.writer = Long.valueOf(RequestContext.get().getUserId());
        this.loadedRecordIds = new HashSet<Long>();
        this.bSimulate = bIsSimulate;
    }

    public ReciprocalContext() {
        this.reciprocalLogs = new ArrayList<ReciprocalLog>();
        this.successRcpRecords = new ArrayList<ReciprocalRecord>();
        this.balZeroRecords = new ArrayList<ReciprocalRecord>();
        this.writeOffDate = TimeServiceHelper.now();
        this.writer = Long.valueOf(RequestContext.get().getUserId());
        this.bSimulate = false;
    }

    public void setCurTask(RcpTask task) {
        this.task = task;
    }

    public RcpTask getCurTask() {
        return this.task;
    }

    public ReciprocalScheme getScheme() {
        return this.scheme;
    }

    public Date getWriteOffDate() {
        return this.writeOffDate;
    }

    public Long getWriter() {
        return this.writer;
    }

    public void addReciprocalLog(ReciprocalLog log) {
        this.reciprocalLogs.add(log);
    }

    public List<ReciprocalLog> getReciprocalLogs() {
        return this.reciprocalLogs;
    }

    public void addRecords(String srcType, ReciprocalRecord record) {
        Set<Long> lstEntryIds = this.vchAndEntryIdMap.get(record.getVoucherId());
        if (lstEntryIds == null) {
            lstEntryIds = new HashSet<Long>();
            this.vchAndEntryIdMap.put(record.getVoucherId(), lstEntryIds);
        }
        lstEntryIds.add(record.getId());
        this.entryAndRecordMap.put(record.getId(), record);
        this.loadedRecordIds.add(record.getId());
    }

    public Map<Long, Set<Long>> getVoucherAndEntryMap() {
        return this.vchAndEntryIdMap;
    }

    public Map<Long, ReciprocalRecord> getEntryAndRecordMap() {
        return this.entryAndRecordMap;
    }

    public List<ReciprocalRecord> getRecords(String srcType) {
        ArrayList<ReciprocalRecord> records = new ArrayList<ReciprocalRecord>();
        if (srcType == null) {
            return records;
        }
        if ("-1".equals(srcType)) {
            records.addAll(this.entryAndRecordMap.values());
        } else {
            Set<Long> ids = this.task.getEntryIds(srcType);
            if (ids == null) {
                return null;
            }
            for (Long id : ids) {
                ReciprocalRecord record = this.entryAndRecordMap.get(id);
                if (record == null || record.getStatus().equals("2")) continue;
                records.add(record);
            }
        }
        return records;
    }

    public void removeRecords(List<ReciprocalRecord> lstRecords, Set<Long> excludeIds) {
        lstRecords.forEach(p -> {
            if (null == excludeIds || !excludeIds.contains(p.getId())) {
                this.entryAndRecordMap.remove(p.getId());
            }
        });
    }

    public void addErrMsg(String msg) {
        this.errMsgs.add(msg);
    }

    public List<String> getErrMsgs() {
        return this.errMsgs;
    }

    public void addSuccessRecord(ReciprocalRecord record) {
        this.successRcpRecords.add(record);
    }

    public List<ReciprocalRecord> getSuccessRecords() {
        return this.successRcpRecords;
    }

    public void addBalZeroRecord(ReciprocalRecord record) {
        this.balZeroRecords.add(record);
    }

    public List<ReciprocalRecord> getBalZeroRecords() {
        return this.balZeroRecords;
    }

    public Boolean IsSimulate() {
        return this.bSimulate;
    }

    public void logInfo(String info) {
        if (this.scheme != null) {
            logger.info(String.format("taskId:%s\uff0c \u5f53\u524d\u65b9\u6848\uff1a%s\uff0c\u7ec4\u7ec7%s\uff0c\u64cd\u4f5c\u65e5\u5fd7\u4fe1\u606f\uff1a%s", this.getCurTask().getTaskId(), this.scheme.getNumber(), this.scheme.getOrg(), info));
        }
    }

    public String getCurUnit() {
        return this.curUnit;
    }

    public void setCurUnit(String unitName) {
        this.curUnit = unitName;
    }

    public Set<Long> getLoadedRecordIds() {
        return this.loadedRecordIds;
    }

    public AtomicInteger getSuccessWriteOffSize() {
        return this.successWriteOffSize;
    }
}

