/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.reciprocal.AbstractRcpWriteOffLoginUnit;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalScheme;

public class VchAgainstWriteOffLogicUnit
extends AbstractRcpWriteOffLoginUnit {
    private static final int _2 = 2;
    private static final int INIT_FILTER_CAPACITY = 8;
    private static final String ORG = "org";
    private static final String ACCOUNTTABLE = "accounttable";
    private static final String BOOKTYPE = "booktype";
    private static final String PERIOD = "period";
    private static final String ACCOUNT = "account";
    private static final String CURRENCY = "currency";
    private static final String ASSGRP = "assgrp";
    private Map<Long, Long> againstMap;
    private List<Long> curTgtVchIds;
    private static final String SELECTFIELDS = "id, org.id org, booktype.id booktype, accounttable.id accounttable, period.id period, account.id account, assgrp.id assgrp, assgrp.value assval, currency.id currency,amountfor,amountbalfor,localcurrency,amount,amountbal,biznum,bizDate,voucherid,voucherentry vchentryid,sourcetype,modifytime,status,expiredate,description,masterid,writeoffperson,creator,entrydc";
    private static final Log logger = LogFactory.getLog(RcpWriteOffUtils.class);

    @Override
    protected void beforeWriteOffEvent() {
        this.againstMap = new HashMap<Long, Long>();
        this.curTgtVchIds = new ArrayList<Long>();
        ThreeTuple<Set<Long>, Set<Long>, Set<Long>> curUnitThreeTuple = this.getCurUnitFilterIds();
        Set vchids = (Set)curUnitThreeTuple.item1;
        if (!vchids.isEmpty()) {
            ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
            lstFilters.add(new QFilter("iseffective", "=", (Object)"1"));
            lstFilters.add(new QFilter("targentity", "in", new ArrayList(vchids)));
            try (DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_reverserelation", (String)"srcentity,targentity", (QFilter[])lstFilters.toArray(new QFilter[0]), (String)"");){
                while (dSet.hasNext()) {
                    Row row = dSet.next();
                    Long srcId = row.getLong("srcentity");
                    Long targetId = row.getLong("targentity");
                    this.againstMap.put(targetId, srcId);
                }
            }
        }
        ReciprocalScheme scheme = this.context.getScheme();
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(8);
        lstFilters.add(new QFilter(ORG, "=", (Object)scheme.getOrg()));
        lstFilters.add(new QFilter(BOOKTYPE, "=", (Object)scheme.getBookType()));
        if (scheme.getAccountTableId() != null) {
            lstFilters.add(new QFilter(ACCOUNTTABLE, "=", (Object)scheme.getAccountTableId()));
        }
        if (scheme.getBookedDatePeriod() != null) {
            lstFilters.add(new QFilter(PERIOD, "<=", (Object)scheme.getBookedDatePeriod()));
        }
        if (scheme.getAccountList().size() > 0) {
            lstFilters.add(new QFilter(ACCOUNT, "in", scheme.getAccountList()));
        }
        if (scheme.getCurrencyList().size() > 0) {
            lstFilters.add(new QFilter(CURRENCY, "in", scheme.getCurrencyList()));
        }
        lstFilters.add(new QFilter(ASSGRP, "in", curUnitThreeTuple.item2));
        lstFilters.add(new QFilter(CURRENCY, "in", curUnitThreeTuple.item3));
        QFilter vchIdFilter = new QFilter("voucherid", "in", this.againstMap.values());
        lstFilters.add(vchIdFilter);
        if (DebugTrace.enable()) {
            logger.info("=====reciprocalAging_taskId:{}_VchAgainstWriteOffLogicUnit_beforeWriteOffEvent_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_\u6267\u884c\u5355\u5143:{}_filters:{}=====", new Object[]{this.context.getCurTask().getTaskId(), scheme.getNumber(), scheme.getOrg(), this.getClass().getName(), JSON.toJSON(lstFilters)});
        }
        int count = 0;
        try (DataSet result = QueryServiceHelper.queryDataSet((String)"LoadRcpRecordUtils.writeOffAllRecords", (String)"gl_acccurrent", (String)SELECTFIELDS, (QFilter[])lstFilters.toArray(new QFilter[0]), null);){
            while (result.hasNext()) {
                Row row = result.next();
                if (this.context.IsSimulate().booleanValue()) {
                    Long reciprocalId = row.getLong("id");
                    Set<Long> entryIds = this.context.getCurTask().getEntryIds("-1");
                    if (!entryIds.contains(reciprocalId)) continue;
                }
                RcpWriteOffUtils.addRecord(this.context, row);
                ++count;
            }
        }
        if (DebugTrace.enable()) {
            List<ReciprocalRecord> records = this.context.getRecords("-1");
            logger.info("=====reciprocalAging_taskId:{}_VchAgainstWriteOffLogicUnit_beforeWriteOffEvent_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_\u6267\u884c\u5355\u5143:{}_count:{}_allRecords:{}_allRecords:{}=====", new Object[]{this.context.getCurTask().getTaskId(), scheme.getNumber(), scheme.getOrg(), this.getClass().getName(), count, records == null ? 0 : records.size(), records == null ? Integer.valueOf(0) : JSON.toJSON(records)});
        }
    }

    @Override
    protected List<Long> getBatchRecords() {
        this.curTgtVchIds.clear();
        if (this.againstMap == null || this.againstMap.isEmpty()) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> vchIds = new ArrayList<Long>(this.againstMap.size() * 2);
        for (Map.Entry<Long, Long> entry : this.againstMap.entrySet()) {
            Long tgtVchId = entry.getKey();
            Long srcVchid = entry.getValue();
            vchIds.add(srcVchid);
            vchIds.add(tgtVchId);
            this.curTgtVchIds.add(tgtVchId);
            if (vchIds.size() < 1000) continue;
            break;
        }
        return vchIds;
    }

    @Override
    protected void doEveryWriteOff() {
        if (this.againstMap == null || this.againstMap.isEmpty()) {
            return;
        }
        ReciprocalScheme scheme = this.context.getScheme();
        HashMap<String, List<ReciprocalRecord>> writeOffRecordMap = new HashMap<String, List<ReciprocalRecord>>();
        for (Long tgtVchId : this.curTgtVchIds) {
            Long srcVchid = this.againstMap.get(tgtVchId);
            if (srcVchid == null) continue;
            List<ReciprocalRecord> srcRecords = this.getRecordsByVchId(srcVchid);
            List<ReciprocalRecord> targetRecords = this.getRecordsByVchId(tgtVchId);
            this.writeOffByAgainstRule(scheme, writeOffRecordMap, srcRecords, targetRecords);
        }
        this.curTgtVchIds.forEach(p -> this.againstMap.remove(p));
    }

    private void writeOffByAgainstRule(ReciprocalScheme scheme, Map<String, List<ReciprocalRecord>> writeOffRecordMap, Collection<ReciprocalRecord> srcRecords, Collection<ReciprocalRecord> targetRecords) {
        if (srcRecords == null || srcRecords.isEmpty() || targetRecords == null || targetRecords.isEmpty()) {
            return;
        }
        writeOffRecordMap.clear();
        for (ReciprocalRecord writeOffRecord : targetRecords) {
            String key = writeOffRecord.groupByKey(this.context, false);
            List lstRecords = writeOffRecordMap.computeIfAbsent(key, p -> new ArrayList());
            lstRecords.add(writeOffRecord);
        }
        for (ReciprocalRecord srcRecord : srcRecords) {
            this.singleWriteOff(scheme, writeOffRecordMap, srcRecord);
        }
    }

    private void singleWriteOff(ReciprocalScheme scheme, Map<String, List<ReciprocalRecord>> writeOffRecordMap, ReciprocalRecord srcRecord) {
        List<ReciprocalRecord> lstWriteOffRecords = writeOffRecordMap.get(srcRecord.groupByKey(this.context, false));
        if (lstWriteOffRecords == null || lstWriteOffRecords.isEmpty()) {
            return;
        }
        Iterator<ReciprocalRecord> iterator = lstWriteOffRecords.iterator();
        while (iterator.hasNext()) {
            ReciprocalRecord targetRecord = iterator.next();
            if (srcRecord.compareTo(targetRecord, false, scheme).booleanValue()) {
                this.generateWriteOffLog(srcRecord, targetRecord);
            }
            if ("2".equals(targetRecord.getStatus())) {
                iterator.remove();
            }
            if (!"2".equals(srcRecord.getStatus())) continue;
            break;
        }
    }

    @Override
    public Boolean isNeedSplit() {
        return Boolean.FALSE;
    }

    private ThreeTuple<Set<Long>, Set<Long>, Set<Long>> getCurUnitFilterIds() {
        List<ReciprocalRecord> records = this.getAllRecords();
        HashSet vchIds = new HashSet();
        HashSet assgrpIds = new HashSet();
        HashSet currencyIds = new HashSet();
        records.forEach(p -> {
            vchIds.add(p.getVoucherId());
            assgrpIds.add(p.getAssgrp());
            currencyIds.add(p.getCurrency());
        });
        return new ThreeTuple(vchIds, assgrpIds, currencyIds);
    }

    @Override
    protected String getQuerySourceType() {
        return "1";
    }

    @Override
    protected String getWriteOffSourceType() {
        return "1";
    }
}

