/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.agingservice.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.CommonResult;
import kd.fi.gl.enums.ResultCode;
import kd.fi.gl.enums.WriteOffMode;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.reciprocal.agingservice.AgingContext;
import kd.fi.gl.reciprocal.agingservice.AgingQueryParam;
import kd.fi.gl.reciprocal.agingservice.AgingServiceResult;
import kd.fi.gl.reciprocal.simulate.WriteOff;
import kd.fi.gl.reciprocal.simulate.balance.vo.AssistVO;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.util.GLUtil;

public class AgingApiUtil {
    private static final String UNDUE = "undue";
    private static final String OVERDUE = "overdue";
    private static final String COLKEY_CUR = "currencyid";
    private static final String COLKEY_LOCAL_CUR = "currencylocal";
    private static final String COLKEY_ROWTYPE = "rowtype";
    private static final String COLKEY_OVERDUE = "overdue";
    private static final String COLKEY_OVERDUELOCAL = "overduelocal";
    private static final String COLKEY_UNDUE = "undue";
    private static final String COLKEY_UNDUELOCAL = "unduelocal";

    public static CommonResult<AgingServiceResult> getAgingData(AgingQueryParam queryParam) {
        DataSet dsRst = AgingApiUtil.queryAgingDataSet(queryParam);
        int count = 0;
        int agingQueryLimit = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.aging.service.query.limit", (int)100000);
        Set dsFieldSet = Arrays.stream(dsRst.getRowMeta().getFieldNames()).collect(Collectors.toSet());
        ArrayList<String> dsFields = new ArrayList<String>(8);
        Map<String, Set<Long>> assgrp = queryParam.getAssgrp();
        for (String flexfield : assgrp.keySet()) {
            if (!dsFieldSet.contains(flexfield)) continue;
            dsFields.add(flexfield);
        }
        if (queryParam.getCurrencyId() != 0L) {
            dsFields.add("undue");
            dsFields.add("overdue");
        }
        dsFields.add(COLKEY_UNDUELOCAL);
        dsFields.add(COLKEY_OVERDUELOCAL);
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(16);
        int fieldSize = dsFields.size();
        for (Row row : dsRst) {
            Object[] arr = new Object[fieldSize];
            for (int j = 0; j < dsFields.size(); ++j) {
                arr[j] = row.get((String)dsFields.get(j));
            }
            dataList.add(arr);
            if (++count <= agingQueryLimit) continue;
            return new CommonResult<Object>(ResultCode.EXCEED.getCode(), ResultCode.EXCEED.getMessage(), null);
        }
        AgingServiceResult agingResult = new AgingServiceResult(dsFields, dataList);
        return CommonResult.success(agingResult);
    }

    public static DataSet queryAgingDataSet(AgingQueryParam queryParam) {
        AgingContext agingContext = new AgingContext(queryParam);
        List<ReciprocalScheme> reciprocalSchemes = AgingApiUtil.buildReciprocalScheme(agingContext);
        DataSet ds = WriteOff.getWriteOffInstance().schemeSimulateWriteOffSummary(reciprocalSchemes);
        Set<String> dsFields = Arrays.stream(ds.getRowMeta().getFieldNames()).collect(Collectors.toSet());
        StringBuilder filter = AgingApiUtil.fileterDataSet(dsFields, agingContext);
        if (filter.length() > 0) {
            ds = ds.filter(filter.toString());
        }
        return AgingApiUtil.caculateDetailCol(ds, agingContext);
    }

    public static String validateAgingParam(AgingQueryParam queryParam) {
        DynamicObject currencyDyn;
        DynamicObject bookTypeDyn;
        long bookTypeId;
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)queryParam.getOrgId())});
        if (orgDyn == null || orgDyn.getLong("id") == 0L) {
            return ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"reciprocalUtils_20", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        long orgId = orgDyn.getLong("id");
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(orgId, bookTypeId = (bookTypeDyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)queryParam.getBookTypeId())})) == null ? 0L : bookTypeDyn.getLong("id"));
        if (bookInfo == null) {
            return ResManager.loadKDString((String)"\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"reciprocalUtils_21", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        long periodTypeId = bookInfo.getPeriodTypeId();
        queryParam.setPeriodType(periodTypeId);
        long accountTableId = bookInfo.getAccountTableId();
        queryParam.setAccountTableId(accountTableId);
        DynamicObject periodDyn = PeriodUtil.getPeriodByDate((Date)queryParam.getBookedDate(), (long)bookInfo.getPeriodTypeId());
        if (periodDyn == null) {
            return ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u5bf9\u5e94\u7684\u671f\u95f4\u4e0d\u5b58\u5728\u3002", (String)"reciprocalUtils_29", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        long accountMasterId = 0L;
        ArrayList<QFilter> accountFilters = new ArrayList<QFilter>(8);
        accountFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        accountFilters.add(new QFilter("masterid", "=", (Object)queryParam.getAccountMasterId()));
        accountFilters.add(new QFilter("accheck", "=", (Object)"1"));
        accountFilters.add(new QFilter("isleaf", "=", (Object)"1"));
        QFilter atFilter = new QFilter("startdate", "<=", (Object)periodDyn.getDate("enddate"));
        atFilter.and(new QFilter("enddate", ">=", (Object)periodDyn.getDate("enddate")));
        accountFilters.add(atFilter);
        DynamicObject acctDyn = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"masterid", (QFilter[])accountFilters.toArray(new QFilter[0]));
        if (acctDyn != null) {
            accountMasterId = acctDyn.getLong("masterid");
        }
        if (accountMasterId == 0L) {
            return ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"reciprocalUtils_22", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        if (queryParam.getCurrencyId() != 0L && (currencyDyn = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)queryParam.getCurrencyId())})) == null) {
            return ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u5b58\u5728\u3002", (String)"reciprocalUtils_23", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        int agingDayFrom = queryParam.getAgingDayFrom();
        int agingDayTo = queryParam.getAgingDayTo();
        if (agingDayTo < 0 || agingDayFrom < 0) {
            return ResManager.loadKDString((String)"\u8d26\u9f84\u6bb5\u6570\u5b57\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"reciprocalUtils_27", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        Date bookedDate = queryParam.getBookedDate();
        if (bookedDate == null) {
            return ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"reciprocalUtils_25", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        Date expireDate = queryParam.getExpireDate();
        if (expireDate == null) {
            return ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"reciprocalUtils_26", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        Integer caculateRule = queryParam.getCaculateRule();
        if (caculateRule == null || caculateRule != -1 && caculateRule != 1) {
            return ResManager.loadKDString((String)"\u8d26\u9f84\u89c4\u5219\u6709\u8bef\u3002", (String)"reciprocalUtils_24", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        boolean exists = AgingApiUtil.isEndInit(orgId, bookTypeId, accountMasterId);
        if (!exists) {
            return ResManager.loadKDString((String)"\u79d1\u76ee\u672a\u7ed3\u675f\u5f80\u6765\u4f59\u989d\u521d\u59cb\u5316\u3002", (String)"AgingApiQueryParam_9", (String)"fi-gl-webapi", (Object[])new Object[0]);
        }
        return null;
    }

    public static List<ReciprocalScheme> buildReciprocalScheme(AgingContext agingContext) {
        AgingQueryParam queryParam = agingContext.getQueryParam();
        Map<String, AssistVO> assistVoMap = agingContext.getAssistVoMap();
        long orgId = queryParam.getOrgId();
        long bookTypeId = queryParam.getBookTypeId();
        long accountId = queryParam.getAccountMasterId();
        HashSet<Long> childOrgs = new HashSet<Long>(8);
        childOrgs.add(orgId);
        ArrayList<Long> accounts = new ArrayList<Long>(8);
        accounts.add(accountId);
        Long currencyId = queryParam.getCurrencyId();
        Long accountTableId = queryParam.getAccountTableId();
        ArrayList<ReciprocalScheme> schemes = new ArrayList<ReciprocalScheme>();
        schemes.addAll(ReciprocalUtils.loadRcpSchemes(orgId, accountTableId, accounts, currencyId));
        Date bookedDate = queryParam.getBookedDate();
        boolean showbyamount = queryParam.isShowByAmount();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bookedDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        bookedDate = calendar.getTime();
        Date expiredate = queryParam.getExpireDate();
        Integer caculateRule = queryParam.getCaculateRule();
        boolean showByExpireDate = caculateRule == 1;
        int agingDayFrom = queryParam.getAgingDayFrom();
        int agingDayTo = queryParam.getAgingDayTo();
        HashMap<String, Tuple<Integer, Integer>> undueMap = new HashMap<String, Tuple<Integer, Integer>>(8);
        HashMap<String, Tuple<Integer, Integer>> overDueMap = new HashMap<String, Tuple<Integer, Integer>>(8);
        overDueMap.put("overdue", new Tuple((Object)(agingDayFrom == 0 ? agingDayFrom + 1 : agingDayFrom), (Object)agingDayTo));
        undueMap.put("undue", new Tuple((Object)(agingDayFrom * -1), (Object)(agingDayTo * -1)));
        if (schemes.isEmpty()) {
            ReciprocalScheme scheme = new ReciprocalScheme();
            scheme.setId(0L);
            scheme.setNumber("default");
            scheme.setOrg(orgId);
            scheme.setAccountList(accounts);
            ArrayList<Long> currencyList = new ArrayList<Long>();
            if (currencyId != 0L) {
                currencyList.add(currencyId);
            }
            scheme.setCurrencyList(currencyList);
            scheme.setWriteOffMode(WriteOffMode.BALANCE.name());
            scheme.setVerifiOrder("0");
            scheme.setReverOrderSameDire(false);
            scheme.setEqualamountpriority(true);
            scheme.setNoVerifiBusiNoEmpty(false);
            scheme.setEquaCanVerfi(false);
            scheme.setWriteOffType(1);
            scheme.setManualWriteoff(false);
            schemes.add(scheme);
        }
        for (ReciprocalScheme scheme : schemes) {
            scheme.setBookType(bookTypeId);
            scheme.setAccountTableId(accountTableId);
            scheme.setPeriodType(queryParam.getPeriodType());
            scheme.setChildOrgs(childOrgs);
            scheme.setBookedDate(bookedDate);
            scheme.setShowByamount(showbyamount);
            scheme.setExpiredate(expiredate);
            scheme.setShowByExpireDate(showByExpireDate);
            scheme.setAssistVOMap(new HashMap<String, AssistVO>(assistVoMap));
            scheme.setOverDueRangeMap(overDueMap);
            scheme.setUnDueRangeMap(undueMap);
            scheme.setSynCurrency(queryParam.getCurrencyId() == 0L);
        }
        return schemes;
    }

    public static StringBuilder fileterDataSet(Set<String> dsFields, AgingContext agingContext) {
        Map<String, AssistVO> assistVoMap = agingContext.getAssistVoMap();
        StringBuilder filter = new StringBuilder();
        assistVoMap.forEach((k, v) -> {
            if (dsFields.contains(k)) {
                Set<Long> assValue;
                if (filter.length() > 0) {
                    filter.append(" or ");
                }
                if ((assValue = ((AssistVO)assistVoMap.get(k)).getAssValue()).size() > 0) {
                    filter.append((String)k).append(" in (").append(String.join((CharSequence)",", assValue.stream().map(String::valueOf).collect(Collectors.toSet()))).append(")");
                } else {
                    filter.append((String)k).append(" is not null ");
                }
            }
        });
        return filter;
    }

    public static DataSet caculateDetailCol(DataSet ds, AgingContext agingContext) {
        Map<String, AssistVO> assistVoMap = agingContext.getAssistVoMap();
        ArrayList<String> groupFields = new ArrayList<String>();
        List<String> fields = GLUtil.getDataSetCols(ds);
        for (String string : fields) {
            if (!Objects.nonNull(assistVoMap.get(string))) continue;
            groupFields.add(string);
        }
        groupFields.add(COLKEY_CUR);
        groupFields.add(COLKEY_LOCAL_CUR);
        ArrayList<String> sumFields = new ArrayList<String>();
        for (String field : fields) {
            if (field.endsWith("total")) {
                sumFields.add(field);
                continue;
            }
            if (!field.startsWith("overdue") && !field.startsWith("undue")) continue;
            sumFields.add(field);
        }
        DataSet dataSet = MulOrgQPRpt.gainSumSet(ds, groupFields.toArray(new String[0]), sumFields.toArray(new String[0]));
        return dataSet.addField("1", COLKEY_ROWTYPE);
    }

    public static Map<String, AssistVO> getAssistVoMap(AgingQueryParam queryParam) {
        Map<String, Set<Long>> assgrp = queryParam.getAssgrp();
        LinkedHashMap<String, AssistVO> assistVOMap = new LinkedHashMap<String, AssistVO>(8);
        if (assgrp == null) {
            return assistVOMap;
        }
        QFilter qFilter = new QFilter("flexfield", "in", assgrp.keySet());
        DynamicObjectCollection flexCollection = QueryServiceHelper.query((String)"bd_asstacttype", (String)"flexfield,name,valuesource,valuetype,disprops", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dyn : flexCollection) {
            String flexfield = dyn.getString("flexfield");
            Set<Long> value = assgrp.get(flexfield);
            String disprops = dyn.getString("disprops");
            String dispprop = null;
            if (StringUtils.isNotEmpty((CharSequence)disprops)) {
                JSONObject jsonObject = JSONObject.parseObject((String)disprops);
                dispprop = jsonObject.getJSONObject("disp").getString("dispprop");
            }
            if ("2".equals(dyn.getString("valuetype"))) {
                assistVOMap.put(flexfield, new AssistVO(flexfield, dyn.getString("name"), "bos_assistantdata_detail", dispprop, value));
                continue;
            }
            assistVOMap.put(flexfield, new AssistVO(flexfield, dyn.getString("name"), dyn.getString("valuesource"), dispprop, value));
        }
        return assistVOMap;
    }

    public static boolean isEndInit(long orgId, long bookTypeId, long accountMasterId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter accountFilter = new QFilter("account.masterid", "=", (Object)accountMasterId);
        QFilter statusFilter = new QFilter("isendinit", "=", (Object)"1");
        boolean exists = QueryServiceHelper.exists((String)"gl_reci_init_state", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, accountFilter, statusFilter});
        return exists;
    }
}

