/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.datarepair.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.reciprocal.datarepair.service.AbstractDataCheckAndRepairService;
import kd.fi.gl.reciprocal.datarepair.util.ReciprocalDataRepairUtil;
import kd.fi.gl.util.FlexUtils;

public class AssgrpErrorUnit
extends AbstractDataCheckAndRepairService {
    private static final String ASSIST_DB = "gl_assist_bd";
    private static final Integer batchCount = 300000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String repairSelected(String checkType, List<Long> recordIds) {
        if (CollectionUtils.isEmpty(recordIds)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4fee\u590d\u7684\u884c", (String)"ReciprocalDataCheckAndRepairPlugin_7", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(16);
        lstFilters.add(new QFilter("id", "in", recordIds));
        DataSet reciprocalDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"id as acctid,voucherentry,voucherid,period,status", (QFilter[])lstFilters.toArray(new QFilter[0]), null);
        ArrayList<Long> vchEntryIds = new ArrayList<Long>(16);
        ArrayList<Long> voucherIds = new ArrayList<Long>(16);
        for (Row record : reciprocalDataSet.copy()) {
            Long voucherId;
            Long voucherentry = record.getLong("voucherentry");
            if (voucherentry != null) {
                vchEntryIds.add(voucherentry);
            }
            if ((voucherId = record.getLong("voucherid")) == null) continue;
            voucherIds.add(voucherId);
        }
        QFilter vchfilters = new QFilter("entries.id", "in", vchEntryIds);
        QFilter voucherIdfilters = new QFilter("id", "in", voucherIds);
        DataSet vchEntryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_voucher", (String)"entries.id entryid,entries.account entryaccount,entries.assgrp entryassgrp", (QFilter[])new QFilter[]{vchfilters, voucherIdfilters}, null);
        if (vchEntryDataSet.isEmpty()) {
            return ResManager.loadKDString((String)"\u5f80\u6765\u8d26\u8bb0\u5f55\u6ca1\u6709\u5bf9\u5e94\u51ed\u8bc1\u5206\u5f55", (String)"ReciprocalDataCheckAndRepairPlugin_5", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        DataSet resultDt = reciprocalDataSet.join(vchEntryDataSet).on("voucherentry", "entryid").select(new String[]{"acctid", "voucherentry", "voucherid", "entryassgrp", "entryaccount", "period", "status"}, new String[]{"entryid"}).finish();
        List<String> resultDtCols = ReciprocalDataRepairUtil.getDataSetCols(resultDt);
        ArrayList<Long> writeOffedIds = new ArrayList<Long>(16);
        ArrayList<Long> accountIds = new ArrayList<Long>(16);
        HashSet<Long> assgrpIds = new HashSet<Long>(16);
        for (Row row : resultDt.copy()) {
            Long acctid = row.getLong("acctid");
            Long vchentryAssgrp = row.getLong("entryassgrp");
            Long entryaccount = row.getLong("entryaccount");
            accountIds.add(entryaccount);
            assgrpIds.add(vchentryAssgrp);
            if ("0".equals(row.getString("status"))) continue;
            writeOffedIds.add(acctid);
        }
        DataSet vchEntryAssgrpDt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ASSIST_DB, (String)"hg entryhg,asstype entryasstype,assval entryassval", (QFilter[])new QFilter[]{new QFilter("hg", "in", assgrpIds)}, null);
        List<String> vchEntryAssgrpDtCols = ReciprocalDataRepairUtil.getDataSetCols(vchEntryAssgrpDt);
        if (vchEntryAssgrpDt == null || vchEntryAssgrpDt.isEmpty()) {
            return ResManager.loadKDString((String)"\u51ed\u8bc1\u5206\u5f55\u7684\u7ef4\u5ea6\u6709\u8bef", (String)"ReciprocalDataCheckAndRepairPlugin_9", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        DataSet vchentryJoinAssDt = resultDt.join(vchEntryAssgrpDt).on("entryassgrp", "entryhg").select(resultDtCols.toArray(new String[0]), vchEntryAssgrpDtCols.toArray(new String[0])).finish();
        List<String> vchentryJoinAssDtCols = ReciprocalDataRepairUtil.getDataSetCols(vchentryJoinAssDt);
        ArrayList<QFilter> accFilters = new ArrayList<QFilter>(2);
        QFilter accTableFilter = new QFilter("id", "in", accountIds);
        accFilters.add(accTableFilter);
        QFilter accheckFilter = new QFilter("checkitementry.enaccheck", "=", (Object)"1");
        accFilters.add(accheckFilter);
        DataSet accountDt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id accountid,checkitementry.asstactitem.flexfield accountflextype", (QFilter[])accFilters.toArray(new QFilter[0]), null);
        if (accountDt == null || accountDt.isEmpty()) {
            return ResManager.loadKDString((String)"\u51ed\u8bc1\u5206\u5f55\u7684\u79d1\u76ee\u6709\u8bef\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_10", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        List<String> accountDtCols = ReciprocalDataRepairUtil.getDataSetCols(accountDt);
        DataSet resultAndAccountDt = vchentryJoinAssDt.join(accountDt).on("entryaccount", "accountid").on("entryasstype", "accountflextype").select(vchentryJoinAssDtCols.toArray(new String[0]), accountDtCols.toArray(new String[0])).finish();
        HashMap<Long, HashMap<String, Object>> vchentryAndAssgrpMap = new HashMap<Long, HashMap<String, Object>>(16);
        for (Object row : resultAndAccountDt) {
            Long l = row.getLong("entryid");
            HashMap<String, Object> assgrpTypeAndValueMap = (HashMap<String, Object>)vchentryAndAssgrpMap.get(l);
            String accounttype = row.getString("accountflextype");
            Object entryassval = row.get("entryassval");
            if (assgrpTypeAndValueMap == null) {
                assgrpTypeAndValueMap = new HashMap<String, Object>(6);
            }
            assgrpTypeAndValueMap.put(accounttype, entryassval);
            vchentryAndAssgrpMap.put(l, assgrpTypeAndValueMap);
        }
        if (vchentryAndAssgrpMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4fee\u590d\u7684\u7ef4\u5ea6\u6570\u636e\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_6", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        HashMap<Long, Long> vchEntryAndAssgrpIdMap = new HashMap<Long, Long>(16);
        for (Map.Entry entry : vchentryAndAssgrpMap.entrySet()) {
            Long vchentryId = (Long)entry.getKey();
            Map flexFieldToValue = (Map)entry.getValue();
            long assgrpId = FlexUtils.saveFlexData(flexFieldToValue);
            vchEntryAndAssgrpIdMap.put(vchentryId, assgrpId);
        }
        Date now = new Date();
        String string = "";
        String logMessage = "";
        String status = "1";
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DynamicObject[] accts;
                ReciprocalDataRepairUtil.doUnWriteOffByAcctIds(writeOffedIds);
                for (DynamicObject dynamicObject : accts = BusinessDataServiceHelper.load((Object[])recordIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_acccurrent"))) {
                    Long assgrp = (Long)vchEntryAndAssgrpIdMap.get(dynamicObject.getLong("voucherentry"));
                    if (assgrp == null) continue;
                    dynamicObject.set("assgrp", (Object)assgrp);
                }
                SaveServiceHelper.update((DynamicObject[])accts);
            }
            catch (Exception e) {
                txHandle.markRollback();
                logMessage = e.getMessage();
                status = "0";
                throw e;
            }
        }
        finally {
            ReciprocalDataRepairUtil.reciDataRepairLog(checkType, now, string, logMessage, status);
        }
        return "";
    }

    @Override
    public String repairByCondition(ReportQueryParam param) {
        DataSet dataSet = this.queryCheckDataSet(param);
        ArrayList<Long> acctIds = new ArrayList<Long>(16);
        for (Row row : dataSet) {
            acctIds.add(row.getLong("id"));
        }
        String checkType = (String)param.getFilter().getValue("checktype");
        return this.repairSelected(checkType, acctIds);
    }

    @Override
    public DataSet queryCheckDataSet(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        Long orgId = filterInfo.getLong("org");
        Long bookTypeId = filterInfo.getLong("booktype");
        Long accountTableId = filterInfo.getLong("accounttable");
        ArrayList<QFilter> accurrentFilters = new ArrayList<QFilter>(3);
        ArrayList<Long> errorAcctAssgrps = new ArrayList<Long>(32);
        if (orgId != null && orgId != 0L) {
            if (bookTypeId == null || bookTypeId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_4", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            if (accountTableId == null || accountTableId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868", (String)"ReciprocalDataCheckAndRepairPlugin_8", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            accurrentFilters.add(new QFilter("org", "=", (Object)orgId));
            accurrentFilters.add(new QFilter("booktype", "=", (Object)bookTypeId));
            accurrentFilters.add(new QFilter("accounttable", "=", (Object)accountTableId));
        }
        DataSet acctDt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"id", (QFilter[])accurrentFilters.toArray(new QFilter[0]), null);
        HashSet<Long> acccurrentIds = new HashSet<Long>(16);
        for (Row row : acctDt) {
            acccurrentIds.add(row.getLong("id"));
            if (acccurrentIds.size() <= batchCount) continue;
            this.getErrorAcctAssgrpIds(errorAcctAssgrps, acccurrentIds);
            acccurrentIds.clear();
        }
        this.getErrorAcctAssgrpIds(errorAcctAssgrps, acccurrentIds);
        QFilter accFilter = new QFilter("id", "in", errorAcctAssgrps);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)" id, org, booktype, period, accounttable, account, assgrp, currency, amountfor, amountbalfor, localcurrency, amount, amountbal, bizdate, expiredate, biznum, description, status, voucherid, sourcetype,voucherentry ", (QFilter[])new QFilter[]{accFilter}, null);
        return dataSet;
    }

    public void getErrorAcctAssgrpIds(List<Long> errorAcctAssgrps, Set<Long> acccurrentIds) {
        DataSet acctDt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_acccurrent", (String)"id acctid,assgrp acctassgrp,voucherentry,voucherid", (QFilter[])new QFilter[]{new QFilter("id", "in", acccurrentIds)}, null);
        List<String> acctCols = ReciprocalDataRepairUtil.getDataSetCols(acctDt);
        HashSet<Long> assgrpIds = new HashSet<Long>(16);
        HashSet<Long> vchEntryIds = new HashSet<Long>(16);
        HashSet<Long> voucherIds = new HashSet<Long>(16);
        for (Row row : acctDt.copy()) {
            assgrpIds.add(row.getLong("acctassgrp"));
            vchEntryIds.add(row.getLong("voucherentry"));
            voucherIds.add(row.getLong("voucherid"));
        }
        DataSet acctAssgrpDt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ASSIST_DB, (String)"hg accthg,asstype acctasstype,assval acctassval", (QFilter[])new QFilter[]{new QFilter("hg", "in", assgrpIds)}, null);
        List<String> acctAssgrpDtCols = ReciprocalDataRepairUtil.getDataSetCols(acctAssgrpDt);
        DataSet acctJoinAssDt = acctDt.leftJoin(acctAssgrpDt).on("acctassgrp", "accthg").select(acctCols.toArray(new String[0]), acctAssgrpDtCols.toArray(new String[0])).finish().filter("voucherentry != 0");
        List<String> acctJoinAssDtCols = ReciprocalDataRepairUtil.getDataSetCols(acctJoinAssDt);
        QFilter vchFilter = new QFilter("entries.id", "in", vchEntryIds);
        QFilter voucherIdFilter = new QFilter("id", "in", voucherIds);
        DataSet vchEntrySet = QueryServiceHelper.queryDataSet((String)"queryNoVchEntryRecordByOrgId", (String)"gl_voucher", (String)"entries.id entryid,entries.account entryaccount,entries.assgrp entryassgrp", (QFilter[])new QFilter[]{vchFilter, voucherIdFilter}, null);
        List<String> vchEntrySetCols = ReciprocalDataRepairUtil.getDataSetCols(vchEntrySet);
        HashSet<Long> entryassgrpIds = new HashSet<Long>(16);
        HashSet<Long> accountIds = new HashSet<Long>(32);
        for (Row row : vchEntrySet.copy()) {
            entryassgrpIds.add(row.getLong("entryassgrp"));
            accountIds.add(row.getLong("entryaccount"));
        }
        DataSet vchEntryAssgrpDt = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)ASSIST_DB, (String)"hg entryhg,asstype entryasstype,assval entryassval", (QFilter[])new QFilter[]{new QFilter("hg", "in", entryassgrpIds)}, null);
        List<String> vchEntryAssgrpDtCols = ReciprocalDataRepairUtil.getDataSetCols(vchEntryAssgrpDt);
        DataSet vchentryJoinAssDt = vchEntrySet.leftJoin(vchEntryAssgrpDt).on("entryassgrp", "entryhg").select(vchEntrySetCols.toArray(new String[0]), vchEntryAssgrpDtCols.toArray(new String[0])).finish();
        List<String> vchentryJoinAssDtCols = ReciprocalDataRepairUtil.getDataSetCols(vchentryJoinAssDt);
        ArrayList<QFilter> accFilters = new ArrayList<QFilter>(2);
        QFilter accTableFilter = new QFilter("id", "in", accountIds);
        accFilters.add(accTableFilter);
        QFilter accheckFilter = new QFilter("checkitementry.enaccheck", "=", (Object)"1");
        accFilters.add(accheckFilter);
        HashMap<Long, List> accountAssistTypesMap = new HashMap<Long, List>(32);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id,checkitementry.asstactitem.flexfield assist", (QFilter[])accFilters.toArray(new QFilter[0]), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long accountId = row.getLong("id");
                accountAssistTypesMap.computeIfAbsent(accountId, v -> new ArrayList(5)).add(row.getString("assist"));
            }
        }
        HashMap<Long, List> resultAssistTypesMap = new HashMap<Long, List>(32);
        HashMap<Long, Long> accurrentAccMap = new HashMap<Long, Long>(32);
        try (DataSet resultDt = acctJoinAssDt.leftJoin(vchentryJoinAssDt).on("voucherentry", "entryid").on("acctasstype", "entryasstype").on("acctassval", "entryassval").select(acctJoinAssDtCols.toArray(new String[0]), vchentryJoinAssDtCols.toArray(new String[0])).finish();){
            while (resultDt.hasNext()) {
                Row row = resultDt.next();
                Long accurrenId = row.getLong("acctid");
                Long entryaccountId = row.getLong("entryaccount");
                Long accthg = row.getLong("accthg");
                if (accthg == null || entryaccountId == null) {
                    errorAcctAssgrps.add(accurrenId);
                    continue;
                }
                accurrentAccMap.put(accurrenId, entryaccountId);
                resultAssistTypesMap.computeIfAbsent(accurrenId, v -> new ArrayList(5)).add(row.getString("acctasstype"));
            }
            for (Map.Entry entry : accurrentAccMap.entrySet()) {
                Long accurrentId = (Long)entry.getKey();
                Long accountId = (Long)entry.getValue();
                List accountAssTypes = (List)accountAssistTypesMap.get(accountId);
                List accurrentAssTypes = (List)resultAssistTypesMap.get(accurrentId);
                if (accountAssTypes == null || accurrentAssTypes == null || ReciprocalDataRepairUtil.checkListDiffrent(accountAssTypes, accurrentAssTypes)) continue;
                errorAcctAssgrps.add(accurrentId);
            }
        }
    }

    @Override
    public List<AbstractReportColumn> getColums(List<AbstractReportColumn> columns) {
        return ReciprocalDataRepairUtil.getAccurrentColums(columns);
    }
}

