/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.datarepair.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.gl.reciprocal.ReciprocalLog;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.datarepair.service.AbstractDataCheckAndRepairService;
import kd.fi.gl.reciprocal.datarepair.util.ReciprocalDataRepairUtil;
import kd.fi.gl.util.ContextUtil;
import kd.fi.gl.util.GLUtil;

public class ReciprocalLogNoAcccurrentUnit
extends AbstractDataCheckAndRepairService {
    private static final String UPDATE_ACCCURRENT_SQL = "UPDATE T_GL_ACCCURRENT SET FAMOUNTBAL=?, FAMOUNTBALFOR=?, FSTATUS=?, FMODIFYTIME=?, FWRITEOFFPERSONID=? WHERE FMASTERID=?";
    private static final String BIZNUM = "biznum";
    private static final String SOURCETYPE = "sourcetype";
    private static final String DESCRIPTION = "description";
    private static final int INIT_RECORD_CAPACITY = 8;
    private static final String ID = "id";
    private static final String WRITEOFFENTRY = "writeoffentry";
    private static final String BUYERENTRY = "buyerentry";
    private static final String VOUCHERID = "voucherid";
    private static final String MODIFYTIME = "modifytime";
    private static final String AMOUNTBAL = "amountbal";
    private static final String AMOUNT = "amount";
    private static final String AMOUNTBALFOR = "amountbalfor";
    private static final String LOCALCURRENCY = "localcurrency";
    private static final String AMOUNTFOR = "amountfor";
    private static final String RECIPROCAL_LOG = "gl_reciprocal_log";
    private static final String ORG = "org";
    private static final String BOOKTYPE = "booktype";
    private static final String PERIOD = "period";
    private static final String ACCOUNT = "account";
    private static final String ASSGRP = "assgrp";
    private static final String CURRENCY = "currency";
    private static final String STATUS = "status";
    private static final String ACCOUNTTABLE = "accounttable";
    private static final String SELECTFIELDS = "id, masterid, org.id org, booktype.id booktype,accounttable.id accounttable, period.id period,account.id account, assgrp.id assgrp,currency.id currency,amountfor,amountbalfor,localcurrency,amount,amountbal,biznum,voucherid,voucherentry vchentryid,sourcetype,modifytime,status, effectivedate, uneffectivedate";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String repairSelected(String checkType, List<Long> recordIds) {
        block46: {
            Date now = new Date();
            String tableName = "";
            String logMessage = "";
            String status = "1";
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    QFilter[] logFilters = new QFilter[]{new QFilter(ID, "in", recordIds)};
                    ArrayList<Long> logIds = new ArrayList<Long>(16);
                    try (DataSet logDataSet = QueryServiceHelper.queryDataSet((String)"gl_ReciprocalDataCheckAndRepairPlugin_querylog", (String)RECIPROCAL_LOG, (String)ID, (QFilter[])logFilters, null);){
                        for (Row row : logDataSet) {
                            logIds.add(row.getLong(ID));
                        }
                    }
                    if (logIds.isEmpty()) break block46;
                    List<ReciprocalLog> logs = ReciprocalLogNoAcccurrentUnit.queryLogInfo(logIds);
                    HashSet<Long> entryIds = new HashSet<Long>(logs.size() * 2);
                    for (ReciprocalLog log : logs) {
                        entryIds.add(log.getBuyerEntryId());
                        entryIds.add(log.getWriteOffEntryId());
                    }
                    HashSet vchIds = new HashSet();
                    Map<Long, ReciprocalRecord> recordMap = ReciprocalLogNoAcccurrentUnit.queryRecordsById(entryIds);
                    recordMap.values().forEach(p -> vchIds.add(p.getVoucherId()));
                    ArrayList<String> operationMsgs = new ArrayList<String>();
                    try (TXHandle handler = TX.requiresNew();){
                        try {
                            ReciprocalLogNoAcccurrentUnit.lockVoucher(new ArrayList<Long>(vchIds));
                            recordMap = ReciprocalLogNoAcccurrentUnit.queryRecordsById(entryIds);
                            logs = ReciprocalLogNoAcccurrentUnit.queryLogInfo(logIds);
                            ArrayList<Long> delLogIds = new ArrayList<Long>();
                            ReciprocalLogNoAcccurrentUnit.unWriteOffRecord(logs, recordMap, operationMsgs, delLogIds);
                            String logMsg = ReciprocalLogNoAcccurrentUnit.delReciprocalLog(delLogIds);
                            operationMsgs.add(logMsg);
                            String recordMsg = ReciprocalLogNoAcccurrentUnit.reWriteReciprocalRecord(recordMap, false);
                            operationMsgs.add(recordMsg);
                        }
                        catch (Exception e) {
                            handler.markRollback();
                            throw e;
                        }
                    }
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    logMessage = e.getMessage();
                    status = "0";
                    throw e;
                }
            }
            finally {
                ReciprocalDataRepairUtil.reciDataRepairLog(checkType, now, tableName, logMessage, status);
            }
        }
        return "";
    }

    private static String reWriteReciprocalRecord(Map<Long, ReciprocalRecord> records, boolean isWriteOff) {
        Date modifyDate = TimeServiceHelper.now();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(8);
        Long zeroId = 0L;
        for (ReciprocalRecord record : records.values()) {
            if (record.getMasterId().equals(zeroId)) continue;
            updateParams.add(new Object[]{record.getAmountBal(), record.getAmountBalFor(), record.getStatus(), modifyDate, isWriteOff ? ContextUtil.getUserId() : 0L, record.getMasterId()});
        }
        if (!updateParams.isEmpty()) {
            DB.executeBatch((DBRoute)new DBRoute("gl"), (String)UPDATE_ACCCURRENT_SQL, updateParams);
        }
        return ResManager.loadKDString((String)"\u5f80\u6765\u8d26\u8bb0\u5f55\u53cd\u5199\u6210\u529f\u3002", (String)"ReciprocalUtils_10", (String)"fi-gl-common", (Object[])new Object[0]);
    }

    private static String delReciprocalLog(Collection<Long> logIds) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)RECIPROCAL_LOG, (Object[])logIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            return ResManager.loadKDString((String)"\u6838\u9500\u65e5\u5fd7\u5220\u9664\u6210\u529f\u3002", (String)"ReciprocalUtils_2", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"\u5220\u9664\u6838\u9500\u65e5\u5fd7\u5931\u8d25\uff1a%s\u3002", (String)"ReciprocalUtils_3", (String)"fi-gl-common", (Object[])new Object[0]), result.getMessage());
    }

    private static void unWriteOffRecordAmount(ReciprocalLog log, ReciprocalRecord srcRecord, ReciprocalRecord targetRecord) {
        BigDecimal writeOffAmt = log.getAmount();
        BigDecimal writeOffAmtFor = log.getAmountFor();
        if (srcRecord != null) {
            srcRecord.addBalLocal(writeOffAmt);
            srcRecord.addBalFor(writeOffAmtFor);
            if (srcRecord.getAmountBalFor().compareTo(srcRecord.getAmountFor()) == 0) {
                srcRecord.setStatus("0");
            } else {
                srcRecord.setStatus("1");
            }
        }
        if (targetRecord != null) {
            targetRecord.addBalLocal(writeOffAmt);
            targetRecord.addBalFor(writeOffAmtFor);
            if (targetRecord.getAmountBalFor().compareTo(targetRecord.getAmountFor()) == 0) {
                targetRecord.setStatus("0");
            } else {
                targetRecord.setStatus("1");
            }
        }
    }

    private static void unWriteOffRecord(List<ReciprocalLog> logs, Map<Long, ReciprocalRecord> recordMap, List<String> operationMsgs, List<Long> delLogIds) {
        for (ReciprocalLog log : logs) {
            ReciprocalRecord srcRecord = recordMap.get(log.getBuyerEntryId());
            ReciprocalRecord tgtRecord = recordMap.get(log.getWriteOffEntryId());
            ReciprocalLogNoAcccurrentUnit.unWriteOffRecordAmount(log, srcRecord, tgtRecord);
            delLogIds.add(log.getId());
        }
    }

    public static void lockVoucher(List<Long> vchids) {
        GLUtil.lockVouchers(vchids);
    }

    private static List<ReciprocalLog> queryLogInfo(List<Long> logIds) {
        ArrayList<ReciprocalLog> logs = new ArrayList<ReciprocalLog>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.doUnWriteOff", (String)RECIPROCAL_LOG, (String)"id,buyerentry,writeoffentry,amount,amountfor", (QFilter[])new QFilter[]{new QFilter(ID, "in", logIds)}, null);){
            while (dSet.hasNext()) {
                Row row = dSet.next();
                ReciprocalLog log = new ReciprocalLog();
                log.setId(row.getLong(ID));
                log.setBuyerEntryId(row.getLong(BUYERENTRY));
                log.setWriteOffEntryId(row.getLong(WRITEOFFENTRY));
                log.setAmount(row.getBigDecimal(AMOUNT));
                log.setAmountFor(row.getBigDecimal(AMOUNTFOR));
                logs.add(log);
            }
        }
        return logs;
    }

    private static Map<Long, ReciprocalRecord> queryRecordsById(Set<Long> ids) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
        lstFilters.add(new QFilter(ID, "in", ids));
        HashMap<Long, ReciprocalRecord> records = new HashMap<Long, ReciprocalRecord>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ReciprocalUtils.queryOneRecord", (String)"gl_acccurrent", (String)SELECTFIELDS, (QFilter[])lstFilters.toArray(new QFilter[0]), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                ReciprocalRecord record = ReciprocalLogNoAcccurrentUnit.getRecord(row);
                records.put(record.getId(), record);
            }
        }
        return records;
    }

    private static ReciprocalRecord getRecord(Row row) {
        ReciprocalRecord record = new ReciprocalRecord();
        record.setId(row.getLong(ID));
        record.setOrg(row.getLong(ORG));
        record.setAccountTable(row.getLong(ACCOUNTTABLE));
        record.setBookType(row.getLong(BOOKTYPE));
        record.setPeriod(row.getLong(PERIOD));
        record.setAccount(row.getLong(ACCOUNT));
        record.setAssgrp(row.getLong(ASSGRP));
        record.setCurrency(row.getLong(CURRENCY));
        record.setAmountFor(row.getBigDecimal(AMOUNTFOR));
        record.setAmountBalFor(row.getBigDecimal(AMOUNTBALFOR));
        record.setLocalCurrency(row.getLong(LOCALCURRENCY));
        record.setAmount(row.getBigDecimal(AMOUNT));
        record.setAmountBal(row.getBigDecimal(AMOUNTBAL));
        record.setBizNum(row.getString(BIZNUM));
        record.setVoucherId(row.getLong(VOUCHERID));
        record.setVchEntryId(row.getLong("vchentryid"));
        String key = row.getString(SOURCETYPE);
        record.setSourceType(key);
        record.setModifyTime(row.getDate(MODIFYTIME));
        record.setStatus(row.getString(STATUS));
        record.setMasterId(row.getLong("masterid"));
        record.setEffectiveDate(row.getDate("effectivedate"));
        record.setUneffectiveDate(row.getDate("uneffectivedate"));
        return record;
    }

    @Override
    public String repairByCondition(ReportQueryParam param) {
        DataSet dataSet = this.queryCheckDataSet(param);
        ArrayList<Long> recordIds = new ArrayList<Long>(8);
        for (Row row : dataSet) {
            recordIds.add(row.getLong(ID));
        }
        String checkType = (String)param.getFilter().getValue("checktype");
        return this.repairSelected(checkType, recordIds);
    }

    @Override
    public DataSet queryCheckDataSet(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        Long orgId = filterInfo.getLong(ORG);
        Long bookTypeId = filterInfo.getLong(BOOKTYPE);
        Long accountTableId = filterInfo.getLong(ACCOUNTTABLE);
        if (orgId != null && orgId != 0L) {
            if (bookTypeId == null || bookTypeId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalDataCheckAndRepairPlugin_4", (String)"fi-gl-common", (Object[])new Object[0]));
            }
            if (accountTableId == null || accountTableId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868", (String)"ReciprocalDataCheckAndRepairPlugin_8", (String)"fi-gl-common", (Object[])new Object[0]));
            }
        }
        StringBuilder buyerentrySb = new StringBuilder();
        buyerentrySb.append("select ").append(" rin.fid id,rin.forgid org,rin.fbooktypeid booktype,rin.facctableid accounttable,rin.fperiodid period,rin.faccountid account, rin.fassgrpid assgrp,rin.famountfor amountfor,rin.famount amount,rin.fwriteoffentryid writeoffentry,rin.fbuyerentryid buyerentry,rin.fcurrencyid currency").append(" from t_gl_reciprocal_log rin  left join t_gl_acccurrent acct on rin.FBUYERENTRYID = acct.FID  where acct.fid is null");
        if (orgId != null && orgId != 0L) {
            buyerentrySb.append(" and rin.forgid = ").append(orgId);
            buyerentrySb.append(" and rin.fbooktypeid = ").append(bookTypeId);
            buyerentrySb.append(" and rin.facctableid = ").append(accountTableId);
        }
        DataSet buyerentrySet = DB.queryDataSet((String)"ReciprocalLogNoAcccurrentUnit_buyerentry_queryCheckDataSet", (DBRoute)DBRoute.of((String)"gl"), (String)buyerentrySb.toString());
        StringBuilder writeoffentrySb = new StringBuilder();
        writeoffentrySb.append("select ").append(" rin.fid id,rin.forgid org,rin.fbooktypeid booktype,rin.facctableid accounttable,rin.fperiodid period,rin.faccountid account, rin.fassgrpid assgrp,rin.famountfor amountfor,rin.famount amount,rin.fwriteoffentryid writeoffentry,rin.fbuyerentryid buyerentry,rin.fcurrencyid currency").append(" from t_gl_reciprocal_log rin left join t_gl_acccurrent acct on rin.FWRITEOFFENTRYID = acct.FID where acct.fid is null");
        if (orgId != null && orgId != 0L) {
            writeoffentrySb.append(" and rin.forgid = ").append(orgId);
            writeoffentrySb.append(" and rin.fbooktypeid = ").append(bookTypeId);
            writeoffentrySb.append(" and rin.facctableid = ").append(accountTableId);
        }
        DataSet writeoffentrySet = DB.queryDataSet((String)"ReciprocalLogNoAcccurrentUnit_writeoffentry_queryCheckDataSet", (DBRoute)DBRoute.of((String)"gl"), (String)writeoffentrySb.toString());
        return buyerentrySet.union(writeoffentrySet);
    }

    @Override
    public List<AbstractReportColumn> getColums(List<AbstractReportColumn> columns) {
        ArrayList<AbstractReportColumn> customColumns = new ArrayList<AbstractReportColumn>(8);
        LocaleString orgName = new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"NoAcccurrentUnit_0", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn orgColumn = ReciprocalDataRepairUtil.createColumn(orgName, ORG, "basedata", Boolean.FALSE);
        orgColumn.setEntityId("bos_org");
        orgColumn.setDisplayProp("name");
        customColumns.add((AbstractReportColumn)orgColumn);
        LocaleString periodName = new LocaleString(ResManager.loadKDString((String)"\u671f\u95f4", (String)"NoAcccurrentUnit_1", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn periodColumn = ReciprocalDataRepairUtil.createColumn(periodName, PERIOD, "basedata", Boolean.FALSE);
        periodColumn.setEntityId("bd_period");
        customColumns.add((AbstractReportColumn)periodColumn);
        customColumns.addAll(columns);
        LocaleString currencyName = new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"ReciprocalLogErrorUnit_2", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn currencyColumn = ReciprocalDataRepairUtil.createColumn(currencyName, CURRENCY, "basedata", Boolean.FALSE);
        currencyColumn.setEntityId("bd_currency");
        currencyColumn.setDisplayProp("name");
        customColumns.add((AbstractReportColumn)currencyColumn);
        LocaleString idName = new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u65e5\u5fd7id", (String)"ReciprocalLogErrorUnit_3", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn idColumn = ReciprocalDataRepairUtil.createColumn(idName, ID, "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)idColumn);
        LocaleString writeoffentryName = new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55id", (String)"ReciprocalLogErrorUnit_4", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn writeoffentryColumn = ReciprocalDataRepairUtil.createColumn(writeoffentryName, WRITEOFFENTRY, "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)writeoffentryColumn);
        LocaleString buyerentryName = new LocaleString(ResManager.loadKDString((String)"\u6302\u8d26\u8bb0\u5f55id", (String)"ReciprocalLogErrorUnit_5", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn buyerentryColumn = ReciprocalDataRepairUtil.createColumn(buyerentryName, BUYERENTRY, "text", Boolean.FALSE);
        customColumns.add((AbstractReportColumn)buyerentryColumn);
        LocaleString amountforName = new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u539f\u5e01\u91d1\u989d", (String)"ReciprocalLogErrorUnit_6", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn amountforColumn = ReciprocalDataRepairUtil.createColumn(amountforName, AMOUNTFOR, AMOUNT, Boolean.FALSE);
        customColumns.add((AbstractReportColumn)amountforColumn);
        LocaleString amountbalforName = new LocaleString(ResManager.loadKDString((String)"\u6838\u9500\u672c\u4f4d\u5e01\u91d1\u989d", (String)"ReciprocalLogErrorUnit_7", (String)"fi-gl-common", (Object[])new Object[0]));
        ReportColumn amountbalforColumn = ReciprocalDataRepairUtil.createColumn(amountbalforName, AMOUNT, AMOUNT, Boolean.FALSE);
        customColumns.add((AbstractReportColumn)amountbalforColumn);
        return customColumns;
    }
}

