/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.simulate;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.business.service.helper.FiFoSimulateServiceHelper;
import kd.fi.gl.business.service.reciprocal.baldeduct.FiFoSimulateParam;
import kd.fi.gl.business.vo.reciprocal.AccountFlexVO;
import kd.fi.gl.business.vo.reciprocal.AgeRangeVO;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.WriteOffMode;
import kd.fi.gl.enums.writeoff.WriteOffField;
import kd.fi.gl.reciprocal.FifoAutoWriteOffService;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalContext;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.simulate.ReciprocalSimulateEngine;
import kd.fi.gl.reciprocal.simulate.WriteOff;
import kd.fi.gl.reciprocal.simulate.balance.vo.AssistVO;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.DataSetUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WriteOffImpl
implements WriteOff {
    private static final Log LOGGER = LogFactory.getLog(WriteOffImpl.class);

    @Override
    public DataSet schemeSimulateWriteOff(List<ReciprocalScheme> schemes, List<WriteOffField> groupFields, List<WriteOffField> sumFields, List<String> flexFiels) {
        if (Objects.isNull(schemes) || schemes.size() == 0) {
            return WriteOffImpl.buildEmptyDataSet(groupFields, sumFields, flexFiels);
        }
        DataSet result = this.schemeSimulateWriteOffDetail(schemes);
        Set dsFileds = Arrays.stream(result.getRowMeta().getFieldNames()).map(String::toLowerCase).collect(Collectors.toSet());
        if (groupFields.size() > 0) {
            List<String> groupList = groupFields.stream().map(x -> x.getFiled().toLowerCase()).collect(Collectors.toList());
            if (dsFileds.containsAll(flexFiels) && dsFileds.containsAll(groupList)) {
                groupList.addAll(flexFiels);
                GroupbyDataSet groupbyDataSet = result.groupBy(groupList.toArray(new String[0]));
                for (WriteOffField field : sumFields) {
                    groupbyDataSet.sum(field.getFiled());
                }
                return groupbyDataSet.finish();
            }
            return WriteOffImpl.buildEmptyDataSet(groupFields, sumFields, flexFiels);
        }
        return result;
    }

    @Override
    public DataSet schemeSimulateWriteOffDetail(List<ReciprocalScheme> schemes) {
        return this.schemeSimulateWriteOff(schemes, false);
    }

    @Override
    public DataSet schemeSimulateWriteOffSummary(List<ReciprocalScheme> schemes) {
        DataSet dataSet = this.schemeSimulateWriteOff(schemes, true);
        return DataSetUtils.gainSumDataSet(dataSet);
    }

    protected Pair<List<ReciprocalScheme>, Map<Pair<Long, Long>, Tuple<Integer, Set<String>>>> reciprocalSchemeWrap(List<ReciprocalScheme> schemes) {
        if (DebugTrace.enable()) {
            LOGGER.info("==WriteOffImpl schemes:{}", schemes);
        }
        if (Objects.isNull(schemes) || schemes.size() == 0) {
            return null;
        }
        HashSet<Long> acctMasterIds = new HashSet<Long>(schemes.size());
        Date bookedDate = new Date();
        for (ReciprocalScheme scheme : schemes) {
            bookedDate = scheme.getBookedDate();
            acctMasterIds.addAll(scheme.getAccountList());
        }
        HashSet<Long> useOrgIds = new HashSet<Long>(schemes.size());
        schemes.forEach(v -> useOrgIds.addAll(v.getChildOrgs()));
        HashMap assistAccountVersionIdToOrgMap = new HashMap(8);
        for (Long acctMasterId : acctMasterIds) {
            Map<Long, Map<Long, AccountVO>> singleMap = WriteOffImpl.getAssistAccountVersionIdToOrgMap(useOrgIds, acctMasterId, bookedDate, true);
            singleMap.forEach((k, v) -> {
                Map fileflexIdMap = (Map)assistAccountVersionIdToOrgMap.get(k);
                if (Objects.nonNull(fileflexIdMap)) {
                    v.forEach((k1, v1) -> {
                        AccountVO accountVO = (AccountVO)fileflexIdMap.get(k1);
                        if (Objects.nonNull(accountVO)) {
                            accountVO.getUserOrgIds().addAll(v1.getUserOrgIds());
                        } else {
                            fileflexIdMap.put(k1, v1);
                        }
                    });
                } else {
                    assistAccountVersionIdToOrgMap.put(k, v);
                }
            });
        }
        if (assistAccountVersionIdToOrgMap.size() == 0) {
            return null;
        }
        HashMap<String, Map> assistNumAccountVersionIdToOrgMap = new HashMap<String, Map>(8);
        SqlBuilder flexSql = new SqlBuilder();
        flexSql.append("SELECT C.fflexfield, C.fentryid FROM t_bas_flex_property C  WHERE ", new Object[0]);
        flexSql.appendIn(" C.fentryid", assistAccountVersionIdToOrgMap.keySet().toArray());
        DB.query((DBRoute)DBRoute.base, (SqlBuilder)flexSql, rs -> {
            while (rs.next()) {
                assistNumAccountVersionIdToOrgMap.put(rs.getString("fflexfield"), (Map)assistAccountVersionIdToOrgMap.get(rs.getLong("fentryid")));
            }
            return null;
        });
        HashMap acctDcMap = new HashMap(assistNumAccountVersionIdToOrgMap.size());
        for (ReciprocalScheme scheme : schemes) {
            for (Map.Entry assistMapEntry : assistNumAccountVersionIdToOrgMap.entrySet()) {
                String flexfield = (String)assistMapEntry.getKey();
                Map acctMapEntry = (Map)assistMapEntry.getValue();
                for (Map.Entry acctVoEntry : acctMapEntry.entrySet()) {
                    AccountVO accountVO = (AccountVO)acctVoEntry.getValue();
                    Long acctId = accountVO.getId();
                    long acctMasterid = accountVO.getMasterId();
                    Integer acctDc = ((AccountVO)((Map)assistNumAccountVersionIdToOrgMap.get(flexfield)).get(acctId)).getDc();
                    HashSet assist = new HashSet(2);
                    assistNumAccountVersionIdToOrgMap.forEach((k, v) -> {
                        if (v.containsKey(acctId)) {
                            assist.add(k);
                        }
                    });
                    for (Long childOrg : scheme.getChildOrgs()) {
                        if (!Objects.nonNull(accountVO.getUserOrgIds()) || !accountVO.getUserOrgIds().contains(childOrg)) continue;
                        acctDcMap.put(Pair.of((Object)childOrg, (Object)acctMasterid), Tuple.create(acctDc, assist));
                    }
                    AssistVO assistVO = scheme.getAssistVOMap().get(flexfield);
                    Set<Long> userOrgIds = ((AccountVO)((Map)assistNumAccountVersionIdToOrgMap.get(flexfield)).get(acctId)).getUserOrgIds();
                    if (Objects.isNull(assistVO)) {
                        scheme.getAssistVOMap().put(flexfield, new AssistVO(flexfield).addAmongOrg((Long)acctMasterid, userOrgIds).addAccount(acctMasterid));
                        continue;
                    }
                    scheme.getAssistVOMap().get(flexfield).addAmongOrg((Long)acctMasterid, userOrgIds).addAccount(acctMasterid);
                }
            }
        }
        DebugTrace.action(() -> LOGGER.info("==WriteOffImpl schemes:{}", (Object)schemes));
        return Pair.of(schemes, acctDcMap);
    }

    private DataSet schemeSimulateWriteOff(List<ReciprocalScheme> schemes, boolean isSummary) {
        Pair<List<ReciprocalScheme>, Map<Pair<Long, Long>, Tuple<Integer, Set<String>>>> pair = this.reciprocalSchemeWrap(schemes);
        if (Objects.isNull(pair) || Objects.isNull(pair.getLeft()) || ((List)pair.getLeft()).size() == 0) {
            return RcpWriteOffUtils.buildEmptyDs();
        }
        List newSchemes = (List)pair.getLeft();
        ArrayList<DataSet> result = new ArrayList<DataSet>(newSchemes.size());
        for (ReciprocalScheme scheme : newSchemes) {
            DebugTrace.action(() -> LOGGER.info("WriteOffImpl#schemeSimulateWriteOff_scheme:{}", (Object)scheme));
            long pTime = System.currentTimeMillis();
            if (WriteOffMode.BALANCE == scheme.getWriteOffMode() && scheme.isShowByamount()) {
                Map acctDcMap = (Map)pair.getRight();
                List<DataSet> dataSets = WriteOffImpl.balanceSimulateWriteOff(scheme, acctDcMap, isSummary);
                result.addAll(dataSets);
            } else {
                DataSet dataSet = WriteOffImpl.orderSimulateWriteOff(scheme, isSummary);
                if (Objects.nonNull(dataSet)) {
                    result.add(dataSet);
                }
                DebugTrace.action(() -> DataSetHelper.logDataSet("WriteOffImpl.schemeSimulateWriteOff_dataSet:", dataSet));
            }
            long aTime = System.currentTimeMillis();
            LOGGER.info("engine.run() Reciprocal Simulate Time" + (aTime - pTime));
        }
        return this.mergeDataSet(result);
    }

    protected static List<DataSet> balanceSimulateWriteOff(ReciprocalScheme scheme, Map<Pair<Long, Long>, Tuple<Integer, Set<String>>> acctDcMap, boolean isSummary) {
        ArrayList<DataSet> result = new ArrayList<DataSet>(scheme.getAccountList().size());
        for (long accId : scheme.getAccountList()) {
            for (Long childOrg : scheme.getChildOrgs()) {
                DataSet dataSet;
                AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(childOrg, (long)scheme.getBookType());
                if (Objects.isNull(bookInfo)) {
                    LOGGER.info(" org not bookinfo:{}", (Object)childOrg);
                    continue;
                }
                Pair pair = Pair.of((Object)childOrg, (Object)accId);
                if (Objects.isNull(acctDcMap.get(pair))) continue;
                Integer acctDc = (Integer)acctDcMap.get((Object)pair).item1;
                if (Objects.isNull(acctDc)) {
                    LOGGER.info("simulateWriteOff scheme \u65b9\u5411: {}", (Object)acctDc);
                    continue;
                }
                FiFoSimulateParam fifoParam = new FiFoSimulateParam().setOrgId(childOrg).setBookTypeId(scheme.getBookType()).setAcctTableId(scheme.getAccountTableId()).setAccountId(accId).setAcctDc(acctDc).setCurrencyIds(Sets.newHashSet(scheme.getCurrencyList())).setBookedDate(scheme.getBookedDate()).setShowByExpireDate(scheme.isShowByExpireDate()).setExpiredate(scheme.getExpiredate()).setSynCurrency(scheme.isSynCurrency());
                Map<String, AssistVO> assistVOMap = scheme.getAssistVOMap();
                ArrayList<AccountFlexVO> accountFlexVOS = new ArrayList<AccountFlexVO>(assistVOMap.size());
                assistVOMap.forEach((k, v) -> {
                    if (v.hasAccount(accId) && v.getAmongOrg().get(accId) != null && v.getAmongOrg().get(accId).contains(childOrg)) {
                        accountFlexVOS.add(new AccountFlexVO(v.getFlexField(), v.getAssValue()));
                    }
                });
                if (isSummary) {
                    List<AgeRangeVO> ageRangeVOS = AgeRangeVO.convert(scheme.getOverDueRangeMap(), scheme.getUnDueRangeMap());
                    dataSet = FiFoSimulateServiceHelper.executeSimulateSumResult(fifoParam, accountFlexVOS, ageRangeVOS);
                } else {
                    dataSet = FiFoSimulateServiceHelper.executeSimulateDetailResult(fifoParam, accountFlexVOS);
                }
                if (Objects.nonNull(dataSet)) {
                    result.add(dataSet);
                }
                DebugTrace.action(() -> DataSetHelper.logDataSet("WriteOffImpl.balanceSimulateWriteOff_dataSet:", dataSet));
            }
        }
        return result;
    }

    protected DataSet mergeDataSet(List<DataSet> result) {
        if (result.size() == 0) {
            return RcpWriteOffUtils.buildEmptyDs();
        }
        HashSet<String> fields = new HashSet<String>(22);
        for (DataSet dataSet : result) {
            fields.addAll(new HashSet<String>(DataSetUtils.getFields(dataSet)));
        }
        String selFieldStr = String.join((CharSequence)",", fields);
        DataSet unionResult = null;
        for (DataSet ds : result) {
            HashSet<String> tmpFields = new HashSet<String>(DataSetUtils.getFields(ds));
            Sets.SetView diffField = Sets.difference(fields, tmpFields);
            for (String field : diffField) {
                ds = ds.addNullField(field);
            }
            if (Objects.isNull(unionResult)) {
                unionResult = ds.select(selFieldStr);
                continue;
            }
            unionResult = unionResult.union(ds.select(selFieldStr));
        }
        return unionResult;
    }

    protected static DataSet orderSimulateWriteOff(ReciprocalScheme scheme, boolean isSummary) {
        ReciprocalSimulateEngine engine = new ReciprocalSimulateEngine(Collections.singletonList(scheme));
        if (isSummary) {
            return engine.orderWriteOff();
        }
        return engine.run();
    }

    @Override
    public void schemeAutoWriteOff(ReciprocalScheme scheme) {
        ReciprocalContext context = new ReciprocalContext(scheme, false);
        FifoAutoWriteOffService fifoWriteOff = new FifoAutoWriteOffService(context);
        fifoWriteOff.autoWriteOff();
    }

    protected static DataSet buildEmptyDataSet(List<WriteOffField> groupFields, List<WriteOffField> sumFields, List<String> flexFiels) {
        LOGGER.info("groupFields:{} sumFields:{} flexFiels:{}", new Object[]{groupFields, sumFields, flexFiels});
        ArrayList<WriteOffField> fields = new ArrayList<WriteOffField>(0);
        if (Objects.nonNull(groupFields)) {
            fields.addAll(groupFields);
        }
        if (Objects.nonNull(sumFields)) {
            fields.addAll(sumFields);
        }
        ArrayList<String> buildFields = new ArrayList<String>(16);
        ArrayList<DataType> buildDt = new ArrayList<DataType>(16);
        for (WriteOffField field : fields) {
            buildFields.add(field.getFiled());
            buildDt.add(field.getType());
        }
        DataSet dataSet = RcpWriteOffUtils.buildWriteOffDs(buildFields, buildDt).build();
        if (Objects.nonNull(flexFiels)) {
            for (String flexFiel : flexFiels) {
                dataSet = dataSet.addNullField(flexFiel);
            }
        }
        LOGGER.info(" DataSet RowMeta:{}", (Object)dataSet.getRowMeta());
        return dataSet;
    }

    private static Map<Long, Map<Long, AccountVO>> getAssistAccountVersionIdToOrgMap(Set<Long> useOrgIds, Long acctMasterId, Date startDate, boolean isLeaf) {
        HashMap<Long, Map<Long, AccountVO>> assistIdToacctMasterIdToUseOrgMap = new HashMap<Long, Map<Long, AccountVO>>(8);
        long acctTableId = 0L;
        String acctNumber = "";
        try (DataSet acctDs = QueryServiceHelper.queryDataSet((String)WriteOffImpl.class.getName(), (String)"bd_accountview", (String)"longnumber,accounttable", (QFilter[])new QFilter("id", "=", (Object)acctMasterId).toArray(), null);){
            while (acctDs.hasNext()) {
                Row next = acctDs.next();
                acctTableId = next.getLong("accounttable");
                acctNumber = next.getString("longnumber");
            }
        }
        SqlBuilder globalSql = new SqlBuilder();
        globalSql.append("SELECT distinct a.fid, a.fmasterid,a.flongnumber, a.fdc, t.fasstactitemid FROM t_bd_account a", new Object[0]);
        globalSql.append(" inner join t_bd_accountasstactitem t on a.fid = t.fid ", new Object[0]);
        globalSql.append(" where fctrlstrategy = '5' AND fstatus = 'C' and t.fenaccheck = '1'", new Object[0]);
        if (isLeaf) {
            globalSql.append(" and fisleaf = ? ", new Object[]{isLeaf});
        }
        globalSql.append(" and fstartdate < ?", new Object[]{startDate});
        globalSql.append(" and fenddate >= ?", new Object[]{startDate});
        globalSql.append(" and flongnumber like '" + acctNumber + "%'", new Object[0]);
        globalSql.append(" and faccounttableid = ?", new Object[]{acctTableId});
        DataSet globalDataSet = DB.queryDataSet((String)AccountUtils.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)globalSql);
        for (Row row : globalDataSet) {
            long id = row.getLong("fasstactitemid");
            String flongnumber = row.getString("flongnumber");
            if (!acctNumber.equals(flongnumber) && !flongnumber.startsWith(acctNumber + "_")) continue;
            assistIdToacctMasterIdToUseOrgMap.computeIfAbsent(id, k -> new HashMap(8)).computeIfAbsent(row.getLong("fid"), x -> new AccountVO(row.getLong("fid"), row.getLong("fmasterid"), row.getInteger("fdc"), new HashSet<Long>(8))).addUserOrgIds(useOrgIds);
        }
        SqlBuilder useSql = new SqlBuilder();
        useSql.append("SELECT a.fid, a.fmasterid,a.flongnumber, a.fdc,u.fuseorgid, t.fasstactitemid  from t_Bd_account_u as u inner join t_Bd_account as a  on a.fid=u.fdataid  inner join t_bd_accountasstactitem t on a.fid = t.fid  where ", new Object[0]);
        useSql.append("  t.fenaccheck = '1'", new Object[0]);
        useSql.append(" and a.fstartdate < ?", new Object[]{startDate});
        useSql.append(" and a.fenddate >= ?", new Object[]{startDate});
        if (isLeaf) {
            useSql.append(" and a.fisleaf = ? ", new Object[]{isLeaf});
        }
        if (!CollectionUtils.isEmpty(useOrgIds)) {
            useSql.appendIn(" and u.fuseorgid ", useOrgIds.toArray());
        }
        useSql.append(" and flongnumber like '" + acctNumber + "%'", new Object[0]);
        useSql.append(" and faccounttableid = ? ", new Object[]{acctTableId});
        try (DataSet dataSet = DB.queryDataSet((String)AccountUtils.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)useSql);){
            for (Row row : dataSet) {
                long id = row.getLong("fasstactitemid");
                String flongnumber = row.getString("flongnumber");
                if (!acctNumber.equals(flongnumber) && !flongnumber.startsWith(acctNumber + "_")) continue;
                assistIdToacctMasterIdToUseOrgMap.computeIfAbsent(id, k -> new HashMap(8)).computeIfAbsent(row.getLong("fid"), x -> new AccountVO(row.getLong("fid"), row.getLong("fmasterid"), row.getInteger("fdc"), new HashSet<Long>(8))).addUserOrgId(row.getLong("fuseorgid"));
            }
        }
        return assistIdToacctMasterIdToUseOrgMap;
    }

    static class AccountVO {
        public Long id;
        public Long masterId;
        public Integer dc;
        public Set<Long> userOrgIds;

        public AccountVO(Long id, Long masterId, Integer dc, Set<Long> userOrgIds) {
            this.id = id;
            this.masterId = masterId;
            this.dc = dc;
            this.userOrgIds = userOrgIds;
        }

        public void addUserOrgIds(Set<Long> userOrgIds) {
            if (Objects.isNull(this.userOrgIds)) {
                this.userOrgIds = new HashSet<Long>(8);
            }
            this.userOrgIds.addAll(userOrgIds);
        }

        public void addUserOrgId(Long userOrgId) {
            if (Objects.isNull(this.userOrgIds)) {
                this.userOrgIds = new HashSet<Long>(8);
            }
            this.userOrgIds.add(userOrgId);
        }

        public Long getId() {
            return this.id;
        }

        public Long getMasterId() {
            return this.masterId;
        }

        public Integer getDc() {
            return this.dc;
        }

        public Set<Long> getUserOrgIds() {
            return this.userOrgIds;
        }
    }
}

