/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.simulate.balance.result;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.dataentity.Tuple;
import kd.fi.gl.enums.writeoff.WriteOffField;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.simulate.balance.AgingResult;
import kd.fi.gl.reciprocal.simulate.balance.vo.AssistVO;

@Deprecated
public class AgingSumarryResult
extends AgingResult {
    public static final String SUFFIX_LOCAL = "local";
    private final List<Integer> sumIndexFileds = new ArrayList<Integer>(8);
    private Object[] sumAssistData;

    public AgingSumarryResult(ReciprocalScheme scheme) {
        super(scheme);
        for (int i = 0; i < this.rowMeta.getDataTypes().length; ++i) {
            if (!(this.rowMeta.getDataType(i) instanceof BigDecimalType)) continue;
            this.sumIndexFileds.add(i);
        }
    }

    @Override
    protected RowMeta buildRowMeta(ReciprocalScheme scheme) {
        ArrayList<Field> writeOffFields = new ArrayList<Field>(30);
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.ORG));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.ACCOUNT));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.CURRENCYID));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.CURRENCYFOR));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.CURRENCYLOCAL));
        ArrayList<String> flexFields = new ArrayList<String>(scheme.getAssistVOMap().keySet());
        for (String string : flexFields) {
            writeOffFields.add(RcpWriteOffUtils.buildField(string, WriteOffField.ASSGRPITEM.getType()));
        }
        for (Map.Entry entry : scheme.getOverDueRangeMap().entrySet()) {
            writeOffFields.add(RcpWriteOffUtils.buildField((String)entry.getKey(), WriteOffField.UDE_EXT.getType()));
            writeOffFields.add(RcpWriteOffUtils.buildField((String)entry.getKey() + SUFFIX_LOCAL, WriteOffField.UDE_EXT.getType()));
        }
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.OVERDUETOTAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.OVERDUETOTALLOCAL));
        for (Map.Entry entry : scheme.getUnDueRangeMap().entrySet()) {
            writeOffFields.add(RcpWriteOffUtils.buildField((String)entry.getKey(), WriteOffField.UDE_EXT.getType()));
            writeOffFields.add(RcpWriteOffUtils.buildField((String)entry.getKey() + SUFFIX_LOCAL, WriteOffField.UDE_EXT.getType()));
        }
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.UNDUETOTAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.UNDUETOTALLOCAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.BALTOTAL));
        writeOffFields.add(RcpWriteOffUtils.buildField(WriteOffField.LOCALBALTOTAL));
        return new RowMeta(writeOffFields.toArray(new Field[0]));
    }

    @Override
    public boolean add(ReciprocalRecord unWriteOffVO, boolean isFirstAdd) {
        if (isFirstAdd) {
            this.assgrpKeyCache.clearAll();
        }
        this.assistSum(unWriteOffVO);
        return true;
    }

    @Override
    public DataSet agingResult() {
        this.add(null, false);
        return this.dsBuilder.build();
    }

    private void assistSum(ReciprocalRecord unWriteOffVO) {
        if (Objects.isNull(unWriteOffVO)) {
            if (Objects.nonNull(this.sumAssistData) && this.sumAssistData.length > 0) {
                this.dsBuilder.append(this.sumAssistData);
            }
            return;
        }
        Object[] groupKey = this.comAssgrpKey(unWriteOffVO);
        if (Objects.isNull(this.sumAssistData) || this.sumAssistData.length == 0) {
            this.assgrpKeyCache.addData(Boolean.TRUE, groupKey);
        } else {
            Boolean assgrpKeyHit = (Boolean)this.assgrpKeyCache.retrieval(groupKey);
            if (Objects.isNull(assgrpKeyHit)) {
                this.dsBuilder.append(this.sumAssistData);
                this.assgrpKeyCache.addData(Boolean.TRUE, groupKey);
                this.sumAssistData = null;
            }
        }
        this.summary(unWriteOffVO);
    }

    private void summary(ReciprocalRecord unWriteOffVO) {
        ArrayList<Object> values = new ArrayList<Object>(30);
        values.add(unWriteOffVO.getOrg());
        values.add(unWriteOffVO.getAccount());
        if (this.scheme.isSynCurrency()) {
            values.add(unWriteOffVO.getLocalCurrency());
        } else {
            values.add(unWriteOffVO.getCurrency());
        }
        values.add(unWriteOffVO.getCurrency());
        values.add(unWriteOffVO.getLocalCurrency());
        for (String flexField : this.flexFields) {
            Map<String, Object> assgrpVals = unWriteOffVO.getAssgrpVals();
            if (Objects.nonNull(assgrpVals)) {
                values.add(assgrpVals.get(flexField));
                continue;
            }
            values.add(0L);
        }
        LocalDate endLocalDate = Instant.ofEpochMilli(this.scheme.getExpiredate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate startLocalDate = this.scheme.isShowByExpireDate() ? Instant.ofEpochMilli(unWriteOffVO.getExpireDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate() : Instant.ofEpochMilli(unWriteOffVO.getBizDate().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        long daysBetween = ChronoUnit.DAYS.between(startLocalDate, endLocalDate);
        BigDecimal overduetotal = BigDecimal.ZERO;
        BigDecimal overduetotallocal = BigDecimal.ZERO;
        for (Map.Entry<String, Tuple<Integer, Integer>> entry : this.scheme.getOverDueRangeMap().entrySet()) {
            if (daysBetween <= (long)((Integer)entry.getValue().item2).intValue() && daysBetween >= (long)((Integer)entry.getValue().item1).intValue() || daysBetween >= (long)((Integer)entry.getValue().item1).intValue() && (Integer)entry.getValue().item2 == 0) {
                values.add(unWriteOffVO.getLeavingAmountFor());
                values.add(unWriteOffVO.getLeavingAmount());
                overduetotal = overduetotal.add(unWriteOffVO.getLeavingAmountFor());
                overduetotallocal = overduetotallocal.add(unWriteOffVO.getLeavingAmount());
                continue;
            }
            values.add(BigDecimal.ZERO);
            values.add(BigDecimal.ZERO);
        }
        values.add(overduetotal);
        values.add(overduetotallocal);
        BigDecimal unduetotal = BigDecimal.ZERO;
        BigDecimal unduetotallocal = BigDecimal.ZERO;
        for (Map.Entry<String, Tuple<Integer, Integer>> entry : this.scheme.getUnDueRangeMap().entrySet()) {
            if (daysBetween >= (long)((Integer)entry.getValue().item2).intValue() && daysBetween <= (long)((Integer)entry.getValue().item1).intValue() || daysBetween <= (long)((Integer)entry.getValue().item1).intValue() && (Integer)entry.getValue().item2 == 0) {
                values.add(unWriteOffVO.getLeavingAmountFor());
                values.add(unWriteOffVO.getLeavingAmount());
                unduetotal = unduetotal.add(unWriteOffVO.getLeavingAmountFor());
                unduetotallocal = unduetotallocal.add(unWriteOffVO.getLeavingAmount());
                continue;
            }
            values.add(BigDecimal.ZERO);
            values.add(BigDecimal.ZERO);
        }
        values.add(unduetotal);
        values.add(unduetotallocal);
        values.add(overduetotal.add(unduetotal));
        values.add(overduetotallocal.add(unduetotallocal));
        if (Objects.isNull(this.sumAssistData) || this.sumAssistData.length == 0) {
            this.sumAssistData = values.toArray();
        } else {
            for (Integer index : this.sumIndexFileds) {
                this.sumAssistData[index.intValue()] = ((BigDecimal)this.sumAssistData[index]).add((BigDecimal)values.get(index));
            }
        }
    }

    private Object[] comAssgrpKey(ReciprocalRecord unWriteOffVO) {
        ArrayList<Object> keys = new ArrayList<Object>(this.flexFields.size() + 3);
        keys.add(unWriteOffVO.getOrg());
        keys.add(unWriteOffVO.getAccount());
        keys.add(unWriteOffVO.getCurrency());
        for (String flexField : this.flexFields) {
            AssistVO assistVO = this.scheme.getAssistVOMap().get(flexField);
            Map<Long, Set<Long>> amongOrg = assistVO.getAmongOrg();
            Set<Long> userOrgs = amongOrg.get(unWriteOffVO.getAccount());
            if (Objects.nonNull(userOrgs) && userOrgs.contains(unWriteOffVO.getOrg())) {
                keys.add(unWriteOffVO.getAssgrpVals().get(flexField));
                continue;
            }
            keys.add("0");
        }
        return keys.toArray();
    }
}

