/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal.simulate.balance.vo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.fi.gl.reciprocal.simulate.balance.vo.UnWriteOffVoucherVO;

public class BalanceVO {
    private final BigDecimal totalAmount;
    private BigDecimal leavingAmount;
    private BigDecimal leavingAmountFor;
    private int dcFor;
    private int dc;
    private List<UnWriteOffVoucherVO> dueVouchers = new ArrayList<UnWriteOffVoucherVO>();

    public BalanceVO(BigDecimal leavingAmountFor, BigDecimal leavingAmount, int dcFor, int dc) {
        this.totalAmount = leavingAmountFor;
        this.leavingAmountFor = leavingAmountFor;
        this.leavingAmount = leavingAmount;
        this.dcFor = dcFor;
        this.dc = dc;
    }

    public BigDecimal deductFor(BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException("param amout must be exceed 0");
        }
        BigDecimal actualAmountFor = this.leavingAmountFor.compareTo(amount) < 0 ? this.leavingAmountFor : amount;
        this.leavingAmountFor = this.leavingAmountFor.subtract(actualAmountFor);
        return actualAmountFor;
    }

    public BigDecimal deduct(BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException("param amout must be exceed 0");
        }
        BigDecimal actualAmount = this.leavingAmount.compareTo(amount) < 0 ? this.leavingAmount : amount;
        this.leavingAmount = this.leavingAmount.subtract(actualAmount);
        return actualAmount;
    }

    public BigDecimal induceFor(BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException("param amout must be exceed 0");
        }
        this.leavingAmountFor = this.leavingAmountFor.add(amount);
        return amount;
    }

    public BigDecimal induce(BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException("param amout must be exceed 0");
        }
        this.leavingAmount = this.leavingAmount.add(amount);
        return amount;
    }

    public BigDecimal getLeavingAmount() {
        return this.leavingAmount;
    }

    public BigDecimal getLeavingAmountFor() {
        return this.leavingAmountFor;
    }

    public int getDcFor() {
        return this.dcFor;
    }

    public int getDc() {
        return this.dc;
    }

    public void setDc(int dc) {
        this.dc = dc;
    }

    public List<UnWriteOffVoucherVO> getDueVouchers() {
        return this.dueVouchers;
    }

    public String toString() {
        return "BalanceVO{totalAmount=" + this.totalAmount + ", leavingAmount=" + this.leavingAmount + ", leavingAmountFor=" + this.leavingAmountFor + ", dcFor=" + this.dcFor + ", dc=" + this.dc + ", dueVouchers=" + this.dueVouchers + '}';
    }
}

