/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.GLUtil;

public class DailyRptQueryParam
extends MulOrgQPRpt {
    private Date dateBegin;
    private Date dateEnd;
    private long periodId;
    private long periodEndId;
    private Date periodBeginDate;
    private Date periodEndDate;
    private Set<Long> closedInitOrgs;

    public DailyRptQueryParam() {
    }

    public DailyRptQueryParam(FilterInfo filterInfo, String entityId) {
        super(filterInfo, entityId);
        long periodType = this.getPeriodType();
        String selectField = "id,begindate,enddate";
        DynamicObjectCollection periodCollection = GLUtil.getPeriodByDate(filterInfo.getDate("datebegin"), filterInfo.getDate("dateend"), selectField, periodType, true);
        if (!periodCollection.isEmpty()) {
            DynamicObject periodBegin = (DynamicObject)periodCollection.get(periodCollection.size() - 1);
            this.periodId = periodBegin.getLong("id");
            this.periodBeginDate = periodBegin.getDate("begindate");
            this.periodBeginDate = this.parseDate(this.periodBeginDate, true);
            if (!"gl_rpt_cashflow".equals(entityId)) {
                this.setStartPeriod(this.periodId);
            }
            DynamicObject periodEnd = (DynamicObject)periodCollection.get(0);
            this.periodEndId = periodEnd.getLong("id");
            this.periodEndDate = periodEnd.getDate("enddate");
            this.periodEndDate = this.parseDate(this.periodEndDate, false);
            this.setEndPeriod(this.periodEndId);
        }
        this.dateBegin = filterInfo.getDate("datebegin");
        this.dateBegin = this.parseDate(this.dateBegin, true);
        this.dateEnd = filterInfo.getDate("dateend");
        this.dateEnd = this.parseDate(this.dateEnd, false);
        if (filterInfo.getBoolean("issubstractpl")) {
            QFilter btFilter = new QFilter("bookstype", "=", filterInfo.getDynamicObject("booktype").getPkValue());
            long periodYear = this.getStartPeriod() / GLUtil.YEAR_PERIOD_L % 10000L;
            QFilter periodFilter = new QFilter("startperiod.periodyear", "=", (Object)periodYear);
            QFilter endFilter = new QFilter("isendinit", "=", (Object)true);
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{btFilter, periodFilter, endFilter});
            this.closedInitOrgs = books.stream().mapToLong(x -> x.getLong("org")).boxed().collect(Collectors.toSet());
        }
    }

    private Date parseDate(Date date, boolean isBeginDay) {
        if (date == null) {
            return null;
        }
        if (isBeginDay) {
            return DateUtil.makeDateOnDayStrart(date);
        }
        return DateUtil.makeDateOnDayEnd(date);
    }

    public Date getDateBegin() {
        return this.dateBegin;
    }

    public Date getDateEnd() {
        return this.dateEnd;
    }

    public long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(long periodId) {
        this.periodId = periodId;
    }

    public Date getPeriodBeginDate() {
        return this.periodBeginDate;
    }

    public Date getPeriodEndDate() {
        return this.periodEndDate;
    }

    public long getPeriodEndId() {
        return this.periodEndId;
    }

    public Set<Long> getClosedInitOrgs() {
        return this.closedInitOrgs;
    }
}

