/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.lang3.StringUtils;

public class NavToSubLedgerRpt {
    private static final Log log = LogFactory.getLog(NavToSubLedgerRpt.class);
    private final ReportQueryParam param;
    private final IFormView view;
    private final List<Long> accIds = new ArrayList<Long>(16);
    private final Set<Long> orgIds = new HashSet<Long>();
    private final Long orgView;
    private final Long curId;
    private final boolean showSum;
    private final boolean isDebit;
    private final String number;
    private final String filterList;
    private Date startDate = null;
    private Date endDate = null;

    public void apply() {
        ReportShowParameter report = this.initShowParameter();
        this.view.showForm((FormShowParameter)report);
    }

    public ReportShowParameter initShowParameter() {
        long org;
        ReportShowParameter report = new ReportShowParameter();
        report.setFormId("gl_rpt_subledger");
        report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        FilterInfo info = this.param.getFilter();
        if (this.orgIds.isEmpty() && (org = info.getLong("org")) != 0L) {
            this.orgIds.add(org);
        }
        long periodType = info.getLong("periodtype");
        Long bookType = info.getLong("booktype");
        long startPeriod = info.getLong("startperiod");
        long endPeriod = info.getLong("endperiod");
        Date dateBegin = info.getDate("datebegin");
        Date dateEnd = info.getDate("dateend");
        long currencyRpt = info.getLong("currencyrpt");
        boolean show_currencyRpt = info.getBoolean("showrpt");
        if (this.orgIds.size() == 1 && this.accIds.size() == 1) {
            Long org2 = this.orgIds.iterator().next();
            Long accId = this.accIds.get(0);
            AccountBookInfo book = AccSysUtil.getBookFromAccSys(this.orgView == null ? 0L : this.orgView, org2, bookType);
            if (book != null && book.isIsbizunit()) {
                long startPeriodOnBook;
                if (dateBegin != null && dateEnd != null) {
                    DynamicObject sp = GLUtil.getPeriodByDate(dateBegin, periodType);
                    DynamicObject ep = GLUtil.getPeriodByDate(dateEnd, periodType);
                    if (sp != null && ep != null) {
                        startPeriod = sp.getLong("id");
                        endPeriod = ep.getLong("id");
                    }
                }
                if ((startPeriodOnBook = book.getStartPeriodId()) > startPeriod && (startPeriod = startPeriodOnBook) > endPeriod) {
                    endPeriod = startPeriod;
                }
                if (dateEnd == null) {
                    DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriod, (String)"bd_period");
                    dateEnd = period.getDate("enddate");
                }
                DynamicObject acctOri = GLUtil.getAccIdByMasterId(org2, accId, dateEnd);
                log.info("\u4f59\u989d\u8868\u8054\u67e5--:accOriId:" + (acctOri != null ? acctOri.getLong("id") : 0L) + "  accId:" + accId);
                if (acctOri != null) {
                    this.accIds.set(0, acctOri.getLong("id"));
                }
            }
        }
        String curStr = this.curId == null || this.curId == 0L ? info.getString("currency") : String.valueOf(this.curId);
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("orgview", (Object)this.orgView);
        filter.addFilterItem("org", null);
        filter.addFilterItem("orgs", new ArrayList<Long>(this.orgIds));
        filter.addFilterItem("booktype", (Object)bookType);
        filter.addFilterItem("periodtype", (Object)periodType);
        if (this.startDate != null || this.endDate != null) {
            filter.addFilterItem("searchtype", (Object)"2");
            filter.addFilterItem("datebegin", (Object)this.startDate);
            filter.addFilterItem("dateend", (Object)this.endDate);
            filter.addFilterItem("balancezero", (Object)false);
        } else {
            filter.addFilterItem("searchtype", (Object)"1");
            filter.addFilterItem("balancezero", (Object)info.getBoolean("balancezero"));
        }
        filter.addFilterItem("startperiod", (Object)startPeriod);
        filter.addFilterItem("endperiod", (Object)endPeriod);
        filter.addFilterItem("accounttable", (Object)info.getLong("accounttable"));
        filter.addFilterItem("account", this.accIds);
        filter.addFilterItem("accountlevel", (Object)info.getString("accountlevel"));
        filter.addFilterItem("currency", (Object)curStr);
        filter.addFilterItem("currencyrpt", (Object)currencyRpt);
        filter.addFilterItem("mulcur", (Object)info.getString("mulcur"));
        if (info.containProp("issubstractpl")) {
            filter.addFilterItem("issubstractpl", (Object)info.getBoolean("issubstractpl"));
        }
        filter.addFilterItem("yearbalzero", (Object)info.getBoolean("yearbalzero"));
        filter.addFilterItem("showdailysum", (Object)this.showSum);
        filter.addFilterItem("showrpt", (Object)show_currencyRpt);
        filter.addFilterItem("showqty", (Object)info.getBoolean("showqty"));
        filter.addFilterItem("showleafaccount", (Object)info.getBoolean("showleafaccount"));
        filter.addFilterItem("nodisplayforzero", (Object)info.getBoolean("nodisplayforzero"));
        CommonAssistUtil.addComassitHyperParam(this.param, filter);
        report.setCustomParam("accounttable", (Object)String.valueOf(info.getLong("accounttable")));
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        report.setQueryParam(queryParam);
        return report;
    }

    public void openVoucher() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("gl_voucher");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        FilterInfo info = this.param.getFilter();
        String org = (this.orgIds.size() > 0 ? this.orgIds.iterator().next().longValue() : info.getLong("org")) + "";
        String curStr = info.getString("currency");
        Long bookType = info.getLong("booktype");
        long startPeriod = info.getLong("startperiod");
        long endPeriod = info.getLong("endperiod");
        String subjectNumber = this.number;
        showParameter.getCustomParams().put("org", org);
        showParameter.getCustomParams().put("booktype", bookType.toString());
        QFilter allFilter = new QFilter("booktype", "=", (Object)bookType);
        allFilter.and(new QFilter("period", ">=", (Object)startPeriod));
        allFilter.and(new QFilter("period", "<=", (Object)endPeriod));
        showParameter.getCustomParams().put("subjectNumber", subjectNumber);
        allFilter.and(new QFilter("entries.account.number", "like", (Object)(subjectNumber + "%")));
        allFilter.and(new QFilter("billstatus", "!=", (Object)"A"));
        if (this.isDebit) {
            allFilter.and(new QFilter("entries.debitlocal", "!=", (Object)0));
        } else {
            allFilter.and(new QFilter("entries.creditlocal", "!=", (Object)0));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.filterList)) {
            allFilter.and(QFilter.fromSerializedString((String)this.filterList));
        }
        if (!curStr.equals("allcurrency") && !curStr.equals("basecurrency")) {
            allFilter.and(new QFilter("entries.currency", "=", (Object)Long.valueOf(curStr)));
        }
        showParameter.getCustomParams().put("filter", allFilter.toSerializedString());
        showParameter.getCustomParams().put("source", "VoucherSummaryFormRpt");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        showParameter.setCustomParam("bookeddate", (Object)new Object[]{sdf.format(info.getDynamicObject("startperiod").get("begindate")), sdf.format(info.getDynamicObject("endperiod").get("enddate"))});
        this.view.showForm((FormShowParameter)showParameter);
    }

    private NavToSubLedgerRpt(SLBuilder builder) {
        this.param = builder.param;
        this.view = builder.view;
        this.accIds.addAll(builder.accIds);
        this.orgIds.addAll(builder.orgIds);
        this.curId = builder.curId;
        this.showSum = builder.showSum;
        this.isDebit = builder.isDebit;
        this.number = builder.number;
        this.filterList = builder.filterList;
        this.orgView = builder.orgView;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    public static class SLBuilder {
        private ReportQueryParam param;
        private IFormView view;
        private List<Long> accIds = new ArrayList<Long>(16);
        private Set<Long> orgIds = new HashSet<Long>();
        private Long curId;
        private boolean showSum;
        private boolean isDebit;
        private String number;
        private String filterList;
        private Long orgView = null;
        private Date startDate = null;
        private Date endDate = null;

        public SLBuilder(ReportQueryParam param, IFormView view) {
            this.param = param;
            this.view = view;
        }

        public SLBuilder accountId(Long accId) {
            this.accIds.add(accId);
            return this;
        }

        public SLBuilder accountIds(Collection<Long> toAddAccIds) {
            this.accIds.addAll(toAddAccIds);
            return this;
        }

        public SLBuilder currencyId(Long curId) {
            this.curId = curId;
            return this;
        }

        public SLBuilder orgId(Long orgId) {
            this.orgIds.add(orgId);
            return this;
        }

        public SLBuilder orgIds(List<Long> orgIds) {
            this.orgIds.addAll(orgIds);
            return this;
        }

        public SLBuilder orgView(Long orgView) {
            this.orgView = orgView;
            return this;
        }

        public SLBuilder showSum(boolean showSum) {
            this.showSum = showSum;
            return this;
        }

        public SLBuilder number(String number) {
            this.number = number;
            return this;
        }

        public SLBuilder isDebit(boolean isDebit) {
            this.isDebit = isDebit;
            return this;
        }

        public SLBuilder filterList(String filterList) {
            this.filterList = filterList;
            return this;
        }

        public SLBuilder date(Date startDate, Date endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
            return this;
        }

        public NavToSubLedgerRpt build() {
            return new NavToSubLedgerRpt(this);
        }
    }
}

