/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.ThreadCache;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.fi.util.StringUtils;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamRpt;

public class QueryParamFactory {
    private static final Set<String> singleOrgReport = Sets.newHashSet((Object[])new String[]{"gl_rpt_subsidiaryledger"});
    private static final String CACHE_ID_KEY = "cacheid";

    public static QueryParamRpt createOrGetWithThreadCache(FilterInfo filterInfo, String entityId) {
        return (QueryParamRpt)ThreadCache.get((Object)filterInfo, () -> singleOrgReport.contains(entityId) ? new QueryParamRpt(filterInfo, entityId) : new MulOrgQPRpt(filterInfo, entityId));
    }

    public static QueryParamRpt createOrGetWithThreadCache(ReportQueryParam param, String entityId) {
        Optional<String> queryIdOpt = Optional.ofNullable((ReportBatchQueryInfo)param.byBatchInfo()).map(ReportBatchQueryInfo::getBatchByDataSetCacheId);
        if (queryIdOpt.isPresent()) {
            FilterInfo filterInfo = param.getFilter();
            return (QueryParamRpt)ThreadCache.get((Object)("QueryParamRpt#" + queryIdOpt.get()), () -> singleOrgReport.contains(entityId) ? new QueryParamRpt(filterInfo, entityId) : new MulOrgQPRpt(filterInfo, entityId));
        }
        return QueryParamFactory.createOrGetWithThreadCache(param.getFilter(), entityId);
    }

    public static QueryParamRpt createOrGetWithThreadCache(ReportQueryParam param, String entityId, boolean newCache) {
        Map customParam = param.getCustomParam();
        String cacheId = (String)customParam.get(CACHE_ID_KEY);
        if (newCache || StringUtils.isEmpty((String)cacheId)) {
            cacheId = UUID.randomUUID().toString();
            customParam.put(CACHE_ID_KEY, cacheId);
        }
        FilterInfo filterInfo = param.getFilter();
        return (QueryParamRpt)ThreadCache.get((Object)("QueryParamRpt#" + cacheId), () -> singleOrgReport.contains(entityId) ? new QueryParamRpt(filterInfo, entityId) : new MulOrgQPRpt(filterInfo, entityId));
    }
}

