/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BatchProcessUtil;
import org.jetbrains.annotations.NotNull;

public class ReportFormUtil {
    public static Map<String, Object> createAccountLevel(long accounttableId) {
        DynamicObject accounttable = BusinessDataServiceHelper.loadSingle((Object)accounttableId, (String)"bd_accounttable");
        int level = accounttable.getInt("maxlevel");
        if (level == 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<ComboItem> list = ReportFormUtil.createItemList(level);
        map.put("levelList", list);
        map.put("defaultItem", list.get(0));
        return map;
    }

    public static List<ComboItem> createAcctLevel(Object accounttablePK) {
        DynamicObject accounttable = BusinessDataServiceHelper.loadSingle((Object)accounttablePK, (String)"bd_accounttable");
        String accountlevel = accounttable.getString("accountlevel");
        int level = accountlevel.split("-").length;
        if (level == 0) {
            return null;
        }
        return ReportFormUtil.createItemList(level);
    }

    public static List<ComboItem> createItemList(int maxLevel) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(maxLevel);
        for (int i = 1; i <= maxLevel; ++i) {
            ComboItem item = new ComboItem();
            String viewStr = String.valueOf(i);
            item.setCaption(new LocaleString(viewStr));
            item.setValue(viewStr);
            list.add(item);
        }
        return list;
    }

    public static List<Long> getVerAcctTable(List<Long> orgIds, long bookTypeId, long endPeriodId) {
        QFilter fbt = new QFilter("booktype", "=", (Object)bookTypeId);
        String selfield = StringUtils.join((Object[])new String[]{"org", "enableperiod", "oldaccttab", "accounttable"}, (String)",");
        DynamicObjectCollection col = BatchProcessUtil.batchQueryDynColl(orgIds, batchOrgs -> QueryServiceHelper.query((String)"gl_book_version", (String)selfield, (QFilter[])new QFilter[]{new QFilter("org", "in", batchOrgs), fbt}, (String)"org, enableperiod desc"));
        HashMap<Long, List<BookVersionCompare>> bookVersionCompareMap = new HashMap<Long, List<BookVersionCompare>>(8);
        for (DynamicObject bookVersion : col) {
            long orgId = bookVersion.getLong("org");
            bookVersionCompareMap.computeIfAbsent(orgId, k -> new ArrayList(10)).add(new BookVersionCompare(bookVersion));
        }
        Map<Long, List<Long>> orgEffectiveTables = ReportFormUtil.computeEffectiveTable(bookVersionCompareMap, endPeriodId);
        HashSet<Long> acctTableIds = new HashSet<Long>();
        orgEffectiveTables.values().stream().forEach(x -> acctTableIds.addAll((Collection<Long>)x));
        orgIds.removeAll(orgEffectiveTables.keySet());
        if (orgEffectiveTables.size() != 0 && !orgIds.isEmpty()) {
            QFilter fbt1 = new QFilter("bookstype", "=", (Object)bookTypeId);
            try (DataSet ds = BatchProcessUtil.batchQueryDataSet(orgIds, batchOrgs -> {
                QFilter forg1 = new QFilter("org", "in", batchOrgs);
                return QueryServiceHelper.queryDataSet((String)ReportFormUtil.class.getName(), (String)"gl_accountbook", (String)"accounttable", (QFilter[])new QFilter[]{forg1, fbt1}, null);
            });){
                for (Row row : ds) {
                    acctTableIds.add(row.getLong("accounttable"));
                }
            }
        }
        return new ArrayList<Long>(acctTableIds);
    }

    protected static Map<Long, List<Long>> computeEffectiveTable(Map<Long, List<BookVersionCompare>> bookVersionCompareMap, long endPeriodId) {
        if (CollectionUtils.isEmpty(bookVersionCompareMap)) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<Long>> orgEffectiveTables = new HashMap<Long, List<Long>>(bookVersionCompareMap.size());
        for (Map.Entry<Long, List<BookVersionCompare>> bookVersionCompareEntry : bookVersionCompareMap.entrySet()) {
            List<BookVersionCompare> bookVersionGroup = bookVersionCompareEntry.getValue();
            Collections.sort(bookVersionGroup);
            long minOldTableId = bookVersionGroup.get(0).getBookVersion().getLong("oldaccttab");
            bookVersionGroup.add(new BookVersionCompare(-1L, -1L, minOldTableId));
            Collections.sort(bookVersionGroup);
            for (int i = 0; i < bookVersionGroup.size() - 1; ++i) {
                bookVersionGroup.get(i).setUpper(bookVersionGroup.get(i + 1).getLower());
            }
            List effectiveTableIds = bookVersionGroup.stream().filter(x -> x.isEffectivePeriod(endPeriodId)).map(x -> x.getEffectiveTableId()).collect(Collectors.toList());
            orgEffectiveTables.put(bookVersionCompareEntry.getKey(), effectiveTableIds);
        }
        return orgEffectiveTables;
    }

    protected static class BookVersionCompare
    implements Comparable<BookVersionCompare> {
        private DynamicObject bookVersion;
        private long lower = -1L;
        private long upper = 99999999999L;
        private long effectiveTableId;

        public BookVersionCompare(DynamicObject bookVersion) {
            this.bookVersion = bookVersion;
            this.lower = bookVersion.getLong("enableperiod");
            this.effectiveTableId = bookVersion.getLong("accounttable");
        }

        public BookVersionCompare(long lower, long upper, long effectiveTableId) {
            this.lower = lower;
            this.upper = upper;
            this.effectiveTableId = effectiveTableId;
        }

        public boolean isEffectivePeriod(long periodId) {
            return periodId >= this.lower && periodId <= this.upper;
        }

        public void setUpper(long upper) {
            this.upper = upper;
        }

        public DynamicObject getBookVersion() {
            return this.bookVersion;
        }

        public long getLower() {
            return this.lower;
        }

        public long getEffectiveTableId() {
            return this.effectiveTableId;
        }

        @Override
        public int compareTo(@NotNull BookVersionCompare other) {
            return Long.compare(this.lower, other.lower);
        }
    }
}

