/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export;

import java.io.Closeable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.PersistedArrayRow;
import kd.bos.algo.env.ThreadContext;
import kd.bos.dataentity.Tuple;

public class RecyclableRowStorage
implements Closeable {
    private static final ThreadLocal<Map<RowMeta, Tuple<Queue<Object[]>, Integer>>> storages = new ThreadLocal();

    public RecyclableRowStorage() {
        ThreadContext.getCurrent().addCloseable((Closeable)this);
    }

    public void openStorage(RowMeta rowMeta, int limit) {
        if (storages.get() == null) {
            storages.set(new HashMap(4));
            ThreadContext.getCurrent().addCloseable((Closeable)new RecyclableRowStorage());
        }
        storages.get().computeIfAbsent(rowMeta, rowMeta1 -> new Tuple(new LinkedList(), (Object)limit));
    }

    public Object[] useOne(RowMeta rowMeta) {
        if (!storages.get().containsKey(rowMeta)) {
            throw new IllegalStateException("storage not open yet.");
        }
        Queue storage = (Queue)RecyclableRowStorage.storages.get().get((Object)rowMeta).item1;
        if (storage.isEmpty()) {
            storage.offer(new Object[rowMeta.getFieldCount()]);
        }
        return (Object[])storage.poll();
    }

    public void recycleOne(AbstractRow row) {
        if (row instanceof PersistedArrayRow) {
            if (!storages.get().containsKey(row.getRowMeta())) {
                throw new IllegalStateException("storage not open yet.");
            }
            Tuple<Queue<Object[]>, Integer> tuple = storages.get().get(row.getRowMeta());
            if (((Queue)tuple.item1).size() <= (Integer)tuple.item2) {
                Arrays.fill(row.values(), null);
                ((Queue)tuple.item1).offer(row.values());
            }
        }
    }

    @Override
    public void close() {
        Map<RowMeta, Tuple<Queue<Object[]>, Integer>> repo = storages.get();
        if (repo != null) {
            repo.clear();
        }
    }
}

