/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;

public class ReportRowSet
implements Serializable {
    private static final long serialVersionUID = -5152895359157750282L;
    private transient int currentIndex = -1;
    private Set<String> columnNameSet;
    private List<Row> rowData;
    private int size_s = 0;
    private Map<String, Integer> colIndexMap;

    public ReportRowSet(RowMeta metaData, List<Row> rowData, Map<String, Integer> colIndexMap) {
        this.colIndexMap = colIndexMap;
        this.initColumnNameSet(metaData);
        this.rowData = rowData;
        if (rowData != null) {
            this.size_s = rowData.size();
        }
    }

    private void initColumnNameSet(RowMeta metaData) {
        this.columnNameSet = new HashSet<String>(32);
        Field[] fields = metaData.getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.columnNameSet.add(fields[i].getName());
        }
    }

    public boolean next() {
        ++this.currentIndex;
        return this.currentIndex < this.size_s;
    }

    public String[] getColumnNames() {
        String[] columnNames = new String[this.columnNameSet.size()];
        return this.columnNameSet.toArray(columnNames);
    }

    public boolean containsColumn(String columnName) {
        return this.columnNameSet.contains(columnName);
    }

    public Object getObject(String columnName) {
        if (this.rowData != null) {
            Row row = this.rowData.get(this.currentIndex);
            if (row == null) {
                return null;
            }
            return row.get(this.colIndexMap.get(columnName).intValue());
        }
        return null;
    }

    public int size() {
        return this.size_s;
    }
}

