/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export.convert;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.Row;
import kd.bos.entity.report.FilterInfo;
import kd.fi.bd.model.Context;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryRow;

public class PeriodBeginConverter
implements IDatasetRowTypeConverter<SubsidiaryRow> {
    @Override
    public SubsidiaryRow convertTo(Context context, Row row) {
        Map periodMap = (Map)context.query("periodMap");
        Map orgCurLocalMap = (Map)context.query("orgCurLocalMap");
        FilterInfo filterInfo = (FilterInfo)context.query("filterInfo");
        Map orgnameMap = (Map)context.query("orgnameMap");
        SubsidiaryRow subsidiaryRow = new SubsidiaryRow();
        subsidiaryRow.setRowtype(row.getString("rowtype"));
        subsidiaryRow.setOrgId(row.getLong("orgid"));
        subsidiaryRow.setOrgName((String)orgnameMap.get(row.getLong("orgid")));
        subsidiaryRow.setAccountId(row.getLong("accountid"));
        subsidiaryRow.setAccountMasterId(row.getLong("accountmasterid"));
        subsidiaryRow.setAccountName(row.getString("accountname"));
        subsidiaryRow.setAccountNumber(row.getString("accountnumber"));
        subsidiaryRow.setAccountDc(row.getInteger("accountdc"));
        subsidiaryRow.setVoucherDesc(row.getString("desc"));
        subsidiaryRow.setPeriodId(row.getLong("period"));
        subsidiaryRow.setPeriodYear(((SubsidiaryPeriod)periodMap.get(row.getLong("period"))).getPeriodyear());
        if (!filterInfo.getBoolean("showqty")) {
            subsidiaryRow.setMeasureUnitId(0L);
        } else {
            subsidiaryRow.setMeasureUnitId(row.getLong("measureunit"));
        }
        if ("basecurrency".equals(filterInfo.getString("currency"))) {
            subsidiaryRow.setCurrencyId((Long)orgCurLocalMap.get(row.getLong("orgid")));
        } else if (!"allcurrency".equals(filterInfo.getString("currency"))) {
            subsidiaryRow.setCurrencyId(Long.valueOf(filterInfo.getString("currency")));
        } else {
            subsidiaryRow.setCurrencyId(row.getLong("currencycolumn"));
        }
        subsidiaryRow.setBaseCurrency((Long)orgCurLocalMap.get(row.getLong("orgid")));
        if (Objects.equals(subsidiaryRow.getRowtype(), "1")) {
            subsidiaryRow.setEndFor(row.getBigDecimal("endfor"));
            subsidiaryRow.setEndLocal(row.getBigDecimal("endlocal"));
            subsidiaryRow.setEndQty(row.getBigDecimal("endqty"));
        } else {
            subsidiaryRow.setYearDebitFor(row.getBigDecimal("yeardebitfor"));
            subsidiaryRow.setYearDebitLocal(row.getBigDecimal("yeardebitlocal"));
            subsidiaryRow.setYearDebitQty(row.getBigDecimal("yeardebitqty"));
            subsidiaryRow.setYearCreditFor(row.getBigDecimal("yearcreditfor"));
            subsidiaryRow.setYearCreditLocal(row.getBigDecimal("yearcreditlocal"));
            subsidiaryRow.setYearCreditQty(row.getBigDecimal("yearcreditqty"));
        }
        subsidiaryRow.setEndDC(subsidiaryRow.getEndLocal().compareTo(BigDecimal.ZERO));
        List flexFields = (List)context.query("flexFieldNames");
        Tuple[] flexTuple = new Tuple[flexFields.size()];
        for (int i = 0; i < flexFields.size(); ++i) {
            flexTuple[i] = Tuple.create(flexFields.get(i), row.get((String)flexFields.get(i)));
        }
        subsidiaryRow.setFlexTuple(flexTuple);
        return subsidiaryRow;
    }
}

