/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.report.export.ExportOption;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.export.processor.BatchProcessorChain;
import kd.fi.gl.report.export.processor.IBatchTransformer;

public abstract class AbstractBatchTransformer<T1, T2>
implements IBatchTransformer<T1, T2> {
    private static final Log LOG = LogFactory.getLog(AbstractBatchTransformer.class);
    private List<T1> batchInData;
    private List<T2> nextBatchInData;
    private final int batchSize;
    private IBatchTransformer<?, ?> nextProcessor;
    private BatchProcessorChain<?, ?> processorChain;
    private int batchSeq;
    private int totalItemCnt;
    private T1 lastItemOfPreBatch;
    private boolean lastBatchFlag;
    private IDatasetRowTypeConverter<T1> datasetRowTypeConverter;

    public AbstractBatchTransformer(int batchSize) {
        this.batchSize = batchSize;
        this.batchInData = new LinkedList<T1>();
        this.nextBatchInData = new LinkedList<T2>();
    }

    @Override
    public void reset() {
        this.batchSeq = 0;
        this.totalItemCnt = 0;
        this.lastItemOfPreBatch = null;
        this.lastBatchFlag = false;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getCurBatchSize() {
        return this.batchInData.size();
    }

    @Override
    public void setLastBatchFlag(boolean lastBatchFlag) {
        this.lastBatchFlag = lastBatchFlag;
    }

    @Override
    public void work(List<T1> dataEntry) {
        IBatchTransformer<?, ?> nextProcessor = this.getNextProcessor();
        if (!this.getOwnedChain().isAbort()) {
            if (CollectionUtils.isNotEmpty(dataEntry)) {
                this.batchInData.addAll(dataEntry);
                if (this.batchInData.size() >= this.getBatchSize()) {
                    this.totalItemCnt += this.batchInData.size();
                    this.lastItemOfPreBatch = this.batchInData.get(this.batchInData.size() - 1);
                    if (this.totalItemCnt > this.getOwnedChain().getExportOption().getTotalLimit()) {
                        this.getOwnedChain().abort();
                    } else {
                        ++this.batchSeq;
                        ArrayList<T2> tmpBatchInData = new ArrayList<T2>(this.process(this.batchInData));
                        if (CollectionUtils.isNotEmpty(tmpBatchInData)) {
                            this.nextBatchInData.addAll(tmpBatchInData);
                        }
                    }
                    this.batchInData.clear();
                }
            }
            if (Objects.nonNull(nextProcessor)) {
                int nextBatchSize = nextProcessor.getBatchSize();
                if (CollectionUtils.isNotEmpty(this.nextBatchInData)) {
                    int loopTimes = this.nextBatchInData.size() / nextBatchSize;
                    int remainder = this.nextBatchInData.size() % nextBatchSize;
                    if (remainder != 0) {
                        ++loopTimes;
                    }
                    for (int i = 0; i < loopTimes; ++i) {
                        List tmpList = this.nextBatchInData.stream().skip(i * nextBatchSize).limit(nextBatchSize).collect(Collectors.toList());
                        if (i == loopTimes - 1) {
                            this.nextBatchInData = tmpList;
                            continue;
                        }
                        nextProcessor.work(tmpList);
                    }
                }
            }
        } else {
            if (DebugTrace.enable()) {
                LOG.info("batch_processor {} is aborted. Give up {} items on batch index: {}.", new Object[]{this.getClass().getName(), this.getCurBatchSize(), this.batchSeq});
            }
            this.batchInData.clear();
            this.nextBatchInData.clear();
            if (Objects.nonNull(nextProcessor)) {
                nextProcessor.work(Collections.EMPTY_LIST);
            }
        }
    }

    @Override
    public void fireFinished() throws Exception {
        IBatchTransformer<?, ?> nextProcessor;
        if (CollectionUtils.isNotEmpty(this.batchInData)) {
            this.totalItemCnt += this.batchInData.size();
            if (this.totalItemCnt > this.getOwnedChain().getExportOption().getTotalLimit()) {
                this.getOwnedChain().abort();
            } else {
                ++this.batchSeq;
                this.setLastBatchFlag(true);
                ArrayList<T2> tmpBatchInData = new ArrayList<T2>(this.process(this.batchInData));
                if (CollectionUtils.isNotEmpty(tmpBatchInData)) {
                    this.nextBatchInData.addAll(tmpBatchInData);
                }
            }
            this.batchInData.clear();
        }
        if (Objects.nonNull(nextProcessor = this.getNextProcessor())) {
            int nextBatchSize = nextProcessor.getBatchSize();
            if (CollectionUtils.isNotEmpty(this.nextBatchInData)) {
                int loopTimes = this.nextBatchInData.size() / nextBatchSize;
                int remainder = this.nextBatchInData.size() % nextBatchSize;
                if (remainder != 0) {
                    ++loopTimes;
                }
                for (int i = 0; i < loopTimes; ++i) {
                    List tmpList = this.nextBatchInData.stream().skip(i * nextBatchSize).limit(nextBatchSize).collect(Collectors.toList());
                    if (i == loopTimes - 1) {
                        nextProcessor.setLastBatchFlag(true);
                    }
                    nextProcessor.work(tmpList);
                }
                this.nextBatchInData.clear();
            }
            this.beforeNextProcessorFireFinished();
            nextProcessor.fireFinished();
        }
    }

    protected void beforeNextProcessorFireFinished() {
    }

    protected abstract List<T2> process(List<T1> var1);

    @Override
    public void setOwnedChain(BatchProcessorChain<?, ?> processorChain) {
        this.processorChain = processorChain;
    }

    @Override
    public BatchProcessorChain<?, ?> getOwnedChain() {
        return this.processorChain;
    }

    @Override
    public IBatchTransformer<?, ?> getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(IBatchTransformer<?, ?> nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    public int getBatchSeq() {
        return this.batchSeq;
    }

    public int getTotalItemCnt() {
        return this.totalItemCnt;
    }

    protected T1 getLastItemOfPreBatch() {
        return this.lastItemOfPreBatch;
    }

    public boolean isLastBatchFlag() {
        return this.lastBatchFlag;
    }

    @Override
    public ExportOption getExportOption() {
        return this.getOwnedChain().getExportOption();
    }
}

