/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export.processor;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.export.convert.PeriodBeginConverter;
import kd.fi.gl.report.export.processor.AbstractBatchTransformer;
import kd.fi.gl.report.subsidiary.SubsidiaryColIndex;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryReportDatasetBuilder;
import kd.fi.gl.report.subsidiary.SubsidiaryRow;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SubsiDiaryHelper;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class BalanceRowTransformer
extends AbstractBatchTransformer<SubsidiaryRow, Row> {
    private static final Log logger = LogFactory.getLog(BalanceRowTransformer.class);
    private Map<String, SubsidiaryRow> periodBeginMap = new LinkedHashMap<String, SubsidiaryRow>(64);
    private String lastSubsidiaryKey = "";
    private Table<String, String, SubsidiaryRow> lastTmpGroupData = HashBasedTable.create();
    private SubsidiaryRow periodTotalDataRow = null;

    public BalanceRowTransformer(int batchSize) {
        super(batchSize);
    }

    private void initPeriodBeginData() {
        long tick = System.currentTimeMillis();
        PeriodBeginConverter converter = new PeriodBeginConverter();
        FilterInfo filterInfo = (FilterInfo)this.getOwnedChain().getContextProp("filterInfo");
        String accountNameField = (String)this.getOwnedChain().getContextProp("accountNameField");
        Long orgId = this.getOwnedChain().getExportOption().getOrgId();
        HashMap<String, SubsidiaryRow> yearMap = new HashMap<String, SubsidiaryRow>(64);
        DataSet yearDataSet = SubsidiaryReportDatasetBuilder.buildYearBalanceSource(orgId, filterInfo, accountNameField);
        while (yearDataSet.hasNext()) {
            SubsidiaryRow row = (SubsidiaryRow)converter.convertTo(this.getOwnedChain().getContext(), yearDataSet.next());
            String subsidiaryKey = this.buildSubsidiaryKey(row);
            yearMap.put(subsidiaryKey, row);
        }
        DataSet periodBeginDataSet = SubsidiaryReportDatasetBuilder.buildPeriodBeginBalanceSource(orgId, filterInfo, accountNameField);
        while (periodBeginDataSet.hasNext()) {
            SubsidiaryRow row = (SubsidiaryRow)converter.convertTo(this.getOwnedChain().getContext(), periodBeginDataSet.next());
            String subsidiaryKey = this.buildSubsidiaryKey(row);
            this.showByAccountDc(row, filterInfo);
            SubsidiaryRow yearRow = (SubsidiaryRow)yearMap.get(subsidiaryKey);
            if (null != yearRow) {
                row.setYearDebitFor(yearRow.getYearDebitFor());
                row.setYearDebitLocal(yearRow.getYearDebitLocal());
                row.setYearDebitQty(yearRow.getYearDebitQty());
                row.setYearCreditFor(yearRow.getYearCreditFor());
                row.setYearCreditLocal(yearRow.getYearCreditLocal());
                row.setYearCreditQty(yearRow.getYearCreditQty());
            }
            this.periodBeginMap.put(subsidiaryKey, row);
            if (Objects.isNull(this.periodTotalDataRow)) {
                this.periodTotalDataRow = new SubsidiaryRow();
                this.periodTotalDataRow.setRowtype("5");
                this.periodTotalDataRow.setVoucherDesc(ResManager.loadKDString((String)"\u672c\u671f\u603b\u5408\u8ba1", (String)"ReportRowType_4", (String)"fi-gl-common", (Object[])new Object[0]));
                this.periodTotalDataRow.setDebitLocal(BigDecimal.ZERO);
                this.periodTotalDataRow.setCreditLocal(BigDecimal.ZERO);
                this.periodTotalDataRow.setEndLocal(BigDecimal.ZERO);
                this.periodTotalDataRow.setBaseCurrency(row.getBaseCurrency());
            }
            BigDecimal periodBeginEndLocal = row.getEndLocal();
            if (row.getEndDC() < 0) {
                periodBeginEndLocal = periodBeginEndLocal.negate();
            }
            this.periodTotalDataRow.setEndLocal(this.periodTotalDataRow.getEndLocal().add(periodBeginEndLocal));
        }
        logger.info("subsidiary_multiorg init periodBeginData.orgId:{},cost:{}ms", (Object)orgId, (Object)(System.currentTimeMillis() - tick));
    }

    @Override
    public void reset() {
        super.reset();
        this.initPeriodBeginData();
    }

    @Override
    protected List<Row> process(List<SubsidiaryRow> batchEntries) {
        Map periodMap = (Map)this.getOwnedChain().getContext().query("periodMap");
        Map orgBookStartPeriodMap = (Map)this.getOwnedChain().getContext().query("orgBookStartPeriodMap");
        FilterInfo filterInfo = (FilterInfo)this.getOwnedChain().getContext().query("filterInfo");
        List<SubsidiaryRow> preGroupList = this.getPreGroupList(batchEntries, filterInfo, periodMap);
        HashBasedTable subsidiaryTable = HashBasedTable.create();
        batchEntries.forEach(arg_0 -> this.lambda$process$0((Table)subsidiaryTable, periodMap, orgBookStartPeriodMap, arg_0));
        ArrayList keyList = new ArrayList(subsidiaryTable.rowKeySet());
        int groupCount = keyList.size();
        block0: for (int k = 0; k < groupCount; ++k) {
            String subsidiaryKey = (String)keyList.get(k);
            SubsidiaryRow lastYearData = null;
            if (this.periodBeginMap.get(subsidiaryKey) == null) {
                subsidiaryTable.row((Object)subsidiaryKey).clear();
                continue;
            }
            SubsidiaryRow periodBeginData = (SubsidiaryRow)this.periodBeginMap.get(subsidiaryKey).clone();
            if (StringUtils.isEmpty((String)this.lastSubsidiaryKey)) {
                this.lastSubsidiaryKey = subsidiaryKey;
            } else if (!subsidiaryKey.equals(this.lastSubsidiaryKey)) {
                this.periodBeginMap.remove(this.lastSubsidiaryKey);
                this.lastSubsidiaryKey = subsidiaryKey;
            }
            Map periodVoucherMap = subsidiaryTable.row((Object)subsidiaryKey);
            for (SubsidiaryPeriod subsidiaryPeriod : periodMap.values()) {
                Optional<SubsidiaryRow> tmpYearDataRowOp;
                BigDecimal debitqtySum;
                if (subsidiaryPeriod.getPeriod() < (Long)orgBookStartPeriodMap.get(periodBeginData.getOrgId())) continue;
                SubsidiaryRow tmpPeriodDataRow = null;
                if (this.lastTmpGroupData.containsRow((Object)subsidiaryKey)) {
                    SubsidiaryRow lastTmpPeriodDataRow = (SubsidiaryRow)this.lastTmpGroupData.get((Object)subsidiaryKey, (Object)"periodData");
                    if (subsidiaryPeriod.getPeriod() < lastTmpPeriodDataRow.getPeriodId()) continue;
                    if (Objects.equals(subsidiaryPeriod.getPeriod(), lastTmpPeriodDataRow.getPeriodId())) {
                        tmpPeriodDataRow = lastTmpPeriodDataRow;
                    }
                }
                List voucherRows = (List)periodVoucherMap.get(subsidiaryPeriod.getPeriod());
                if (filterInfo.getBoolean("nozeroperiod") && voucherRows.size() == 0) {
                    if (!periodBeginData.getPeriodId().equals(subsidiaryPeriod.getPeriod()) || this.lastTmpGroupData.containsRow((Object)subsidiaryKey)) continue;
                    voucherRows.add(0, periodBeginData);
                    continue;
                }
                SubsidiaryRow lastVoucherData = null != lastYearData ? lastYearData : periodBeginData;
                BigDecimal creditforSum = null != tmpPeriodDataRow ? tmpPeriodDataRow.getCreditFor() : BigDecimal.ZERO;
                BigDecimal creditlocalSum = null != tmpPeriodDataRow ? tmpPeriodDataRow.getCreditLocal() : BigDecimal.ZERO;
                BigDecimal creditqtySum = null != tmpPeriodDataRow ? tmpPeriodDataRow.getCreditQty() : BigDecimal.ZERO;
                BigDecimal debitforSum = null != tmpPeriodDataRow ? tmpPeriodDataRow.getDebitFor() : BigDecimal.ZERO;
                BigDecimal debitlocalSum = null != tmpPeriodDataRow ? tmpPeriodDataRow.getDebitLocal() : BigDecimal.ZERO;
                BigDecimal bigDecimal = debitqtySum = null != tmpPeriodDataRow ? tmpPeriodDataRow.getDebitQty() : BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty((Collection)voucherRows)) {
                    lastVoucherData = (SubsidiaryRow)voucherRows.get(voucherRows.size() - 1);
                    for (int i = 0; i < voucherRows.size(); ++i) {
                        SubsidiaryRow preVoucherData;
                        SubsidiaryRow voucherData = (SubsidiaryRow)voucherRows.get(i);
                        voucherData.setAccountName(periodBeginData.getAccountName());
                        voucherData.setAccountNumber(periodBeginData.getAccountNumber());
                        if (i == 0) {
                            Optional<SubsidiaryRow> tmpLastVoucherDataRowOp = this.getTmpDataRow(subsidiaryPeriod, subsidiaryKey, "lastVoucherData");
                            SubsidiaryRow lastVoucherDataRow = tmpLastVoucherDataRowOp.isPresent() ? tmpLastVoucherDataRowOp.get() : lastYearData;
                            preVoucherData = null != lastVoucherDataRow ? lastVoucherDataRow : periodBeginData;
                        } else {
                            preVoucherData = (SubsidiaryRow)voucherRows.get(i - 1);
                        }
                        BigDecimal endDc = new BigDecimal(preVoucherData.getEndDC());
                        voucherData.setEndLocal(voucherData.getDebitLocal().subtract(voucherData.getCreditLocal()).add(preVoucherData.getEndLocal().multiply(endDc)));
                        voucherData.setEndFor(voucherData.getDebitFor().subtract(voucherData.getCreditFor()).add(preVoucherData.getEndFor().multiply(endDc)));
                        voucherData.setEndQty(voucherData.getDebitQty().subtract(voucherData.getCreditQty()).add(preVoucherData.getEndQty().multiply(endDc)));
                        this.showByAccountDc(voucherData, filterInfo);
                        creditforSum = creditforSum.add(voucherData.getCreditFor());
                        creditlocalSum = creditlocalSum.add(voucherData.getCreditLocal());
                        creditqtySum = creditqtySum.add(voucherData.getCreditQty());
                        debitforSum = debitforSum.add(voucherData.getDebitFor());
                        debitlocalSum = debitlocalSum.add(voucherData.getDebitLocal());
                        debitqtySum = debitqtySum.add(voucherData.getDebitQty());
                    }
                }
                if (periodBeginData.getPeriodId().equals(subsidiaryPeriod.getPeriod()) && !this.lastTmpGroupData.containsRow((Object)subsidiaryKey)) {
                    voucherRows.add(0, periodBeginData);
                }
                SubsidiaryRow periodDataRow = (SubsidiaryRow)periodBeginData.clone();
                periodDataRow.setRowtype("3");
                periodDataRow.setPeriodYear(subsidiaryPeriod.getPeriodyear());
                periodDataRow.setPeriodId(subsidiaryPeriod.getPeriod());
                periodDataRow.setBookedDate(subsidiaryPeriod.getEnddate());
                periodDataRow.setVoucherDesc(ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"ReportRowType_2", (String)"fi-gl-common", (Object[])new Object[0]));
                periodDataRow.setCreditFor(creditforSum);
                periodDataRow.setCreditLocal(creditlocalSum);
                periodDataRow.setCreditQty(creditqtySum);
                periodDataRow.setDebitFor(debitforSum);
                periodDataRow.setDebitLocal(debitlocalSum);
                periodDataRow.setDebitQty(debitqtySum);
                periodDataRow.setEndDC(lastVoucherData.getEndDC());
                periodDataRow.setEndLocal(lastVoucherData.getEndLocal());
                periodDataRow.setEndFor(lastVoucherData.getEndFor());
                periodDataRow.setEndQty(lastVoucherData.getEndQty());
                SubsidiaryRow yearDataRow = (SubsidiaryRow)periodDataRow.clone();
                yearDataRow.setRowtype("4");
                yearDataRow.setVoucherDesc(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"ReportRowType_3", (String)"fi-gl-common", (Object[])new Object[0]));
                boolean isCrossYear = false;
                if (null != lastYearData && !Objects.equals(lastYearData.getPeriodYear(), periodDataRow.getPeriodYear())) {
                    isCrossYear = true;
                    lastYearData = null;
                }
                SubsidiaryRow tmpYearDataRow = (tmpYearDataRowOp = this.getTmpDataRow(subsidiaryPeriod, subsidiaryKey, "yearData")).isPresent() ? tmpYearDataRowOp.get() : lastYearData;
                BigDecimal lastYearCreditfor = BigDecimal.ZERO;
                BigDecimal lastYearCreditlocal = BigDecimal.ZERO;
                BigDecimal lastYearCreditqty = BigDecimal.ZERO;
                BigDecimal lastYearDebitfor = BigDecimal.ZERO;
                BigDecimal lastYearDebitlocal = BigDecimal.ZERO;
                BigDecimal lastYearDebitqty = BigDecimal.ZERO;
                if (isCrossYear) {
                    if (null != tmpYearDataRow) {
                        lastYearCreditfor = tmpYearDataRow.getCreditFor();
                        lastYearCreditlocal = tmpYearDataRow.getCreditLocal();
                        lastYearCreditqty = tmpYearDataRow.getCreditQty();
                        lastYearDebitfor = tmpYearDataRow.getDebitFor();
                        lastYearDebitlocal = tmpYearDataRow.getDebitLocal();
                        lastYearDebitqty = tmpYearDataRow.getDebitQty();
                    }
                } else {
                    lastYearCreditfor = null != tmpYearDataRow ? tmpYearDataRow.getCreditFor() : periodBeginData.getYearCreditFor();
                    lastYearCreditlocal = null != tmpYearDataRow ? tmpYearDataRow.getCreditLocal() : periodBeginData.getYearCreditLocal();
                    lastYearCreditqty = null != tmpYearDataRow ? tmpYearDataRow.getCreditQty() : periodBeginData.getYearCreditQty();
                    lastYearDebitfor = null != tmpYearDataRow ? tmpYearDataRow.getDebitFor() : periodBeginData.getYearDebitFor();
                    lastYearDebitlocal = null != tmpYearDataRow ? tmpYearDataRow.getDebitLocal() : periodBeginData.getYearDebitLocal();
                    lastYearDebitqty = null != tmpYearDataRow ? tmpYearDataRow.getDebitQty() : periodBeginData.getYearDebitQty();
                }
                yearDataRow.setEndDC(lastVoucherData.getEndDC());
                yearDataRow.setEndLocal(lastVoucherData.getEndLocal());
                yearDataRow.setEndFor(lastVoucherData.getEndFor());
                yearDataRow.setEndQty(lastVoucherData.getEndQty());
                lastYearData = yearDataRow;
                if (k == groupCount - 1 && Objects.equals(this.getLastItemOfPreBatch(), lastVoucherData) && !this.isLastBatchFlag()) {
                    this.lastTmpGroupData.clear();
                    this.lastTmpGroupData.put((Object)subsidiaryKey, (Object)"lastVoucherData", (Object)lastVoucherData);
                    this.lastTmpGroupData.put((Object)subsidiaryKey, (Object)"periodData", (Object)periodDataRow);
                    if (isCrossYear) {
                        this.lastTmpGroupData.put((Object)subsidiaryKey, (Object)"crossYear", (Object)new SubsidiaryRow());
                    }
                    yearDataRow.setCreditFor(lastYearCreditfor);
                    yearDataRow.setCreditLocal(lastYearCreditlocal);
                    yearDataRow.setCreditQty(lastYearCreditqty);
                    yearDataRow.setDebitFor(lastYearDebitfor);
                    yearDataRow.setDebitLocal(lastYearDebitlocal);
                    yearDataRow.setDebitQty(lastYearDebitqty);
                    this.lastTmpGroupData.put((Object)subsidiaryKey, (Object)"yearData", (Object)yearDataRow);
                    continue block0;
                }
                BalanceRowTransformer.dealPrice(filterInfo, periodDataRow);
                voucherRows.add(periodDataRow);
                this.sumPeriodTotalDataRow(periodDataRow);
                if (!Objects.equals(yearDataRow.getPeriodId(), periodBeginData.getPeriodId())) {
                    yearDataRow.setCreditFor(periodDataRow.getCreditFor().add(lastYearCreditfor));
                    yearDataRow.setCreditLocal(periodDataRow.getCreditLocal().add(lastYearCreditlocal));
                    yearDataRow.setCreditQty(periodDataRow.getCreditQty().add(lastYearCreditqty));
                    yearDataRow.setDebitFor(periodDataRow.getDebitFor().add(lastYearDebitfor));
                    yearDataRow.setDebitLocal(periodDataRow.getDebitLocal().add(lastYearDebitlocal));
                    yearDataRow.setDebitQty(periodDataRow.getDebitQty().add(lastYearDebitqty));
                } else {
                    yearDataRow.setCreditFor(lastYearCreditfor);
                    yearDataRow.setCreditLocal(lastYearCreditlocal);
                    yearDataRow.setCreditQty(lastYearCreditqty);
                    yearDataRow.setDebitFor(lastYearDebitfor);
                    yearDataRow.setDebitLocal(lastYearDebitlocal);
                    yearDataRow.setDebitQty(lastYearDebitqty);
                }
                BalanceRowTransformer.dealPrice(filterInfo, yearDataRow);
                voucherRows.add(yearDataRow);
            }
        }
        List<Row> batchResultList = this.afterProcess(periodMap, preGroupList, (Table<String, Long, List<SubsidiaryRow>>)subsidiaryTable);
        return batchResultList;
    }

    private static void dealPrice(FilterInfo filterInfo, SubsidiaryRow subsidiaryRow) {
        if (filterInfo.getBoolean("showqty")) {
            if (subsidiaryRow.getEndQty().compareTo(BigDecimal.ZERO) != 0) {
                subsidiaryRow.setEndPrice(subsidiaryRow.getEndFor().divide(subsidiaryRow.getEndQty(), 10, RoundingMode.HALF_UP).abs());
            }
            if (subsidiaryRow.getDebitQty().compareTo(BigDecimal.ZERO) != 0) {
                subsidiaryRow.setDebitPrice(subsidiaryRow.getDebitFor().divide(subsidiaryRow.getDebitQty(), 10, RoundingMode.HALF_UP).abs());
            }
            if (subsidiaryRow.getCreditQty().compareTo(BigDecimal.ZERO) != 0) {
                subsidiaryRow.setCreditPrice(subsidiaryRow.getCreditFor().divide(subsidiaryRow.getCreditQty(), 10, RoundingMode.HALF_UP).abs());
            }
        }
    }

    private List<Row> afterProcess(Map<Long, SubsidiaryPeriod> periodMap, List<SubsidiaryRow> preGroupList, Table<String, Long, List<SubsidiaryRow>> subsidiaryTable) {
        LinkedList<SubsidiaryRow> resultList = new LinkedList<SubsidiaryRow>();
        if (!CollectionUtils.isEmpty(preGroupList)) {
            resultList.addAll(preGroupList);
        }
        subsidiaryTable.values().stream().forEach(x -> resultList.addAll((Collection<SubsidiaryRow>)x));
        if (this.isLastBatchFlag()) {
            this.periodBeginMap.remove(this.lastSubsidiaryKey);
            if (!CollectionUtils.isEmpty(periodMap)) {
                resultList.addAll(this.processOnlyPeriodBeginData());
            }
            if (this.getOwnedChain().isFinalDataSetFlag() && this.periodTotalDataRow != null) {
                BigDecimal debitLocal = this.periodTotalDataRow.getDebitLocal();
                BigDecimal creditLocal = this.periodTotalDataRow.getCreditLocal();
                BigDecimal endLocal = this.periodTotalDataRow.getEndLocal();
                endLocal = debitLocal.subtract(creditLocal).add(endLocal);
                this.periodTotalDataRow.setEndDC(endLocal.compareTo(BigDecimal.ZERO));
                this.periodTotalDataRow.setEndLocal(endLocal.abs());
                resultList.add(this.periodTotalDataRow);
            }
            this.lastTmpGroupData.clear();
            this.lastSubsidiaryKey = null;
        }
        return this.convertTo(resultList);
    }

    private List<SubsidiaryRow> processOnlyPeriodBeginData() {
        LinkedList<SubsidiaryRow> resultList = new LinkedList<SubsidiaryRow>();
        Map periodMap = (Map)this.getOwnedChain().getContext().query("periodMap");
        FilterInfo filterInfo = (FilterInfo)this.getOwnedChain().getContext().query("filterInfo");
        HashBasedTable subsidiaryTable = HashBasedTable.create();
        this.periodBeginMap.forEach((arg_0, arg_1) -> BalanceRowTransformer.lambda$processOnlyPeriodBeginData$2((Table)subsidiaryTable, arg_0, arg_1));
        ArrayList keyList = new ArrayList(subsidiaryTable.rowKeySet());
        int groupCount = keyList.size();
        for (int k = 0; k < groupCount; ++k) {
            String subsidiaryKey = (String)keyList.get(k);
            SubsidiaryRow periodBeginData = this.periodBeginMap.get(subsidiaryKey);
            Map periodVoucherMap = subsidiaryTable.row((Object)subsidiaryKey);
            for (SubsidiaryPeriod subsidiaryPeriod : periodMap.values()) {
                ArrayList<SubsidiaryRow> voucherRows = (ArrayList<SubsidiaryRow>)periodVoucherMap.get(subsidiaryPeriod.getPeriod());
                if (filterInfo.getBoolean("nozeroperiod")) continue;
                if (CollectionUtils.isEmpty((Collection)voucherRows)) {
                    voucherRows = new ArrayList<SubsidiaryRow>(2);
                    subsidiaryTable.put((Object)subsidiaryKey, (Object)subsidiaryPeriod.getPeriod(), voucherRows);
                }
                SubsidiaryRow periodDataRow = (SubsidiaryRow)periodBeginData.clone();
                periodDataRow.setRowtype("3");
                periodDataRow.setPeriodYear(subsidiaryPeriod.getPeriodyear());
                periodDataRow.setPeriodId(subsidiaryPeriod.getPeriod());
                periodDataRow.setBookedDate(subsidiaryPeriod.getEnddate());
                periodDataRow.setVoucherDesc(ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"ReportRowType_2", (String)"fi-gl-common", (Object[])new Object[0]));
                BalanceRowTransformer.dealPrice(filterInfo, periodDataRow);
                voucherRows.add(periodDataRow);
                SubsidiaryRow yearDataRow = (SubsidiaryRow)periodDataRow.clone();
                yearDataRow.setRowtype("4");
                yearDataRow.setVoucherDesc(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"ReportRowType_3", (String)"fi-gl-common", (Object[])new Object[0]));
                if (Objects.equals(periodBeginData.getPeriodYear(), yearDataRow.getPeriodYear())) {
                    yearDataRow.setCreditFor(periodBeginData.getYearCreditFor());
                    yearDataRow.setCreditLocal(periodBeginData.getYearCreditLocal());
                    yearDataRow.setCreditQty(periodBeginData.getYearCreditQty());
                    yearDataRow.setDebitFor(periodBeginData.getYearDebitFor());
                    yearDataRow.setDebitLocal(periodBeginData.getYearDebitLocal());
                    yearDataRow.setDebitQty(periodBeginData.getYearDebitQty());
                } else {
                    yearDataRow.setCreditFor(BigDecimal.ZERO);
                    yearDataRow.setCreditLocal(BigDecimal.ZERO);
                    yearDataRow.setCreditQty(BigDecimal.ZERO);
                    yearDataRow.setDebitFor(BigDecimal.ZERO);
                    yearDataRow.setDebitLocal(BigDecimal.ZERO);
                    yearDataRow.setDebitQty(BigDecimal.ZERO);
                }
                BalanceRowTransformer.dealPrice(filterInfo, yearDataRow);
                voucherRows.add(yearDataRow);
            }
        }
        subsidiaryTable.values().stream().forEach(x -> resultList.addAll((Collection<SubsidiaryRow>)x));
        this.periodBeginMap.clear();
        return resultList;
    }

    private List<SubsidiaryRow> getPreGroupList(List<SubsidiaryRow> batchEntries, FilterInfo filterInfo, Map<Long, SubsidiaryPeriod> periodMap) {
        LinkedList<SubsidiaryRow> preGroupList = new LinkedList<SubsidiaryRow>();
        String firstKey = this.buildSubsidiaryKey(batchEntries.get(0));
        if (this.lastTmpGroupData.isEmpty() || this.lastTmpGroupData.containsRow((Object)firstKey)) {
            return preGroupList;
        }
        String subsidiaryKey = (String)this.lastTmpGroupData.rowKeySet().iterator().next();
        SubsidiaryRow periodDataRow = (SubsidiaryRow)this.lastTmpGroupData.get((Object)subsidiaryKey, (Object)"periodData");
        if (filterInfo.getBoolean("nozeroperiod") && periodDataRow.getCreditLocal().compareTo(BigDecimal.ZERO) == 0 && periodDataRow.getDebitLocal().compareTo(BigDecimal.ZERO) == 0) {
            return preGroupList;
        }
        SubsidiaryRow yearDataRow = (SubsidiaryRow)this.lastTmpGroupData.get((Object)subsidiaryKey, (Object)"yearData");
        SubsidiaryRow crossYearDataRow = (SubsidiaryRow)yearDataRow.clone();
        for (SubsidiaryPeriod subsidiaryPeriod : periodMap.values()) {
            if (Objects.equals(subsidiaryPeriod.getPeriod(), periodDataRow.getPeriodId())) {
                preGroupList.add(periodDataRow);
                this.sumPeriodTotalDataRow(periodDataRow);
                if (this.lastTmpGroupData.containsColumn((Object)"crossYear")) {
                    crossYearDataRow.setCreditFor(periodDataRow.getCreditFor());
                    crossYearDataRow.setCreditLocal(periodDataRow.getCreditLocal());
                    crossYearDataRow.setCreditQty(periodDataRow.getCreditQty());
                    crossYearDataRow.setDebitFor(periodDataRow.getDebitFor());
                    crossYearDataRow.setDebitLocal(periodDataRow.getDebitLocal());
                    crossYearDataRow.setDebitQty(periodDataRow.getDebitQty());
                    preGroupList.add(crossYearDataRow);
                } else {
                    if (!Objects.equals(subsidiaryPeriod.getPeriod(), filterInfo.getLong("startperiod"))) {
                        yearDataRow.setCreditFor(periodDataRow.getCreditFor().add(yearDataRow.getCreditFor()));
                        yearDataRow.setCreditLocal(periodDataRow.getCreditLocal().add(yearDataRow.getCreditLocal()));
                        yearDataRow.setCreditQty(periodDataRow.getCreditQty().add(yearDataRow.getCreditQty()));
                        yearDataRow.setDebitFor(periodDataRow.getDebitFor().add(yearDataRow.getDebitFor()));
                        yearDataRow.setDebitLocal(periodDataRow.getDebitLocal().add(yearDataRow.getDebitLocal()));
                        yearDataRow.setDebitQty(periodDataRow.getDebitQty().add(yearDataRow.getDebitQty()));
                    }
                    preGroupList.add(yearDataRow);
                }
            }
            if (subsidiaryPeriod.getPeriod() <= periodDataRow.getPeriodId()) continue;
            SubsidiaryRow nextPeriodDataRow = (SubsidiaryRow)periodDataRow.clone();
            nextPeriodDataRow.setPeriodYear(subsidiaryPeriod.getPeriodyear());
            nextPeriodDataRow.setPeriodId(subsidiaryPeriod.getPeriod());
            nextPeriodDataRow.setBookedDate(subsidiaryPeriod.getEnddate());
            nextPeriodDataRow.setCreditFor(BigDecimal.ZERO);
            nextPeriodDataRow.setCreditLocal(BigDecimal.ZERO);
            nextPeriodDataRow.setCreditQty(BigDecimal.ZERO);
            nextPeriodDataRow.setDebitFor(BigDecimal.ZERO);
            nextPeriodDataRow.setDebitLocal(BigDecimal.ZERO);
            nextPeriodDataRow.setDebitQty(BigDecimal.ZERO);
            SubsidiaryRow nextPeriodYearRow = null;
            nextPeriodYearRow = this.lastTmpGroupData.containsColumn((Object)"crossYear") ? (SubsidiaryRow)crossYearDataRow.clone() : (SubsidiaryRow)yearDataRow.clone();
            nextPeriodYearRow.setPeriodYear(subsidiaryPeriod.getPeriodyear());
            nextPeriodYearRow.setPeriodId(subsidiaryPeriod.getPeriod());
            nextPeriodYearRow.setBookedDate(subsidiaryPeriod.getEnddate());
            preGroupList.add(nextPeriodDataRow);
            preGroupList.add(nextPeriodYearRow);
        }
        this.lastTmpGroupData.clear();
        return preGroupList;
    }

    private Optional<SubsidiaryRow> getTmpDataRow(SubsidiaryPeriod subsidiaryPeriod, String subsidiaryKey, String tmpKey) {
        if (this.lastTmpGroupData.containsRow((Object)subsidiaryKey)) {
            SubsidiaryRow tmpDataRow = (SubsidiaryRow)this.lastTmpGroupData.get((Object)subsidiaryKey, (Object)tmpKey);
            if (Objects.equals(subsidiaryPeriod.getPeriod(), tmpDataRow.getPeriodId())) {
                return Optional.of(tmpDataRow);
            }
        }
        return Optional.empty();
    }

    private void sumPeriodTotalDataRow(SubsidiaryRow periodData) {
        this.periodTotalDataRow.setDebitLocal(this.periodTotalDataRow.getDebitLocal().add(periodData.getDebitLocal()));
        this.periodTotalDataRow.setCreditLocal(this.periodTotalDataRow.getCreditLocal().add(periodData.getCreditLocal()));
    }

    private List<Row> convertTo(List<SubsidiaryRow> resultList) {
        LinkedList<Row> rowList = new LinkedList<Row>();
        RowMeta rowMeta = (RowMeta)this.getOwnedChain().getContextProp("rowMeta");
        List flexFieldNames = (List)this.getOwnedChain().getContextProp("flexFieldNames");
        List cusVoucherFields = (List)this.getOwnedChain().getContextProp("cusVoucherFields");
        List<String> cusVoucherFieldNames = cusVoucherFields.stream().map(x -> x.getField()).collect(Collectors.toList());
        Map<Long, DynamicObject> voucherInfoMap = ReportUtils.getVoucherInfoMap(cusVoucherFields, resultList);
        SubsidiaryColIndex subsidiaryColIndex = SubsidiaryColIndex.of(rowMeta, flexFieldNames, cusVoucherFieldNames);
        ArrayList detailDataList = new ArrayList(8);
        ArrayList totalDataList = new ArrayList(8);
        resultList.forEach(x -> {
            Object[] data = new Object[rowMeta.getFieldCount()];
            data[subsidiaryColIndex.getAccountId()] = x.getAccountId();
            data[subsidiaryColIndex.getAccountName()] = x.getAccountName();
            data[subsidiaryColIndex.getAccountNumber()] = x.getAccountNumber();
            data[subsidiaryColIndex.getAccountDc()] = x.getAccountDc();
            data[subsidiaryColIndex.getOrgName()] = x.getOrgName();
            data[subsidiaryColIndex.getOrgId()] = x.getOrgId();
            data[subsidiaryColIndex.getBizDate()] = x.getBizDate();
            data[subsidiaryColIndex.getDateField()] = x.getBookedDate();
            data[subsidiaryColIndex.getVoucherDesc()] = x.getVoucherDesc();
            data[subsidiaryColIndex.getVoucherId()] = x.getVoucherId();
            Long voucherentryId = x.getVoucherEntryId();
            data[subsidiaryColIndex.getFentryId()] = voucherentryId;
            if (Objects.equals(x.getRowtype(), "2") && !CollectionUtils.isEmpty((Map)voucherInfoMap)) {
                Map<String, Integer> cusVoucherFieldIndexes = subsidiaryColIndex.getCusVoucherFieldIndexes();
                DynamicObject voucherDyn = (DynamicObject)voucherInfoMap.get(voucherentryId);
                for (ReportFieldSettingVo cusVoucherField : cusVoucherFields) {
                    data[cusVoucherFieldIndexes.get((Object)cusVoucherField.getField()).intValue()] = voucherDyn.get(cusVoucherField.getFieldMark());
                }
            }
            data[subsidiaryColIndex.getVoucherNumber()] = x.getVoucherNum();
            if (!Objects.equals(x.getRowtype(), "1")) {
                data[subsidiaryColIndex.getPeriod()] = x.getPeriodId();
            }
            data[subsidiaryColIndex.getLocalRate()] = x.getLocalRate();
            data[subsidiaryColIndex.getMeasureUnit()] = x.getMeasureUnitId();
            data[subsidiaryColIndex.getCurrencyColumn()] = x.getCurrencyId();
            data[subsidiaryColIndex.getBaseCurrency()] = x.getBaseCurrency();
            data[subsidiaryColIndex.getDc()] = x.getEndDC();
            data[subsidiaryColIndex.getEndFor()] = x.getEndFor();
            data[subsidiaryColIndex.getEndLocal()] = x.getEndLocal();
            data[subsidiaryColIndex.getEndQty()] = x.getEndQty();
            data[subsidiaryColIndex.getEndPrice()] = x.getEndPrice();
            data[subsidiaryColIndex.getCreditFor()] = x.getCreditFor();
            data[subsidiaryColIndex.getCreditLocal()] = x.getCreditLocal();
            data[subsidiaryColIndex.getCreditQty()] = x.getCreditQty();
            data[subsidiaryColIndex.getCreditPrice()] = x.getCreditPrice();
            data[subsidiaryColIndex.getDebitFor()] = x.getDebitFor();
            data[subsidiaryColIndex.getDebitLocal()] = x.getDebitLocal();
            data[subsidiaryColIndex.getDebitQty()] = x.getDebitQty();
            data[subsidiaryColIndex.getDebitPrice()] = x.getDebitPrice();
            if (Objects.equals(x.getRowtype(), "5")) {
                totalDataList.add(data);
            } else {
                List<Integer> flexIndexes = subsidiaryColIndex.getFlexIndexes();
                for (int i = 0; i < flexIndexes.size(); ++i) {
                    data[flexIndexes.get((int)i).intValue()] = x.getFlexTuple()[i].item2;
                }
                detailDataList.add(data);
            }
        });
        DataSet detailDataSet = Algo.create((String)"BalanceRowTransformer.rebuildDetailDataSet").createDataSet(detailDataList.iterator(), rowMeta);
        while (detailDataSet.hasNext()) {
            rowList.add(detailDataSet.next());
        }
        if (!CollectionUtils.isEmpty(totalDataList)) {
            DataSet totalDataSet = Algo.create((String)"BalanceRowTransformer.rebuildTotalDataSet").createDataSet(totalDataList.iterator(), rowMeta);
            rowList.add(totalDataSet.next());
        }
        return rowList;
    }

    private void showByAccountDc(SubsidiaryRow row, FilterInfo filterInfo) {
        Map orgAccountdcMap = (Map)this.getOwnedChain().getContext().query("orgAccountdcMap");
        Boolean isShowByAccountDC = (Boolean)orgAccountdcMap.get(row.getOrgId());
        BigDecimal endlocal = row.getEndLocal();
        if (endlocal == null || GLUtil.isZero(endlocal)) {
            row.setEndDC(0);
        } else {
            int accountDc = row.getAccountDc();
            BigDecimal dcVal = new BigDecimal(accountDc);
            BigDecimal endForVal = row.getEndFor().multiply(dcVal);
            BigDecimal endLocalVal = row.getEndLocal().multiply(dcVal);
            BigDecimal endQtyVal = row.getEndQty().multiply(dcVal);
            boolean isBaseCurrency = SubsiDiaryHelper.isBaseCurrencyByQuery(filterInfo);
            if (!isShowByAccountDC.booleanValue() && (!isBaseCurrency && endForVal.compareTo(BigDecimal.ZERO) < 0 || isBaseCurrency && endLocalVal.compareTo(BigDecimal.ZERO) < 0)) {
                dcVal = dcVal.multiply(new BigDecimal("-1"));
                endForVal = endForVal.negate();
                endLocalVal = endLocalVal.negate();
                endQtyVal = endQtyVal.negate();
            }
            row.setEndDC(dcVal.intValue());
            row.setEndQty(endQtyVal);
            row.setEndLocal(endLocalVal);
            row.setEndFor(endForVal);
            if (filterInfo.getBoolean("showqty") && row.getEndQty().compareTo(BigDecimal.ZERO) != 0) {
                row.setEndPrice(row.getEndFor().divide(row.getEndQty(), 10, RoundingMode.HALF_UP).abs());
            }
        }
    }

    @Override
    public void fireFinished() throws Exception {
        super.fireFinished();
        this.periodBeginMap.clear();
    }

    private String buildSubsidiaryKey(SubsidiaryRow row) {
        String orgname = row.getOrgName();
        Long accountid = row.getAccountId();
        Long accountmasterid = row.getAccountMasterId();
        Integer accountdc = row.getAccountDc();
        Long currencycolumn = row.getCurrencyId();
        Long measureunit = row.getMeasureUnitId();
        int flexFieldCount = row.getFlexTuple().length;
        Object[] orderKeyArr = new Object[flexFieldCount + 5];
        for (int i = 0; i < flexFieldCount; ++i) {
            orderKeyArr[i] = Objects.isNull(row.getFlexTuple()[i].item2) ? Integer.valueOf(0) : row.getFlexTuple()[i].item2;
        }
        orderKeyArr[flexFieldCount] = orgname;
        orderKeyArr[flexFieldCount + 1] = Objects.isNull(accountmasterid) ? accountid : accountmasterid;
        orderKeyArr[flexFieldCount + 2] = accountdc;
        orderKeyArr[flexFieldCount + 3] = currencycolumn;
        orderKeyArr[flexFieldCount + 4] = measureunit;
        return Joiner.on((String)"_").join(orderKeyArr);
    }

    private static /* synthetic */ void lambda$processOnlyPeriodBeginData$2(Table subsidiaryTable, String k, SubsidiaryRow v) {
        LinkedList<SubsidiaryRow> rows = new LinkedList<SubsidiaryRow>();
        rows.add(v);
        subsidiaryTable.put((Object)k, (Object)v.getPeriodId(), rows);
    }

    private /* synthetic */ void lambda$process$0(Table subsidiaryTable, Map periodMap, Map orgBookStartPeriodMap, SubsidiaryRow row) {
        List rows;
        String subsidiaryKey = this.buildSubsidiaryKey(row);
        Long period = row.getPeriodId();
        if (!subsidiaryTable.containsRow((Object)subsidiaryKey)) {
            for (SubsidiaryPeriod subsidiaryPeriod : periodMap.values()) {
                if (subsidiaryPeriod.getPeriod() < (Long)orgBookStartPeriodMap.get(row.getOrgId())) continue;
                subsidiaryTable.put((Object)subsidiaryKey, (Object)subsidiaryPeriod.getPeriod(), new LinkedList());
            }
        }
        if (null != (rows = (List)subsidiaryTable.get((Object)subsidiaryKey, (Object)period))) {
            rows.add(row);
        }
    }
}

