/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.DateFormatObject;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.format.TimeFormatObject;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.MulBasedataReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.KDBizException;
import kd.bos.export.IExporter;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportPropUtil;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.product.ProductSettingService;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportOperationColumn;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.userconfig.GridConfigDAO;
import kd.bos.util.FileNameUtils;
import kd.fi.bd.util.POIUtils;
import kd.fi.bd.util.TimerFactory;
import kd.fi.gl.report.export.RecyclableRowStorage;
import kd.fi.gl.report.export.ReportRowSet;
import kd.fi.gl.report.export.processor.AbstractBatchTransformer;
import kd.fi.gl.util.SubsiDiaryHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.util.DefaultTempFileCreationStrategy;
import org.apache.poi.util.TempFile;
import org.apache.poi.util.TempFileCreationStrategy;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ReportExcelTransformer
extends AbstractBatchTransformer<Row, Void> {
    private static final Log logger = LogFactory.getLog(ReportExcelTransformer.class);
    private static final String EXPORTER_INSTANCE = "kd.bos.mvc.export.GridExcelExporter";
    private ReportList reportList;
    private AbstractReportListModel reportModel;
    private IReportView reportView;
    private Map<String, String> mergeMap = new HashMap<String, String>();
    private String ctrlKey = "reportlistap";
    private List<AbstractReportColumn> exportColumns = new ArrayList<AbstractReportColumn>(10);
    private List<ReportColumn> allCols;
    private List<ReportColumn> visibleCols;
    private IExporter<AbstractReportColumn> exporter;
    private SXSSFWorkbook curWorkbook;
    private int cntWroteRowCurSheet;
    private int curSheetIndex = 0;
    private int loopTimes = 0;
    private int index = 0;
    private String fileName;
    private String zipFileName;
    ZipOutputStream zipOut;
    private List<String> urls = new LinkedList<String>();
    private Map<String, Boolean> configMap = new HashMap<String, Boolean>(8);
    Map<String, Object> progressCusData = new HashMap<String, Object>(8);
    private final String entityID;
    private FilterInfo filterInfo;

    public Map<String, String> getMergeMap() {
        return this.mergeMap;
    }

    public ReportExcelTransformer(ReportList reportList, int batchSize) {
        this(reportList, batchSize, null);
    }

    public ReportExcelTransformer(ReportList reportList, int batchSize, FilterInfo filterInfo) {
        super(batchSize);
        this.reportList = reportList;
        this.reportView = (IReportView)reportList.getView();
        this.entityID = this.reportView.getEntityId();
        this.filterInfo = filterInfo;
        this.initModel();
    }

    @Override
    public void reset() {
        this.initExporter(false);
    }

    private void initModel() {
        this.reportModel = (AbstractReportListModel)this.reportList.getReportModel();
        List<AbstractReportColumn> columns = this.getColumnList((IReportListModel)this.reportModel);
        this.allCols = this.getReportColumnList(columns, false);
        this.visibleCols = this.getReportColumnList(columns, true);
        this.getExportColumn(columns);
        IDataModel model = this.reportView.getModel();
        if (model != null) {
            MainEntityType itemType = model.getDataEntityType();
            this.reportModel.setEntityType(itemType);
        }
        if ("gl_rpt_subledger".equals(this.entityID)) {
            this.reportList.getFlexColumnSplitService().splitFlextColumn(this.exportColumns);
        }
    }

    private void getExportColumn(List<AbstractReportColumn> columns) {
        FormatObject format = this.getFormat();
        ArrayList<AbstractReportColumn> originColumns = new ArrayList<AbstractReportColumn>();
        HashMap<String, AbstractReportColumn> originColumnMap = new HashMap<String, AbstractReportColumn>();
        List<GridConfigurationRow> configRows = this.getUserGridConfigRows();
        if (CollectionUtils.isEmpty(configRows)) {
            Map<String, String> initFieldMap = new HashMap();
            List initFieldList = this.reportList.getInitField();
            if (!CollectionUtils.isEmpty((Collection)initFieldList)) {
                initFieldMap = this.initFieldListToMap(initFieldList);
            }
            if (!CollectionUtils.isEmpty((Map)initFieldMap)) {
                this.removeByInitField(columns, initFieldMap);
            }
        }
        for (AbstractReportColumn abstractReportColumn : columns) {
            if (abstractReportColumn instanceof ReportOperationColumn) continue;
            String fieldKey = null;
            if (abstractReportColumn instanceof ReportColumnGroup) {
                fieldKey = ((ReportColumnGroup)abstractReportColumn).getFieldKey();
                List childrens = ((ReportColumnGroup)abstractReportColumn).getChildren();
                for (AbstractReportColumn child : childrens) {
                    if (child instanceof ReportOperationColumn) continue;
                    if (child instanceof ReportColumnGroup) {
                        this.recurGroupColumnUserFormat((ReportColumnGroup)child, format);
                        continue;
                    }
                    child.setUserFormat(format);
                }
            } else {
                if (abstractReportColumn instanceof ReportColumn) {
                    fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey();
                }
                abstractReportColumn.setUserFormat(format);
            }
            if (!StringUtils.isBlank((CharSequence)fieldKey)) {
                originColumnMap.put(fieldKey, abstractReportColumn);
            }
            if (!StringUtils.isBlank((CharSequence)fieldKey) && fieldKey.toLowerCase().equals("fseq")) continue;
            originColumns.add(abstractReportColumn);
        }
        HashMap<String, AbstractReportColumn> allColumnMap = new HashMap<String, AbstractReportColumn>();
        HashMap<String, AbstractReportColumn> parentColumnMap = new HashMap<String, AbstractReportColumn>();
        this.allColumnMap(originColumnMap, allColumnMap, parentColumnMap);
        if (configRows != null && !configRows.isEmpty()) {
            for (GridConfigurationRow row : configRows) {
                this.configMap.put(row.getFieldKey(), row.isHide());
                if (!row.isHide() && !CollectionUtils.isEmpty((Collection)row.getChildren())) {
                    ReportColumnGroup reportColumnGroup;
                    AbstractReportColumn abstractReportColumn = (AbstractReportColumn)originColumnMap.get(row.getFieldKey());
                    if (abstractReportColumn instanceof ReportColumnGroup && CollectionUtils.isEmpty((Collection)(reportColumnGroup = (ReportColumnGroup)abstractReportColumn).getChildren())) continue;
                    List rowChildrenList = row.getChildren();
                    Iterator iterator = rowChildrenList.iterator();
                    int index = 0;
                    while (iterator.hasNext()) {
                        GridConfigurationRow gridConfigurationRow = (GridConfigurationRow)iterator.next();
                        if (gridConfigurationRow.getChildren().size() == 0 && gridConfigurationRow.isHide()) {
                            abstractReportColumn = (AbstractReportColumn)originColumnMap.get(row.getFieldKey());
                            if (abstractReportColumn instanceof ReportColumnGroup) {
                                ReportColumnGroup reportColumnGroup2 = (ReportColumnGroup)abstractReportColumn;
                                reportColumnGroup2.getChildren().remove(index);
                                continue;
                            }
                        } else if (gridConfigurationRow.getChildren().size() > 0) {
                            this.dealMulGroup(gridConfigurationRow, allColumnMap, parentColumnMap);
                        }
                        ++index;
                    }
                }
                AbstractReportColumn column = null;
                for (Map.Entry columnEntry : originColumnMap.entrySet()) {
                    Object fieldKey = this.getMergeMap().get(columnEntry.getKey()) == null ? columnEntry.getKey() : this.getMergeMap().get(columnEntry.getKey());
                    if (!Objects.equals(fieldKey, row.getFieldKey())) continue;
                    column = (AbstractReportColumn)columnEntry.getValue();
                    break;
                }
                if (column == null) continue;
                this.exportColumns.add(column);
                originColumns.remove(column);
            }
        }
        this.exportColumns.addAll(originColumns);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)this.reportList.getView().getService(FormViewPluginProxy.class);
        if (pluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).fireResetColumns(this.exportColumns);
        }
    }

    private Map<String, String> initFieldListToMap(List<Map<String, String>> initFieldList) {
        HashMap<String, String> resMap = new HashMap<String, String>(initFieldList.size());
        for (Map<String, String> map : initFieldList) {
            resMap.put(map.get("fieldkey"), map.get("isvisible"));
        }
        return resMap;
    }

    private void removeByInitField(List<AbstractReportColumn> columns, Map<String, String> initFieldMap) {
        Iterator<AbstractReportColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String fieldKey;
            AbstractReportColumn column = iterator.next();
            if (column instanceof ReportColumnGroup) {
                this.removeByInitField(((ReportColumnGroup)column).getChildren(), initFieldMap);
                continue;
            }
            if (!(column instanceof ReportColumn) || !initFieldMap.containsKey(fieldKey = ((ReportColumn)column).getFieldKey()) || Boolean.parseBoolean(initFieldMap.get(fieldKey))) continue;
            iterator.remove();
        }
    }

    private void dealMulGroup(GridConfigurationRow gridConfigurationRow, Map<String, AbstractReportColumn> originColumnMap, Map<String, AbstractReportColumn> parentColumnMap) {
        if (gridConfigurationRow.isHide() && gridConfigurationRow.getChildren().size() > 0) {
            this.removeGroupChild(parentColumnMap, originColumnMap.get(gridConfigurationRow.getFieldKey()), gridConfigurationRow);
            return;
        }
        for (GridConfigurationRow row : gridConfigurationRow.getChildren()) {
            AbstractReportColumn abstractReportColumn;
            if (row.getChildren().size() == 0 && row.isHide()) {
                abstractReportColumn = originColumnMap.get(row.getFieldKey());
                if (abstractReportColumn instanceof ReportColumnGroup) {
                    this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                    continue;
                }
                if (!(abstractReportColumn instanceof ReportColumn)) continue;
                this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                continue;
            }
            if (row.getChildren().size() <= 0) continue;
            if (row.isHide()) {
                abstractReportColumn = originColumnMap.get(gridConfigurationRow.getFieldKey());
                if (abstractReportColumn instanceof ReportColumnGroup) {
                    this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                } else if (abstractReportColumn instanceof ReportColumn) {
                    this.removeGroupChild(parentColumnMap, abstractReportColumn, row);
                }
            }
            this.dealMulGroup(row, originColumnMap, parentColumnMap);
        }
    }

    private void removeGroupChild(Map<String, AbstractReportColumn> parentColumnMap, AbstractReportColumn abstractReportColumn, GridConfigurationRow row) {
        String fieldKey = "";
        if (abstractReportColumn instanceof ReportColumn) {
            fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey();
        } else if (abstractReportColumn instanceof ReportColumnGroup) {
            fieldKey = row.getFieldKey();
        }
        ReportColumnGroup reportColumnGroup = (ReportColumnGroup)parentColumnMap.get(fieldKey);
        if (reportColumnGroup == null) {
            return;
        }
        List columnList = reportColumnGroup.getChildren();
        Iterator iterator1 = columnList.iterator();
        while (iterator1.hasNext()) {
            AbstractReportColumn abstractReportColumn1 = (AbstractReportColumn)iterator1.next();
            if (abstractReportColumn1 instanceof ReportColumn) {
                if (!((ReportColumn)abstractReportColumn1).getFieldKey().equals(row.getFieldKey())) continue;
                iterator1.remove();
                continue;
            }
            if (!(abstractReportColumn1 instanceof ReportColumnGroup) || !((ReportColumnGroup)abstractReportColumn1).getFieldKey().equals(row.getFieldKey())) continue;
            iterator1.remove();
        }
    }

    private void allColumnMap(Map<String, AbstractReportColumn> originColumnMap, Map<String, AbstractReportColumn> map, Map<String, AbstractReportColumn> parentColumnMap) {
        for (Map.Entry<String, AbstractReportColumn> entry : originColumnMap.entrySet()) {
            if (entry.getValue() instanceof ReportColumn) {
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof ReportColumnGroup)) continue;
            map.put(entry.getKey(), entry.getValue());
            HashMap<String, AbstractReportColumn> groupMap = new HashMap<String, AbstractReportColumn>();
            for (AbstractReportColumn column : ((ReportColumnGroup)entry.getValue()).getChildren()) {
                if (column instanceof ReportColumn) {
                    groupMap.put(((ReportColumn)column).getFieldKey(), column);
                    parentColumnMap.put(((ReportColumn)column).getFieldKey(), entry.getValue());
                    continue;
                }
                if (!(column instanceof ReportColumnGroup)) continue;
                groupMap.put(((ReportColumnGroup)column).getFieldKey(), column);
                parentColumnMap.put(((ReportColumnGroup)column).getFieldKey(), entry.getValue());
            }
            this.allColumnMap(groupMap, map, parentColumnMap);
        }
    }

    @Override
    protected List<Void> process(List<Row> batchRows) {
        FormViewPluginProxy pluginProxy;
        TimerFactory.Timer timer = (TimerFactory.Timer)this.getOwnedChain().getContext().query("timer");
        if (timer != null) {
            timer.time("begin transformer excel on single batch");
        }
        if (this.cntWroteRowCurSheet >= this.getExportOption().getSheetRowLimit()) {
            this.cntWroteRowCurSheet = 0;
            try {
                if (timer != null) {
                    timer.time("begin save split file");
                }
                String formName = this.reportView.getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
                String currDateTime = dateFormat.format(new Date());
                RequestContext ctx = RequestContext.getOrCreate();
                String userName = ctx.getUserName();
                String fileName = formName + "-" + currDateTime + "-" + userName + "_part" + ++this.index + ".xlsx";
                long tick = System.currentTimeMillis();
                String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)this.reportView.getServiceAppId(this.reportView.getPageId()), (String)UUID.randomUUID().toString(), (String)fileName);
                String downloadUrl = POIUtils.getAttachmentDownloadUrl((SXSSFWorkbook)this.curWorkbook, (String)fileName, (String)path);
                downloadUrl = downloadUrl + "&fId=" + this.reportView.getEntityId() + "&appId=" + this.reportView.getServiceAppId(this.reportView.getPageId());
                logger.info("subsidiary_multiorg export getAttachmentDownloadUrl.fileName:{} cost:{}ms", (Object)fileName, (Object)(System.currentTimeMillis() - tick));
                this.urls.add(downloadUrl);
                if (timer != null) {
                    timer.time("done save split file");
                }
            }
            catch (Exception e) {
                logger.error("failed to close workbook:" + e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            this.initExporter(true);
            this.loopTimes = 0;
        }
        this.cntWroteRowCurSheet += batchRows.size();
        this.exporter.setLoopTimes(this.loopTimes++);
        RowMeta rowMeta = (RowMeta)this.getOwnedChain().getContextProp("rowMeta");
        Map colIndexMap = (Map)this.getOwnedChain().getContextProp("colIndexMap");
        ReportRowSet rowSet = new ReportRowSet(rowMeta, batchRows, colIndexMap);
        if (timer != null) {
            timer.time("done row set create");
        }
        DynamicObjectCollection rowDatas = this.toDynamicObjectCollection(rowSet, this.allCols);
        if (timer != null) {
            timer.time("done DynamicObjectCollection create");
        }
        if ("gl_rpt_assistbalance".equals(this.entityID) && (pluginProxy = (FormViewPluginProxy)this.reportView.getService(FormViewPluginProxy.class)) instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).fireProcessRowData(this.ctrlKey, rowDatas, this.reportModel.getReportQueryParam());
        }
        NumberFormatProvider numberFormatProvider = ReportColumn.initNumberFormatProvider((DynamicObjectCollection)rowDatas, this.visibleCols);
        if (timer != null) {
            timer.time("done format provider");
        }
        this.reportModel.preProcessExportData(this.exportColumns, rowDatas, numberFormatProvider);
        if (timer != null) {
            timer.time("done preProcessExportData");
        }
        this.exporter.export(this.exportColumns, rowDatas, numberFormatProvider);
        if (timer != null) {
            timer.time("done exporter.export");
        }
        try {
            this.curWorkbook.getSheet(String.format("sheet%s", this.curSheetIndex)).flushRows();
            if (timer != null) {
                timer.time("done flushRows");
            }
            this.progressCusData.put("batchSeq", this.getBatchSeq());
            this.getExportOption().getExportProgress().feedbackCustData(this.progressCusData);
            this.getOwnedChain().registerContext("totalCount", this.getTotalItemCnt());
            this.getExportOption().getExportProgress().feedbackProgress(this.getTotalItemCnt() * 2, this.getTotalItemCnt());
        }
        catch (IOException e) {
            logger.error("failed to flush sheet :" + e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        if (this.getExportOption().isRecycleRowStorage()) {
            RecyclableRowStorage rowStorage = (RecyclableRowStorage)this.getOwnedChain().getContext().query("rowStorage");
            batchRows.stream().map(AbstractRow.class::cast).forEach(rowStorage::recycleOne);
            if (timer != null) {
                timer.time("done RecyclableRowStorage");
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void fireFinished() throws Exception {
        super.fireFinished();
        if (Objects.isNull(this.curWorkbook)) {
            return;
        }
        try {
            String formName = this.reportView.getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
            String currDateTime = dateFormat.format(new Date());
            RequestContext ctx = RequestContext.getOrCreate();
            String userName = ctx.getUserName();
            String fileName = "";
            fileName = this.index != 0 ? formName + "-" + currDateTime + "-" + userName + "-part" + ++this.index + ".xlsx" : formName + "-" + currDateTime + "-" + userName + ".xlsx";
            long tick = System.currentTimeMillis();
            String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)this.reportView.getServiceAppId(this.reportView.getPageId()), (String)UUID.randomUUID().toString(), (String)fileName);
            String downloadUrl = POIUtils.getAttachmentDownloadUrl((SXSSFWorkbook)this.curWorkbook, (String)fileName, (String)path);
            downloadUrl = downloadUrl + "&fId=" + this.reportView.getEntityId() + "&appId=" + this.reportView.getServiceAppId(this.reportView.getPageId());
            logger.info("subsidiary_multiorg export getAttachmentDownloadUrl.fileName:{} cost:{}ms", (Object)fileName, (Object)(System.currentTimeMillis() - tick));
            this.urls.add(downloadUrl);
            this.getOwnedChain().registerContext("downloadUrl", this.urls);
        }
        catch (Exception e) {
            logger.error("failed to close workbook:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private void initExporter(boolean forceinit) {
        if (Objects.nonNull(this.exporter) && !forceinit) {
            return;
        }
        try {
            this.exporter = (IExporter)Class.forName(EXPORTER_INSTANCE).newInstance();
            this.exporter.setReportList(this.reportList);
            this.curWorkbook = new SXSSFWorkbook(-1);
            TempFile.setTempFileCreationStrategy((TempFileCreationStrategy)new DefaultTempFileCreationStrategy(){

                public File createTempFile(String prefix, String suffix) throws IOException {
                    return File.createTempFile(FilenameUtils.getName((String)prefix), FilenameUtils.getName((String)suffix));
                }
            });
            this.curSheetIndex = 1;
            this.curWorkbook.createSheet(String.format("sheet%s", this.curSheetIndex));
            String searchCondition = this.reportView.getPageCache().get("searchCondition");
            StringBuilder searchConditionBuilder = new StringBuilder(searchCondition);
            if (!"gl_rpt_assistbalance".equals(this.entityID) && !this.entityID.startsWith("gl_rpt_accountbalance")) {
                int colonIndex = searchCondition.indexOf(65306);
                int semicolonIndex = searchCondition.indexOf(59);
                searchConditionBuilder.replace(colonIndex + 1, semicolonIndex, this.getExportOption().getConditionOrgName());
            }
            this.exporter.setSearchCondition(searchConditionBuilder.toString());
            this.exporter.setWb(this.curWorkbook);
            this.exporter.setCaption(this.reportView.getFormShowParameter().getFormConfig().getCaption().getLocaleValue());
            this.exporter.setMap(this.configMap);
            this.exporter.setSize(this.getBatchSize());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.error("failed to create exporter:" + e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private DynamicObjectCollection toDynamicObjectCollection(ReportRowSet rowSet, List<ReportColumn> columns) {
        DynamicObjectType itemType = ReportPropUtil.createReportType((DynamicObjectType)this.reportModel.getItemType(), columns);
        DynamicObjectCollection rowData = new DynamicObjectCollection(itemType, null);
        while (rowSet.next()) {
            DynamicObject obj = this.toDynamicObject(rowSet, itemType, columns);
            rowData.add((Object)obj);
        }
        BusinessDataReader.loadRefence((Object[])rowData.toArray((Object[])new DynamicObject[0]), (IDataEntityType)itemType);
        return rowData;
    }

    private DynamicObject toDynamicObject(ReportRowSet rowSet, DynamicObjectType itemType, List<ReportColumn> columns) {
        DynamicObject obj = new DynamicObject(itemType);
        for (ReportColumn column : columns) {
            DynamicProperty property;
            String key;
            String string = key = column.getDateIndex() == null ? column.getFieldKey() : column.getDateIndex();
            if (column instanceof MulBasedataReportColumn) {
                key = key + ".fbasedataid";
            }
            if (!rowSet.containsColumn(key) || (property = itemType.getProperty(column.getFieldKey())) == null) continue;
            if (property instanceof ICollectionProperty) {
                if (!(property instanceof MulBasedataProp)) continue;
                DynamicObjectCollection objs = (DynamicObjectCollection)obj.get((IDataEntityProperty)property);
                DynamicObject col = objs.addNew();
                col.set("fbasedataid_id", rowSet.getObject(key));
                continue;
            }
            if (property instanceof BasedataProp) {
                ((BasedataProp)property).getRefIdProp().setValue((Object)obj, rowSet.getObject(key));
                continue;
            }
            property.setValue((Object)obj, rowSet.getObject(key));
        }
        return obj;
    }

    private List<AbstractReportColumn> getColumnList(IReportListModel reportModel) {
        FormViewPluginProxy pluginProxy;
        String key = this.reportView.getEntityId() + "_" + this.ctrlKey + "_reportcolumnsmap";
        String columnsSetting = this.reportList.getModel().getCurrUserSetting(key);
        String json = this.reportList.getModel().getCurrUserSetting(this.reportView.getFormShowParameter().getSettingKey());
        List<AbstractReportColumn> columns = reportModel.getColumns();
        if (columnsSetting != null) {
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)columnsSetting);
            for (AbstractReportColumn column2 : columns) {
                ReportColumn c;
                if (!(column2 instanceof ReportColumn) || map.get((c = (ReportColumn)column2).getFieldKey()) == null) continue;
                c.setHide(((Boolean)map.get(c.getFieldKey())).booleanValue());
            }
        }
        if (json != null) {
            for (AbstractReportColumn column3 : columns) {
                this.resovleColumn(column3, json);
            }
        }
        if ("gl_rpt_subsidiaryledger".equals(this.entityID)) {
            ArrayList<AbstractReportColumn> leftColumns = new ArrayList<AbstractReportColumn>();
            ReportColumn orgcolumn = new ReportColumn();
            orgcolumn.setFieldType("text");
            orgcolumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ReportExport_0", (String)"fi-gl-common", (Object[])new Object[0])));
            orgcolumn.setFieldKey("orgname");
            leftColumns.add((AbstractReportColumn)orgcolumn);
            if (!SubsiDiaryHelper.isExport(this.filterInfo)) {
                SubsiDiaryHelper.createAccountancyTypeColumns2(leftColumns, reportModel.getReportQueryParam().getFilter());
            }
            columns.addAll(0, leftColumns);
        }
        if ((pluginProxy = (FormViewPluginProxy)this.reportView.getService(FormViewPluginProxy.class)) instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)pluginProxy).fireAfterCreateColumn(this.ctrlKey, (List)columns, reportModel.getReportQueryParam(), reportModel.getOtherQueryParam());
        }
        if ("gl_rpt_subledger".equals(this.entityID)) {
            columns = columns.stream().peek(column -> {
                if (column instanceof ReportColumn) {
                    switch (((ReportColumn)column).getFieldKey()) {
                        case "assgrp": {
                            ((ReportColumn)column).setHide(false);
                            break;
                        }
                        case "basecurrency": {
                            ((ReportColumn)column).setDateIndex(null);
                        }
                    }
                }
            }).filter(column -> !(column instanceof ReportColumn) || !"accountname".equals(((ReportColumn)column).getFieldKey()) || !"accountcloumn".equals(((ReportColumn)column).getFieldKey())).collect(Collectors.toList());
            int acctIndex = 0;
            for (int i = 0; i < columns.size(); ++i) {
                String fieldKey;
                AbstractReportColumn reportColumn = columns.get(i);
                if (!(reportColumn instanceof ReportColumn) || !(fieldKey = ((ReportColumn)reportColumn).getFieldKey()).equals("org") && !fieldKey.startsWith("comassist")) continue;
                acctIndex = i + 1;
            }
            ReportColumn column4 = new ReportColumn();
            column4.setFieldType("text");
            column4.setCaption(new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee\u540d\u79f0", (String)"ReportExport_3", (String)"fi-gl-common", (Object[])new Object[0])));
            column4.setFieldKey("accountname");
            columns.add(acctIndex, (AbstractReportColumn)column4);
            column4 = new ReportColumn();
            column4.setFieldType("text");
            column4.setCaption(new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801", (String)"ReportExport_2", (String)"fi-gl-common", (Object[])new Object[0])));
            column4.setFieldKey("accountnumber");
            columns.add(acctIndex, (AbstractReportColumn)column4);
            column4 = new ReportColumn();
            column4.setFieldType("basedata");
            column4.setCaption(new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"ReportExport_1", (String)"fi-gl-common", (Object[])new Object[0])));
            column4.setFieldKey("account1");
            column4.setEntityId("bd_accountview");
            column4.setHide(true);
            columns.add(acctIndex, (AbstractReportColumn)column4);
        }
        this.mergeMap = new HashMap<String, String>();
        this.mergeColumn(columns);
        SingleOrgContextHelper.createReportSingleOrgContext(columns);
        this.filterBlackList(this.reportView.getEntityId(), columns);
        return columns;
    }

    private void filterBlackList(String entityId, List<AbstractReportColumn> columns) {
        if (StringUtils.isBlank((CharSequence)entityId) || columns == null) {
            return;
        }
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List ctrls = service.getFormDisVistCtl(entityId);
        if (ctrls == null || ctrls.isEmpty()) {
            return;
        }
        this.setBlackListColumn(ctrls, columns);
    }

    private void setBlackListColumn(List<String> ctrls, List<AbstractReportColumn> columns) {
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                if (!ctrls.contains(((ReportColumn)column).getFieldKey())) continue;
                ((ReportColumn)column).setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            List children = ((ReportColumnGroup)column).getChildren();
            this.setBlackListColumn(ctrls, children);
        }
    }

    private void resovleColumn(AbstractReportColumn column, String json) {
        JSONObject settings = JSON.parseObject((String)json);
        if (column instanceof ReportColumn) {
            JSONObject colObject;
            ReportColumn c = (ReportColumn)column;
            if (settings != null && settings.getJSONObject("reportlistap") != null && (colObject = settings.getJSONObject("reportlistap").getJSONObject("cw")) != null && colObject.get((Object)c.getFieldKey()) != null && colObject.get((Object)c.getFieldKey()) instanceof Integer) {
                int widthObj = (Integer)colObject.get((Object)c.getFieldKey());
                c.setWidth(new LocaleString("" + widthObj));
            }
        } else if (column instanceof ReportColumnGroup) {
            ReportColumnGroup g = (ReportColumnGroup)column;
            for (AbstractReportColumn r : g.getChildren()) {
                this.resovleColumn(r, json);
            }
        }
    }

    private List<ReportColumn> getReportColumnList(List<AbstractReportColumn> reportColumns, boolean isOnlyVisible) {
        ArrayList<ReportColumn> cols = new ArrayList<ReportColumn>();
        this.setReportColumns(reportColumns, cols, isOnlyVisible);
        return cols;
    }

    private void setReportColumns(List<AbstractReportColumn> acols, List<ReportColumn> cols, boolean isOnlyVisible) {
        for (AbstractReportColumn acol : acols) {
            if (!(!(acol instanceof ReportColumn) || isOnlyVisible && ((ReportColumn)acol).isHide())) {
                cols.add((ReportColumn)acol);
                continue;
            }
            if (!(acol instanceof ReportColumnGroup)) continue;
            this.setReportColumns(((ReportColumnGroup)acol).getChildren(), cols, isOnlyVisible);
        }
    }

    private void mergeColumn(List<AbstractReportColumn> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            AbstractReportColumn column = columns.get(i);
            if (!(column instanceof ReportColumnGroup)) continue;
            List cols = ((ReportColumnGroup)column).getChildren();
            this.mergeColumn(cols);
            if (!this.isOnlyOneVisibleColumn(cols)) continue;
            columns.remove(i);
            for (AbstractReportColumn col : cols) {
                if (!this.isVisible(col)) continue;
                col.setCaption(column.getCaption());
                if (col instanceof ReportColumn) {
                    this.mergeMap.put(((ReportColumn)col).getFieldKey(), ((ReportColumnGroup)column).getFieldKey());
                    continue;
                }
                if (!(col instanceof ReportColumnGroup)) continue;
                this.mergeMap.put(((ReportColumnGroup)col).getFieldKey(), ((ReportColumnGroup)column).getFieldKey());
            }
            columns.addAll(i, cols);
        }
    }

    private boolean isOnlyOneVisibleColumn(List<AbstractReportColumn> columns) {
        ArrayList<AbstractReportColumn> cols = new ArrayList<AbstractReportColumn>();
        for (int i = 0; i < columns.size(); ++i) {
            AbstractReportColumn column = columns.get(i);
            if (!this.isVisible(column)) continue;
            cols.add(column);
            if (cols.size() <= 1) continue;
            return false;
        }
        return cols.size() != 1 || cols.get(0) == null || ((AbstractReportColumn)cols.get(0)).isHideSingleColumnRow();
    }

    private boolean isVisible(AbstractReportColumn column) {
        if (column instanceof ReportColumn && !((ReportColumn)column).isHide()) {
            return true;
        }
        if (column instanceof ReportColumnGroup) {
            List columns = ((ReportColumnGroup)column).getChildren();
            for (int i = 0; i < columns.size(); ++i) {
                if (!this.isVisible((AbstractReportColumn)columns.get(i))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private FormatObject getFormat() {
        String fmt;
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        Map userFormat = inteService.getUserFormat(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        FormatObject result = new FormatObject();
        Map numberFormat = (Map)userFormat.get("numberFormat");
        Map timeFormat = (Map)userFormat.get("timeFormat");
        Map currencyFormat = (Map)userFormat.get("currencyFormat");
        if (!numberFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)numberFormat);
            result.setNumberFormat((NumberFormatObject)SerializationUtils.fromJsonString((String)fmt, NumberFormatObject.class));
        }
        if (!timeFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)timeFormat);
            result.setTimeFormat((TimeFormatObject)SerializationUtils.fromJsonString((String)fmt, TimeFormatObject.class));
        }
        if (!currencyFormat.isEmpty()) {
            fmt = SerializationUtils.toJsonString((Object)currencyFormat);
            result.setCurrencyFormat((CurrencyFormatObject)SerializationUtils.fromJsonString((String)fmt, CurrencyFormatObject.class));
        }
        result.setDateFormat(new DateFormatObject(userFormat.get("dateFormat").toString()));
        return result;
    }

    private void recurGroupColumnUserFormat(ReportColumnGroup column, FormatObject format) {
        List children = column.getChildren();
        if (children != null && !children.isEmpty()) {
            for (AbstractReportColumn col : children) {
                if (col instanceof ReportColumnGroup) {
                    this.recurGroupColumnUserFormat((ReportColumnGroup)col, format);
                    continue;
                }
                col.setUserFormat(format);
            }
        }
    }

    private List<GridConfigurationRow> getUserGridConfigRows() {
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        return gridConfigDAO.getGridConfig(this.reportView.getFormShowParameter().getFormId(), this.ctrlKey);
    }

    private boolean isOver() {
        return this.getOwnedChain().isFinalDataSetFlag() && this.isLastBatchFlag();
    }
}

