/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.SubsiDiaryHelper;

public class AssistBalanceQuery {
    private static final Log logger = LogFactory.getLog(AssistBalanceQuery.class);
    private final Map<String, CustomFlexProperty> flexField2Property;
    private final Map<String, Set<Object>> flexField2SelectedValues;
    private final FilterInfo filterInfo;

    public AssistBalanceQuery(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
        this.flexField2SelectedValues = filterInfo.getFlexFilterItems().stream().collect(Collectors.toMap(FilterItemInfo::getPropName, filterItemInfo -> (Set)filterItemInfo.getValue()));
        this.flexField2Property = FlexUtils.batchGetFlexProperty(this.flexField2SelectedValues.keySet().toArray(new String[0])).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new CustomFlexProperty((FlexProperty)entry.getValue())));
    }

    public Map<String, CustomFlexProperty> getCustomFlexProperties() {
        return this.flexField2Property;
    }

    public MainEntityType balEntityType() {
        try {
            MainEntityType balEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"gl_balance").clone();
            for (CustomFlexProperty flexProperty : this.flexField2Property.values()) {
                BasedataProp flexProp = this.getBasedataProp(flexProperty);
                balEntity.addProperty((DynamicProperty)flexProp);
            }
            return balEntity;
        }
        catch (CloneNotSupportedException e) {
            LogFactory.getLog(this.getClass()).error((Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public MainEntityType balEntityType(String flexField) {
        try {
            MainEntityType balEntity = (MainEntityType)EntityMetadataCache.getDataEntityType((String)"gl_balance").clone();
            CustomFlexProperty customFlexProperty = this.flexField2Property.get(flexField);
            BasedataProp flexProp = this.getBasedataProp(customFlexProperty);
            balEntity.addProperty((DynamicProperty)flexProp);
            return balEntity;
        }
        catch (CloneNotSupportedException e) {
            LogFactory.getLog(this.getClass()).error((Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private BasedataProp getBasedataProp(CustomFlexProperty flexProperty) throws CloneNotSupportedException {
        BasedataProp flexProp = new BasedataProp();
        flexProp.setAlias("fassgrpid");
        flexProp.setName(flexProperty.getCustomPropKey());
        String flexPropEntity = AssistValueType.isManualTxt(flexProperty.property.getValueType()) ? "gl_assist_txt" : "gl_assist_bd";
        DynamicObjectType clonedFlexType = (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)flexPropEntity).clone();
        ((LongProp)clonedFlexType.getProperties().get((Object)"id")).setAlias("fid");
        flexProp.setComplexType((IDataEntityType)clonedFlexType);
        return flexProp;
    }

    public DataSet queryWithORM(List<QFilter> balanceFilters, String balanceSelect, String orderBy, int top, Distinctable distinctable, String ... assistBDSelect) {
        ORM orm = ORM.create();
        orm.setDataEntityType("gl_balance", (IDataEntityType)this.balEntityType());
        Tuple2<List<QFilter>, String> customFiltersAndSelectField = this.getCustomFlexPropFilterAndSelectFields(assistBDSelect);
        ArrayList<QFilter> filters = new ArrayList<QFilter>((Collection)customFiltersAndSelectField.t1);
        filters.addAll(balanceFilters);
        if (assistBDSelect.length > 0) {
            balanceSelect = StringUtils.isEmpty((CharSequence)balanceSelect) ? ((String)customFiltersAndSelectField.t2).substring(1) : balanceSelect + (String)customFiltersAndSelectField.t2;
        }
        return orm.queryDataSet(this.getClass().getName() + "#assistBalanceQuery", "gl_balance", balanceSelect, filters.toArray(new QFilter[0]), orderBy, top, distinctable);
    }

    public DataSet query(QueryParam queryParam, String balanceSelect, String ... assistBDSelect) {
        AccountBookInfo defaultBook;
        long orgId = this.filterInfo.getLong("org");
        Set<Long> childOrgId = SubsiDiaryHelper.getChildOrgId(this.filterInfo);
        childOrgId.add(orgId);
        long bookTypeId = this.filterInfo.getLong("booktype");
        if (bookTypeId == 0L && (defaultBook = AccSysUtil.getDefaultBookFromAccSys((Long)this.filterInfo.getDynamicObject("org").getPkValue())) != null) {
            bookTypeId = defaultBook.getBookTypeId();
        }
        queryParam.setBalEntityType(this.balEntityType());
        ArrayList customF = queryParam.getCustomFilter();
        if (customF == null) {
            customF = new ArrayList(4);
        }
        Tuple2<List<QFilter>, String> customFiltersAndSelectField = this.getCustomFlexPropFilterAndSelectFields(assistBDSelect);
        customF.addAll((Collection)customFiltersAndSelectField.t1);
        queryParam.setCustomFilter(customF);
        if (assistBDSelect.length > 0) {
            balanceSelect = balanceSelect + (String)customFiltersAndSelectField.t2;
        }
        return BalanceQueryExecutor.getInstance().getBalance(balanceSelect, childOrgId.toArray(new Long[0]), bookTypeId, this.filterInfo.getLong("accounttable"), this.filterInfo.getLong("startperiod"), this.filterInfo.getLong("endperiod"), queryParam);
    }

    public Tuple2<List<QFilter>, String> getCustomFlexPropFilterAndSelectFields(String ... assistBDSelectField) {
        StringBuilder customSelectField = new StringBuilder();
        List customFilters = this.flexField2Property.entrySet().stream().map(flexField2Property -> {
            String flexField = (String)flexField2Property.getKey();
            CustomFlexProperty customProp = (CustomFlexProperty)flexField2Property.getValue();
            Set<Object> flexValues = this.flexField2SelectedValues.get(flexField);
            for (String field : assistBDSelectField) {
                customSelectField.append(", ").append(customProp.getInnerPropKey(field)).append(" ").append(customProp.getInnerPropAlia(field));
            }
            boolean selectAllValues = flexValues == null || flexValues.size() <= 0;
            boolean selectEmptyValue = flexValues != null && (flexValues.remove(0L) || flexValues.remove(""));
            QFilter joinFilter = QFilter.join((String)customProp.getCustomPropKey(), (String)customProp.getInnerHgKey(), (QFilter)new QFilter(customProp.getInnerAsstypeKey(), "=", (Object)flexField), (ORMHint.JoinHint)(selectAllValues || selectEmptyValue ? ORMHint.JoinHint.LEFT : ORMHint.JoinHint.INNER), (boolean)false);
            QFilter flexValueFilter = selectAllValues ? QFilter.of((String)"1=1", (Object[])new Object[0]) : (selectEmptyValue ? QFilter.isNull((String)customProp.getInnerAssvalKey()) : new QFilter(customProp.getInnerAssvalKey(), "in", flexValues));
            return joinFilter.and(flexValueFilter);
        }).collect(Collectors.toList());
        return new Tuple2(customFilters, (Object)customSelectField.toString());
    }

    public static class CustomFlexProperty {
        public final FlexProperty property;
        public static final String CUSTOM_PROP_PREFIX = "assgrp_";
        private static final String Flag_NONE_DETAIL_ALIA = "@noneDetailAlia";

        public CustomFlexProperty(FlexProperty property) {
            this.property = property;
        }

        public String getCustomPropKey() {
            return CUSTOM_PROP_PREFIX + this.property.getFlexField();
        }

        public String getInnerHgKey() {
            return this.getCustomPropKey() + ".hg";
        }

        public String getInnerAssvalKey() {
            return this.getCustomPropKey() + ".assval";
        }

        public String getInnerAsstypeKey() {
            return this.getCustomPropKey() + ".asstype";
        }

        public String getInnerPropKey(String inner) {
            if (inner.contains(Flag_NONE_DETAIL_ALIA)) {
                return this.getCustomPropKey() + "." + inner.split(Flag_NONE_DETAIL_ALIA)[0];
            }
            return this.getCustomPropKey() + "." + inner;
        }

        public static String ofNoneDetailAlia(String inner) {
            return inner + Flag_NONE_DETAIL_ALIA;
        }

        public String getInnerPropAlia(String inner) {
            if (inner.contains(Flag_NONE_DETAIL_ALIA)) {
                return this.property.getFlexField();
            }
            return inner + "_" + this.property.getFlexField();
        }
    }
}

