/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.synbook;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.LocalCacheHelper;
import kd.fi.gl.enums.synbook.TriggerTiming;
import kd.fi.gl.model.schema.synvoucher.SynVoucherSchema;

public class VoucherRealTimeSynchronizer {
    private static final String OPERATION_SYNBOOK = "syncbookvoucher";

    public static OperationResult doSynchronize(DynamicObject[] voucherDyns, TriggerTiming triggerTiming) {
        if (ArrayUtils.isEmpty((Object[])voucherDyns) || triggerTiming == null) {
            return new OperationResult();
        }
        DynamicProperty orgIdProperty = voucherDyns[0].getDynamicObjectType().getProperty("org_id");
        Object[] toSyncVoucherPks = Arrays.stream(voucherDyns).collect(Collectors.groupingBy(arg_0 -> ((DynamicProperty)orgIdProperty).getValueFast(arg_0))).entrySet().stream().filter(e -> VoucherRealTimeSynchronizer.existsRealTimeRule((Long)e.getKey(), triggerTiming)).flatMap(e -> ((List)e.getValue()).stream()).map(DataEntityBase::getPkValue).toArray();
        if (toSyncVoucherPks.length > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(SynVoucherSchema.INSTANCE.Option_RealTime.toTypeName(), "");
            option.setVariableValue("ignoreValidation", "true");
            return OperationServiceHelper.executeOperate((String)OPERATION_SYNBOOK, (String)"gl_voucher", (Object[])toSyncVoucherPks, (OperateOption)option);
        }
        return new OperationResult();
    }

    private static boolean existsRealTimeRule(long orgId, TriggerTiming timing) {
        return LocalCacheHelper.getIfAbsent(CacheKey.getCacheKey(CacheKeyPrefix.REAL_TIME_SYNCHRONIZE, new Object[]{timing, orgId}), Boolean.class, () -> VoucherRealTimeSynchronizer.existsRealTimeRuleFromDB(orgId, timing));
    }

    private static Boolean existsRealTimeRuleFromDB(long orgId, TriggerTiming timing) {
        QFilterBuilder qFilterBuilder = QFilterBuilder.create((String)"exeway", (String)"=", (Object)"ontime").addEqual("enable", (Object)Boolean.TRUE).addEqual("strikeopre", (Object)timing.getValue()).add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_voucher_rulecondition", (Long)orgId));
        return QueryServiceHelper.exists((String)"gl_voucher_rulecondition", (QFilter[])qFilterBuilder.toArray(new QFilter[0]));
    }
}

