/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.taxreport;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.common.ManageItemCell;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.taxreport.ITaxReportDataHandler;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.TaxReportFormHelper;
import kd.fi.gl.util.TaxReportParam;

public abstract class AbstractTaxReportDataHandler
implements ITaxReportDataHandler {
    private static final String dbRowid = "dbrowid";
    private static final String ISTOTALROW = "istotalrow";
    private static final String FETCHRULE = "fetchrule";
    private static final String ITEMID = "itemid";
    private static final String SIGN = "sign";
    private static final String COLUMNKEY = "columnkey";
    private static final String MASTERID = "masterid";
    private static final String assetEntryKey = "assetentryentity";
    private static final String equityEntryKey = "equityentryentity";
    private static Log log = LogFactory.getLog(AbstractTaxReportDataHandler.class);

    @Override
    public List<List<BigDecimal>> handle(TaxReportParam param) {
        if (this.isReCaculateTotalRow()) {
            DynamicObjectCollection parentBalSheet = this.getParentBalSheet(param);
            HashMap<Long, Tuple<String, BigDecimal[]>> itemAndAmtMap = new HashMap<Long, Tuple<String, BigDecimal[]>>(parentBalSheet.size());
            ArrayList<Long> rowAndItemMap = new ArrayList<Long>(parentBalSheet.size());
            this.buildParentOrgSheetMap(parentBalSheet, rowAndItemMap, itemAndAmtMap, param);
            Map<String, List<BigDecimal>> resultMap = this.groupChildOrgSheetAmount(param, itemAndAmtMap, rowAndItemMap);
            return this.handleMultOrgTotalRows(param, resultMap, parentBalSheet, param.getEntityType());
        }
        return this.sumChildOrgSheetAmount(param);
    }

    protected boolean isReCaculateTotalRow() {
        return true;
    }

    protected abstract DynamicObjectCollection getParentBalSheet(TaxReportParam var1);

    protected abstract DynamicObjectCollection getChildBalSheet(Long var1, TaxReportParam var2);

    protected abstract List<List<BigDecimal>> collectChildOrgBal(Long var1, TaxReportParam var2);

    private void buildParentOrgSheetMap(DynamicObjectCollection parentBalSheet, List<Long> rowAndItemMap, Map<Long, Tuple<String, BigDecimal[]>> rowAndAmtMap, TaxReportParam param) {
        for (DynamicObject row : parentBalSheet) {
            Long masterId = null;
            masterId = assetEntryKey.equals(param.getEntityType()) ? Long.valueOf(row.getLong("assetmasterid")) : (equityEntryKey.equals(param.getEntityType()) ? Long.valueOf(row.getLong("equitymasterid")) : Long.valueOf(row.getLong("projectmasterid")));
            String rowId = row.getString(dbRowid);
            rowAndAmtMap.put(masterId, new Tuple<String, BigDecimal[]>(rowId, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO}));
            rowAndItemMap.add(masterId);
        }
    }

    protected abstract DynamicObjectCollection getSheetExps(TaxReportParam var1);

    protected abstract void handleSingleOrgRowAmt(Map<Long, Tuple<String, BigDecimal[]>> var1, DynamicObjectCollection var2, List<List<BigDecimal>> var3, TaxReportParam var4);

    protected abstract Map<String, List<BigDecimal>> transToMap(Map<Long, Tuple<String, BigDecimal[]>> var1, List<Long> var2, TaxReportParam var3);

    private List<List<BigDecimal>> handleMultOrgTotalRows(TaxReportParam param, Map<String, List<BigDecimal>> resultList, DynamicObjectCollection collection, String entityType) {
        String type = param.getType();
        HashMap<String, ManageItemCell> cellAndItemMap = new HashMap<String, ManageItemCell>();
        HashMap<String, List<String>> expKeyMap = new HashMap<String, List<String>>();
        DynamicObjectCollection expCollection = this.getSheetExps(param);
        this.buildCellMapping(expCollection, cellAndItemMap, expKeyMap);
        HashMap<Long, String> itemIdAndRowIndexMap = new HashMap<Long, String>();
        for (DynamicObject dyn : collection) {
            String balRowId;
            int index = 1;
            int size = 5;
            if (assetEntryKey.equals(entityType) || equityEntryKey.equals(entityType)) {
                balRowId = dyn.getString(dbRowid);
                index = assetEntryKey.equals(entityType) ? 1 : 3;
                size = assetEntryKey.equals(entityType) ? 3 : 5;
            } else {
                balRowId = dyn.getString(dbRowid);
            }
            if ("income".equals(type)) {
                size = 3;
            }
            for (int i = index; i < size; ++i) {
                String key = balRowId + "," + i;
                ManageItemCell cell = (ManageItemCell)cellAndItemMap.get(key);
                if (cell == null) continue;
                Long itemId = AbstractTaxReportDataHandler.getItemId(type, dyn, i);
                cell.setItemId(itemId);
                itemIdAndRowIndexMap.put(itemId, balRowId);
            }
        }
        this.loadDetailCellRowAndColIdx(cellAndItemMap, itemIdAndRowIndexMap);
        TaxReportFormHelper.handleTotalRows(type, param.getEntityType(), Collections.singleton(param.getParentOrg()), param.getAccTableId(), resultList, expKeyMap, cellAndItemMap);
        return new ArrayList<List<BigDecimal>>(resultList.values());
    }

    private void loadDetailCellRowAndColIdx(Map<String, ManageItemCell> cellAndItemMap, Map<Long, String> itemIdAndRowIndexMap) {
        for (ManageItemCell cell : cellAndItemMap.values()) {
            Set<Long> detailItemIds = cell.getDetailItemIds();
            String colIndex = cell.getColIdx();
            for (Long detailItemId : detailItemIds) {
                String rowIndex = itemIdAndRowIndexMap.get(detailItemId);
                if (StringUtils.isEmpty((CharSequence)rowIndex)) continue;
                cell.addDetailCell(rowIndex + "," + colIndex);
            }
        }
    }

    private static Long getItemId(String type, DynamicObject dyn, int colKey) {
        Long itemId = 0L;
        if ("income".equals(type)) {
            itemId = dyn.getLong("project");
        } else if ("balancesheet".equals(type)) {
            itemId = colKey >= 1 && colKey <= 2 ? Long.valueOf(dyn.getLong("asset")) : Long.valueOf(dyn.getLong("equity"));
        }
        return itemId;
    }

    private void buildCellMapping(DynamicObjectCollection expCollection, Map<String, ManageItemCell> cellAndItemMap, Map<String, List<String>> expKeyMap) {
        if (expCollection != null) {
            for (DynamicObject dyn : expCollection) {
                if (dyn.getString(FETCHRULE) == null || "null".equals(dyn.getString(FETCHRULE))) continue;
                String key = dyn.getString("rowtag") + "," + dyn.getString(COLUMNKEY);
                Boolean isTotalRow = dyn.getBoolean(ISTOTALROW);
                String val = "";
                if (isTotalRow.booleanValue()) {
                    val = dyn.get(ITEMID) + "," + dyn.get(SIGN);
                    ManageItemCell cell = cellAndItemMap.computeIfAbsent(key, p -> new ManageItemCell(dyn.getString("rowtag"), dyn.getString(COLUMNKEY)));
                    cell.addDetailItemId(dyn.getLong(ITEMID));
                } else {
                    val = dyn.getLong(MASTERID) + "," + dyn.getString(SIGN) + "," + dyn.getString(FETCHRULE);
                }
                if (expKeyMap.containsKey(key)) {
                    List<String> list = expKeyMap.get(key);
                    list.add(val);
                    expKeyMap.put(key, list);
                    continue;
                }
                ArrayList<String> expList = new ArrayList<String>();
                expList.add(val);
                expKeyMap.put(key, expList);
            }
        }
    }

    private Map<String, List<BigDecimal>> groupChildOrgSheetAmount(final TaxReportParam param, Map<Long, Tuple<String, BigDecimal[]>> itemAndAmtMap, List<Long> rowAndItemMap) {
        HashMap<Long, Future> futures = new HashMap<Long, Future>(param.getChildOrgSet().size());
        for (final Long l : param.getChildOrgSet()) {
            Future future = ThreadService.submit((Callable)new Callable<List<List<BigDecimal>>>(){

                @Override
                public List<List<BigDecimal>> call() throws Exception {
                    return AbstractTaxReportDataHandler.this.collectChildOrgBal(l, param);
                }
            }, (TaskType)TaskType.GL_TAX_REPORT_DATA_HANDLER);
            futures.put(l, future);
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                List resultList = (List)((Future)entry.getValue()).get();
                Long childOrgId = (Long)entry.getKey();
                DynamicObjectCollection childBalSheet = this.getChildBalSheet(childOrgId, param);
                if (childBalSheet.isEmpty() || resultList.size() != childBalSheet.size()) {
                    this.logInfo(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u8868\u8fbe\u5f0f\u53d6\u503c\u884c\u6570%2$s\uff0c\u9879\u76ee\u884c\u6570%3$s\uff0c\u6c47\u603b\u5931\u8d25\u3002", (String)"AbstractTaxReportDataHandler_0", (String)"fi-gl-common", (Object[])new Object[0]), childOrgId, resultList.size(), childBalSheet.size()));
                    continue;
                }
                this.handleSingleOrgRowAmt(itemAndAmtMap, childBalSheet, resultList, param);
            }
            catch (Exception e) {
                throw new KDBizException(GLUtil.printError(e));
            }
        }
        return this.transToMap(itemAndAmtMap, rowAndItemMap, param);
    }

    private List<List<BigDecimal>> sumChildOrgSheetAmount(TaxReportParam param) {
        List<List<BigDecimal>> resultList = new ArrayList<List<BigDecimal>>(1024);
        for (Long childOrgId : param.getChildOrgSet()) {
            List<List<BigDecimal>> childBal = this.collectChildOrgBal(childOrgId, param);
            if (childBal.isEmpty()) continue;
            if (resultList.isEmpty()) {
                resultList = childBal;
                continue;
            }
            if (childBal.size() != resultList.size()) {
                this.logInfo(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u8868\u8fbe\u5f0f\u53d6\u503c\u884c\u6570%2$s\uff0c\u548c\u7ed3\u679c\u96c6\u53d6\u503c\u884c\u6570%3$s\u4e0d\u540c\uff0c\u6c47\u603b\u5931\u8d25\u3002", (String)"AbstractTaxReportDataHandler_1", (String)"fi-gl-common", (Object[])new Object[0]), childOrgId, childBal.size(), resultList.size()));
                continue;
            }
            this.commonSumEachRow(resultList, childBal);
        }
        return resultList;
    }

    private void commonSumEachRow(List<List<BigDecimal>> resultList, List<List<BigDecimal>> childBal) {
        for (int i = 0; i < childBal.size(); ++i) {
            List<BigDecimal> childRow = childBal.get(i);
            List<BigDecimal> resultRow = resultList.get(i);
            for (int j = 0; j < resultRow.size(); ++j) {
                resultRow.set(j, resultRow.get(j).add(childRow.get(j)));
            }
        }
    }

    private void logInfo(String msg) {
        log.error(msg);
    }
}

