/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.tools;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.gl.balcal.repair.BalanceRepairService;
import kd.fi.gl.balcal.repair.CashflowRepairService;
import kd.fi.gl.balcal.repair.OrgPeriodVO;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.tools.IAssistIdFinder;
import kd.fi.gl.tools.dao.AssistReplaceLogVO;
import kd.fi.gl.tools.dao.ReplaceLogDAO;
import kd.fi.gl.tools.dao.ReplaceRecordDAO;
import org.apache.commons.lang3.StringUtils;

public class AssistDuplicateRepairTool {
    private static final Log LOG = LogFactory.getLog(AssistDuplicateRepairTool.class);
    static final String TABLE_GL_ASSIST = "t_gl_assist";
    private static final List<String> EXCLUDE_TABLES = Arrays.asList("t_gl_assist_txt", "t_gl_assist_bd", "t_gl_assist", "t_gl_cashflow", "T_GL_VOUCHERENTRY", "T_GL_BALANCE");
    private static final List<String> INVALID_TABLES = Arrays.asList("ghj", "t_yx_flextest", "T_isv_test123456", "T_isv_test123456entry", "t_wxy_bill", "t_wxy_billentry", "t_yx_purapplyentryentity", "t_yx_purchaseapply", "t_yx_subentryentity", "kd_mobile_biz");
    private static final int REPLACE_BATCH = 500;
    private static final BalanceRepairService balanceService = new BalanceRepairService();
    private static final CashflowRepairService cashflowService = new CashflowRepairService();

    public static synchronized int work(IAssistIdFinder finder) {
        Date beginDate = new Date();
        ReplaceRecordDAO.createTable();
        ReplaceLogDAO.createTable();
        finder.prepareReplaceAssistIds();
        long replaceId = 0L;
        HashMap<Long, List<Long>> replacePairs = new HashMap<Long, List<Long>>(8);
        int replaceCount = 0;
        int totalReplaceCount = 0;
        try (DataSet replaceDs = ReplaceRecordDAO.list(beginDate);){
            while (replaceDs.hasNext()) {
                ArrayList<Long> removeIds;
                Row row = replaceDs.next();
                long curRemoveId = row.getLong("FREMOVEID");
                long curReplaceId = row.getLong("FREPLACID");
                if (curReplaceId != replaceId) {
                    if (replaceCount > 500) {
                        AssistDuplicateRepairTool.processAssistReplace(replacePairs);
                        replacePairs.clear();
                        replaceCount = 0;
                        totalReplaceCount += replaceCount;
                    }
                    replaceId = curReplaceId;
                }
                if (null == (removeIds = (ArrayList<Long>)replacePairs.get(curReplaceId))) {
                    removeIds = new ArrayList<Long>(8);
                    replacePairs.put(curReplaceId, removeIds);
                }
                removeIds.add(curRemoveId);
                ++replaceCount;
            }
        }
        AssistDuplicateRepairTool.processAssistReplace(replacePairs);
        return totalReplaceCount += replaceCount;
    }

    public static synchronized void fixUniqueIndex() {
        String dropIndexSql = "EXEC p_DropIdx 'IDX_GL_T_GL_ASSIST', 'T_GL_ASSIST'; ";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)dropIndexSql);
        String createIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_GL_T_GL_ASSIST')  CREATE UNIQUE INDEX IDX_GL_T_GL_ASSIST ON T_GL_ASSIST ( FVALUE );";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)createIndexSql);
    }

    private static void processAssistReplace(Map<Long, List<Long>> replacePairs) {
        if (replacePairs.isEmpty()) {
            return;
        }
        HashMap<Long, Long> removeToReplaceMap = new HashMap<Long, Long>(8);
        for (Map.Entry<Long, List<Long>> entry : replacePairs.entrySet()) {
            Long replaceId = entry.getKey();
            List<Long> removeIds = entry.getValue();
            for (Long removeId : removeIds) {
                removeToReplaceMap.put(removeId, replaceId);
            }
        }
        try (TXHandle txh = TX.requiresNew();){
            try {
                AssistDuplicateRepairTool.repairOtherBills(removeToReplaceMap);
                AssistDuplicateRepairTool.repairVoucherAndBalance(removeToReplaceMap);
                ArrayList removeAssistIds = new ArrayList(removeToReplaceMap.keySet());
                SqlBuilder existVoucherSql = new SqlBuilder();
                existVoucherSql.append("select top 1 ve.fid from t_gl_voucherentry ve where", new Object[0]);
                existVoucherSql.appendIn(" ve.fassgrpid ", removeAssistIds);
                existVoucherSql.appendIn(" or ve.fmaincfassgrpid ", removeAssistIds);
                boolean isExistVoucher = AssistDuplicateRepairTool.exist(existVoucherSql);
                SqlBuilder existBalanceSql = new SqlBuilder();
                existBalanceSql.append("select top 1 fid from t_gl_balance where", new Object[0]);
                existBalanceSql.appendIn(" fassgrpid ", removeAssistIds);
                boolean isExistBalance = AssistDuplicateRepairTool.exist(existBalanceSql);
                if (isExistBalance) {
                    SqlBuilder queryBalanceSQL = new SqlBuilder();
                    queryBalanceSQL.append("select fid from t_gl_balance where", new Object[0]);
                    queryBalanceSQL.appendIn(" fassgrpid ", removeAssistIds);
                    DataSet ds = DB.queryDataSet((String)"queryBalances", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)queryBalanceSQL);
                    StringBuilder fids = new StringBuilder("balance ids: ");
                    while (ds.hasNext()) {
                        fids.append(ds.next().getLong("fid")).append(",");
                    }
                    String log = fids.toString();
                    LOG.error("exist_balance ids: " + log);
                }
                SqlBuilder existCashflowSql = new SqlBuilder();
                existCashflowSql.append("select top 1 fid from t_gl_cashflow where", new Object[0]);
                existCashflowSql.appendIn(" fassgrpid ", removeAssistIds);
                boolean isExistCashflow = AssistDuplicateRepairTool.exist(existCashflowSql);
                SqlBuilder existBalanceLogSql = new SqlBuilder();
                existBalanceLogSql.append("select top 1 fid from t_gl_balance_log where ", new Object[0]);
                existBalanceLogSql.append(" fcalculated = '0' and ", new Object[0]);
                existBalanceLogSql.appendIn(" fassgrpid ", removeAssistIds);
                boolean isExistBalanceLog = AssistDuplicateRepairTool.exist(existBalanceLogSql);
                if (isExistVoucher || isExistBalance || isExistCashflow || isExistBalanceLog) {
                    throw new KDBizException("exist voucher/balance/balancelog refer after replacement: voucher: " + isExistVoucher + ", balance:" + isExistBalance + ", balancelog: " + isExistBalanceLog + ", isExistCashflow:" + isExistCashflow);
                }
                SqlBuilder deleteSql = new SqlBuilder();
                deleteSql.append("delete from t_gl_assist where ", new Object[0]);
                deleteSql.appendIn(" fid ", new ArrayList(removeToReplaceMap.keySet()));
                DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)deleteSql);
                LOG.error("DELETE T_GL_ASSIST ID for repair duplicate value: " + removeToReplaceMap.keySet());
            }
            catch (Exception e) {
                LOG.error("process voucher assist replace failed on :" + e.getMessage(), (Throwable)e);
                txh.markRollback();
                throw new KDBizException((Throwable)e, GLErrorCode.SYS_ERR, new Object[0]);
            }
        }
    }

    private static boolean exist(SqlBuilder sqlBuilder) {
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
    }

    private static void repairOtherBills(Map<Long, Long> removeToReplaceMap) {
        ArrayList<Long> removeAssistIds = new ArrayList<Long>(removeToReplaceMap.keySet());
        Set lowerExtTab = EXCLUDE_TABLES.stream().map(String::toLowerCase).collect(Collectors.toSet());
        DataSet entityDs = DB.queryDataSet((String)"queryScope", (DBRoute)DBRoute.of((String)"sys.meta"), (String)"select distinct ftablename , ffieldname, p.fnumber from t_meta_objecttyperef r inner join t_meta_entitydesign p on r.fentityid = p.fid WHERE frefobjecttypeid='gl_assist';");
        while (entityDs.hasNext()) {
            Row row = entityDs.next();
            String tableName = row.getString("ftablename");
            String fieldName = row.getString("ffieldname");
            String entityId = row.getString("fnumber");
            if (StringUtils.isNotBlank((CharSequence)tableName) && INVALID_TABLES.contains(tableName.trim()) || !StringUtils.isNotBlank((CharSequence)tableName) || !StringUtils.isNotBlank((CharSequence)fieldName) || !StringUtils.isNotBlank((CharSequence)entityId) || lowerExtTab.contains(tableName.trim().toLowerCase())) continue;
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityId);
            LOG.info("process other bill: " + entityId);
            String routeKey = entity.getDBRouteKey();
            if ("fi".equalsIgnoreCase(routeKey) || "gl".equalsIgnoreCase(routeKey) || "ai".equals(routeKey)) {
                try {
                    Optional<EntityType> entityType = entity.getAllEntities().values().stream().filter(e -> tableName.equalsIgnoreCase(e.getAlias())).findFirst();
                    if (!entityType.isPresent()) continue;
                    Optional<IDataEntityProperty> property = entityType.get().getProperties().stream().filter(p -> fieldName.equalsIgnoreCase(p.getAlias())).findFirst();
                    if (!property.isPresent()) {
                        throw new KDBizException(" can not find the field name : " + fieldName + " on table: " + tableName);
                    }
                    String pkField = entity.getPrimaryKey().getAlias();
                    String updateStr = String.format("update %s set %s = ? where %s = ? and %s = ?;", tableName, fieldName, pkField, fieldName);
                    SqlBuilder sqlBuilder = new SqlBuilder();
                    sqlBuilder.append("select " + pkField + ", " + fieldName + " from " + tableName.trim() + " where ", new Object[0]);
                    sqlBuilder.appendIn(" " + fieldName, removeAssistIds);
                    ArrayList<AssistReplaceLogVO> logVOS = new ArrayList<AssistReplaceLogVO>(8);
                    ArrayList<Object[]> params = new ArrayList<Object[]>(8);
                    try {
                        DataSet ds = DB.queryDataSet((String)"queryRepairOtherBill", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
                        Throwable throwable = null;
                        try {
                            while (ds.hasNext()) {
                                Row billRow = ds.next();
                                long pk = billRow.getLong(pkField);
                                long removeId = billRow.getLong(fieldName);
                                long repalceId = removeToReplaceMap.get(removeId);
                                logVOS.add(new AssistReplaceLogVO(tableName, fieldName, pk, removeId, repalceId));
                                params.add(new Object[]{repalceId, pk, removeId});
                                if (logVOS.size() <= 1000) continue;
                                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)updateStr, params);
                                LOG.info("execute batch: {}, params: {}", (Object)updateStr, params);
                                ReplaceLogDAO.insert(logVOS);
                                logVOS.clear();
                                params.clear();
                            }
                            if (logVOS.size() <= 1000) continue;
                            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)updateStr, params);
                            LOG.info("execute batch: {}, params: {}", (Object)updateStr, params);
                            ReplaceLogDAO.insert(logVOS);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ds == null) continue;
                            if (throwable != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ds.close();
                            continue;
                        }
                    }
                    catch (Exception e2) {
                        if (e2 instanceof SQLException) {
                            LOG.error("other bill failed on " + e2.getMessage(), (Throwable)e2);
                            continue;
                        }
                        if (e2.getMessage().startsWith("ERROR: column \"fid\" does not exist")) continue;
                        throw new KDBizException((Throwable)e2, new ErrorCode(tableName + "failed", sqlBuilder.toString()), new Object[0]);
                    }
                }
                catch (Exception e3) {
                    LOG.error("failed to process entity: " + entityId + ", field name: " + fieldName + " encounter exception: " + e3.getMessage(), (Throwable)e3);
                    throw new KDBizException("entity: " + entityId + ", field name: " + fieldName + " encounter exception: " + e3.getMessage());
                }
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select count(1) cnt from " + tableName.trim() + " where ", new Object[0]);
            sqlBuilder.appendIn(" " + fieldName, removeAssistIds);
            try {
                int count = (Integer)DB.query((DBRoute)DBRoute.of((String)routeKey), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Integer>(){

                    public Integer handle(ResultSet rs) throws Exception {
                        rs.next();
                        return rs.getInt("cnt");
                    }
                });
                if (count <= 0) continue;
                throw new KDBizException("entity: " + entityId + ", field name: " + fieldName + " had referred.");
            }
            catch (Exception e4) {
                if (e4 instanceof KDException && ((KDException)e4).getErrorCode().getCode().equals("bos.sQLTableNotExist")) continue;
                throw new KDBizException("logic error on replace other bills.");
            }
        }
    }

    private static void repairVoucherAndBalance(Map<Long, Long> removeToReplaceMap) {
        ArrayList<Long> removeAssistIds = new ArrayList<Long>(removeToReplaceMap.keySet());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select v.fid,v.fbooktypeid,v.forgid,v.fperiodid,ve.fentryid,ve.fassgrpid,ve.fmaincfassgrpid  from t_gl_voucherentry ve inner join t_gl_voucher v on ve.fid = v.fid where", new Object[0]);
        sqlBuilder.appendIn(" ve.fassgrpid ", removeAssistIds);
        sqlBuilder.appendIn(" or ve.fmaincfassgrpid ", removeAssistIds);
        HashMap<OrgPeriodVO, Set<Long>> voucherOrgPeriodKeys = new HashMap<OrgPeriodVO, Set<Long>>(8);
        HashMap<OrgPeriodVO, Set<Long>> cfOrgPeriodKeys = new HashMap<OrgPeriodVO, Set<Long>>(8);
        ArrayList<Object[]> voucherRepairBuff = new ArrayList<Object[]>(100);
        ArrayList<Object[]> cashflowRepairBuff = new ArrayList<Object[]>(100);
        DataSet ds = DB.queryDataSet((String)"queryRepairVoucher", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        Object object = null;
        try {
            while (ds.hasNext()) {
                long replaceId;
                Set<Long> ids;
                Row row = ds.next();
                long orgId = row.getLong("forgid");
                long bookTypeId = row.getLong("fbooktypeid");
                long periodId = row.getLong("fperiodid");
                long entryId = row.getLong("fentryid");
                long removeAssistId = row.getLong("fassgrpid");
                long removeMaincfAssistId = row.getLong("fmaincfassgrpid");
                OrgPeriodVO key = new OrgPeriodVO(orgId, bookTypeId, periodId);
                if (removeToReplaceMap.containsKey(removeAssistId)) {
                    ids = (HashSet<Long>)voucherOrgPeriodKeys.get(key);
                    if (null == ids) {
                        ids = new HashSet<Long>(8);
                        voucherOrgPeriodKeys.put(key, ids);
                    }
                    replaceId = removeToReplaceMap.get(removeAssistId);
                    ids.add(replaceId);
                    voucherRepairBuff.add(new Object[]{replaceId, entryId, removeAssistId});
                }
                if (removeToReplaceMap.containsKey(removeMaincfAssistId)) {
                    ids = (Set)cfOrgPeriodKeys.get(key);
                    if (null == ids) {
                        ids = new HashSet(8);
                        cfOrgPeriodKeys.put(key, ids);
                    }
                    replaceId = removeToReplaceMap.get(removeMaincfAssistId);
                    ids.add(replaceId);
                    cashflowRepairBuff.add(new Object[]{replaceId, entryId, removeMaincfAssistId});
                }
                if (voucherRepairBuff.size() + cashflowRepairBuff.size() <= 1000) continue;
                AssistDuplicateRepairTool.persistVoucherDB(voucherRepairBuff, cashflowRepairBuff);
            }
            if (voucherRepairBuff.size() + cashflowRepairBuff.size() > 0) {
                AssistDuplicateRepairTool.persistVoucherDB(voucherRepairBuff, cashflowRepairBuff);
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Collection<BookScope> balanceScopes = AssistDuplicateRepairTool.groupEffectiveScope(voucherOrgPeriodKeys);
        for (BookScope bookScope : balanceScopes) {
            if (bookScope.assistIds.isEmpty()) {
                throw new KDBizException("logic error");
            }
            AssistDuplicateRepairTool.deleteBalance(bookScope.orgId, bookScope.bookTypeId, bookScope.startPeriod, bookScope.endPeriod, new HashSet<Object>(removeAssistIds));
            balanceService.reCalculateByAssist(bookScope.orgId, bookScope.bookTypeId, bookScope.assistIds, bookScope.startPeriod, bookScope.endPeriod);
        }
        Collection<BookScope> cfScopes = AssistDuplicateRepairTool.groupEffectiveScope(cfOrgPeriodKeys);
        for (BookScope bookScope : cfScopes) {
            if (bookScope.assistIds.isEmpty()) {
                throw new KDBizException("logic error");
            }
            AssistDuplicateRepairTool.deleteCashflow(bookScope.orgId, bookScope.bookTypeId, bookScope.startPeriod, bookScope.endPeriod, new HashSet<Object>(removeAssistIds));
            cashflowService.reCalculateByAssist(bookScope.orgId, bookScope.bookTypeId, bookScope.assistIds, bookScope.startPeriod, bookScope.endPeriod);
        }
    }

    private static final Collection<BookScope> groupEffectiveScope(Map<OrgPeriodVO, Set<Long>> orgPeriodMap) {
        if (null == orgPeriodMap || orgPeriodMap.isEmpty()) {
            return new HashSet<BookScope>(8);
        }
        HashMap<String, BookScope> scopes = new HashMap<String, BookScope>(8);
        for (Map.Entry<OrgPeriodVO, Set<Long>> entry : orgPeriodMap.entrySet()) {
            OrgPeriodVO vo = entry.getKey();
            String _key = String.format("%s_%s", vo.orgId, vo.bookTypeId);
            BookScope scope = (BookScope)scopes.get(_key);
            if (null == scope) {
                scope = new BookScope(vo.orgId, vo.bookTypeId);
                scopes.put(_key, scope);
            }
            if (vo.periodId < scope.getStartPeriod()) {
                scope.setStartPeriod(vo.periodId);
            }
            if (vo.periodId > scope.getEndPeriod()) {
                scope.setEndPeriod(vo.periodId);
            }
            if (scope.getStartPeriod() == 0L) {
                scope.setStartPeriod(scope.getEndPeriod());
            }
            if (scope.getEndPeriod() == 0L) {
                scope.setEndPeriod(scope.getStartPeriod());
            }
            scope.addAll((Collection<Long>)entry.getValue());
        }
        for (BookScope scope : scopes.values()) {
            LOG.error("scope is: {}", (Object)scope);
        }
        return scopes.values();
    }

    private static final void deleteBalance(long orgId, long bookTypeId, long startPeriodId, long endPeriodId, Set<Object> assgrpIds) {
        LOG.info("delete balance: org: {}, booktypeid: {}, startperiod: {}, endperiod: {}, assistid: {}", new Object[]{orgId, bookTypeId, startPeriodId, endPeriodId, assgrpIds});
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("DELETE FROM T_GL_BALANCE WHERE ", new Object[0]);
        sqlBuilder.append(" forgid = ?", new Object[]{orgId});
        sqlBuilder.append(" and fbooktypeid = ?", new Object[]{bookTypeId});
        sqlBuilder.append(" and fperiodid >= ?", new Object[]{startPeriodId});
        sqlBuilder.append(" and fperiodid <= ?", new Object[]{endPeriodId});
        sqlBuilder.appendIn(" and fassgrpid ", new ArrayList<Object>(assgrpIds));
        boolean isSuc = DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        LOG.error("delete balance success? " + isSuc);
    }

    private static final void deleteCashflow(long orgId, long bookTypeId, long startPeriodId, long endPeriodId, Set<Object> assgrpIds) {
        LOG.info("delete cashflow: org: {}, booktypeid: {}, startperiod: {}, endperiod: {}, assistid: {}", new Object[]{orgId, bookTypeId, startPeriodId, endPeriodId, assgrpIds});
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("DELETE FROM t_gl_cashflow WHERE ", new Object[0]);
        sqlBuilder.append(" forgid = ?", new Object[]{orgId});
        sqlBuilder.append(" and fbooktypeid = ?", new Object[]{bookTypeId});
        sqlBuilder.append(" and fperiodid >= ?", new Object[]{startPeriodId});
        sqlBuilder.append(" and fperiodid <= ?", new Object[]{endPeriodId});
        sqlBuilder.appendIn(" and fassgrpid ", new ArrayList<Object>(assgrpIds));
        boolean isSuc = DB.execute((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);
        LOG.error("delete balance success? " + isSuc);
    }

    private static void persistVoucherDB(List<Object[]> voucherRepairBuff, List<Object[]> cashflowRepairBuff) {
        if (!voucherRepairBuff.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)"update t_gl_voucherentry set fassgrpid = ? where fentryid = ? and fassgrpid = ?;", voucherRepairBuff);
            ReplaceLogDAO.insert(voucherRepairBuff.stream().map(x -> {
                LOG.info("replace voucher: entry id: {}, fassigrpid: {}", x[2], x[0]);
                return new AssistReplaceLogVO("gl_voucherentry", "fassgrpid", (Long)x[1], (Long)x[2], (Long)x[0]);
            }).collect(Collectors.toList()));
            voucherRepairBuff.clear();
        }
        if (!cashflowRepairBuff.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)"update t_gl_voucherentry set fmaincfassgrpid = ? where fentryid = ? and fmaincfassgrpid = ?;", cashflowRepairBuff);
            ReplaceLogDAO.insert(cashflowRepairBuff.stream().map(x -> {
                LOG.info("replace voucher: entry id: {}, fmaincfassgrpid: {}", x[2], x[0]);
                return new AssistReplaceLogVO("gl_voucherentry", "fmaincfassgrpid", (Long)x[1], (Long)x[2], (Long)x[0]);
            }).collect(Collectors.toList()));
            cashflowRepairBuff.clear();
        }
    }

    static class BookScope {
        private long orgId;
        private long bookTypeId;
        private long startPeriod = 0L;
        private long endPeriod = 0L;
        private Set<Long> assistIds = new HashSet<Long>(8);

        public BookScope(long orgId, long bookTypeId) {
            this.orgId = orgId;
            this.bookTypeId = bookTypeId;
        }

        public long getStartPeriod() {
            return this.startPeriod;
        }

        public void setStartPeriod(long startPeriod) {
            this.startPeriod = startPeriod;
        }

        public long getEndPeriod() {
            return this.endPeriod;
        }

        public void setEndPeriod(long endPeriod) {
            this.endPeriod = endPeriod;
        }

        public void addAll(Collection<Long> ids) {
            if (null != ids && !ids.isEmpty()) {
                this.assistIds.addAll(ids);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BookScope bookScope = (BookScope)o;
            return this.orgId == bookScope.orgId && this.bookTypeId == bookScope.bookTypeId;
        }

        public int hashCode() {
            return Objects.hash(this.orgId, this.bookTypeId);
        }

        public String toString() {
            return "BookScope{orgId=" + this.orgId + ", bookTypeId=" + this.bookTypeId + ", startPeriod=" + this.startPeriod + ", endPeriod=" + this.endPeriod + ", assistIds=" + this.assistIds + '}';
        }
    }
}

