/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;

public class ACAccountCheckHelper {
    public static void createAccountancyTypeColumns(List<AbstractReportColumn> reportColumns, FilterInfo filterInfo) {
        for (FilterItemInfo itemInfo : filterInfo.getFlexFilterItems()) {
            String displayProperty = "2";
            FlexProperty flexProp = FlexEntityMetaUtils.getFlexProperty((String)itemInfo.getPropName());
            if (flexProp == null) continue;
            ReportColumn column = null;
            if ("3".equals(flexProp.getValueType())) {
                column = new ReportColumn();
                column.setFieldType("text");
                column.setCaption(flexProp.getName());
                column.setFieldKey(itemInfo.getPropName());
                reportColumns.add((AbstractReportColumn)column);
                continue;
            }
            if (flexProp == null) continue;
            displayProperty = flexProp.getDisplayStyle().getDisplayProperty().getValue();
            if ("1".equals(displayProperty)) {
                ACAccountCheckHelper.addNumberColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE);
                continue;
            }
            if ("2".equals(displayProperty) || null == displayProperty) {
                ACAccountCheckHelper.addNameColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE);
                continue;
            }
            if (!"3".equals(displayProperty)) continue;
            ACAccountCheckHelper.addNameAndNumberColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE);
        }
    }

    private static void addNameColumn(List<AbstractReportColumn> reportColumns, FilterItemInfo itemInfo, FlexProperty flexProp, Boolean isHide) {
        ReportColumn column = null;
        if ("1".equals(flexProp.getValueType()) && flexProp.getValueSource() != null) {
            column = ReportColumn.createBaseDataColumn((String)itemInfo.getPropName(), (String)flexProp.getValueSource());
        } else if ("2".equals(flexProp.getValueType()) && flexProp.getAssistantType() != null) {
            column = ReportColumn.createBaseDataColumn((String)itemInfo.getPropName(), (String)"bos_assistantdata_detail");
        }
        if (column != null) {
            column.setCaption(flexProp.getName());
            column.setHide(isHide.booleanValue());
            reportColumns.add((AbstractReportColumn)column);
        }
    }

    private static void addNumberColumn(List<AbstractReportColumn> reportColumns, FilterItemInfo itemInfo, FlexProperty flexProp, Boolean isHide) {
        ReportColumn column = null;
        if ("1".equals(flexProp.getValueType()) && flexProp.getValueSource() != null) {
            column = ReportColumn.createBaseDataColumn((String)itemInfo.getPropName(), (String)flexProp.getValueSource());
            column.setDisplayProp("number");
        } else if ("2".equals(flexProp.getValueType()) && flexProp.getAssistantType() != null) {
            column = ReportColumn.createBaseDataColumn((String)itemInfo.getPropName(), (String)"bos_assistantdata_detail");
            column.setDisplayProp("number");
        }
        if (column != null) {
            column.setCaption(flexProp.getName());
            column.setHide(isHide.booleanValue());
            reportColumns.add((AbstractReportColumn)column);
        }
    }

    private static void addNameAndNumberColumn(List<AbstractReportColumn> reportColumns, FilterItemInfo itemInfo, FlexProperty flexProp, Boolean isHide) {
        ReportColumn column = null;
        if ("1".equals(flexProp.getValueType()) && flexProp.getValueSource() != null) {
            column = new ReportColumn();
            column.setFieldType("text");
            column.setFieldKey(itemInfo.getPropName() + ".number");
            column.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"ACAccountCheckHelper_0", (String)"fi-gl-common", (Object[])new Object[0]), flexProp.getName())));
            column.setHide(isHide.booleanValue());
            reportColumns.add((AbstractReportColumn)column);
            column = ReportColumn.createBaseDataColumn((String)itemInfo.getPropName(), (String)flexProp.getValueSource());
        } else if ("2".equals(flexProp.getValueType()) && flexProp.getAssistantType() != null) {
            column = new ReportColumn();
            column.setCaption(flexProp.getName());
            column.setHide(isHide.booleanValue());
            reportColumns.add((AbstractReportColumn)column);
            column = new ReportColumn();
            column.setFieldType("basedata");
            column.setFieldKey(itemInfo.getPropName());
            column.setDisplayProp("number");
            column.setEntityId("bos_assistantdata_detail");
            column = ReportColumn.createBaseDataColumn((String)itemInfo.getPropName(), (String)"bos_assistantdata_detail");
        }
        if (column != null) {
            column.setCaption(flexProp.getName());
            column.setHide(isHide.booleanValue());
            reportColumns.add((AbstractReportColumn)column);
        }
    }
}

