/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.util.BaseDataUtil;

public class AccountBookHelper {
    private static final AccountBookHelper instance = new AccountBookHelper();
    private static final Log LOGGER = LogFactory.getLog(AccountBookHelper.class);
    private static String ORG = "org";
    private static String ORG_ID = "org_id";
    private static String BOOKSTYPE_ID = "bookstype_id";

    public static AccountBookHelper get() {
        return instance;
    }

    private AccountBookHelper() {
    }

    public static boolean checkAccountBookIsRefered(Object bookId) {
        DynamicObject dataObj = BusinessDataServiceHelper.loadSingle((Object)bookId, (String)"gl_accountbook");
        Object idValue = dataObj.getPkValue();
        String entityName = dataObj.getDataEntityType().getName();
        boolean isRefered = AccountBookHelper.checkVoucherRef(dataObj);
        if (isRefered) {
            return isRefered;
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        BasedataEntityType basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        List<BaseDataRefenceKey> refKeys = BaseDataUtil.getAllRefKeys(basedataEntityType);
        List voucherEntityKeyList = refKeys.stream().filter(baseDataRefenceKey -> "t_gl_voucher".equalsIgnoreCase(baseDataRefenceKey.getRefTable())).map(BaseDataRefenceKey::getRefEntityKey).collect(Collectors.toList());
        checker.getIgnoreRefEntityIds().addAll(voucherEntityKeyList);
        BaseDataCheckRefrenceResult refrenceResult = checker.checkRef(basedataEntityType, idValue);
        if (refrenceResult.isRefence()) {
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
            String billName = refMainType.getDisplayName().toString();
            String fieldName = refrenceResult.getRefenceKey().getRefCol();
            for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                if (!(property instanceof IFieldHandle) || !StringUtils.equals((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) continue;
                fieldName = ((IFieldHandle)property).getDisplayName().toString();
                break;
            }
            return true;
        }
        return false;
    }

    public static boolean checkAccountBookIsRefered(DynamicObject dataObj) {
        Object idValue = dataObj.getPkValue();
        String entityName = dataObj.getDataEntityType().getName();
        if (AccountBookHelper.checkVoucherAmortachemeRef(dataObj) || AccountBookHelper.checkAdjustexChangeRateRef(dataObj) || AccountBookHelper.checkAutoTransRef(dataObj) || AccountBookHelper.checkVchTemplateRef(dataObj)) {
            return true;
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        BasedataEntityType basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        List<BaseDataRefenceKey> refKeys = BaseDataUtil.getAllRefKeys(basedataEntityType);
        List voucherEntityKeyList = refKeys.stream().filter(baseDataRefenceKey -> "t_gl_voucher".equalsIgnoreCase(baseDataRefenceKey.getRefTable())).map(BaseDataRefenceKey::getRefEntityKey).collect(Collectors.toList());
        checker.getIgnoreRefEntityIds().addAll(voucherEntityKeyList);
        BaseDataCheckRefrenceResult refrenceResult = checker.checkRef(basedataEntityType, idValue);
        if (refrenceResult.isRefence()) {
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
            String billName = refMainType.getDisplayName().toString();
            String fieldName = refrenceResult.getRefenceKey().getRefCol();
            for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                if (!(property instanceof IFieldHandle) || !StringUtils.equals((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) continue;
                fieldName = ((IFieldHandle)property).getDisplayName().toString();
                break;
            }
            if (DebugTrace.enable()) {
                LOGGER.info("\u8d26\u7c3f[{}]\u88ab[{}]\u5b57\u6bb5[{}]\u5f15\u7528", new Object[]{idValue, billName, fieldName});
            }
            return true;
        }
        return false;
    }

    public static boolean checkVoucherRef(DynamicObject dataObj) {
        long orgid = dataObj.getLong("org_id");
        long bookstypeid = dataObj.getLong("bookstype_id");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter bookstypeFilter = new QFilter("booktype", "=", (Object)bookstypeid);
        return QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])new QFilter[]{orgFilter, bookstypeFilter});
    }

    public Map<Key, DynamicObject> queryAcctBooks(List<Long> orgIDS, List<Long> bookTypeID, String selectFields) {
        QFilter orgF = new QFilter("org", "in", orgIDS);
        QFilter bookTypeF = new QFilter("bookstype", "in", bookTypeID);
        StringBuilder fieldsBuilder = new StringBuilder();
        fieldsBuilder.append("org, bookstype");
        if (StringUtils.isNotEmpty((CharSequence)selectFields)) {
            fieldsBuilder.append(",").append(selectFields);
        }
        DynamicObjectCollection acctBookDyos = QueryServiceHelper.query((String)"gl_accountbook", (String)fieldsBuilder.toString(), (QFilter[])new QFilter[]{orgF, bookTypeF});
        HashMap<Key, DynamicObject> res = new HashMap<Key, DynamicObject>(orgIDS.size());
        acctBookDyos.forEach(dyo -> res.put(new Key((DynamicObject)dyo), (DynamicObject)dyo));
        return res;
    }

    public static boolean checkVoucherAmortachemeRef(DynamicObject dataObj) {
        long orgid = dataObj.getLong(ORG_ID);
        long bookstypeid = dataObj.getLong(BOOKSTYPE_ID);
        QFilter orgFilter = new QFilter(ORG, "=", (Object)orgid);
        QFilter bookstypeFilter = new QFilter("accountbooks", "=", (Object)bookstypeid);
        return QueryServiceHelper.exists((String)"gl_voucheramortacheme", (QFilter[])new QFilter[]{orgFilter, bookstypeFilter});
    }

    public static boolean checkAdjustexChangeRateRef(DynamicObject dataObj) {
        long orgid = dataObj.getLong(ORG_ID);
        long bookstypeid = dataObj.getLong(BOOKSTYPE_ID);
        QFilter orgFilter = new QFilter(ORG, "=", (Object)orgid);
        QFilter bookstypeFilter = new QFilter("bookstype", "=", (Object)bookstypeid);
        return QueryServiceHelper.exists((String)"gl_adjustexchangerate", (QFilter[])new QFilter[]{orgFilter, bookstypeFilter});
    }

    public static boolean checkAutoTransRef(DynamicObject dataObj) {
        long orgid = dataObj.getLong(ORG_ID);
        long bookstypeid = dataObj.getLong(BOOKSTYPE_ID);
        QFilter orgFilter = new QFilter(ORG, "=", (Object)orgid);
        QFilter bookstypeFilter = new QFilter("bookstype", "=", (Object)bookstypeid);
        return QueryServiceHelper.exists((String)"gl_autotrans", (QFilter[])new QFilter[]{orgFilter, bookstypeFilter});
    }

    public static boolean checkVchTemplateRef(DynamicObject dataObj) {
        long orgid = dataObj.getLong(ORG_ID);
        long bookstypeid = dataObj.getLong(BOOKSTYPE_ID);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid from  t_ai_vchtemplate  a inner join t_ai_vchbooktypes b on a.fid =b.fid ", new Object[0]);
        sqlBuilder.append(" where  a.forgid = ?", new Object[]{orgid});
        sqlBuilder.append(" and b.fbasedataid =? ", new Object[]{bookstypeid});
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, rs -> rs.next());
    }

    public static String genCacheKey(Object id) {
        return String.format("book_updatelog_%s", id);
    }

    public static class Key {
        public final Long org;
        public final Long bookType;

        public Key(Long org, Long bookType) {
            this.org = org;
            this.bookType = bookType;
        }

        protected Key(DynamicObject acctBookDyo) {
            this.org = acctBookDyo.getLong("org");
            this.bookType = acctBookDyo.getLong("bookstype");
        }

        public String toString() {
            return this.org.toString() + "-" + this.bookType.toString();
        }

        public boolean equals(Object obj) {
            return obj != null && this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return Objects.hash(this.toString());
        }
    }
}

