/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.fi.gl.util.FlexUtils;
import org.apache.commons.lang3.tuple.Triple;

public class AssistEntityQueryHelper {
    private AssistEntityQueryHelper() {
    }

    public static DataSet queryWithORM(String entityNumber, List<String> flexFields, List<QFilter> balanceFilters, List<String> selFields, String orderBy, Distinctable distinctable) {
        Triple<MainEntityType, List<QFilter>, List<String>> triple = FlexUtils.buildDynamicORMAssistOnBalance(flexFields, entityNumber, true);
        return AssistEntityQueryHelper.getDataSet(entityNumber, balanceFilters, selFields, orderBy, distinctable, triple);
    }

    public static DataSet queryWithORM(String entityNumber, Map<String, Set<Long>> flexFieldToValues, List<QFilter> balanceFilters, List<String> selFields, String orderBy, Distinctable distinctable) {
        Map<String, FlexProperty> propInfos = FlexUtils.batchGetFlexProperty(flexFieldToValues.keySet().toArray(new String[0]));
        ArrayList<FlexUtils.AssistFilterEntry> assistFilterItems = new ArrayList<FlexUtils.AssistFilterEntry>(flexFieldToValues.size());
        flexFieldToValues.forEach((k, v) -> assistFilterItems.add(new FlexUtils.AssistFilterEntry((String)k, (Set<Object>)new HashSet<Object>((Collection<Object>)v), (FlexProperty)propInfos.get(k))));
        Triple<MainEntityType, List<QFilter>, List<String>> triple = FlexUtils.buildDynamicORMAssistOnBalance(assistFilterItems, entityNumber, true);
        return AssistEntityQueryHelper.getDataSet(entityNumber, balanceFilters, selFields, orderBy, distinctable, triple);
    }

    private static DataSet getDataSet(String entityNumber, List<QFilter> balanceFilters, List<String> selFields, String orderBy, Distinctable distinctable, Triple<MainEntityType, List<QFilter>, List<String>> triple) {
        ORM orm = ORM.create();
        orm.setDataEntityType(entityNumber, (IDataEntityType)triple.getLeft());
        ArrayList<QFilter> filters = new ArrayList<QFilter>((Collection)triple.getMiddle());
        filters.addAll(balanceFilters);
        ((List)triple.getRight()).addAll(selFields);
        return orm.queryDataSet(AssistEntityQueryHelper.class.getName() + "#queryWithORM", entityNumber, Joiner.on((String)",").join((Iterable)triple.getRight()), filters.toArray(new QFilter[0]), orderBy, -1, distinctable);
    }
}

