/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.util.GLUtil;

public class BalanceCheckHelper {
    private static final String FIELD = String.join((CharSequence)",", "id", "period", "endperiod", "beginqty", "beginfor", "beginlocal", "debitqty", "debitfor", "debitlocal", "creditqty", "creditfor", "creditlocal", "yeardebitqty", "yeardebitfor", "yeardebitlocal", "yearcreditqty", "yearcreditfor", "yearcreditlocal", "endqty", "endfor", "endlocal");
    private static final Log logger = LogFactory.getLog(BalanceCheckHelper.class);
    private static String BAL = "SELECT b.forgid,b.fbooktypeid,b.fperiodid,b.faccountid,b.FASSGRPID,b.fcurrencyid,b.fmeasureunitid,sum(b.FDEBITLOCAL) fdebitlocal,sum(b.fcreditlocal) fcreditlocal FROM t_gl_balance b where b.forgid=? and b.fbooktypeid=? and b.fperiodid=? group by b.forgid,b.fbooktypeid,b.fperiodid,b.faccountid, b.FASSGRPID, b.FCURRENCYID,b.fmeasureunitid";
    private static String VCH = "SELECT v.forgid,v.fbooktypeid,v.fperiodid,av.fmasterid FACCOUNTID, ve.FASSGRPID, ve.FCURRENCYID,ve.fmeasureunitid,sum(ve.FLOCALDEBIT) FLOCALDEBIT,sum(ve.FLOCALCREDIT) FLOCALCREDIT FROM t_gl_voucher v INNER JOIN t_gl_voucherentry ve ON v.fid = ve.fid inner join t_bd_account av on av.fid=ve.faccountid WHERE v.FBILLSTATUS IN ('B','C')  and v.forgid= ? and v.fbooktypeid= ? and v.fperiodid=? and ve.forgid= ? and ve.fperiodid=? group by v.forgid,v.fbooktypeid,v.fperiodid,av.fmasterid, ve.FASSGRPID, ve.FCURRENCYID,ve.fmeasureunitid";

    public static DynamicObjectCollection getAllBooks(QFilter forg) {
        QFilter fisbizunit = new QFilter("isbizunit", "=", (Object)"1");
        if (forg != null) {
            fisbizunit = fisbizunit.and(forg);
        }
        DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org,startperiod,curperiod,cashinitperiod,bookstype,isendinit,accounttable,basecurrency", (QFilter[])new QFilter[]{fisbizunit});
        return col;
    }

    public static DynamicObjectCollection getBizBook(Set<Long> orgIds) {
        DynamicObjectCollection col = null;
        DynamicObjectCollection verorg = QueryServiceHelper.query((String)"gl_book_version", (String)"org", null, null);
        HashSet verOrgIds = new HashSet(verorg.size());
        verorg.forEach(x -> verOrgIds.add(x.getLong("org")));
        if (orgIds != null && !orgIds.isEmpty()) {
            orgIds.removeAll(verOrgIds);
            QFilter forg = new QFilter("org", "in", orgIds);
            col = BalanceCheckHelper.getAllBooks(forg);
        } else if (verOrgIds.isEmpty()) {
            col = BalanceCheckHelper.getAllBooks(null);
        } else {
            QFilter forg = new QFilter("org", "not in", verOrgIds);
            col = BalanceCheckHelper.getAllBooks(forg);
        }
        return col;
    }

    private static String buildAcctKey(Row row) {
        return row.getLong("org") + "-" + row.getLong("booktype") + "-" + row.getLong("account") + "-" + row.getLong("comassist1") + "-" + row.getLong("comassist2") + "-" + row.getLong("assgrp") + "-" + row.getLong("currency") + "-" + row.getLong("measureunit");
    }

    private static String buildCfKey(Row row) {
        return row.getLong("org") + "-" + row.getLong("booktype") + "-" + row.getLong("comassist1") + "-" + row.getLong("comassist2") + "-" + row.getLong("cfitem") + "-" + row.getLong("assgrp") + "-" + row.getLong("currency");
    }

    public static List<String> checkBalPeriod(long orgId, long btId, long startperiod, long endperiodid) {
        QFilter fb = new QFilter("id", ">=", (Object)startperiod);
        QFilter fe = new QFilter("id", "<=", (Object)endperiodid);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fb, fe}, (String)"id");
        ArrayList<String> err = new ArrayList<String>(100);
        for (DynamicObject period : periods) {
            DataSet ds = BalanceCheckHelper.queryBal(orgId, btId, period.getLong("id"));
            Throwable throwable = null;
            try {
                for (Row row : ds) {
                    BigDecimal bDebit = row.getBigDecimal("fdebitlocal");
                    BigDecimal bCredit = row.getBigDecimal("fcreditlocal");
                    BigDecimal vDebit = row.getBigDecimal("flocaldebit");
                    BigDecimal vCredit = row.getBigDecimal("flocalcredit");
                    if (!(bDebit.compareTo(BigDecimal.ZERO) != 0 && vDebit == null || bCredit.compareTo(BigDecimal.ZERO) != 0 && vCredit == null || vDebit != null && bDebit.compareTo(vDebit) != 0) && (vCredit == null || bCredit.compareTo(vCredit) == 0)) continue;
                    String key = String.format("select * from t_gl_balance where fperiodid=%s and forgid=%s and fbooktypeid=%s and faccountid=%s and fassgrpid=%s;", row.getLong("fperiodid"), row.getLong("forgid"), row.getLong("fbooktypeid"), row.getLong("faccountid"), row.getLong("fassgrpid"));
                    err.add(key);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return err;
    }

    private static DataSet queryBal(long orgId, long btId, long periodId) {
        DataSet bal = DB.queryDataSet((String)"kd.fi.gl.common.BalanceCheckTask", (DBRoute)DBRoute.of((String)"gl"), (String)BAL, (Object[])new Object[]{orgId, btId, periodId});
        DataSet vch = DB.queryDataSet((String)"kd.fi.gl.common.BalanceCheckTask", (DBRoute)DBRoute.of((String)"gl"), (String)VCH, (Object[])new Object[]{orgId, btId, periodId, orgId, periodId});
        bal = bal.leftJoin(vch).on("forgid", "forgid").on("fbooktypeid", "fbooktypeid").on("fperiodid", "fperiodid").on("faccountid", "faccountid").on("fassgrpid", "fassgrpid").on("fcurrencyid", "fcurrencyid").on("fmeasureunitid", "fmeasureunitid").select(new String[]{"forgid", "fbooktypeid", "faccountid", "fassgrpid", "fcurrencyid", "fmeasureunitid", "fdebitlocal", "fcreditlocal", "fperiodid"}, new String[]{"flocaldebit", "flocalcredit"}).finish();
        return bal;
    }

    private static Map<String, Map<String, BigDecimal>> getBalInitData(QFilter forg, QFilter fbt) {
        HashMap<String, Map<String, BigDecimal>> map = new HashMap<String, Map<String, BigDecimal>>(100);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"gl_initbalance", (String)"comassist1,comassist2,account.masterid account,currency,assgrp,measureunit,org,booktype,begindebitlocal,begindebitfor,begindebitqty,begincreditlocal,begincreditfor,begincreditqty,yeardebitlocal,yeardebitfor,yeardebitqty,yearcreditlocal,yearcreditfor,yearcreditqty", (QFilter[])new QFilter[]{fbt, forg}, null);){
            for (Row row : ds) {
                String key = BalanceCheckHelper.buildAcctKey(row);
                HashMap<String, BigDecimal> map1 = new HashMap<String, BigDecimal>(10);
                map1.put("beginlocal", row.getBigDecimal("begindebitlocal").subtract(row.getBigDecimal("begincreditlocal")));
                map1.put("beginfor", row.getBigDecimal("begindebitfor").subtract(row.getBigDecimal("begincreditfor")));
                map1.put("beginqty", row.getBigDecimal("begindebitqty").subtract(row.getBigDecimal("begincreditqty")));
                map1.put("yeardebitlocal", row.getBigDecimal("yeardebitlocal"));
                map1.put("yearcreditlocal", row.getBigDecimal("yearcreditlocal"));
                map1.put("yeardebitqty", row.getBigDecimal("yeardebitqty"));
                map1.put("yearcreditqty", row.getBigDecimal("yearcreditqty"));
                map1.put("yeardebitfor", row.getBigDecimal("yeardebitfor"));
                map1.put("yearcreditfor", row.getBigDecimal("yearcreditfor"));
                map.put(key, map1);
            }
        }
        return map;
    }

    private static Map<String, BigDecimal> getCFInitData(QFilter forg, QFilter fbt) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(100);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"gl_initcashflow", (String)"comassist1,comassist2,cfitem.masterid cfitem,assgrp,currency,org,booktype,yearamount", (QFilter[])new QFilter[]{fbt, forg}, null);){
            for (Row row : ds) {
                String key = BalanceCheckHelper.buildCfKey(row);
                map.put(key, row.getBigDecimal("yearamount"));
            }
        }
        return map;
    }

    public static List<String> getAcctBalErrData(DynamicObjectCollection books, boolean isFix) {
        List<String> result = BalanceCheckHelper.printLog(() -> {
            String sel = "org,booktype,comassist1,comassist2,period,endperiod,accounttable,account,assgrp,currency,measureunit,beginfor,beginlocal,debitfor,debitlocal,creditfor,creditlocal,yeardebitfor,yeardebitlocal,yearcreditfor,yearcreditlocal,endfor,endlocal";
            String orderBy = "org,booktype,comassist1,comassist2,account,assgrp,currency,measureunit,period";
            ArrayList<String> err = new ArrayList<String>(100);
            for (DynamicObject obj : books) {
                LockKey lockKey;
                long btId;
                long orgId = obj.getLong("org");
                boolean getLock = Lock.tryLock(orgId, btId = obj.getLong("bookstype"), lockKey = LockKey.BalanceCal, () -> {
                    QFilter forg = new QFilter("org", "=", (Object)orgId);
                    QFilter fbt = new QFilter("booktype", "=", (Object)btId);
                    long startperiod = obj.getLong("startperiod");
                    boolean isEndInit = obj.getBoolean("isendinit");
                    Map<String, Map<String, BigDecimal>> initData = BalanceCheckHelper.getBalInitData(forg, fbt);
                    try (DataSet ds = QueryServiceHelper.queryDataSet((String)"checkallbal", (String)"gl_balance", (String)sel, (QFilter[])new QFilter[]{forg, fbt}, (String)orderBy);){
                        String key = "";
                        String lastKey = "";
                        boolean check = false;
                        BigDecimal endLocal = BigDecimal.ZERO;
                        BigDecimal yearDL = BigDecimal.ZERO;
                        BigDecimal yearCL = BigDecimal.ZERO;
                        long prePid = 0L;
                        long preEndPid = 0L;
                        for (Row row : ds) {
                            block24: {
                                long period;
                                block22: {
                                    Map<String, BigDecimal> re;
                                    block25: {
                                        block23: {
                                            key = BalanceCheckHelper.buildAcctKey(row);
                                            period = row.getLong("period");
                                            if (key.equals(lastKey)) break block22;
                                            if (!StringUtils.isEmpty((String)lastKey) && !isFix && preEndPid != GLUtil.MAX_PERIOD) {
                                                err.add(lastKey);
                                            }
                                            check = false;
                                            lastKey = key;
                                            if (period == startperiod) break block23;
                                            if (row.getBigDecimal("beginlocal").compareTo(BigDecimal.ZERO) != 0 || row.getBigDecimal("creditlocal").compareTo(row.getBigDecimal("yearcreditlocal")) != 0 || row.getBigDecimal("debitlocal").compareTo(row.getBigDecimal("yeardebitlocal")) != 0) {
                                                check = true;
                                                BalanceCheckHelper.dealAcctBal(err, key, isFix, startperiod, null);
                                                continue;
                                            }
                                            break block24;
                                        }
                                        re = initData.get(key);
                                        if (re != null) break block25;
                                        if (row.getBigDecimal("beginlocal").compareTo(BigDecimal.ZERO) != 0 || row.getBigDecimal("creditlocal").compareTo(row.getBigDecimal("yearcreditlocal")) != 0 || row.getBigDecimal("debitlocal").compareTo(row.getBigDecimal("yeardebitlocal")) != 0) {
                                            check = true;
                                            BalanceCheckHelper.dealAcctBal(err, key, isFix, startperiod, null);
                                            continue;
                                        }
                                        break block24;
                                    }
                                    if (!isEndInit) break block24;
                                    BigDecimal beginlocal = re.get("beginlocal");
                                    BigDecimal yd = re.get("yeardebitlocal");
                                    BigDecimal yc = re.get("yearcreditlocal");
                                    if (row.getBigDecimal("beginlocal").compareTo(beginlocal) != 0 || row.getBigDecimal("debitlocal").add(yd).compareTo(row.getBigDecimal("yeardebitlocal")) != 0 || row.getBigDecimal("creditlocal").add(yc).compareTo(row.getBigDecimal("yearcreditlocal")) != 0) {
                                        check = true;
                                        BalanceCheckHelper.dealAcctBal(err, key, isFix, startperiod, re);
                                        continue;
                                    }
                                    break block24;
                                }
                                lastKey = key;
                                if (check) {
                                    preEndPid = row.getLong("endperiod");
                                    continue;
                                }
                                if (row.getBigDecimal("beginlocal").compareTo(endLocal) != 0 || period != preEndPid) {
                                    BalanceCheckHelper.dealAcctBal(err, key, isFix, startperiod, null);
                                    preEndPid = row.getLong("endperiod");
                                    check = true;
                                    continue;
                                }
                                if (prePid / 10000L == period / 10000L && (row.getBigDecimal("debitlocal").add(yearDL).compareTo(row.getBigDecimal("yeardebitlocal")) != 0 || row.getBigDecimal("creditlocal").add(yearCL).compareTo(row.getBigDecimal("yearcreditlocal")) != 0)) {
                                    BalanceCheckHelper.dealAcctBal(err, key, isFix, startperiod, null);
                                    preEndPid = row.getLong("endperiod");
                                    check = true;
                                    continue;
                                }
                                if (prePid / 10000L != period / 10000L && (row.getBigDecimal("debitlocal").compareTo(row.getBigDecimal("yeardebitlocal")) != 0 || row.getBigDecimal("creditlocal").compareTo(row.getBigDecimal("yearcreditlocal")) != 0)) {
                                    BalanceCheckHelper.dealAcctBal(err, key, isFix, startperiod, null);
                                    preEndPid = row.getLong("endperiod");
                                    check = true;
                                    continue;
                                }
                            }
                            yearDL = row.getBigDecimal("yeardebitlocal");
                            yearCL = row.getBigDecimal("yearcreditlocal");
                            endLocal = row.getBigDecimal("endlocal");
                            preEndPid = row.getLong("endperiod");
                            prePid = row.getLong("period");
                            lastKey = key;
                        }
                    }
                });
                if (getLock) continue;
                err.add(String.format("acquire lock fi/gl/%s/%s-%s fail-", new Object[]{lockKey, orgId, btId}));
            }
            return err;
        }, isFix);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> printLog(Supplier<List<String>> func, boolean isFix) {
        long time = System.currentTimeMillis();
        ArrayList<String> err = new ArrayList(1);
        try {
            ArrayList<String> arrayList = err = func.get();
            return arrayList;
        }
        finally {
            long cost;
            if (!isFix && (cost = System.currentTimeMillis() - time) > 60000L) {
                logger.info("check result:" + BalanceCheckHelper.transfer(err));
            }
        }
    }

    private static String transfer(List<String> list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String obj : list) {
            sb.append(obj.toString()).append(",");
            if (++i <= 100) continue;
            break;
        }
        return sb.toString();
    }

    private static void dealAcctBal(List<String> err, String key, boolean isFix, long startperiod, Map<String, BigDecimal> initData) {
        if (isFix) {
            BalanceCheckHelper.fixAcctBal(key, initData, startperiod);
        } else {
            err.add(key);
        }
    }

    private static void fixAcctBal(String key, Map<String, BigDecimal> initData, long startperiod) {
        String[] keys = key.split("-");
        QFilter[] filter = new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(keys[0])), new QFilter("booktype", "=", (Object)Long.parseLong(keys[1])), new QFilter("account", "=", (Object)Long.parseLong(keys[2])), new QFilter("comassist1", "=", (Object)Long.parseLong(keys[3])), new QFilter("comassist2", "=", (Object)Long.parseLong(keys[4])), new QFilter("assgrp", "=", (Object)Long.parseLong(keys[5])), new QFilter("currency", "=", (Object)Long.parseLong(keys[6])), new QFilter("measureunit", "=", (Object)Long.parseLong(keys[7]))};
        try (DataSet balSet = QueryServiceHelper.queryDataSet((String)"fixAcctBal", (String)"gl_balance", (String)FIELD, (QFilter[])filter, (String)"endperiod");){
            BigDecimal endfor = BigDecimal.ZERO;
            BigDecimal endqty = BigDecimal.ZERO;
            BigDecimal endlocal = BigDecimal.ZERO;
            BigDecimal ydq = BigDecimal.ZERO;
            BigDecimal ydf = BigDecimal.ZERO;
            BigDecimal ydl = BigDecimal.ZERO;
            BigDecimal ycq = BigDecimal.ZERO;
            BigDecimal ycf = BigDecimal.ZERO;
            BigDecimal ycl = BigDecimal.ZERO;
            boolean isFirst = true;
            String updateSql = "update t_gl_balance set fbeginqty=?,fbeginfor=?,fbeginlocal=?,fyeardebitqty=?,fyeardebitfor=?,fyeardebitlocal=?,fyearcreditqty=?,fyearcreditfor=?,fyearcreditlocal=?,fendqty=?,fendfor=?,fendlocal=? where fid=?";
            ArrayList<Object[]> params = new ArrayList<Object[]>(100);
            long lastPeriodId = startperiod;
            for (Row row : balSet) {
                Object[] param = new Object[13];
                long periodId = row.getLong("period");
                if (isFirst) {
                    isFirst = false;
                    if (periodId == startperiod) {
                        if (initData != null) {
                            endfor = initData.get("beginfor");
                            endqty = initData.get("beginqty");
                            endlocal = initData.get("beginlocal");
                            ydq = row.getBigDecimal("debitqty").add(initData.get("yeardebitqty"));
                            ydf = row.getBigDecimal("debitfor").add(initData.get("yeardebitfor"));
                            ydl = row.getBigDecimal("debitlocal").add(initData.get("yeardebitlocal"));
                            ycq = row.getBigDecimal("creditqty").add(initData.get("yearcreditqty"));
                            ycf = row.getBigDecimal("creditfor").add(initData.get("yearcreditfor"));
                            ycl = row.getBigDecimal("creditlocal").add(initData.get("yearcreditlocal"));
                        } else {
                            ydq = row.getBigDecimal("debitqty");
                            ydf = row.getBigDecimal("debitfor");
                            ydl = row.getBigDecimal("debitlocal");
                            ycq = row.getBigDecimal("creditqty");
                            ycf = row.getBigDecimal("creditfor");
                            ycl = row.getBigDecimal("creditlocal");
                        }
                    } else {
                        ydq = row.getBigDecimal("debitqty");
                        ydf = row.getBigDecimal("debitfor");
                        ydl = row.getBigDecimal("debitlocal");
                        ycq = row.getBigDecimal("creditqty");
                        ycf = row.getBigDecimal("creditfor");
                        ycl = row.getBigDecimal("creditlocal");
                    }
                } else {
                    boolean isCurrYear;
                    boolean bl = isCurrYear = periodId / GLUtil.YEAR_PERIOD_L == lastPeriodId / GLUtil.YEAR_PERIOD_L;
                    if (isCurrYear) {
                        ydq = row.getBigDecimal("debitqty").add(ydq);
                        ydf = row.getBigDecimal("debitfor").add(ydf);
                        ydl = row.getBigDecimal("debitlocal").add(ydl);
                        ycq = row.getBigDecimal("creditqty").add(ycq);
                        ycf = row.getBigDecimal("creditfor").add(ycf);
                        ycl = row.getBigDecimal("creditlocal").add(ycl);
                    } else {
                        ydq = row.getBigDecimal("debitqty");
                        ydf = row.getBigDecimal("debitfor");
                        ydl = row.getBigDecimal("debitlocal");
                        ycq = row.getBigDecimal("creditqty");
                        ycf = row.getBigDecimal("creditfor");
                        ycl = row.getBigDecimal("creditlocal");
                    }
                }
                lastPeriodId = periodId;
                param[0] = endqty;
                param[1] = endfor;
                param[2] = endlocal;
                param[3] = ydq;
                param[4] = ydf;
                param[5] = ydl;
                param[6] = ycq;
                param[7] = ycf;
                param[8] = ycl;
                endqty = endqty.add(row.getBigDecimal("debitqty")).subtract(row.getBigDecimal("creditqty"));
                endfor = endfor.add(row.getBigDecimal("debitfor")).subtract(row.getBigDecimal("creditfor"));
                endlocal = endlocal.add(row.getBigDecimal("debitlocal")).subtract(row.getBigDecimal("creditlocal"));
                param[9] = endqty;
                param[10] = endfor;
                param[11] = endlocal;
                param[12] = row.getLong("id");
                params.add(param);
            }
            if (!params.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateSql, params);
            }
        }
    }

    public static List<String> getCfBalErrData(DynamicObjectCollection books, boolean isFix) {
        List<String> result = BalanceCheckHelper.printLog(() -> {
            ArrayList<String> err = new ArrayList<String>(100);
            String sel = "org,booktype,comassist1,comassist2,period,endperiod,cfitem,assgrp,currency,amount,yearamount";
            String orderBy = "org,booktype,comassist1,comassist2,cfitem,assgrp,currency,period";
            for (DynamicObject obj : books) {
                LockKey lockKey;
                long btId;
                long orgId = obj.getLong("org");
                boolean getLock = Lock.tryLock(orgId, btId = obj.getLong("bookstype"), lockKey = LockKey.CashflowCal, () -> {
                    long startperiod = obj.getLong("cashinitperiod") == 0L ? obj.getLong("startperiod") : obj.getLong("cashinitperiod");
                    QFilter forg = new QFilter("org", "=", (Object)orgId);
                    QFilter fbt = new QFilter("booktype", "=", (Object)btId);
                    QFilter fperiod = new QFilter("period", ">=", (Object)startperiod);
                    Map<String, BigDecimal> initData = BalanceCheckHelper.getCFInitData(forg, fbt);
                    try (DataSet ds = QueryServiceHelper.queryDataSet((String)"checkallbal", (String)"gl_cashflow", (String)sel, (QFilter[])new QFilter[]{forg, fbt, fperiod}, (String)orderBy);){
                        String key = "";
                        String lastKey = "";
                        boolean check = false;
                        BigDecimal yearLocal = BigDecimal.ZERO;
                        long preEndPid = 0L;
                        long prePid = 0L;
                        for (Row row : ds) {
                            long period;
                            key = BalanceCheckHelper.buildCfKey(row);
                            if (!key.equals(lastKey)) {
                                if (!StringUtils.isEmpty((String)lastKey) && !isFix && preEndPid != GLUtil.MAX_PERIOD) {
                                    err.add(lastKey);
                                }
                                check = false;
                                period = row.getLong("period");
                                lastKey = key;
                                if (period != startperiod) {
                                    if (row.getBigDecimal("amount").compareTo(row.getBigDecimal("yearamount")) != 0) {
                                        check = true;
                                        BalanceCheckHelper.dealCfbal(err, key, null, isFix, startperiod);
                                        continue;
                                    }
                                } else {
                                    BigDecimal re = initData.get(key);
                                    if (re == null) {
                                        if (row.getBigDecimal("amount").compareTo(row.getBigDecimal("yearamount")) != 0) {
                                            check = true;
                                            BalanceCheckHelper.dealCfbal(err, key, null, isFix, startperiod);
                                            continue;
                                        }
                                    } else if (row.getBigDecimal("amount").add(re).compareTo(row.getBigDecimal("yearamount")) != 0) {
                                        check = true;
                                        BalanceCheckHelper.dealCfbal(err, key, re, isFix, startperiod);
                                        continue;
                                    }
                                }
                                yearLocal = row.getBigDecimal("yearamount");
                                preEndPid = row.getLong("endperiod");
                                prePid = row.getLong("period");
                                continue;
                            }
                            lastKey = key;
                            if (check) {
                                preEndPid = row.getLong("endperiod");
                                continue;
                            }
                            period = row.getLong("period");
                            if (period != preEndPid) {
                                BalanceCheckHelper.dealCfbal(err, key, null, isFix, startperiod);
                                check = true;
                            } else if (prePid / 10000L == period / 10000L && row.getBigDecimal("amount").add(yearLocal).compareTo(row.getBigDecimal("yearamount")) != 0) {
                                BalanceCheckHelper.dealCfbal(err, key, null, isFix, startperiod);
                                check = true;
                            } else if (prePid / 10000L != period / 10000L && row.getBigDecimal("amount").compareTo(row.getBigDecimal("yearamount")) != 0) {
                                BalanceCheckHelper.dealCfbal(err, key, null, isFix, startperiod);
                                check = true;
                            }
                            yearLocal = row.getBigDecimal("yearamount");
                            preEndPid = row.getLong("endperiod");
                            prePid = row.getLong("period");
                            lastKey = key;
                        }
                        if (!isFix && preEndPid != 0L && preEndPid != GLUtil.MAX_PERIOD) {
                            err.add(lastKey);
                        }
                    }
                });
                if (getLock) continue;
                err.add(String.format("acquire lock fi/gl/%s/%s-%s fail-", new Object[]{lockKey, orgId, btId}));
            }
            return err;
        }, isFix);
        return result;
    }

    private static void dealCfbal(List<String> err, String key, BigDecimal initYearBal, boolean isFix, long startperiodid) {
        if (isFix) {
            BalanceCheckHelper.fixCfBal(key, initYearBal, startperiodid);
        } else {
            err.add(key);
        }
    }

    private static void fixCfBal(String key, BigDecimal initYearBal, long startperiod) {
        String[] keys = key.split("-");
        String updateSql = "update t_gl_cashflow set fyearamount=? where fid = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(100);
        String sql = "select fid,fperiodid,fendperiodid,famount,fyearamount from t_gl_cashflow where forgid=? and fbooktypeid=? and fcfitemid=? and fassgrpid=? and fcurrencyid=? and fperiodid>= ? and fcomassist1=? and fcomassist2=? order by fendperiodid";
        try (DataSet balSet = DB.queryDataSet((String)"fixCfBal", (DBRoute)DBRoute.of((String)"gl"), (String)sql, (Object[])new Object[]{Long.parseLong(keys[0]), Long.parseLong(keys[1]), Long.parseLong(keys[4]), Long.parseLong(keys[5]), Long.parseLong(keys[6]), startperiod, Long.parseLong(keys[2]), Long.parseLong(keys[3])});){
            boolean isFirst = true;
            BigDecimal yearamount = BigDecimal.ZERO;
            long lastPeriodid = startperiod;
            for (Row row : balSet) {
                long periodId = row.getLong("fperiodid");
                if (isFirst) {
                    isFirst = false;
                    yearamount = startperiod == periodId ? (initYearBal != null ? row.getBigDecimal("famount").add(initYearBal) : row.getBigDecimal("famount")) : row.getBigDecimal("famount");
                } else {
                    boolean isCurrYear = periodId / GLUtil.YEAR_PERIOD_L == lastPeriodid / GLUtil.YEAR_PERIOD_L;
                    yearamount = isCurrYear ? row.getBigDecimal("famount").add(yearamount) : row.getBigDecimal("famount");
                }
                params.add(new Object[]{yearamount, row.getLong("fid")});
                lastPeriodid = periodId;
            }
            if (!params.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateSql, params);
            }
        }
    }

    public static Long getMaxVchPeriodId(long orgId, long btId, long curPid) {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select max(fperiodid) endperiod from t_gl_balance where forgid=? and fbooktypeid=?", (Object[])new Object[]{orgId, btId}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getLong("endperiod");
            }
            return curPid;
        });
    }

    public static Long getMaxCFPeriodId(long orgId, long btId, long curPid) {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select max(fperiodid) endperiod from t_gl_cashflow where forgid=? and fbooktypeid=?", (Object[])new Object[]{orgId, btId}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getLong("endperiod");
            }
            return curPid;
        });
    }

    public static List<String> checkCfitemFlow(long orgId, long btId, long baseCurrencyId, long periodId) {
        ArrayList<String> err = new ArrayList<String>(100);
        DBRoute route = DBRoute.of((String)"gl");
        String mainSql = "SELECT v.forgid,v.fbooktypeid,v.fperiodid,cfi.fmasterid fcfitemid,ve.fmaincfassgrpid fassgrpid,sum(ve.fmaincfamount) famount  FROM t_gl_voucher v INNER JOIN t_gl_voucherentry ve ON v.fid = ve.fid INNER JOIN t_gl_cashflowitem cfi ON cfi.fid=ve.fmaincfitemid  WHERE v.forgid = ? and v.fbooktypeid = ? and v.fperiodid=? and v.fbillstatus in ('B','C') group by v.forgid,fbooktypeid,v.fperiodid,cfi.fmasterid,fmaincfassgrpid";
        DataSet main = DB.queryDataSet((String)"BalanceCheckTask", (DBRoute)route, (String)mainSql, (Object[])new Object[]{orgId, btId, periodId});
        String suppSql = "SELECT v.forgid,v.fbooktypeid,v.fperiodid,cfi.fmasterid fcfitemid, 0 fassgrpid, sum(ve.fsuppcfamount) famount  FROM t_gl_voucher v INNER JOIN t_gl_voucherentry ve ON v.fid = ve.fid INNER JOIN t_gl_cashflowitem cfi ON cfi.fid=ve.fsuppcfitemid  WHERE v.forgid = ? and v.fbooktypeid = ? and v.fperiodid=? and v.fbillstatus in ('B','C') group by v.forgid,fbooktypeid,v.fperiodid,cfi.fmasterid";
        DataSet supp = DB.queryDataSet((String)"BalanceCheckTask", (DBRoute)route, (String)suppSql, (Object[])new Object[]{orgId, btId, periodId});
        DataSet cashProfit = null;
        Long cashProfitId = BalanceCheckHelper.getCashProfit(orgId);
        if (cashProfitId != 0L) {
            String profit = "SELECT v.forgid,v.fbooktypeid,v.fperiodid," + cashProfitId + " fcfitemid, 0 fassgrpid, sum(ve.flocalcredit-ve.flocaldebit) famount  FROM t_gl_voucher v INNER JOIN t_gl_voucherentry ve ON v.fid = ve.fid INNER JOIN t_bd_account ba ON ba.fid=ve.faccountid  INNER JOIN t_bd_accounttype bat ON bat.fid=ba.faccounttypeid  WHERE v.forgid = ? and v.fbooktypeid = ? and v.fperiodid=? and v.fbillstatus in ('B','C') AND v.fsourcetype <> '1' AND bat.faccounttype = '4' group by v.forgid, v.fbooktypeid,v.fperiodid";
            cashProfit = DB.queryDataSet((String)"BalanceCheckTask", (DBRoute)route, (String)profit, (Object[])new Object[]{orgId, btId, periodId});
        }
        DataSet all = main.union(supp);
        if (cashProfit != null) {
            all = all.union(cashProfit);
        }
        String caslBal = "SELECT b.forgid,b.fbooktypeid,b.fassgrpid, b.fcfitemid,b.fperiodid, sum(b.famount) bamt FROM t_gl_cashflow b where b.forgid =? and b.fbooktypeid=? and b.fperiodid=? group by b.forgid,b.fbooktypeid,b.fperiodid,b.fcfitemid,b.fassgrpid";
        DataSet cashBalSet = DB.queryDataSet((String)"kd.fi.gl.common.BalanceCheckTask", (DBRoute)route, (String)caslBal, (Object[])new Object[]{orgId, btId, periodId});
        DataSet ds = all.join(cashBalSet).on("forgid", "forgid").on("fbooktypeid", "fbooktypeid").on("fperiodid", "fperiodid").on("fcfitemid", "fcfitemid").on("fassgrpid", "fassgrpid").select(new String[]{"forgid", "fbooktypeid", "fcfitemid", "fassgrpid", "fperiodid", "bamt"}, new String[]{"famount"}).finish().filter("bamt <> famount");
        for (Row row : ds) {
            err.add(String.join((CharSequence)"-", row.getString("forgid"), row.getString("fbooktypeid"), row.getString("fcfitemid"), row.getString("fassgrpid"), row.getString("fperiodid")));
        }
        return err;
    }

    private static Long getCashProfit(long orgId) {
        QFilter fid = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        QFilter cashProfitQf = new QFilter("isprefit", "=", (Object)"1");
        DynamicObject cashProfitDb = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_cashflowitem", (QFilter[])new QFilter[]{fid, cashProfitQf});
        if (cashProfitDb != null) {
            return cashProfitDb.getLong("masterid");
        }
        return 0L;
    }
}

