/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.PerformanceMonitor;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.balcal.CalculatorCFs;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.LocalCacheHelper;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.constant.Voucher;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherEntriesSummary;
import kd.fi.gl.util.VoucherSaveValidatorParam;

public class CashFlowItemHelper {
    private static final String CashFlowName = "gl_cashflow_log";
    public static LogFacts logFacts = new LogFacts();
    private static final Log logger = LogFactory.getLog(CashFlowItemHelper.class);
    public static final int DEFAULT_BATCH_SIZE = 1000;

    private CashFlowItemHelper() {
    }

    public static void calBal(Set<String> orgBooktypes) {
        for (String bookId : orgBooktypes) {
            String[] ids = bookId.trim().split("-");
            CalculatorCFs.calculator(Long.parseLong(ids[0]), Long.parseLong(ids[1]), null, CashFlowName, false);
        }
    }

    public static void calculateEntry(DynamicObject vchDyn, boolean localSet) {
        if ("1".equals(vchDyn.getString("sourcetype"))) {
            vchDyn.set("mainstatus", (Object)"0");
            vchDyn.set("suppstatus", (Object)"0");
            return;
        }
        VoucherEntriesSummary result = CashFlowItemHelper.calculateCashFlowOnVch(vchDyn, localSet);
        if (result.isExistsCashAccount()) {
            if (result.isExistsPlAccount()) {
                if (result.isMainCfDesignated()) {
                    if (result.getDesiginatedMainAmt().compareTo(result.getCashAccountDebitTotal()) == 0) {
                        vchDyn.set("mainstatus", (Object)"3");
                    } else {
                        vchDyn.set("mainstatus", (Object)"2");
                    }
                    CashFlowItemHelper.setSuppStatus(vchDyn, result);
                } else {
                    vchDyn.set("mainstatus", (Object)"1");
                    if (localSet) {
                        CashFlowItemHelper.setSuppStatus(vchDyn, result);
                    } else {
                        vchDyn.set("suppstatus", (Object)"0");
                    }
                }
            } else if (result.isExistsNotCachNotPlAccount()) {
                if (result.isMainCfDesignated()) {
                    if (result.getDesiginatedMainAmt().compareTo(result.getCashAccountDebitTotal()) == 0) {
                        vchDyn.set("mainstatus", (Object)"3");
                    } else {
                        vchDyn.set("mainstatus", (Object)"2");
                    }
                } else {
                    vchDyn.set("mainstatus", (Object)"1");
                }
                CashFlowItemHelper.setSuppStatus(vchDyn, result);
            } else {
                vchDyn.set("mainstatus", (Object)"0");
                vchDyn.set("suppstatus", (Object)"0");
            }
        } else if (result.isExistsPlAccount()) {
            vchDyn.set("mainstatus", (Object)"0");
            if (result.isExistsNotCachNotPlAccount()) {
                CashFlowItemHelper.setSuppStatus(vchDyn, result);
            } else {
                vchDyn.set("suppstatus", (Object)"0");
            }
        } else if (result.isExistsNotCachNotPlAccount()) {
            vchDyn.set("mainstatus", (Object)"0");
            if (result.isSuppCfDesignated()) {
                if (result.getDesiginatedSuppAmt().compareTo(BigDecimal.ZERO) == 0) {
                    vchDyn.set("suppstatus", (Object)"c");
                } else {
                    vchDyn.set("suppstatus", (Object)"b");
                }
            } else {
                vchDyn.set("suppstatus", (Object)"a");
            }
        } else {
            vchDyn.set("mainstatus", (Object)"0");
            vchDyn.set("suppstatus", (Object)"0");
        }
        vchDyn.set("vdescription", (Object)result.getVchDesc());
        vchDyn.set("debitlocamount", (Object)result.getDebitLocTotal().getSum());
        vchDyn.set("creditlocamount", (Object)result.getCreditLocTotal().getSum());
    }

    protected static VoucherEntriesSummary calculateCashFlowOnVch(DynamicObject vchDyn, boolean localSet) {
        VoucherEntriesSummary result = new VoucherEntriesSummary();
        DynamicObjectCollection entries = vchDyn.getDynamicObjectCollection("entries");
        if (entries.isEmpty()) {
            return result;
        }
        result.setVchDesc(((DynamicObject)entries.get(0)).getString("edescription").trim());
        for (DynamicObject entry : entries) {
            CashFlowItemHelper.calculateEntry(result, entry, localSet);
        }
        return result;
    }

    protected static void calculateEntry(VoucherEntriesSummary result, DynamicObject entry, boolean localSet) {
        DynamicObject accDyn = entry.getDynamicObject("account");
        if (null == accDyn || AccountType.isBudgetType(accDyn.getLong("accounttype_id"))) {
            return;
        }
        BigDecimal creditLoc = entry.getBigDecimal("creditlocal");
        BigDecimal debitLoc = entry.getBigDecimal("debitlocal");
        result.getDebitLocTotal().accumulate(debitLoc, (Object[])new Object[0]);
        result.getCreditLocTotal().accumulate(creditLoc, (Object[])new Object[0]);
        boolean isCashAcct = GLUtil.isCashAcct(accDyn);
        if (isCashAcct) {
            if (!result.isExistsCashAccount()) {
                result.setExistsCashAccount(true);
            }
            result.setCashAccountDebitTotal(result.getCashAccountDebitTotal().add(debitLoc).subtract(creditLoc));
            if (!localSet) {
                return;
            }
        }
        boolean isPlAccount = GLUtil.isPLAcct(accDyn);
        if (!(result.isExistsNotCachNotPlAccount() || isPlAccount || isCashAcct)) {
            result.setExistsNotCachNotPlAccount(true);
        }
        if (!result.isExistsPlAccount() && isPlAccount) {
            result.setExistsPlAccount(true);
        }
        DynamicObject mainItem = entry.getDynamicObject("maincfitem");
        BigDecimal mainCfAmt = entry.getBigDecimal("maincfamount");
        DynamicObject suppItem = entry.getDynamicObject("suppcfitem");
        BigDecimal suppCfAmt = entry.getBigDecimal("suppcfamount");
        if (mainItem != null) {
            if (!result.isMainCfDesignated()) {
                result.setMainCfDesignated(true);
            }
            boolean in = true;
            if ("o".equals(mainItem.getString("direction"))) {
                result.setDesiginatedMainAmt(result.getDesiginatedMainAmt().subtract(mainCfAmt));
                in = false;
            } else {
                result.setDesiginatedMainAmt(result.getDesiginatedMainAmt().add(mainCfAmt));
            }
            boolean isDealActivity = mainItem.getBoolean("isdealactivity");
            if (!result.isMainCfDesignatedOnPlAcct() && isPlAccount) {
                result.setMainCfDesignatedOnPlAcct(true);
            }
            if (isDealActivity) {
                BigDecimal amtOnActivities = result.getAmtOnActivities();
                amtOnActivities = in ? amtOnActivities.add(mainCfAmt) : amtOnActivities.subtract(mainCfAmt);
                result.setAmtOnActivities(amtOnActivities);
            }
        }
        if (isPlAccount) {
            result.setNetProfit(result.getNetProfit().add(creditLoc).subtract(debitLoc));
        }
        if (suppItem != null) {
            result.setDesiginatedSuppAmt(result.getDesiginatedSuppAmt().add(suppCfAmt));
            if (!result.isSuppCfDesignated()) {
                result.setSuppCfDesignated(true);
            }
        }
    }

    private static void setSuppStatus(DynamicObject vchDyn, VoucherEntriesSummary result) {
        BigDecimal suppAmt = result.getAmtOnActivities().subtract(result.getNetProfit());
        if (suppAmt.compareTo(result.getDesiginatedSuppAmt()) != 0) {
            if (result.isExistsCashAccount() && !result.isMainCfDesignated()) {
                vchDyn.set("suppstatus", (Object)"0");
            } else if (result.isSuppCfDesignated()) {
                vchDyn.set("suppstatus", (Object)"2");
            } else {
                vchDyn.set("suppstatus", (Object)"1");
            }
        } else if (suppAmt.compareTo(result.getDesiginatedSuppAmt()) == 0) {
            if (result.isSuppCfDesignated()) {
                vchDyn.set("suppstatus", (Object)"3");
            } else {
                vchDyn.set("suppstatus", (Object)"0");
            }
        }
    }

    public static void designCF(DynamicObject v) {
        block2: {
            DynamicObject entry;
            DynamicObject account;
            String suppstatus;
            long periodId;
            block3: {
                DynamicObject entry2;
                DynamicObject account2;
                if ("1".equals(v.getString("sourcetype"))) break block2;
                periodId = v.getLong(GLField.id_("period"));
                String mainstatus = v.getString("mainstatus");
                suppstatus = v.getString("suppstatus");
                if (!"1".equals(mainstatus)) break block3;
                DynamicObjectCollection col = v.getDynamicObjectCollection("entries");
                long orgId = v.getLong(Voucher.id_("org"));
                Iterator iterator = col.iterator();
                while (iterator.hasNext() && null != (account2 = (entry2 = (DynamicObject)iterator.next()).getDynamicObject("account"))) {
                    if (GLUtil.isCashAcct(account2)) continue;
                    String field = entry2.getBigDecimal("debitlocal").signum() != 0 ? "debitlocal" : "creditlocal";
                    long assgrpId = entry2.getLong("assgrp_id");
                    DynamicObject[] cfItems = CashFlowItemHelper.getPresetCFItem(orgId, assgrpId, field, account2, periodId);
                    DynamicObject mainItem = cfItems[0];
                    DynamicObject suppItem = cfItems[1];
                    CashFlowItemHelper.setMainCF(mainItem, suppItem, entry2, account2);
                }
                break block2;
            }
            if (!"1".equals(suppstatus)) break block2;
            DynamicObjectCollection col = v.getDynamicObjectCollection("entries");
            long orgId = v.getLong(Voucher.id_("org"));
            Iterator iterator = col.iterator();
            while (iterator.hasNext() && null != (account = (entry = (DynamicObject)iterator.next()).getDynamicObject("account"))) {
                String field;
                boolean isPL = GLUtil.isPLAcct(account);
                if (isPL) continue;
                String string = field = entry.getBigDecimal("debitlocal").signum() != 0 ? "debitlocal" : "creditlocal";
                long assgrpId = entry.getLong("assgrp_id");
                DynamicObject[] cfItems = CashFlowItemHelper.getPresetCFItem(orgId, assgrpId, field, account, periodId);
                DynamicObject suppItem = cfItems[1];
                if (suppItem == null) continue;
                entry.set("suppcfitem", (Object)suppItem);
                entry.set("suppcfamount", (Object)entry.getBigDecimal("creditlocal").subtract(entry.getBigDecimal("debitlocal")));
            }
        }
    }

    private static void setMainCF(DynamicObject cfItem, DynamicObject suppItem, DynamicObject entry, DynamicObject account) {
        if (cfItem != null) {
            BigDecimal dc = BigDecimal.ONE;
            if ("o".equals(cfItem.getString("direction"))) {
                dc = dc.negate();
            }
            entry.set("maincfitem", (Object)cfItem);
            entry.set("maincfamount", (Object)entry.getBigDecimal("creditlocal").subtract(entry.getBigDecimal("debitlocal")).multiply(dc));
            if (suppItem != null) {
                boolean isdealactivity = cfItem.getBoolean("isdealactivity");
                boolean isPL = GLUtil.isPLAcct(account);
                if (isPL && !isdealactivity) {
                    entry.set("suppcfitem", (Object)suppItem);
                    entry.set("suppcfamount", (Object)entry.getBigDecimal("debitlocal").subtract(entry.getBigDecimal("creditlocal")));
                } else if (!isPL && isdealactivity) {
                    entry.set("suppcfitem", (Object)suppItem);
                    entry.set("suppcfamount", (Object)entry.getBigDecimal("creditlocal").subtract(entry.getBigDecimal("debitlocal")));
                }
            }
        }
    }

    private static DynamicObject[] getPresetCFItem(long orgId, long assgrp, String field, DynamicObject acct, long periodId) {
        CacheKey cacheKey1 = CacheKey.getCacheKey(CacheKeyPrefix.GL_CashFlowPS, new Object[0]);
        Boolean hasExist = LocalCacheHelper.get(cacheKey1, Boolean.class);
        if (hasExist != null) {
            if (!hasExist.booleanValue()) {
                return new DynamicObject[]{null, null};
            }
        } else {
            hasExist = QueryServiceHelper.exists((String)"gl_presetcashflowitem", null);
            LocalCacheHelper.put(cacheKey1, hasExist);
            if (!hasExist.booleanValue()) {
                return new DynamicObject[]{null, null};
            }
        }
        CacheKey cacheKey = CacheKey.getCacheKey(CacheKeyPrefix.GL_CashFlowPS, orgId, acct.getLong("accounttable_id"));
        HashMap<String, DynamicObject[]> items = LocalCacheHelper.get(cacheKey, Map.class);
        String key = acct.getLong("id") + "-" + assgrp + "-" + field;
        if (items != null) {
            if (items.containsKey(key)) {
                return (DynamicObject[])items.get(key);
            }
            DynamicObject[] presetCF = CashFlowItemHelper.getPresetCFItemFromDB(orgId, assgrp, field, acct, periodId);
            items.put(key, presetCF);
            return presetCF;
        }
        DynamicObject[] presetCF = CashFlowItemHelper.getPresetCFItemFromDB(orgId, assgrp, field, acct, periodId);
        items = new HashMap<String, DynamicObject[]>();
        items.put(key, presetCF);
        LocalCacheHelper.put(cacheKey, items);
        return presetCF;
    }

    private static DynamicObject[] getPresetCFItemFromDB(long orgId, long assgrp, String field, DynamicObject acct, long periodId) {
        String dc = "debitlocal".equals(field) ? "1" : "-1";
        ArrayList<PresetCashFlowItemParam> paramList = new ArrayList<PresetCashFlowItemParam>(2);
        PresetCashFlowItemParam param = new PresetCashFlowItemParam();
        param.setAcctId(acct.getLong("id"));
        param.setAcctLongnumber(acct.getString("longnumber"));
        param.setDc(dc);
        param.setAssgrp(assgrp);
        param.setItemType("1");
        paramList.add(param);
        PresetCashFlowItemParam param1 = new PresetCashFlowItemParam();
        param1.setAcctId(acct.getLong("id"));
        param1.setAcctLongnumber(acct.getString("longnumber"));
        param1.setDc(dc);
        param1.setAssgrp(assgrp);
        param1.setItemType("3");
        paramList.add(param1);
        Map map = PresetCashItemUtil.batchGetCashFlowItemIds(paramList, (long)orgId, (long)acct.getLong("accounttable_id"), (long)periodId);
        Long mainItemId = (Long)map.get(param);
        Long suppItemId = (Long)map.get(param1);
        DynamicObject mainItem = null;
        DynamicObject suppItem = null;
        if (mainItemId != null && mainItemId != 0L) {
            mainItem = BusinessDataServiceHelper.loadSingleFromCache((Object)mainItemId, (String)"gl_cashflowitem");
        }
        if (suppItemId != null && suppItemId != 0L) {
            suppItem = BusinessDataServiceHelper.loadSingleFromCache((Object)suppItemId, (String)"gl_cashflowitem");
        }
        return new DynamicObject[]{mainItem, suppItem};
    }

    public static void setCFStatus(Object[] param, VoucherSaveValidatorParam cp) {
        if (cp.isHashCash()) {
            if (cp.isHasPL()) {
                if (cp.isHashMainCf()) {
                    param[0] = cp.getCashtotalused().compareTo(cp.getCashtotalamt()) == 0 ? "3" : "2";
                    CashFlowItemHelper.setDesignStatus(param, cp);
                } else {
                    param[0] = "1";
                    param[1] = "1";
                }
            } else if (cp.isNotC_NotPL()) {
                param[0] = cp.isHashMainCf() ? (cp.getCashtotalused().compareTo(cp.getCashtotalamt()) == 0 ? "3" : "2") : "1";
                CashFlowItemHelper.setDesignStatus(param, cp);
            }
        } else if (cp.isHasPL()) {
            param[0] = "0";
            if (cp.isNotC_NotPL()) {
                CashFlowItemHelper.setDesignStatus(param, cp);
            } else {
                param[1] = "0";
            }
        } else if (cp.isNotC_NotPL()) {
            param[0] = "0";
            param[1] = "a";
        } else {
            param[0] = "0";
            param[1] = "0";
        }
    }

    private static void setDesignStatus(Object[] param, VoucherSaveValidatorParam cp) {
        BigDecimal[] cashAmt = cp.getCashAmt();
        BigDecimal suppAmt = cashAmt[0].subtract(cashAmt[1]);
        if (suppAmt.compareTo(cashAmt[2]) != 0) {
            param[1] = cp.isHashCash() && !cp.isHashMainCf() ? "0" : (cp.isHasSuppCf() ? "2" : "1");
        } else if (suppAmt.compareTo(cashAmt[2]) == 0) {
            param[1] = cp.isHasSuppCf() ? "3" : "0";
        }
    }

    public static String hasCashflowbiz(long orgId, long booktypeId, long periodId) {
        QFilter bookTypeFilter;
        boolean hasBiz = false;
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct fvoucherid from t_gl_tempvoucher_cf_index where ", new Object[0]);
        sqlBuilder.append("forgid = ? ", new Object[]{orgId});
        List vouvherIds = (List)PerformanceMonitor.watch(() -> (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> voucherIds = new ArrayList<Long>(16);
                while (rs.next()) {
                    voucherIds.add(rs.getLong(1));
                }
                return voucherIds;
            }
        }), (int)10, (Object)sqlBuilder);
        if (vouvherIds.size() > 0) {
            QFilter idf = new QFilter("id", "in", (Object)vouvherIds);
            bookTypeFilter = new QFilter("booktype", "=", (Object)booktypeId);
            QFilter periodFilter = new QFilter("period", "<", (Object)periodId);
            hasBiz = QueryServiceHelper.exists((String)"gl_voucher", (QFilter[])new QFilter[]{idf, bookTypeFilter, periodFilter});
        }
        if (hasBiz) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u6682\u5b58\u51ed\u8bc1\u5df2\u6307\u5b9a\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u53d6\u6d88\u6307\u5b9a\u540e\u518d\u8bd5\u3002", (String)"CashFlowItemHelper_0", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        bookTypeFilter = new QFilter("booktype", "=", (Object)booktypeId);
        QFilter counteFilter = new QFilter("count", "!=", (Object)0);
        QFilter periodFilter = new QFilter("period", "<", (Object)periodId);
        QFilter prefitFilter = new QFilter("cfitem.isprefit", "=", (Object)"0");
        hasBiz = QueryServiceHelper.exists((String)"gl_cashflow", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, counteFilter, periodFilter, prefitFilter});
        if (hasBiz) {
            return ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868\u4e2d\u5b58\u5728\u672c\u671f\u53d1\u751f\uff0c\u8bf7\u5148\u53d6\u6d88\u76f8\u5173\u73b0\u91d1\u6d41\u91cf\u6307\u5b9a\u540e\u518d\u8bd5\u3002", (String)"CashFlowItemHelper_1", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        QFilter calculatedFilter = new QFilter("calculated", "=", (Object)false);
        hasBiz = QueryServiceHelper.exists((String)CashFlowName, (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, calculatedFilter, periodFilter, prefitFilter});
        if (hasBiz) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u672a\u8ba1\u7b97\u7684\u73b0\u91d1\u6d41\u91cf\u65e5\u5fd7\uff0c\u8bf7\u7b49\u5f85\u65e5\u5fd7\u5168\u90e8\u8ba1\u7b97\u5b8c\u6210\u540e\u518d\u8bd5\u3002", (String)"CashFlowItemHelper_2", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        QFilter deleteFilter = new QFilter("tabdelete", "=", (Object)false);
        hasBiz = QueryServiceHelper.exists((String)"gl_initcashflow", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, deleteFilter});
        if (hasBiz) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u6570\u636e\uff0c\u8bf7\u5148\u5220\u9664\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"CashFlowItemHelper_3", (String)"fi-gl-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean permitDesignCashflow(IDataModel model) {
        DynamicObject book = (DynamicObject)model.getValue("book");
        long period = (Long)model.getValue("period_id");
        return CashFlowItemHelper.permitDesignCashflowByPeriod(book.getLong(GLField.id_("cashinitperiod")), period);
    }

    public static boolean permitDesignCashflow(long bookId, long curPeriod) {
        return (Boolean)ThreadCache.get((Object)String.format("permitDesignCashflow: %1$s-%2$s", bookId, curPeriod), () -> {
            DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"cashinitperiod", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bookId)});
            return CashFlowItemHelper.permitDesignCashflowByPeriod(book.getLong(GLField.id_("cashinitperiod")), curPeriod);
        });
    }

    public static boolean permitDesignCashflowByPeriod(long bookCFPeriod, long curPeriod) {
        return bookCFPeriod != 0L && bookCFPeriod <= curPeriod;
    }

    public static Map<Long, Long> getAddNewVersionCfItems(long orgId, long endPeriod) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        DynamicObject endPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriod, (String)"bd_period");
        QFilter startDate = new QFilter("startdate", "<=", (Object)endPeriodDyn.getDate("enddate"));
        DataSet cfItemSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.CashFlowItemHelper", (String)"gl_cashflowitem", (String)"id,masterid,isleaf", (QFilter[])new QFilter[]{baseDataFilter, startDate}, null);
        DataSet finish = cfItemSet.copy().join(cfItemSet).on("masterid", "masterid").select(new String[]{"id", "masterid", "isleaf"}, new String[]{"isleaf versionleaf"}).finish();
        finish = finish.filter("isleaf = true and versionleaf = false");
        for (Row row : finish) {
            if (map.containsKey(row.getLong("masterid")) && !row.getLong("masterid").equals(row.getLong("id"))) continue;
            map.put(row.getLong("id"), row.getLong("masterid"));
        }
        logger.info("getAddNewVersionCfItems : " + ((Object)map).toString());
        return map;
    }

    public static Set<Long> getAllCfitemIdsByOrg(long orgId, long orgViewId, long endPeriod, boolean includeChild, boolean includeParentSelf) {
        HashSet<Long> cashflowItemIds = new HashSet<Long>();
        Set<Long> orgParent = new HashSet<Long>();
        orgParent.add(orgId);
        if (includeChild) {
            orgParent = AccSysUtil.getChildOrgId("10", orgViewId, orgParent, includeParentSelf);
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", new ArrayList(orgParent), (boolean)false);
        QFilter startDate = null;
        QFilter endDate = null;
        if (endPeriod > 0L) {
            DynamicObject endPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriod, (String)"bd_period");
            startDate = new QFilter("startdate", "<=", (Object)endPeriodDyn.getDate("enddate"));
            endDate = new QFilter("enddate", ">", (Object)endPeriodDyn.getDate("enddate"));
        }
        DataSet cfItemSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.util.CashflowItemHelper", (String)"gl_cashflowitem", (String)"id", (QFilter[])new QFilter[]{baseDataFilter, startDate, endDate}, null);
        for (Row row : cfItemSet) {
            cashflowItemIds.add(row.getLong("id"));
        }
        return cashflowItemIds;
    }

    public static class LogFacts {
        private Set<Long> loadSingleVchs = new HashSet<Long>(8);
        private Long loadSingleTotal = 0L;
        private Long entriesTotal = 0L;
        private Long loadSingleTotalCost = 0L;
        private Long saveTotalCost = 0L;
        private Long publishTotalCost = 0L;
        private Long getCashAssFromAccountAssTotal = 0L;
        private Long getCashAssFromAccountAssTotalCost = 0L;

        public void init() {
            this.loadSingleVchs = new HashSet<Long>(8);
            this.loadSingleTotal = 0L;
            this.entriesTotal = 0L;
            this.loadSingleTotalCost = 0L;
            this.saveTotalCost = 0L;
            this.publishTotalCost = 0L;
            this.getCashAssFromAccountAssTotal = 0L;
            this.getCashAssFromAccountAssTotalCost = 0L;
        }

        public String toString() {
            return "LogFacts{loadSingleVchs.size=" + this.loadSingleVchs.size() + ", loadSingleTotal=" + this.loadSingleTotal + ", entriesTotal=" + this.entriesTotal + ", loadSingleTotalCost=" + this.loadSingleTotalCost + ", saveTotalCost=" + this.saveTotalCost + ", publishTotalCost=" + this.publishTotalCost + ", getCashAssFromAccountAssTotal=" + this.getCashAssFromAccountAssTotal + ", getCashAssFromAccountAssTotalCost=" + this.getCashAssFromAccountAssTotalCost + '}';
        }
    }
}

