/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.gl.assistitem.CashFLowItemFlexValueGetter;
import kd.fi.gl.balcal.CalculatorCFs;
import kd.fi.gl.balcal.CashflowKey;
import kd.fi.gl.balcal.CashflowLog;
import kd.fi.gl.balcal.CashflowLogKey;
import kd.fi.gl.balcal.LogList;
import kd.fi.gl.bean.VchCfRowInfo;
import kd.fi.gl.comassist.ComassistContext;
import kd.fi.gl.comassist.ComassistMidTransterModel;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.CashFlowSumDCEnum;
import kd.fi.gl.enums.CashStatusType;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.notice.NoticeAction;
import kd.fi.gl.notice.NoticeMessenger;
import kd.fi.gl.util.DesignateContext;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.IctRecordUtil;
import kd.fi.gl.util.VchCfDnyWrapper;
import kd.fi.gl.util.VchCfRowWrapper;
import kd.fi.gl.util.VchCfWrapper;
import kd.fi.gl.util.VoucherEntriesSummary;
import kd.fi.gl.voucher.count.VoucherCountHelper;

public class CashFlowItemHelperNew {
    private static final String CashFlowName = "gl_cashflow_log";
    private static final String insertCashLogSql = "INSERT INTO t_gl_cashflow_log(FID,FCREATETIME,FVOUCHERID,FORGID,FBOOKTYPEID,FPERIODID,FVCHENTRYID,FCFITEMID,FCURRENCYID,FASSGRPID,FACCOUNTID,FTYPE,FDC,FBOOKEDDATE,#FAMOUNT,FCOUNT,FOPERATION,FCALCULATED) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?@)";
    private static final Log extLogger = ExtLogFactory.getLog(CashFlowItemHelperNew.class, (String)"[CashFlowItemHelperNew]");
    public static LogFacts logFacts = new LogFacts();
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private static String SELECT = "id,org,billstatus,booktype,bookeddate,period,localcur,mainstatus,suppstatus,entries.id,entries.creditlocal,entries.debitlocal,entries.maincfitem,entries.maincfassgrp,entries.maincfamount,entries.suppcfitem,entries.suppcfamount,#entries.account.id masterid, entries.account.accounttable accounttable,entries.maincfitem.direction,entries.assgrp,entries.account.iscash iscash,entries.account.isbank isbank,entries.account.iscashequivalent iscashequivalent,entries.account.accounttype.accounttype";
    private static String UPDATECF = "update t_gl_voucherentry set fmaincfitemid=?,fmaincfamount=?,fmaincfassgrpid=?,fsuppcfitemid=?,fsuppcfamount=? where fentryid = ?";
    private static String UPDATESTATUS = "update t_gl_voucher set fmainstatus=?, fsuppstatus=? where fid=?";

    private CashFlowItemHelperNew() {
    }

    public static void batchCalVoucherStatus(Map<Long, List<Long>> dataMap, String type, Set<String> bookIds, List<Object[]> paramsList, List<Object[]> vchParams, List<Object[]> entryParams, Set<Long> vchIds) {
        HashMap vchInfoMap = new HashMap(dataMap.size());
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"CashFlowItemHelper", (String)"gl_voucher", (String)CashFlowItemHelperNew.getSelectField(size), (QFilter[])new QFilter("id", "in", dataMap.keySet()).toArray(), (String)"id");){
            ArrayList<VchCfRowInfo> vRowInfos = new ArrayList<VchCfRowInfo>(10);
            long voucherId = 0L;
            for (Row row : ds) {
                if (voucherId != 0L && row.getLong("id") != voucherId) {
                    vchInfoMap.put(voucherId, vRowInfos);
                    vRowInfos = new ArrayList(10);
                }
                vRowInfos.add(new VchCfRowInfo(row, size));
                voucherId = row.getLong("id");
            }
            if (voucherId != 0L) {
                vchInfoMap.put(voucherId, vRowInfos);
            }
        }
        for (Map.Entry entry : vchInfoMap.entrySet()) {
            Long voucherId = (Long)entry.getKey();
            List vchRowInfos = (List)entry.getValue();
            CashFlowItemHelperNew.calVoucherStatus(voucherId, vchRowInfos, dataMap.get(voucherId), type, bookIds, paramsList, vchParams, entryParams, vchIds);
        }
    }

    public static void calVoucherStatus(long voucherId, List<VchCfRowInfo> vchRowInfos, List<Long> entryIds, String type, Set<String> bookIds, List<Object[]> paramsList, List<Object[]> vchParams, List<Object[]> entryParams, Set<Long> vchIds) {
        LogList<CashflowKey> cashFlowLogList = new LogList<CashflowKey>();
        LogList<CashflowKey> tempLogList = new LogList<CashflowKey>();
        LogList<CashflowKey> tempLogList2 = new LogList<CashflowKey>();
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        HashMap<Long, Map<Integer, Set<Long>>> map = size > 0 ? CashFlowItemHelperNew.collectComAssistData(vchRowInfos, size) : new HashMap();
        ComassistContext context = new ComassistContext();
        context.init(map);
        VoucherEntriesSummary summary = new VoucherEntriesSummary();
        VchCfRowWrapper cfWrapper = null;
        long orgId = 0L;
        long bookTypeId = 0L;
        long periodId = 0L;
        String dc = CashFlowItemHelperNew.getDC(vchRowInfos);
        int mainRowSize = 0;
        for (VchCfRowInfo entry : vchRowInfos) {
            long id = entry.getEntryId();
            if (orgId == 0L) {
                orgId = entry.getOrgId();
                bookTypeId = entry.getBookTypeId();
                periodId = entry.getPeriodId();
            }
            if (!entry.isCashAcct() && !AccountType.isBudgetProp(entry.getAccounttype())) {
                ++mainRowSize;
            }
            cfWrapper = new VchCfRowWrapper(entry);
            if (entryIds.contains(id)) {
                Object[] entryParam = CashFlowItemHelperNew.defaultParam(entry);
                boolean isPL = !"0".equals(cfWrapper.getAccount().getString("pltype"));
                DynamicObject maincfItem = cfWrapper.getMaincfItem();
                if ("1".equals(type) && entry.getMaincfItemId() != 0L) {
                    CashFlowItemHelperNew.addLogList(cashFlowLogList, cfWrapper, -1, 1, entry.getMaincfassgrpId(), dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    cfWrapper.setMaincfItem(null);
                    entryParam[0] = 0;
                    entryParam[1] = BigDecimal.ZERO;
                    entryParam[2] = 0;
                    boolean isdealactivity = maincfItem.getBoolean("isdealactivity");
                    BigDecimal cfDC = BigDecimal.ONE;
                    if ("o".equals(maincfItem.getString("direction"))) {
                        cfDC = cfDC.negate();
                    }
                    if (entry.getSuppcfItemId() != 0L) {
                        CashFlowItemHelperNew.addLogList(cashFlowLogList, cfWrapper, -1, 2, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                        cfWrapper.setSuppcfItem(null);
                        entryParam[3] = 0;
                        entryParam[4] = BigDecimal.ZERO;
                    } else if (isPL && !isdealactivity || !isPL && isdealactivity) {
                        BigDecimal suppcfAmt = BigDecimal.ZERO;
                        suppcfAmt = isPL && !isdealactivity ? cfWrapper.getDebitlocal().subtract(cfWrapper.getCreditlocal()) : cfWrapper.getMaincfAmt().multiply(cfDC);
                        cfWrapper.setSuppcfAmt(suppcfAmt);
                        CashFlowItemHelperNew.addLogList(cashFlowLogList, cfWrapper, -1, 2, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    }
                    cfWrapper.setSuppcfAmt(BigDecimal.ZERO);
                    if (cfWrapper.getMaincfAmt().compareTo(cfWrapper.getCreditlocal().subtract(cfWrapper.getDebitlocal()).multiply(cfDC)) != 0) {
                        cfWrapper.setMaincfAmt(cfWrapper.getMaincfAmt().multiply(cfDC));
                        CashFlowItemHelperNew.addLogList(tempLogList, cfWrapper, 1, 1, 0L, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    } else {
                        cfWrapper.setMaincfAmt(cfWrapper.getCreditlocal().subtract(cfWrapper.getDebitlocal()));
                        CashFlowItemHelperNew.addLogList(tempLogList2, cfWrapper, 1, 1, 0L, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    }
                    cfWrapper.setMaincfAmt(BigDecimal.ZERO);
                } else if ("2".equals(type) && entry.getSuppcfItemId() != 0L) {
                    CashFlowItemHelperNew.addLogList(cashFlowLogList, cfWrapper, -1, 2, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    cfWrapper.setSuppcfItem(null);
                    entryParam[3] = 0;
                    entryParam[4] = BigDecimal.ZERO;
                    BigDecimal suppcfAmt = cfWrapper.getCreditlocal().subtract(cfWrapper.getDebitlocal());
                    if (maincfItem != null) {
                        boolean isdealactivity = maincfItem.getBoolean("isdealactivity");
                        if (isPL && !isdealactivity) {
                            suppcfAmt = cfWrapper.getDebitlocal().subtract(cfWrapper.getCreditlocal());
                        } else if (!isPL && isdealactivity) {
                            suppcfAmt = cfWrapper.getMaincfAmt();
                            if ("o".equals(maincfItem.getString("direction"))) {
                                suppcfAmt = suppcfAmt.negate();
                            }
                        }
                    }
                    cfWrapper.setSuppcfAmt(suppcfAmt);
                    CashFlowItemHelperNew.addLogList(cashFlowLogList, cfWrapper, 1, 2, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    cfWrapper.setSuppcfAmt(BigDecimal.ZERO);
                }
                entryParams.add(entryParam);
            }
            CashFlowItemHelperNew.calculateEntry(summary, cfWrapper);
        }
        Tuple<String, String> status = CashFlowItemHelperNew.calStatus(summary);
        if (tempLogList.size() > 0) {
            if ("1".equals(status.item1)) {
                HashSet<Long> vEntryIds = new HashSet<Long>(10);
                for (VchCfRowInfo entry : vchRowInfos) {
                    if (entry.isCashAcct() || AccountType.isBudgetProp(entry.getAccounttype())) continue;
                    cfWrapper = new VchCfRowWrapper(entry);
                    cfWrapper.setMaincfItem(null);
                    cfWrapper.setMaincfAmt(cfWrapper.getCreditlocal().subtract(cfWrapper.getDebitlocal()));
                    CashFlowItemHelperNew.addLogList(cashFlowLogList, cfWrapper, 1, 1, 0L, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    if (entryIds.contains(entry.getEntryId())) continue;
                    vEntryIds.add(entry.getEntryId());
                }
                if (vEntryIds.size() > 0) {
                    Map<Long, BigDecimal> deductInfos = CashFlowItemHelperNew.getDeductInfos(voucherId, vEntryIds);
                    for (VchCfRowInfo entry : vchRowInfos) {
                        BigDecimal deducAmt;
                        long eId = entry.getEntryId();
                        if (!vEntryIds.contains(eId) || (deducAmt = deductInfos.get(eId)) == null || deducAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        cfWrapper = new VchCfRowWrapper(entry);
                        cfWrapper.setMaincfItem(null);
                        cfWrapper.setMaincfAmt(deducAmt);
                        CashFlowItemHelperNew.addLogList(cashFlowLogList, cfWrapper, -1, 1, 0L, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    }
                }
            } else {
                cashFlowLogList.add(tempLogList);
                cashFlowLogList.add(tempLogList2);
            }
        } else if (tempLogList2.size() > 0) {
            if ("1".equals(status.item1) && "3".equals(vchRowInfos.get(0).getMainstatus()) && mainRowSize != tempLogList2.size()) {
                for (VchCfRowInfo entry : vchRowInfos) {
                    if (entry.isCashAcct() || AccountType.isBudgetProp(entry.getAccounttype())) continue;
                    cfWrapper = new VchCfRowWrapper(entry);
                    cfWrapper.setMaincfItem(null);
                    cfWrapper.setMaincfAmt(cfWrapper.getCreditlocal().subtract(cfWrapper.getDebitlocal()));
                    CashFlowItemHelperNew.addLogList(cashFlowLogList, cfWrapper, 1, 1, 0L, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                }
            } else {
                cashFlowLogList.add(tempLogList2);
            }
        }
        vchParams.add(new Object[]{status.item1, status.item2, voucherId});
        vchIds.add(voucherId);
        CashFlowItemHelperNew.calAndSave(bookIds, paramsList, entryParams, vchParams, cashFlowLogList, orgId, bookTypeId, periodId, voucherId, vchIds);
    }

    private static Map<Long, BigDecimal> getDeductInfos(Long voucherid, Set<Long> vEntryIds) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fvchentryid,feamount from t_gl_cashflowsumentry e inner join t_gl_cashflowsum s on e.fid = s.fid ", new Object[0]);
        sb.append(" where s.fcfitemid = 0 and s.ftype = ? ", new Object[]{CashStatusType.MAINITEM.getValue()});
        sb.append(" and fvoucherid = ? ", new Object[]{voucherid});
        sb.appendIn(" and fvchentryid ", new ArrayList<Long>(vEntryIds));
        HashMap<Long, BigDecimal> deductInfos = new HashMap<Long, BigDecimal>(16);
        DataSet dataSet = DB.queryDataSet((String)"getDeductInfos", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sb);
        for (Row row : dataSet) {
            deductInfos.put(row.getLong("fvchentryid"), row.getBigDecimal("feamount"));
        }
        return deductInfos;
    }

    private static String getDC(List<VchCfRowInfo> vchRowInfos) {
        BigDecimal debitTotalAmt = BigDecimal.ZERO;
        BigDecimal creditTotalAmt = BigDecimal.ZERO;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (VchCfRowInfo row : vchRowInfos) {
            if (!row.isCashAcct()) continue;
            BigDecimal debit = row.getDebitlocal();
            BigDecimal credit = row.getCreditlocal();
            debitTotalAmt = debitTotalAmt.add(debit);
            creditTotalAmt = creditTotalAmt.add(credit);
            totalAmt = totalAmt.add(debit).subtract(credit);
        }
        if (debitTotalAmt.compareTo(BigDecimal.ZERO) != 0 && creditTotalAmt.compareTo(BigDecimal.ZERO) != 0) {
            if (totalAmt.compareTo(BigDecimal.ZERO) > 0) {
                return CashFlowSumDCEnum.DEBIT.getValue();
            }
            return CashFlowSumDCEnum.CREDIT.getValue();
        }
        if (creditTotalAmt.compareTo(BigDecimal.ZERO) != 0) {
            return CashFlowSumDCEnum.CREDIT.getValue();
        }
        return CashFlowSumDCEnum.DEBIT.getValue();
    }

    private static String getSelectField(int size) {
        return SELECT.replace("#", CashFlowItemHelperNew.getDynVchComassistField(size));
    }

    private static String getDynVchComassistField(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= size; ++i) {
            sb.append("entries.comassist").append(i).append(" comassist").append(i).append(",");
        }
        return sb.toString();
    }

    private static String getInsertCashLogSql() {
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        return insertCashLogSql.replace("#", CashFlowItemHelperNew.dynBalComassistField(size)).replace("@", CashFlowItemHelperNew.dynParam(size));
    }

    private static String dynBalComassistField(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= size; ++i) {
            sb.append("fcomassist").append(i).append("id,");
        }
        return sb.toString();
    }

    private static String dynParam(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(",?");
        }
        return sb.toString();
    }

    private static Map<Long, Map<Integer, Set<Long>>> collectComAssistData(List<VchCfRowInfo> vRowInfos, int size) {
        HashMap<Long, Map<Integer, Set<Long>>> map = new HashMap<Long, Map<Integer, Set<Long>>>();
        for (VchCfRowInfo row : vRowInfos) {
            long accttable = row.getAccounttableId();
            Map setMap = map.computeIfAbsent(accttable, x -> new HashMap());
            List<Long> comassistIds = row.getComassistIds();
            for (int i = 1; i <= size; ++i) {
                Set ids = setMap.computeIfAbsent(i, x -> new HashSet());
                ids.add(comassistIds.get(i - 1));
            }
        }
        return map;
    }

    public static void saveData(List<Object[]> paramsList, List<Object[]> vchParams, List<Object[]> entryParams, Set<Long> voucherIds) {
        try (TXHandle tx = TX.requiresNew((String)"calVoucherStatus");){
            try {
                VoucherCountHelper.createChangeLog(voucherIds, "cfsave", true);
                long calAndSaveStart = System.currentTimeMillis();
                DBRoute gl = DBRoute.of((String)"gl");
                if (!entryParams.isEmpty()) {
                    try (ShardingHintContext ignored = ShardingHintContext.create((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, voucherIds)});){
                        DB.executeBatch((DBRoute)gl, (String)UPDATECF, entryParams);
                    }
                }
                if (!paramsList.isEmpty()) {
                    DB.executeBatch((DBRoute)gl, (String)CashFlowItemHelperNew.getInsertCashLogSql(), paramsList);
                }
                if (!vchParams.isEmpty()) {
                    DB.executeBatch((DBRoute)gl, (String)UPDATESTATUS, vchParams);
                }
                VoucherCountHelper.createChangeLog(voucherIds, "cfsave", false);
                if (!voucherIds.isEmpty()) {
                    List<String> vchIds = voucherIds.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
                    IctRecordUtil.asyncIctRecordCfValue(vchIds);
                }
                long pulishStart = System.currentTimeMillis();
                NoticeMessenger.delivery(voucherIds.toArray(new Long[0]), NoticeAction.SEND_CF);
                vchParams.clear();
                entryParams.clear();
                voucherIds.clear();
                paramsList.clear();
                long calAndSaveEnd = System.currentTimeMillis();
                LogFacts logFacts = CashFlowItemHelperNew.logFacts;
                logFacts.saveTotalCost = logFacts.saveTotalCost + (calAndSaveEnd - calAndSaveStart);
                logFacts = CashFlowItemHelperNew.logFacts;
                logFacts.publishTotalCost = logFacts.publishTotalCost + (calAndSaveEnd - pulishStart);
                extLogger.info("[T_preset]calAndSave_cost: {} ms, pulish_cost: {} ms", (Object)(calAndSaveEnd - calAndSaveStart), (Object)(calAndSaveEnd - pulishStart));
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(GLErrorCode.SYS_ERR, new Object[]{e});
            }
        }
    }

    private static void calAndSave(Set<String> bookIds, List<Object[]> paramsList, List<Object[]> entryParams, List<Object[]> vchParams, LogList<CashflowKey> cashFlowLogList, long orgId, long bookTypeId, long periodId, long voucherId, Set<Long> voucherIds) {
        CashFlowItemHelperNew.updateBalance(cashFlowLogList, bookIds, paramsList, orgId, bookTypeId, periodId, voucherId);
        if (vchParams.size() > 1000) {
            CashFlowItemHelperNew.saveData(paramsList, vchParams, entryParams, voucherIds);
        }
    }

    public static void batchCalVoucherStatus(Map<Long, Map<Long, BigDecimal>> dataMap, Map<Long, Map<Long, Long>> itemMap, String type, Set<String> bookIds, List<Object[]> paramsList, List<Object[]> vchParams, List<Object[]> entryParams, Set<Long> vchIds, Map<Long, DynamicObject> cfItemMap, Long assgrpId) {
        HashMap vchInfoMap = new HashMap(dataMap.size());
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"CashFlowItemHelper", (String)"gl_voucher", (String)CashFlowItemHelperNew.getSelectField(size), (QFilter[])new QFilter("id", "in", dataMap.keySet()).toArray(), (String)"id");){
            ArrayList<VchCfRowInfo> vRowInfos = new ArrayList<VchCfRowInfo>(10);
            long voucherId = 0L;
            for (Row row : ds) {
                if (voucherId != 0L && row.getLong("id") != voucherId) {
                    vchInfoMap.put(voucherId, vRowInfos);
                    vRowInfos = new ArrayList(10);
                }
                vRowInfos.add(new VchCfRowInfo(row, size));
                voucherId = row.getLong("id");
            }
            if (voucherId != 0L) {
                vchInfoMap.put(voucherId, vRowInfos);
            }
        }
        for (Map.Entry entry : vchInfoMap.entrySet()) {
            Long voucherId = (Long)entry.getKey();
            List vchRowInfos = (List)entry.getValue();
            CashFlowItemHelperNew.calVoucherStatus(voucherId, vchRowInfos, dataMap.get(voucherId), itemMap.get(voucherId), type, bookIds, paramsList, vchParams, entryParams, vchIds, cfItemMap, assgrpId);
        }
    }

    public static void calVoucherStatus(long voucherId, List<VchCfRowInfo> vRowInfos, Map<Long, BigDecimal> designMap, Map<Long, Long> itemMap, String type, Set<String> bookIds, List<Object[]> logParamsList, List<Object[]> vchParam, List<Object[]> entryParams, Set<Long> voucherIds, Map<Long, DynamicObject> cfItemMap, Long assgrpId) {
        LogList<CashflowKey> cashFlowLogList = new LogList<CashflowKey>();
        long orgId = 0L;
        long bookTypeId = 0L;
        long periodId = 0L;
        int size = ComAssistTable.getMaxCommonAssistKeys().size();
        HashMap<Long, Map<Integer, Set<Long>>> map = size > 0 ? CashFlowItemHelperNew.collectComAssistData(vRowInfos, size) : new HashMap();
        ComassistContext context = new ComassistContext();
        context.init(map);
        VoucherEntriesSummary summary = new VoucherEntriesSummary();
        VchCfRowWrapper wrapper = null;
        Object[] entryParam = null;
        DynamicObject cfItem = null;
        boolean isdealactivity = false;
        String dc = CashFlowItemHelperNew.getDC(vRowInfos);
        for (VchCfRowInfo entry : vRowInfos) {
            if (orgId == 0L) {
                orgId = entry.getOrgId();
                bookTypeId = entry.getBookTypeId();
                periodId = entry.getPeriodId();
            }
            long entryId = entry.getEntryId();
            wrapper = new VchCfRowWrapper(entry);
            BigDecimal designAmt = designMap.get(entryId);
            if (designAmt != null) {
                entryParam = CashFlowItemHelperNew.defaultParam(entry);
                Long itemId = itemMap.get(entryId);
                Long assgrpIdParam = assgrpId;
                if (null == assgrpIdParam) {
                    assgrpIdParam = entry.getAssgrpId();
                }
                boolean isPL = !"0".equals(wrapper.getAccount().getString("pltype"));
                cfItem = CashFlowItemHelperNew.getCfItem(cfItemMap, itemId);
                if ("1".equals(type)) {
                    DynamicObject maincfItem = wrapper.getMaincfItem();
                    isdealactivity = cfItem.getBoolean("isdealactivity");
                    if (entry.getMaincfItemId() == 0L) {
                        BigDecimal amt = designAmt;
                        if ("o".equals(cfItem.getString("direction"))) {
                            amt = amt.negate();
                        }
                        wrapper.setMaincfAmt(amt);
                    }
                    CashFlowItemHelperNew.addLogList(cashFlowLogList, wrapper, -1, 1, entry.getMaincfassgrpId(), dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    if (maincfItem != null && (isPL && isdealactivity && !maincfItem.getBoolean("isdealactivity") || !isPL && !isdealactivity && maincfItem.getBoolean("isdealactivity"))) {
                        if (entry.getSuppcfItemId() == 0L) {
                            BigDecimal suppcfAmt = BigDecimal.ZERO;
                            if (isPL && !maincfItem.getBoolean("isdealactivity")) {
                                suppcfAmt = wrapper.getDebitlocal().subtract(wrapper.getCreditlocal());
                            } else {
                                suppcfAmt = wrapper.getMaincfAmt();
                                if ("o".equals(maincfItem.getString("direction"))) {
                                    suppcfAmt = suppcfAmt.negate();
                                }
                            }
                            wrapper.setSuppcfAmt(suppcfAmt);
                        }
                        CashFlowItemHelperNew.addLogList(cashFlowLogList, wrapper, -1, 2, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                        wrapper.setSuppcfAmt(BigDecimal.ZERO);
                        if (entry.getSuppcfItemId() != 0L) {
                            wrapper.setSuppcfItem(null);
                            entryParam[3] = 0;
                            entryParam[4] = BigDecimal.ZERO;
                        }
                    }
                    wrapper.setMaincfItem(cfItem);
                    wrapper.setMaincfAmt(designAmt);
                    entryParam[0] = itemId;
                    entryParam[1] = designAmt;
                    long mainCFAssgrp = DesignateContext.getOrCreate().isManual() ? assgrpIdParam : CashFlowItemHelperNew.getCashAssFromAccountAss(assgrpIdParam, cfItem.getLong("id"), orgId);
                    entryParam[2] = mainCFAssgrp;
                    if (itemId != 0L) {
                        CashFlowItemHelperNew.addLogList(cashFlowLogList, wrapper, 1, 1, mainCFAssgrp, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                        if (entry.getSuppcfItemId() == 0L && maincfItem == null && (isPL && !isdealactivity || !isPL && isdealactivity) || entry.getSuppcfItemId() == 0L && maincfItem != null && (isPL && !isdealactivity && maincfItem.getBoolean("isdealactivity") || !isPL && isdealactivity && !maincfItem.getBoolean("isdealactivity"))) {
                            BigDecimal suppcfAmt = BigDecimal.ZERO;
                            if (isPL && !isdealactivity) {
                                suppcfAmt = wrapper.getDebitlocal().subtract(wrapper.getCreditlocal());
                            } else {
                                suppcfAmt = wrapper.getMaincfAmt();
                                if ("o".equals(cfItem.getString("direction"))) {
                                    suppcfAmt = suppcfAmt.negate();
                                }
                            }
                            wrapper.setSuppcfAmt(suppcfAmt);
                            CashFlowItemHelperNew.addLogList(cashFlowLogList, wrapper, 1, 2, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                        }
                    }
                } else {
                    if (entry.getSuppcfItemId() == 0L) {
                        BigDecimal suppcfAmt = wrapper.getCreditlocal().subtract(wrapper.getDebitlocal());
                        DynamicObject maincfItem = wrapper.getMaincfItem();
                        if (maincfItem != null) {
                            isdealactivity = maincfItem.getBoolean("isdealactivity");
                            if (isPL && !isdealactivity) {
                                suppcfAmt = wrapper.getDebitlocal().subtract(wrapper.getCreditlocal());
                            } else if (!isPL && isdealactivity) {
                                suppcfAmt = wrapper.getMaincfAmt();
                                if ("o".equals(maincfItem.getString("direction"))) {
                                    suppcfAmt = suppcfAmt.negate();
                                }
                            }
                        }
                        wrapper.setSuppcfAmt(suppcfAmt);
                    }
                    CashFlowItemHelperNew.addLogList(cashFlowLogList, wrapper, -1, 2, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    wrapper.setSuppcfItem(cfItem);
                    wrapper.setSuppcfAmt(designAmt);
                    entryParam[3] = itemId;
                    entryParam[4] = designAmt;
                    if (itemId != 0L) {
                        CashFlowItemHelperNew.addLogList(cashFlowLogList, wrapper, 1, 2, dc, context.getComassistTable(entry.getAccounttableId()), entry);
                    }
                }
                entryParams.add(entryParam);
            }
            CashFlowItemHelperNew.calculateEntry(summary, wrapper);
        }
        voucherIds.add(voucherId);
        Tuple<String, String> status = CashFlowItemHelperNew.calStatus(summary);
        vchParam.add(new Object[]{status.item1, status.item2, voucherId});
        CashFlowItemHelperNew.calAndSave(bookIds, logParamsList, entryParams, vchParam, cashFlowLogList, orgId, bookTypeId, periodId, voucherId, voucherIds);
    }

    private static Object[] defaultParam(VchCfRowInfo rowInfo) {
        return new Object[]{rowInfo.getMaincfItemId(), rowInfo.getMaincfAmt(), rowInfo.getMaincfassgrpId(), rowInfo.getSuppcfItemId(), rowInfo.getSuppcfAmt(), rowInfo.getEntryId()};
    }

    private static Long getCashAssFromAccountAss(Long accountAssgrpId, Long cashflowId, Long orgId) {
        extLogger.info("getCashAssFromAccountAss params: assgrpId = {}, cashFlowId = {}, orgId = {}", new Object[]{accountAssgrpId, cashflowId, orgId});
        if (accountAssgrpId == 0L) {
            return 0L;
        }
        DynamicObject assist = BusinessDataServiceHelper.loadSingleFromCache((Object)accountAssgrpId, (String)"gl_assist", (String)"id");
        String assistValue = assist.getString("assvals");
        CashFLowItemFlexValueGetter cashFLowItemFlexValueGetter = new CashFLowItemFlexValueGetter();
        extLogger.info("getFromAccountFlexValueJson params: assistValue = {}", (Object)assistValue);
        long result = cashFLowItemFlexValueGetter.getFromAccountFlexValueJson(new FlexValueJson(assistValue), cashflowId, orgId);
        extLogger.info("getCashAssFromAccountAss result: {}", (Object)result);
        return result;
    }

    private static void addLogList(LogList<CashflowKey> cashFlowLogList, VchCfWrapper wrapper, int negate, int type, String dc, ComassistMidTransterModel table, VchCfRowInfo row) {
        CashFlowItemHelperNew.addLogList(cashFlowLogList, wrapper, negate, type, 0L, dc, table, row);
    }

    private static void addLogList(LogList<CashflowKey> cashFlowLogList, VchCfWrapper wrapper, int negate, int type, long assgrpId, String dc, ComassistMidTransterModel table, VchCfRowInfo row) {
        BigDecimal amt;
        long itemId;
        if (1 == type) {
            itemId = wrapper.getMaincfItem() == null ? 0L : wrapper.getMaincfItem().getLong("masterid");
            amt = wrapper.getMaincfAmt();
        } else {
            itemId = wrapper.getSuppcfItem() == null ? 0L : wrapper.getSuppcfItem().getLong("masterid");
            amt = wrapper.getSuppcfAmt();
        }
        CashflowLogKey cashflowLogKey = new CashflowLogKey(row, itemId, assgrpId, table, String.valueOf(type));
        cashflowLogKey.setDc(dc);
        cashflowLogKey.setCount(negate);
        CashflowLog cashFlowLog = new CashflowLog();
        cashFlowLog.setAmount(amt);
        cashFlowLog.setCount(1);
        if (negate == -1) {
            cashFlowLog.negate();
        }
        cashFlowLogList.add(cashflowLogKey, cashFlowLog);
    }

    public static void updateBalance(LogList<CashflowKey> cashFlowLogList, Set<String> orgBook, List<Object[]> paramList, long orgId, long bookTypeId, long periodId, long voucherId) {
        HashMap<Long, LogList<CashflowKey>> cfLogData = new HashMap<Long, LogList<CashflowKey>>();
        cfLogData.put(periodId, cashFlowLogList);
        if (cashFlowLogList.size() != 0) {
            cfLogData.put(periodId, cashFlowLogList);
        }
        String operate = "submit";
        List<Object[]> newBalParams = CashFlowItemHelperNew.getListParams(orgId, bookTypeId, voucherId, cfLogData, operate);
        paramList.addAll(newBalParams);
        orgBook.add(orgId + "-" + bookTypeId);
    }

    private static List<Object[]> getListParams(long orgId, long bookTypeId, long voucherId, Map<Long, LogList<CashflowKey>> logListMap, String operate) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(logListMap.size());
        for (Map.Entry<Long, LogList<CashflowKey>> entry : logListMap.entrySet()) {
            LogList<CashflowKey> logList = entry.getValue();
            Map<CashflowKey, kd.fi.gl.balcal.Log> balMap = logList.getData();
            for (Map.Entry<CashflowKey, kd.fi.gl.balcal.Log> entry2 : balMap.entrySet()) {
                CashflowLog cashLog = (CashflowLog)entry2.getValue();
                if (cashLog.isZero()) continue;
                Object[] groupKey = ((CashflowLogKey)entry2.getKey()).getKeyValue();
                ArrayList<Object> params = new ArrayList<Object>(groupKey.length + 11);
                long id = CashFlowItemHelperNew.getIdOnCashFlow();
                params.add(id);
                params.add(new Date());
                for (int i = 0; i < groupKey.length; ++i) {
                    params.add(groupKey[i]);
                }
                params.add(cashLog.getAmount());
                params.add(cashLog.getCount());
                params.add(operate);
                params.add(false);
                result.add(params.toArray());
            }
        }
        return result;
    }

    private static long getIdOnCashFlow() {
        return DB.genLongId((String)CashFlowName);
    }

    public static void calBal(Set<String> orgBooktypes) {
        for (String bookId : orgBooktypes) {
            String[] ids = bookId.trim().split("-");
            CalculatorCFs.calculatorSync(Long.parseLong(ids[0]), Long.parseLong(ids[1]), null, CashFlowName);
        }
    }

    public static void calculateEntry(DynamicObject vchDyn) {
        if ("1".equals(vchDyn.getString("sourcetype"))) {
            vchDyn.set("mainstatus", (Object)"0");
            vchDyn.set("suppstatus", (Object)"0");
            return;
        }
        VoucherEntriesSummary result = CashFlowItemHelperNew.calculateCashFlowOnVch(vchDyn);
        Tuple<String, String> status = CashFlowItemHelperNew.calStatus(result);
        vchDyn.set("mainstatus", status.item1);
        vchDyn.set("suppstatus", status.item2);
        vchDyn.set("vdescription", (Object)result.getVchDesc());
        vchDyn.set("debitlocamount", (Object)result.getDebitLocTotal().getSum());
        vchDyn.set("creditlocamount", (Object)result.getCreditLocTotal().getSum());
    }

    protected static Tuple<String, String> calStatus(VoucherEntriesSummary result) {
        Tuple<String, String> status = new Tuple<String, String>();
        if (result.isExistsCashAccount()) {
            if (result.isExistsPlAccount()) {
                if (result.isMainCfDesignated()) {
                    status.item1 = result.getDesiginatedMainAmt().compareTo(result.getCashAccountDebitTotal()) == 0 ? "3" : "2";
                    CashFlowItemHelperNew.setSuppStatus(status, result);
                } else {
                    status.item1 = "1";
                    status.item2 = "0";
                }
            } else if (result.isExistsNotCachNotPlAccount()) {
                status.item1 = result.isMainCfDesignated() ? (result.getDesiginatedMainAmt().compareTo(result.getCashAccountDebitTotal()) == 0 ? "3" : "2") : "1";
                CashFlowItemHelperNew.setSuppStatus(status, result);
            } else {
                status.item1 = "0";
                status.item2 = "0";
            }
        } else if (result.isExistsPlAccount()) {
            status.item1 = "0";
            if (result.isExistsNotCachNotPlAccount()) {
                CashFlowItemHelperNew.setSuppStatus(status, result);
            } else {
                status.item2 = "0";
            }
        } else {
            status.item1 = "0";
            status.item2 = result.isSuppCfDesignated() ? (result.getDesiginatedSuppAmt().compareTo(BigDecimal.ZERO) == 0 ? "c" : "b") : "a";
        }
        return status;
    }

    private static VoucherEntriesSummary calculateCashFlowOnVch(DynamicObject vchDyn) {
        VoucherEntriesSummary result = new VoucherEntriesSummary();
        DynamicObjectCollection entries = vchDyn.getDynamicObjectCollection("entries");
        if (entries.isEmpty()) {
            return result;
        }
        result.setVchDesc(((DynamicObject)entries.get(0)).getString("edescription").trim());
        for (DynamicObject entry : entries) {
            VchCfDnyWrapper vchCfWrapper = new VchCfDnyWrapper(entry);
            CashFlowItemHelperNew.calculateEntry(result, vchCfWrapper);
        }
        return result;
    }

    private static void calculateEntry(VoucherEntriesSummary result, VchCfWrapper vchEntry) {
        boolean isPlAccount;
        DynamicObject accDyn = vchEntry.getAccount();
        if (null == accDyn) {
            return;
        }
        BigDecimal creditLoc = vchEntry.getCreditlocal();
        BigDecimal debitLoc = vchEntry.getDebitlocal();
        result.getDebitLocTotal().accumulate(debitLoc, (Object[])new Object[0]);
        result.getCreditLocTotal().accumulate(creditLoc, (Object[])new Object[0]);
        if (GLUtil.isCashAcct(vchEntry.getAccount())) {
            if (!result.isExistsCashAccount()) {
                result.setExistsCashAccount(true);
            }
            result.setCashAccountDebitTotal(result.getCashAccountDebitTotal().add(debitLoc).subtract(creditLoc));
            return;
        }
        boolean bl = isPlAccount = !"0".equals(vchEntry.getAccount().getString("pltype"));
        if (!result.isExistsNotCachNotPlAccount() && !isPlAccount) {
            result.setExistsNotCachNotPlAccount(true);
        }
        if (!result.isExistsPlAccount() && isPlAccount) {
            result.setExistsPlAccount(true);
        }
        DynamicObject maincf = vchEntry.getMaincfItem();
        BigDecimal mainCfAmt = vchEntry.getMaincfAmt();
        if (maincf != null) {
            if (!result.isMainCfDesignated()) {
                result.setMainCfDesignated(true);
            }
            boolean in = true;
            if ("o".equals(maincf.getString("direction"))) {
                result.setDesiginatedMainAmt(result.getDesiginatedMainAmt().subtract(mainCfAmt));
                in = false;
            } else {
                result.setDesiginatedMainAmt(result.getDesiginatedMainAmt().add(mainCfAmt));
            }
            boolean isDealActivity = maincf.getBoolean("isdealactivity");
            if (!result.isMainCfDesignatedOnPlAcct() && isPlAccount) {
                result.setMainCfDesignatedOnPlAcct(true);
            }
            if (isDealActivity) {
                BigDecimal amtOnActivities = result.getAmtOnActivities();
                amtOnActivities = in ? amtOnActivities.add(mainCfAmt) : amtOnActivities.subtract(mainCfAmt);
                result.setAmtOnActivities(amtOnActivities);
            }
        }
        if (isPlAccount) {
            result.setNetProfit(result.getNetProfit().add(creditLoc).subtract(debitLoc));
        }
        if (vchEntry.getSuppcfItem() != null) {
            BigDecimal suppCfAmt = vchEntry.getSuppcfAmt();
            result.setDesiginatedSuppAmt(result.getDesiginatedSuppAmt().add(suppCfAmt));
            if (!result.isSuppCfDesignated()) {
                result.setSuppCfDesignated(true);
            }
        }
    }

    protected static void setSuppStatus(Tuple<String, String> tuple, VoucherEntriesSummary result) {
        BigDecimal suppAmt = result.getAmtOnActivities().subtract(result.getNetProfit());
        if (suppAmt.compareTo(result.getDesiginatedSuppAmt()) != 0) {
            tuple.item2 = result.isExistsCashAccount() && !result.isMainCfDesignated() ? "0" : (result.isSuppCfDesignated() ? "2" : "1");
        } else if (suppAmt.compareTo(result.getDesiginatedSuppAmt()) == 0) {
            tuple.item2 = result.isSuppCfDesignated() ? "3" : "0";
        }
    }

    public static DynamicObject getCfItem(Map<Long, DynamicObject> cfItemMapCache, Long cfItemId) {
        DynamicObject cfItem = cfItemMapCache.get(cfItemId);
        if (cfItem == null) {
            String selProps = "id,masterid,number,name,direction,isdealactivity";
            cfItem = BusinessDataServiceHelper.loadSingleFromCache((Object)cfItemId, (String)"gl_cashflowitem", (String)selProps);
            cfItemMapCache.put(cfItemId, cfItem);
        }
        return cfItem;
    }

    public static Set<Long> getCFItemIdByNumber(String number) {
        QFilter numFilter = new QFilter("number", "=", (Object)number);
        DynamicObjectCollection cfItems = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id", (QFilter[])numFilter.toArray());
        HashSet<Long> cfItemIds = new HashSet<Long>(1);
        for (DynamicObject cfItem : cfItems) {
            cfItemIds.add(cfItem.getLong("id"));
        }
        return cfItemIds;
    }

    public static class LogFacts {
        private Set<Long> loadSingleVchs = new HashSet<Long>(8);
        private Long loadSingleTotal = 0L;
        private Long entriesTotal = 0L;
        private Long loadSingleTotalCost = 0L;
        private Long saveTotalCost = 0L;
        private Long publishTotalCost = 0L;
        private Long getCashAssFromAccountAssTotal = 0L;
        private Long getCashAssFromAccountAssTotalCost = 0L;

        public void init() {
            this.loadSingleVchs = new HashSet<Long>(8);
            this.loadSingleTotal = 0L;
            this.entriesTotal = 0L;
            this.loadSingleTotalCost = 0L;
            this.saveTotalCost = 0L;
            this.publishTotalCost = 0L;
            this.getCashAssFromAccountAssTotal = 0L;
            this.getCashAssFromAccountAssTotalCost = 0L;
        }

        public String toString() {
            return "LogFacts{loadSingleVchs.size=" + this.loadSingleVchs.size() + ", loadSingleTotal=" + this.loadSingleTotal + ", entriesTotal=" + this.entriesTotal + ", loadSingleTotalCost=" + this.loadSingleTotalCost + ", saveTotalCost=" + this.saveTotalCost + ", publishTotalCost=" + this.publishTotalCost + ", getCashAssFromAccountAssTotal=" + this.getCashAssFromAccountAssTotal + ", getCashAssFromAccountAssTotalCost=" + this.getCashAssFromAccountAssTotalCost + '}';
        }
    }
}

