/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.AssistantDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.MasterBaseDataUtils;
import kd.fi.gl.util.OrgFilterUtils;

public class FlexValueReader {
    private static final String ASSISTANT_GROUP = "group";
    protected long mainOrgId;
    protected MatchMode matchMode;

    public FlexValueReader(long mainOrgId, MatchMode matchMode) {
        this.mainOrgId = mainOrgId;
        this.matchMode = matchMode;
    }

    public Object getSingleFlexValue(String flexField, Object value) {
        return this.batchGetFlexValue(flexField, true, value).get(0);
    }

    public List<Object> batchGetFlexValue(String flexField, boolean distinct, Object ... values) {
        String queryEntity;
        QFilterBuilder qFilterBuilder = new QFilterBuilder();
        FlexProperty flexProperty = FlexUtils.getFlexProperty(flexField);
        switch (AssistValueType.getTypeEnum(flexProperty.getValueType())) {
            case baseData: {
                queryEntity = flexProperty.getValueSource();
                QFilter baseDatapermissionFilter = this.getBaseDataFilter(queryEntity);
                qFilterBuilder.add(baseDatapermissionFilter);
                if ("bos_adminorg".equals(queryEntity)) {
                    qFilterBuilder.add(OrgFilterUtils.getOrgFilterByEntityId(queryEntity, false));
                    break;
                }
                if (!"bos_org".equals(queryEntity)) break;
                String orgFunc = flexProperty.getOrgFunc() == 0L ? "10" : String.valueOf(flexProperty.getOrgFunc());
                qFilterBuilder.add(OrgFilterUtils.getOrgFilterByViewType(orgFunc, false));
                break;
            }
            case assistData: {
                queryEntity = "bos_assistantdata_detail";
                long assistantTypeId = Long.parseLong(flexProperty.getAssistantType());
                QFilter assistantPermissionFilter = AssistantDataServiceHelper.getAssistantDataFilter((Long)assistantTypeId, (Long)this.mainOrgId);
                qFilterBuilder.add(assistantPermissionFilter).addEqual(ASSISTANT_GROUP, (Object)assistantTypeId);
                break;
            }
            default: {
                return Collections.singletonList("");
            }
        }
        DynamicProperty filterProp = this.matchMode.parser.getProperty(queryEntity);
        qFilterBuilder.addIn(filterProp.getName(), (Object)values);
        Multimap<Object, Object> valuesMap = this.queryValue(queryEntity, qFilterBuilder.toArray(new QFilter[0]), filterProp.getName());
        this.check(flexProperty.getGLName(), values, valuesMap, filterProp.getDisplayName().getLocaleValue());
        Stream<Object> resultStream = Arrays.stream(values).map(value -> StringUtils.isEmpty((CharSequence)String.valueOf(value)) ? "0" : valuesMap.get(value).iterator().next());
        return distinct ? resultStream.distinct().collect(Collectors.toList()) : resultStream.collect(Collectors.toList());
    }

    private void check(String flexName, Object[] values, Multimap<Object, Object> valuesMap, String filterPropName) {
        block4: for (Object value : values) {
            switch (valuesMap.get(value).size()) {
                case 1: {
                    continue block4;
                }
                case 0: {
                    if (!StringUtils.isNotEmpty((CharSequence)String.valueOf(value))) continue block4;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6839\u636e%2$s=%3$s\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u503c\u3002", (String)"FlexValueReader_0", (String)GLApp.instance.commonModule(), (Object[])new Object[0]), flexName, filterPropName, value));
                }
                default: {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6839\u636e%2$s=%3$s\u627e\u5230\u591a\u4e2a\u7ef4\u5ea6\u503c\u3002", (String)"FlexValueReader_1", (String)GLApp.instance.commonModule(), (Object[])new Object[0]), flexName, filterPropName, value));
                }
            }
        }
    }

    private QFilter getBaseDataFilter(String entityId) {
        return Optional.ofNullable(BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)this.mainOrgId)).orElseGet(() -> QFilter.of((String)"1=1", (Object[])new Object[0]));
    }

    private Multimap<Object, Object> queryValue(String queryEntity, QFilter[] qFilters, String filterProp) {
        HashMultimap result = HashMultimap.create();
        String masterIdField = MasterBaseDataUtils.getMasterIdField(queryEntity);
        String pkField = StringUtils.isEmpty((CharSequence)masterIdField) ? "id" : masterIdField;
        QueryServiceHelper.queryDataSet((String)"FlexValueReader#queryValue", (String)queryEntity, (String)String.join((CharSequence)",", filterProp, pkField), (QFilter[])qFilters, null).forEachRemaining(arg_0 -> FlexValueReader.lambda$queryValue$2((Multimap)result, filterProp, pkField, arg_0));
        return result;
    }

    private static /* synthetic */ void lambda$queryValue$2(Multimap result, String filterProp, String pkField, Row row) {
        result.put(row.get(filterProp), row.get(pkField));
    }

    static interface Parser {
        public DynamicProperty getProperty(String var1);
    }

    public static enum MatchMode {
        NUMBER(entityId -> {
            BasedataEntityType dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
            return dataEntityType.getProperty(dataEntityType.getNumberProperty());
        }),
        NAME(entityId -> {
            BasedataEntityType dataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
            return dataEntityType.getProperty(dataEntityType.getNameProperty());
        });

        private final Parser parser;

        private MatchMode(Parser parser) {
            this.parser = parser;
        }
    }
}

