/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.sdk.exception.BeginDtxException;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;

public class IctRecordUtil {
    private static final Log logger = LogFactory.getLog(IctRecordUtil.class);

    public static void asyncIctRecordHandle(DynamicObject[] dataEntities) {
        if (Objects.isNull(dataEntities) || dataEntities.length == 0) {
            return;
        }
        List<String> vchIds = Arrays.stream(dataEntities).map(v -> v.getString("id")).collect(Collectors.toList());
        IctRecordUtil.asyncIctRecordHandle(vchIds, OperatorType.UnAudit);
    }

    public static void asyncIctRecordCfValue(List<String> vchIds) {
        IctRecordUtil.asyncIctRecordHandle(vchIds, OperatorType.PreCf);
    }

    public static void asyncIctRecordHandle(List<String> vchIds, OperatorType operator) {
        block3: {
            DynamicObject dynAcctObj = QueryServiceHelper.queryOne((String)"ict_relacctrecord", (String)"id", null);
            DynamicObject dynCfObj = QueryServiceHelper.queryOne((String)"ict_relcfrecord", (String)"id", null);
            if (Objects.isNull(dynAcctObj) && Objects.isNull(dynCfObj)) {
                logger.info("=IctRecordUtil \u5185\u90e8\u4ea4\u6613\u6ca1\u542f\u7528");
                return;
            }
            try {
                ECGlobalSession.begin((String)"modify_voucher", (DBRoute)DBRoute.of((String)"fi"), (boolean)true);
                ECGlobalSession.setBusinessType((String)"gl_voucher");
                ECGlobalSession.setBusinessInfo(vchIds);
                ECGlobalSession.setAsync((boolean)true);
                logger.info("=IctRecordUtil vchIds\uff1a{}", vchIds);
                Lists.partition(vchIds, (int)1000).forEach(v -> {
                    CommonParam param = new CommonParam();
                    param.put((Object)"operator", (Object)operator.name());
                    param.put((Object)"vchInfo", v);
                    ECGlobalSession.register((String)"fi", (String)"ict", (String)"IctVoucherModifyService", (Param)param, (String)"modify_voucher_ict_record");
                });
            }
            catch (Exception bde) {
                if (bde instanceof BeginDtxException && DtxErrorCodeConstants.NEST_DTX_ERROR.getErrorCode().equals(((BeginDtxException)bde).getErrorCode().getCode())) break block3;
                throw bde;
            }
        }
    }

    static enum OperatorType {
        UnAudit,
        PreCf;

    }
}

