/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DateTimeReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.util.StringUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.vo.ReportFieldSettingVo;
import org.apache.commons.collections4.list.UnmodifiableList;

public class ReportFieldSettingUtil {
    public static List<ReportFieldSettingVo> getConfigs(String formId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fformid,ftype,ffield,ffieldmark,fissys from t_gl_report_field_seting ", new Object[0]);
        sql.append(" where fformid = ? ", new Object[]{formId});
        ArrayList list = new ArrayList();
        return (List)DB.query((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                ReportFieldSettingVo settingVo = new ReportFieldSettingVo();
                settingVo.setFormId(rs.getString(1));
                settingVo.setType(rs.getString(2));
                settingVo.setField(rs.getString(3));
                settingVo.setFieldMark(rs.getString(4));
                settingVo.setIsSys(rs.getString(5));
                list.add(settingVo);
            }
            return list;
        });
    }

    public static List<String> getDisplayFieldConfigs(String formId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT ffield from t_gl_report_field_seting ", new Object[0]);
        sql.append(" where fformid = ? ", new Object[]{formId});
        sql.append(" and ftype = '1' and fissys='0' ", new Object[0]);
        ArrayList list = new ArrayList();
        return (List)DB.query((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            return list;
        });
    }

    public static List<String> getFilterFieldConfigs(String formId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT ffieldmark from t_gl_report_field_seting ", new Object[0]);
        sql.append(" where fformid = ? ", new Object[]{formId});
        sql.append(" and ftype = '2' ", new Object[0]);
        ArrayList list = new ArrayList();
        return (List)DB.query((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            return list;
        });
    }

    public static List<ReportFieldSettingVo> getDisplayFieldConfigList(String formId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT ffield,ffieldmark from t_gl_report_field_seting ", new Object[0]);
        sql.append(" where fformid = ? ", new Object[]{formId});
        sql.append(" and ftype = '1' and fissys='0' ", new Object[0]);
        ArrayList list = new ArrayList(8);
        DB.query((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sql, rs -> {
            while (rs.next()) {
                ReportFieldSettingVo vo = new ReportFieldSettingVo();
                vo.setField(rs.getString(1));
                vo.setFieldMark(rs.getString(2));
                list.add(vo);
            }
            return list;
        });
        ArrayList<ReportFieldSettingVo> resList = new ArrayList<ReportFieldSettingVo>(8);
        if (!list.isEmpty()) {
            MainEntityType voucherEntity = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
            Map allFields = voucherEntity.getAllFields();
            for (ReportFieldSettingVo fieldSettingVo : list) {
                for (Map.Entry map : allFields.entrySet()) {
                    if (!((String)map.getKey()).equals(fieldSettingVo.getField()) || !StringUtils.isNotEmpty((String)((IDataEntityProperty)map.getValue()).getAlias())) continue;
                    resList.add(fieldSettingVo);
                }
            }
        }
        return resList;
    }

    public static List<ReportFieldSettingVo> getDisplayFieldConfigListWithCache(String formId) {
        return (List)ThreadCache.get((Object)("ReportFieldSettingUtil_" + formId), () -> ReportFieldSettingUtil.getDisplayFieldConfigList(formId));
    }

    public static List<ReportColumn> createCustomColumns(String formId) {
        List<String> fieldList = ReportFieldSettingUtil.getDisplayFieldConfigs(formId);
        if (fieldList != null && fieldList.size() > 0) {
            ArrayList<ReportColumn> list = new ArrayList<ReportColumn>(fieldList.size());
            MainEntityType voucherEntity = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
            for (String field : fieldList) {
                for (Map.Entry map : voucherEntity.getAllFields().entrySet()) {
                    if (!((String)map.getKey()).equals(field)) continue;
                    IDataEntityProperty entityProperty = (IDataEntityProperty)map.getValue();
                    list.add(ReportFieldSettingUtil.getColumns(entityProperty, field));
                }
            }
            return ReportFieldSettingUtil.setCstMcColumns(list);
        }
        return new ArrayList<ReportColumn>();
    }

    private static List<ReportColumn> setCstMcColumns(List<ReportColumn> cstColumns) {
        HashSet mcFields = new HashSet(8);
        UnmodifiableList configs = LocalCurrencyConfigService.queryEnableCurrencies();
        if (!configs.isEmpty()) {
            for (LocalCurrencyConfigVO configVO : configs) {
                configVO.getVoucherFields(new MCT[]{MCT.CREDIT, MCT.DEBIT}).forEach(metaField -> mcFields.add(metaField.getMetaId()));
            }
            for (ReportColumn cstColumn : cstColumns) {
                String fieldKey = cstColumn.getFieldKey();
                if (!mcFields.contains(fieldKey)) continue;
                cstColumn.setCurrencyField(null);
                cstColumn.setFieldType("decimal");
            }
        }
        return cstColumns;
    }

    private static ReportColumn getColumns(IDataEntityProperty entityProperty, String field) {
        if (entityProperty instanceof ComboProp) {
            ComboReportColumn column = new ComboReportColumn();
            column.setFieldKey(field);
            column.setCaption(entityProperty.getDisplayName());
            column.setFieldType("combofield");
            column.setComboItems(((ComboProp)entityProperty).getComboItems());
            return column;
        }
        if (entityProperty instanceof AmountProp) {
            ReportColumn column = new ReportColumn();
            column.setFieldKey(field);
            column.setCaption(entityProperty.getDisplayName());
            column.setFieldType("amount");
            column.setCurrencyField("basecurrency");
            return column;
        }
        if (entityProperty instanceof DateProp) {
            ReportColumn column = new ReportColumn();
            column.setFieldKey(field);
            column.setCaption(entityProperty.getDisplayName());
            column.setFieldType("date");
            return column;
        }
        if (entityProperty instanceof DateTimeProp) {
            DateTimeReportColumn column = new DateTimeReportColumn();
            column.setFieldKey(field);
            column.setCaption(entityProperty.getDisplayName());
            column.setFieldType("date");
            column.setFieldProperty((DynamicProperty)new DateTimeProp());
            return column;
        }
        ReportColumn column = new ReportColumn();
        column.setFieldKey(field);
        column.setCaption(entityProperty.getDisplayName());
        column.setFieldType("text");
        return column;
    }
}

