/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;

public class SpecialPermItemHelper {
    private static SpecialPermItemHelper instance;
    private static final String HARD_CODE_RULE_ID = "10YVY=EQ5WOD";
    private static final String DEFAULT_SELECTED_FIELD = "id";

    private SpecialPermItemHelper() {
    }

    public static synchronized SpecialPermItemHelper getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new SpecialPermItemHelper();
        return instance;
    }

    public boolean checkUserHasTheSpecialPermItem(Long userID, String ruleID) {
        return this.isCurUserInWhiteList(ruleID, userID);
    }

    private boolean isCurUserInWhiteList(String ruleID, Long userID) {
        return this.isCurUserInWhiteUserList(ruleID, userID) || this.isCurUserInWhiteRoleList(ruleID, userID) || this.isCurUserInWhiteUserGroupList(ruleID, userID);
    }

    private boolean isCurUserInWhiteRoleList(String ruleID, Long userID) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.getClass().getName(), (String)"perm_exceptrole", null, (QFilter[])new QFilter[]{new QFilter("operationruleobj", "=", (Object)ruleID)}, null);
        Set roleSet = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getRolesByUser(userID);
        for (int i = 0; i < doc.size(); ++i) {
            DynamicObject dObj = (DynamicObject)doc.get(i);
            String roleID = dObj.getString("role.id");
            if (!roleSet.contains(roleID)) continue;
            return true;
        }
        return false;
    }

    private boolean isCurUserInWhiteUserGroupList(String ruleID, Long userID) {
        QFilter ruleIDFilter = new QFilter("operationruleobj", "=", (Object)ruleID);
        DynamicObjectCollection userGroupIDs = QueryServiceHelper.query((String)"perm_exceptusrgrp", (String)"usergroup", (QFilter[])new QFilter[]{ruleIDFilter});
        for (DynamicObject userGroupID : userGroupIDs) {
            DynamicObjectCollection user2GroupRelationDOC = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"user", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", userGroupID.get("usergroup"))});
            for (DynamicObject relationDo : user2GroupRelationDOC) {
                if (userID.longValue() != relationDo.getLong("user")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCurUserInWhiteUserList(String ruleID, Long curUserID) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)this.getClass().getName(), (String)"perm_exceptuser", null, (QFilter[])new QFilter[]{new QFilter("operationruleobj", "=", (Object)ruleID)}, null);
        for (int i = 0; i < doc.size(); ++i) {
            DynamicObject dObj = (DynamicObject)doc.get(i);
            Long userID = dObj.getLong("user.id");
            if (userID.longValue() != curUserID.longValue()) continue;
            return true;
        }
        return false;
    }

    public DynamicObject getActivePermController(String ruleID, String selectedField) {
        QFilter enabledFilter;
        QFilter idFilter;
        DynamicObjectCollection antiClosePeriodCollection = QueryServiceHelper.query((String)"perm_operationruleobj", (String)(selectedField = selectedField == null ? DEFAULT_SELECTED_FIELD : selectedField.trim()), (QFilter[])new QFilter[]{idFilter = new QFilter("operationrule", "=", (Object)(ruleID = ruleID == null ? HARD_CODE_RULE_ID : ruleID.trim())), enabledFilter = new QFilter("objenabled", "=", (Object)"1")});
        if (antiClosePeriodCollection.isEmpty()) {
            return null;
        }
        return (DynamicObject)antiClosePeriodCollection.get(0);
    }

    public DynamicObject getActivePermRuleController(String id) {
        QFilter idFilter = new QFilter(DEFAULT_SELECTED_FIELD, "=", (Object)id);
        DynamicObjectCollection doCollection = QueryServiceHelper.query((String)"perm_operationrule", (String)"rule", (QFilter[])new QFilter[]{idFilter});
        if (doCollection.isEmpty()) {
            return null;
        }
        return (DynamicObject)doCollection.get(0);
    }
}

