/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.subsidiary.SubsidiaryAccount;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.GLUtil;

public class SubsiDiaryHelper {
    private static final String startPeriod = "startperiod";
    private static final String endPeriod = "endperiod";
    private static final String account = "account";
    private static final String acctKey = "bd_accountview";
    private static final String assistTxt = "gl_assist_txt";
    private static final String TYPE_TXT = "type_txt";
    private static final String assistDb = "gl_assist_bd";
    private static final String[] structreTreeKeys = new String[]{"bos_org", "bos_adminorg"};
    private static final String[] structureTreeValues = new String[]{"bos_org_structure", "bos_adminorg_structure"};

    public static DataSet getBalance(FilterInfo filterInfo, String balanceSel, List<Long> assgrpIds) {
        return SubsiDiaryHelper.getBalance(filterInfo, balanceSel, assgrpIds, filterInfo.getLong(startPeriod), filterInfo.getLong(endPeriod));
    }

    public static DataSet getBalance(FilterInfo filterInfo, String balanceSel, List<Long> assgrpIds, long startPeriodId, long endPeriodId) {
        AccountBookInfo defaultBook;
        long orgId = filterInfo.getLong("org");
        Set<Long> childOrgId = SubsiDiaryHelper.getChildOrgId(filterInfo);
        childOrgId.add(orgId);
        long bookTypeId = filterInfo.getLong("booktype");
        if (bookTypeId == 0L && (defaultBook = AccSysUtil.getDefaultBookFromAccSys((Long)filterInfo.getDynamicObject("org").getPkValue())) != null) {
            bookTypeId = defaultBook.getBookTypeId();
        }
        BalanceQueryExecutor balanceQueryExecutor = BalanceQueryExecutor.getInstance();
        DataSet balanceData = balanceQueryExecutor.getBalance(balanceSel, childOrgId.toArray(new Long[0]), bookTypeId, filterInfo.getLong("accounttable"), startPeriodId, endPeriodId, SubsiDiaryHelper.getParam(filterInfo, assgrpIds, null));
        return balanceData;
    }

    public static Object[] getAcctIdByMasterId(Set<Long> masterIdSet) {
        HashSet<Long> acctIdSet = new HashSet<Long>(64);
        QFilter acctIdFilter = new QFilter("masterid", "in", masterIdSet);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getAcctIdByMasterId"), (String)acctKey, (String)"id", (QFilter[])acctIdFilter.toArray(), null);){
            for (Row row : dataSet) {
                acctIdSet.add(row.getLong("id"));
            }
        }
        return acctIdSet.toArray();
    }

    public static Set<Long> getAcctMasterIds2(FilterInfo filterInfo, long orgId) {
        return (Set)ThreadCache.get((Object)Objects.hash(filterInfo, orgId), () -> {
            HashSet<Long> acctMasterIdSet = new HashSet<Long>(64);
            Object[] acctIds = SubsiDiaryHelper.getAcctIDs(filterInfo, orgId);
            QFilter acctIdFilter = new QFilter("id", "in", (Object)acctIds);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(AccountUtils.class.getName() + "#getAcctMasterIds"), (String)acctKey, (String)"masterid", (QFilter[])acctIdFilter.toArray(), null);){
                for (Row row : dataSet) {
                    acctMasterIdSet.add(row.getLong("masterid"));
                }
            }
            return acctMasterIdSet;
        });
    }

    public static Object[] getAcctMasterIds(FilterInfo filterInfo, long orgId) {
        return SubsiDiaryHelper.getAcctMasterIds2(filterInfo, orgId).toArray();
    }

    public static Object[] getAcctIDs(FilterInfo filter) {
        return SubsiDiaryHelper.getAcctIDs(filter, filter.getLong("org"));
    }

    public static Object[] getAcctIDs(FilterInfo filter, Long orgId) {
        Set<String> flexField = filter.getFlexFilterItems().stream().map(FilterItemInfo::getPropName).collect(Collectors.toSet());
        long accountTable = filter.getLong("accounttable");
        Set<Long> allValidAcctIds = ReportUtils.getAccIdsByFlexFields(Collections.singletonList(orgId), accountTable, flexField, filter.getLong(endPeriod));
        if (filter.getDynamicObjectCollection(account) != null) {
            Set<Long> accountIDsSelected = filter.getDynamicObjectCollection(account).stream().map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toSet());
            HashSet<Long> allSubAccountMasterIDsSelected = SubsiDiaryHelper.getAllSubAccountMasterID(accountIDsSelected, orgId, accountTable);
            HashSet<Long> selectedAcctIds = SubsiDiaryHelper.acctMasterIDToID(allSubAccountMasterIDsSelected);
            allValidAcctIds.retainAll(selectedAcctIds);
        }
        return allValidAcctIds.toArray();
    }

    public static HashSet<Long> getAllSubAccountMasterID(Set<Long> parentAcctIDs, Long orgID, long accountTable) {
        HashSet<Long> res = new HashSet<Long>(parentAcctIDs);
        if (parentAcctIDs.size() > 0) {
            Set longNums = BusinessDataServiceHelper.loadFromCache((String)acctKey, (String)"longnumber", (QFilter[])new QFilter("id", "in", (Object)parentAcctIDs.toArray()).toArray()).values().stream().map(dynamicObject -> dynamicObject.getString("longnumber")).collect(Collectors.toSet());
            QueryServiceHelper.query((String)acctKey, (String)String.join((CharSequence)", ", "longnumber", "masterid"), (QFilter[])new QFilter("accounttable", "=", (Object)accountTable).toArray()).stream().filter(acctDyo -> {
                String currentNum = acctDyo.getString("longnumber");
                return longNums.stream().anyMatch(currentNum::startsWith);
            }).map(acctDyo -> acctDyo.getLong("masterid")).forEach(res::add);
        }
        return res;
    }

    public static QueryParam getParam(FilterInfo filterInfo, List<Long> assgrpIds, Map<String, Object> otherParam) {
        Boolean isAddFilter;
        QueryParam param = new QueryParam();
        param.setZeroAmtNoDisplay(filterInfo.getBoolean("nodisplayforzero"));
        param.setZeroBalNoDisplay(filterInfo.getBoolean("balancezero"));
        param.setSubstractPL(filterInfo.getBoolean("issubstractpl"));
        param.setAccountVersionPeriodId(filterInfo.getLong(endPeriod));
        param.setAccountFilter(new QFilter("id", "in", (Object)SubsiDiaryHelper.getAcctIDs(filterInfo)));
        param.setOnlyLeafAcctBal(true);
        if (assgrpIds != null && !assgrpIds.isEmpty()) {
            param.setAssGrpIds(new HashSet<Long>(assgrpIds));
        }
        if (filterInfo.getDynamicObjectCollection("measureunits") != null) {
            DynamicObjectCollection unitsDynColl = filterInfo.getDynamicObjectCollection("measureunits");
            ArrayList<Long> uList = new ArrayList<Long>(unitsDynColl.size());
            for (DynamicObject dyn : unitsDynColl) {
                uList.add(dyn.getLong("id"));
            }
            param.setMeasureUnitIds(uList.toArray(new Long[0]));
        }
        long currencyId = 0L;
        String currencyVal = filterInfo.getString("currency");
        if (!"basecurrency".equals(currencyVal) && !"allcurrency".equals(currencyVal)) {
            currencyId = Long.parseLong(filterInfo.getString("currency"));
            param.setCurrencyIds(new Long[]{currencyId});
        }
        if (otherParam != null && (isAddFilter = (Boolean)otherParam.get("isAddAmountFilter")) != null) {
            param.setAddAmountFilter(isAddFilter.booleanValue());
        }
        return param;
    }

    public static Set<Long> getChildOrgId(FilterInfo filterInfo) {
        List<Object> orgs = null;
        Set<Object> childOrg = new HashSet();
        if (filterInfo.containProp("orgs")) {
            DynamicObjectCollection dyns = filterInfo.getDynamicObjectCollection("orgs");
            orgs = dyns.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        } else {
            orgs = new ArrayList<Long>();
            orgs.add(filterInfo.getLong("org"));
        }
        DynamicObject orgViewItem = filterInfo.getDynamicObject("orgview");
        if (orgs.size() == 1 && orgViewItem != null) {
            childOrg = AccSysUtil.getChildOrgsByView((Long)orgs.get(0), orgViewItem.getLong("id"), "gl_rpt_assistbalance");
        } else {
            QFilter entityFilter = new QFilter("isbizunit", "=", (Object)true);
            DynamicObjectCollection btCol = BatchProcessUtil.batchQueryDynColl(orgs, batchOrgs -> QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{new QFilter("org", "in", batchOrgs), entityFilter}));
            childOrg = btCol.stream().map(x -> x.getLong("org")).collect(Collectors.toSet());
        }
        return childOrg;
    }

    private static HashSet<Long> acctMasterIDToID(HashSet<Long> ids) {
        HashSet<Long> masterIds = new HashSet<Long>();
        if (ids == null || ids.isEmpty()) {
            return masterIds;
        }
        QFilter filter = new QFilter("id", "in", ids);
        DataSet masterSet = QueryServiceHelper.queryDataSet((String)"SubsiDiaryHelper.acctMasterIDToID", (String)acctKey, (String)"masterid", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : masterSet) {
            long masterId = row.getLong("masterid");
            masterIds.add(masterId);
        }
        HashSet<Long> acctIds = new HashSet<Long>();
        QFilter mFilter = new QFilter("masterid", "in", masterIds);
        DataSet accSet = QueryServiceHelper.queryDataSet((String)"SubsiDiaryHelper.acctMasterIDToID", (String)acctKey, (String)"id", (QFilter[])new QFilter[]{mFilter}, null);
        for (Row row : accSet) {
            long accId = row.getLong("id");
            acctIds.add(accId);
        }
        return acctIds;
    }

    public static void createAccountancyTypeColumns(List<AbstractReportColumn> reportColumns, FilterInfo filterInfo) {
        for (FilterItemInfo itemInfo : filterInfo.getFlexFilterItems()) {
            String displayProperty = "2";
            FlexProperty flexProp = FlexEntityMetaUtils.getFlexProperty((String)itemInfo.getPropName());
            if (flexProp == null) continue;
            ReportColumn column = null;
            if ("3".equals(flexProp.getValueType())) {
                column = new ReportColumn();
                column.setFieldType("text");
                column.setCaption(flexProp.getName());
                column.setFieldKey(itemInfo.getPropName());
                reportColumns.add((AbstractReportColumn)column);
                continue;
            }
            BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)flexProp.getValueSource());
            String numField = entity.getNumberProperty();
            if (flexProp == null) continue;
            displayProperty = flexProp.getDisplayStyle().getDisplayProperty().getValue();
            if ("1".equals(displayProperty)) {
                SubsiDiaryHelper.addNumberColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE, numField);
                SubsiDiaryHelper.addNameColumn(reportColumns, itemInfo, flexProp, Boolean.TRUE);
                continue;
            }
            if ("2".equals(displayProperty) || null == displayProperty) {
                SubsiDiaryHelper.addNameColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE);
                continue;
            }
            if (!"3".equals(displayProperty)) continue;
            SubsiDiaryHelper.addNumberColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE, numField);
            SubsiDiaryHelper.addNameColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE);
        }
    }

    public static void createAccountancyTypeColumns2(List<AbstractReportColumn> reportColumns, FilterInfo filterInfo) {
        for (FilterItemInfo itemInfo : filterInfo.getFlexFilterItems()) {
            String displayProperty = "2";
            FlexProperty flexProp = FlexEntityMetaUtils.getFlexProperty((String)itemInfo.getPropName());
            if (flexProp == null) continue;
            ReportColumn column = null;
            if ("3".equals(flexProp.getValueType())) {
                column = new ReportColumn();
                column.setFieldType("text");
                column.setCaption(flexProp.getName());
                column.setFieldKey(itemInfo.getPropName());
                reportColumns.add((AbstractReportColumn)column);
                continue;
            }
            BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)flexProp.getValueSource());
            String numField = entity.getNumberProperty();
            if (flexProp == null) continue;
            displayProperty = flexProp.getDisplayStyle().getDisplayProperty().getValue();
            if ("1".equals(displayProperty)) {
                SubsiDiaryHelper.addNumberColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE, numField);
                SubsiDiaryHelper.addNameColumn(reportColumns, itemInfo, flexProp, Boolean.TRUE);
                continue;
            }
            if ("2".equals(displayProperty) || null == displayProperty) {
                SubsiDiaryHelper.addNameColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE);
                continue;
            }
            if ("3".equals(displayProperty)) {
                SubsiDiaryHelper.addNumberColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE, numField);
                SubsiDiaryHelper.addNameColumn(reportColumns, itemInfo, flexProp, Boolean.FALSE);
                continue;
            }
            String displayField = "4".equals(displayProperty) ? "longNumber" : "fullName";
            String caption = "4".equals(displayProperty) ? String.format(ResManager.loadKDString((String)"%s\u957f\u7f16\u7801", (String)"SubsiDiaryHelper_10", (String)"fi-gl-common", (Object[])new Object[0]), flexProp.getName()) : String.format(ResManager.loadKDString((String)"%s\u957f\u540d\u79f0", (String)"SubsiDiaryHelper_11", (String)"fi-gl-common", (Object[])new Object[0]), flexProp.getName());
            ReportColumn column2 = ReportColumn.createBaseDataColumn((String)flexProp.getFlexField(), (String)flexProp.getValueSource());
            column2.setDisplayProp(displayField);
            column2.setCaption(new LocaleString(caption));
            column2.setFreeze(true);
            column2.setHide(Boolean.FALSE.booleanValue());
            reportColumns.add((AbstractReportColumn)column2);
        }
    }

    private static void addNameColumn(List<AbstractReportColumn> reportColumns, FilterItemInfo itemInfo, FlexProperty flexProp, Boolean isHide) {
        ReportColumn column = null;
        if ("1".equals(flexProp.getValueType()) && flexProp.getValueSource() != null) {
            column = ReportColumn.createBaseDataColumn((String)itemInfo.getPropName(), (String)flexProp.getValueSource());
        } else if ("2".equals(flexProp.getValueType()) && flexProp.getAssistantType() != null) {
            column = ReportColumn.createBaseDataColumn((String)itemInfo.getPropName(), (String)"bos_assistantdata_detail");
        }
        if (column != null) {
            column.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u540d\u79f0", (String)"SubsiDiaryHelper_0", (String)"fi-gl-common", (Object[])new Object[0]), flexProp.getName())));
            column.setHide(isHide.booleanValue());
            reportColumns.add((AbstractReportColumn)column);
        }
    }

    private static void addNumberColumn(List<AbstractReportColumn> reportColumns, FilterItemInfo itemInfo, FlexProperty flexProp, Boolean isHide, String numField) {
        ReportColumn column = ReportColumn.createBaseDataPropColumn((String)(itemInfo.getPropName() + "." + numField), (String)itemInfo.getPropName(), (String)numField);
        column.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"SubsiDiaryHelper_1", (String)"fi-gl-common", (Object[])new Object[0]), flexProp.getName())));
        column.setFreeze(true);
        column.setHide(isHide.booleanValue());
        reportColumns.add((AbstractReportColumn)column);
    }

    public static DataSet createDatSet(List<String> fileds, List<DataType> dataType, List<List<Long>> fValList) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fileds.toArray(new String[fileds.size()]), (DataType[])dataType.toArray(new DataType[dataType.size()]));
        Algo algo = Algo.create((String)"query");
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (List<Long> row : fValList) {
            builder.append((Object[])row.toArray(new Long[row.size()]));
        }
        return builder.build();
    }

    public static DataSet createObjSet(List<String> fileds, List<DataType> dataType, List<List<Object>> fValList) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fileds.toArray(new String[fileds.size()]), (DataType[])dataType.toArray(new DataType[dataType.size()]));
        Algo algo = Algo.create((String)"query");
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (List<Object> row : fValList) {
            builder.append(row.toArray(new Object[row.size()]));
        }
        return builder.build();
    }

    public static void getLeafIds(HashSet<Long> ids, HashSet<Long> idList) {
        QFilter fparent = new QFilter("parent", "in", ids);
        DynamicObjectCollection col = QueryServiceHelper.query((String)acctKey, (String)"id,parent,level,isleaf", (QFilter[])fparent.toArray());
        HashSet<Long> unLeafAcctIds = new HashSet<Long>();
        if (col != null) {
            for (DynamicObject obj : col) {
                long acctId = obj.getLong("id");
                idList.add(acctId);
                unLeafAcctIds.add(acctId);
            }
        }
        if (unLeafAcctIds.size() > 0) {
            SubsiDiaryHelper.getLeafIds(unLeafAcctIds, idList);
        }
    }

    public static HashSet<Long> getLeafAcct(HashSet<Long> ids) {
        QFilter fparent = new QFilter("id", "in", ids);
        DynamicObjectCollection col = QueryServiceHelper.query((String)acctKey, (String)"id,parent,level,isleaf", (QFilter[])fparent.toArray());
        HashSet<Long> leafIds = new HashSet<Long>();
        if (col != null) {
            for (DynamicObject obj : col) {
                long acctId = obj.getLong("id");
                if (!obj.getBoolean("isleaf")) continue;
                leafIds.add(acctId);
            }
        }
        return leafIds;
    }

    public static void getMulTreeLeafIdToMap(Map<Long, Map<Long, Long>> leafIdToMap, Map<Long, Long> leafIdToIdMap, Set<Long> ids, String entityNumber, Set<Long> noLeafIds, Map<Long, Integer> levelMap, Map<Long, String> longNumberMap, Map<Long, Long> relationMap, Map<String, Long> indexMap, Set<Long> pids) {
        QFilter fid = new QFilter("id", "in", ids);
        String sel = "parent pid, id, isleaf, level, longnumber";
        DataSet childSet = QueryServiceHelper.queryDataSet((String)"SubsiDiaryHelper.getPIdToIdMap", (String)entityNumber, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        HashMap<Long, Long> tempIdToLeafIdMap = new HashMap<Long, Long>();
        ids.clear();
        for (Row row : childSet) {
            long pid = row.getLong("pid");
            long id = row.getLong("id");
            if (relationMap.get(id) == null) {
                long index = indexMap.get("index");
                relationMap.put(id, index);
                indexMap.put("index", ++index);
            }
            for (Map.Entry<Long, Long> entryVal : leafIdToIdMap.entrySet()) {
                long idVal = entryVal.getValue();
                if (idVal != id) continue;
                long leafId = entryVal.getKey();
                if (leafIdToMap.get(leafId) == null) {
                    HashMap<Long, Long> idToPidMap = new HashMap<Long, Long>();
                    idToPidMap.put(id, pid);
                    leafIdToMap.put(leafId, idToPidMap);
                } else {
                    leafIdToMap.get(leafId).put(id, pid);
                }
                if (pid == 0L) continue;
                ids.add(pid);
                tempIdToLeafIdMap.put(leafId, pid);
            }
            if (!row.getBoolean("isleaf").booleanValue()) {
                noLeafIds.add(id);
            }
            levelMap.put(id, row.getInteger("level"));
            longNumberMap.put(id, row.getString("longnumber"));
        }
        leafIdToIdMap.clear();
        leafIdToIdMap.putAll(tempIdToLeafIdMap);
        if (!ids.isEmpty()) {
            pids.addAll(ids);
            SubsiDiaryHelper.getTreeLeafIdToMap(leafIdToMap, leafIdToIdMap, ids, entityNumber, noLeafIds, levelMap, longNumberMap, relationMap, indexMap, pids, 0L);
        }
    }

    public static void getTreeLeafIdToMap(Map<Long, Map<Long, Long>> leafIdToMap, Map<Long, Long> leafIdToIdMap, Set<Long> ids, String entityNumber, Set<Long> noLeafIds, Map<Long, Integer> levelMap, Map<Long, String> longNumberMap, Map<Long, Long> relationMap, Map<String, Long> indexMap, Set<Long> pids, long orgViewId) {
        DataSet childSet;
        if (SubsiDiaryHelper.isContainsStructTree(entityNumber)) {
            childSet = SubsiDiaryHelper.queryStructTree(ids, entityNumber, orgViewId);
        } else {
            QFilter fid = new QFilter("id", "in", ids);
            String sel = "parent pid, id, isleaf, level, longnumber";
            childSet = QueryServiceHelper.queryDataSet((String)"SubsiDiaryHelper.getPIdToIdMap", (String)entityNumber, (String)sel, (QFilter[])new QFilter[]{fid}, null);
        }
        HashMap<Long, Long> tempIdToLeafIdMap = new HashMap<Long, Long>();
        ids.clear();
        for (Row row : childSet) {
            long pid = row.getLong("pid");
            long id = row.getLong("id");
            if (relationMap.get(id) == null) {
                long index = indexMap.get("index");
                relationMap.put(id, index);
                indexMap.put("index", ++index);
            }
            for (Map.Entry<Long, Long> entryVal : leafIdToIdMap.entrySet()) {
                long idVal = entryVal.getValue();
                if (idVal != id) continue;
                long leafId = entryVal.getKey();
                if (leafIdToMap.get(leafId) == null) {
                    HashMap<Long, Long> idToPidMap = new HashMap<Long, Long>();
                    idToPidMap.put(id, pid);
                    leafIdToMap.put(leafId, idToPidMap);
                } else {
                    leafIdToMap.get(leafId).put(id, pid);
                }
                if (pid == 0L) continue;
                ids.add(pid);
                tempIdToLeafIdMap.put(leafId, pid);
            }
            if (!row.getBoolean("isleaf").booleanValue()) {
                noLeafIds.add(id);
            }
            levelMap.put(id, row.getInteger("level"));
            longNumberMap.put(id, row.getString("longnumber"));
        }
        leafIdToIdMap.clear();
        leafIdToIdMap.putAll(tempIdToLeafIdMap);
        if (!ids.isEmpty()) {
            pids.addAll(ids);
            SubsiDiaryHelper.getTreeLeafIdToMap(leafIdToMap, leafIdToIdMap, ids, entityNumber, noLeafIds, levelMap, longNumberMap, relationMap, indexMap, pids, orgViewId);
        }
    }

    private static boolean isContainsStructTree(String entityName) {
        List<String> list = Arrays.asList(structreTreeKeys);
        return list.contains(entityName);
    }

    private static DataSet queryStructTree(Set<Long> ids, String entityName, long orgViewId) {
        List<String> keyList = Arrays.asList(structreTreeKeys);
        List<String> valueList = Arrays.asList(structureTreeValues);
        if (!keyList.contains(entityName)) {
            return null;
        }
        int index = keyList.indexOf(entityName);
        String structureEntityName = valueList.get(index);
        QFilter fview = new QFilter("view", "=", (Object)orgViewId);
        String sel = "parent pid, org id, isleaf, level, longnumber";
        DataSet result = BatchProcessUtil.batchQueryDataSet(ids, batchOrgs -> {
            QFilter forg = new QFilter("org", "in", batchOrgs);
            return QueryServiceHelper.queryDataSet((String)"SubsiDiaryHelper.queryStructTree", (String)structureEntityName, (String)sel, (QFilter[])new QFilter[]{forg, fview}, null);
        });
        return result;
    }

    public static void getDetailOrParent(Set<Long> parents, Map<Long, Map<Long, Long>> leafIdToMap, Map<Long, Long> relationMap, Map<String, Long> indexMap) {
        HashSet<Long> result = new HashSet<Long>();
        result.addAll(leafIdToMap.keySet());
        result.retainAll(parents);
        if (!result.isEmpty()) {
            for (Map.Entry<Long, Map<Long, Long>> entryMap : leafIdToMap.entrySet()) {
                if (!result.contains(entryMap.getKey())) continue;
                Long index = indexMap.get("index");
                entryMap.getValue().put(index, entryMap.getKey());
                relationMap.put(index, entryMap.getKey());
                Long l = index;
                Long l2 = index = Long.valueOf(index + 1L);
                indexMap.put("index", index);
                result.remove(entryMap.getKey());
            }
        }
    }

    public static DataSet createMulTreeMapSet(Map<Long, Map<Long, Long>> leafIdToMap, String groupEntityId, List<String> listField, Map<Long, Integer> levelMap, Map<Long, String> longNumberMap, Map<Long, Long> relationMap, DataSet relationSet) {
        Set<Long> groupIds = SubsiDiaryHelper.getKeyMap(leafIdToMap);
        QFilter fgroupId = new QFilter("id", "in", groupIds);
        String sel = "name treename, number treenumber, id";
        DataSet groupNameSet = QueryServiceHelper.queryDataSet((String)"SubsiDiaryHelper.getPIdToIdMap", (String)groupEntityId, (String)sel, (QFilter[])new QFilter[]{fgroupId}, null);
        ArrayList<List<Object>> listSetVal = new ArrayList<List<Object>>();
        for (Map.Entry<Long, Map<Long, Long>> entryMap : leafIdToMap.entrySet()) {
            long leafId = entryMap.getKey();
            Map<Long, Long> allParentMap = entryMap.getValue();
            for (Map.Entry<Long, Long> parentMap : allParentMap.entrySet()) {
                ArrayList<Object> listRow = new ArrayList<Object>();
                long groupId = parentMap.getKey();
                long pid = parentMap.getValue();
                listRow.add(relationMap.get(pid));
                listRow.add(relationMap.get(groupId));
                listRow.add(leafId);
                listRow.add("1");
                listRow.add(levelMap.get(groupId));
                listRow.add(longNumberMap.get(groupId));
                listSetVal.add(listRow);
            }
        }
        ArrayList<DataType> listData = new ArrayList<DataType>();
        listData.add((DataType)DataType.LongType);
        listData.add((DataType)DataType.LongType);
        listData.add((DataType)DataType.LongType);
        listData.add((DataType)DataType.IntegerType);
        listData.add((DataType)DataType.IntegerType);
        listData.add((DataType)DataType.StringType);
        DataSet groupSet = SubsiDiaryHelper.createObjSet(listField, listData, listSetVal);
        groupNameSet = groupNameSet.join(relationSet, JoinType.LEFT).on("id", "id").select(new String[]{"treename", "treenumber", "pid"}).finish();
        groupSet = groupSet.join(groupNameSet, JoinType.LEFT).on("id", "pid").select(listField.toArray(new String[0]), new String[]{"treename", "treenumber"}).finish();
        return groupSet;
    }

    public static Set<Long> getKeyMap(Map<Long, Map<Long, Long>> leafIdToMap) {
        HashSet<Long> keys = new HashSet<Long>();
        for (Map.Entry<Long, Map<Long, Long>> entryMap : leafIdToMap.entrySet()) {
            Map<Long, Long> allParentMap = entryMap.getValue();
            for (Map.Entry<Long, Long> parentMap : allParentMap.entrySet()) {
                keys.add(parentMap.getKey());
            }
        }
        return keys;
    }

    public static DataSet createTreeMapSet(Map<Long, Map<Long, Long>> leafIdToMap, List<String> listField, Set<Long> noLeafIds, Map<Long, Integer> levelMap, Map<Long, String> longNumberMap, Map<Long, Long> relationMap) {
        ArrayList<List<Object>> listSetVal = new ArrayList<List<Object>>();
        for (Map.Entry<Long, Map<Long, Long>> entryMap : leafIdToMap.entrySet()) {
            long leafId = entryMap.getKey();
            Map<Long, Long> allToMap = entryMap.getValue();
            Set<Long> leafList = SubsiDiaryHelper.isLeafMap(allToMap);
            for (Map.Entry<Long, Long> allMap : allToMap.entrySet()) {
                ArrayList<Object> listRow = new ArrayList<Object>();
                long id = allMap.getKey();
                long pid = allMap.getValue();
                if (noLeafIds.contains(id) && !leafList.contains(id)) {
                    listRow.add(id);
                    listRow.add(relationMap.get(pid));
                    listRow.add(relationMap.get(id));
                    listRow.add(leafId);
                    listRow.add("1");
                } else {
                    long idVal;
                    long rId = relationMap.get(id);
                    if (relationMap.get(id) != null && (idVal = relationMap.get(id).longValue()) == pid) {
                        rId = id;
                        id = idVal;
                    }
                    listRow.add(id);
                    listRow.add(relationMap.get(pid));
                    listRow.add(rId);
                    listRow.add(leafId);
                    listRow.add("0");
                }
                listRow.add(levelMap.get(id));
                listRow.add(longNumberMap.get(id));
                listSetVal.add(listRow);
            }
        }
        ArrayList<DataType> listData = new ArrayList<DataType>();
        listData.add((DataType)DataType.LongType);
        listData.add((DataType)DataType.LongType);
        listData.add((DataType)DataType.LongType);
        listData.add((DataType)DataType.LongType);
        listData.add((DataType)DataType.IntegerType);
        listData.add((DataType)DataType.IntegerType);
        listData.add((DataType)DataType.StringType);
        return SubsiDiaryHelper.createObjSet(listField, listData, listSetVal);
    }

    private static Set<Long> isLeafMap(Map<Long, Long> idToPidMap) {
        HashSet<Long> ids = new HashSet<Long>(idToPidMap.size());
        HashSet<Long> pids = new HashSet<Long>(idToPidMap.size());
        for (Map.Entry<Long, Long> entry : idToPidMap.entrySet()) {
            long id = entry.getKey();
            ids.add(id);
            long pid = entry.getValue();
            pids.add(pid);
        }
        ids.removeAll(pids);
        return ids;
    }

    public static DataSet buildTreeByMap(Map<Long, Long> idToPidMap) {
        ArrayList<List<Long>> listSetVal = new ArrayList<List<Long>>(idToPidMap.size());
        for (Map.Entry<Long, Long> entryMap : idToPidMap.entrySet()) {
            long id = entryMap.getKey();
            long pid = entryMap.getValue();
            ArrayList<Long> ids = new ArrayList<Long>(2);
            ids.add(id);
            ids.add(pid);
            listSetVal.add(ids);
        }
        ArrayList<DataType> listDataType = new ArrayList<DataType>();
        listDataType.add((DataType)DataType.LongType);
        listDataType.add((DataType)DataType.LongType);
        ArrayList<String> fieldKeys = new ArrayList<String>();
        fieldKeys.add("id");
        fieldKeys.add("pid");
        return SubsiDiaryHelper.createDatSet(fieldKeys, listDataType, listSetVal);
    }

    public static long getOrgViewId(String valuetype, String entityName, String flexField) {
        String orgFuncId = SubsiDiaryHelper.getOrgFuncId(valuetype, entityName, flexField);
        orgFuncId = orgFuncId == null ? "01" : orgFuncId;
        return OrgUnitServiceHelper.getViewIdByType((String)orgFuncId);
    }

    public static String getOrgFuncId(String valuetype, String entityName, String flexField) {
        if ("bos_adminorg".equals(entityName)) {
            return "01";
        }
        String orgFuncId = "15";
        if (!"1".equals(valuetype) && !"bos_org".equals(entityName) && StringUtils.isNotBlank((CharSequence)flexField)) {
            return null;
        }
        FlexProperty flexProperty = FlexEntityMetaUtils.getFlexProperty((String)flexField);
        if (null != flexProperty && StringUtils.isNotBlank((CharSequence)flexProperty.getOrgFuncNumber())) {
            return flexProperty.getOrgFuncNumber();
        }
        return orgFuncId;
    }

    public static DataSet acctBalanceHyper(DataSet assSet, Map<String, List<String>> entityNameFlexsMap) {
        if (assSet == null || entityNameFlexsMap == null || entityNameFlexsMap.isEmpty()) {
            return assSet;
        }
        ArrayList<Long> hgIds = new ArrayList<Long>();
        Field field = assSet.getRowMeta().getField("id", false);
        if (field == null) {
            field = assSet.getRowMeta().getField("hg", false);
        }
        String fieldAlias = field.getAlias();
        for (Object row : assSet.copy()) {
            hgIds.add(row.getLong(fieldAlias));
        }
        DataSet hgSet = null;
        for (Map.Entry entry : entityNameFlexsMap.entrySet()) {
            String entityName = (String)entry.getKey();
            List flexs = (List)entry.getValue();
            QFilter fflex = new QFilter("asstype", "not in", (Object)flexs);
            QFilter fval = null;
            fval = assistTxt.equals(entityName) ? new QFilter("assval", "!=", (Object)"0") : new QFilter("assval", "!=", (Object)0);
            QFilter fhg = new QFilter("hg", "in", hgIds);
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(fflex);
            list.add(fval);
            list.add(fhg);
            String selectFields = "hg";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SubsiDiaryHelper.acctBalanceHyper", (String)entityName, (String)selectFields, (QFilter[])list.toArray(new QFilter[0]), null);
            hgSet = hgSet == null ? dataSet : dataSet.join(hgSet, JoinType.INNER).on("hg", "hg").select(new String[]{"hg"}, new String[0]).finish();
        }
        HashSet<Long> noHgIds = new HashSet<Long>();
        if (hgSet != null) {
            for (Row row : hgSet) {
                noHgIds.add(row.getLong("hg"));
            }
        }
        hgIds.removeAll(noHgIds);
        HashMap<String, ArrayList<Long>> hashMap = new HashMap<String, ArrayList<Long>>();
        hashMap.put("hgIds", hgIds);
        assSet = assSet.filter(fieldAlias + " in hgIds", hashMap);
        return assSet;
    }

    public static DataSet assToAssgrp(FilterInfo filterInfo, Object obj, Map<String, Tuple2<String, Set<Object>>> assistMap) {
        DataSet assTypeData = null;
        if (!SubsiDiaryHelper.isExportAll(filterInfo) && SubsiDiaryHelper.isAllNull(obj)) {
            return SubsiDiaryHelper.createNullDataSet((Map)obj, assistMap);
        }
        HashMap<String, List<String>> entityNameFlexsMap = new HashMap<String, List<String>>();
        boolean isOnlyQueryeAssist = filterInfo.getBoolean("firstHyperFormId");
        boolean preFilter = false;
        boolean curFilter = false;
        int i = 0;
        String dsFilter = null;
        for (FilterItemInfo itemInfo : filterInfo.getFlexFilterItems()) {
            String assType = itemInfo.getPropName();
            QFilter filter = new QFilter("asstype", "=", (Object)assType);
            QFilter fassVal = null;
            Tuple2<String, Set<Object>> tuple2 = assistMap.get(assType);
            Set assval = (Set)tuple2.t2;
            curFilter = assval != null && assval.size() > 0;
            if (SubsiDiaryHelper.isExportAll(filterInfo)) {
                if (assval != null && assval.size() > 0) {
                    fassVal = new QFilter("assval", "in", (Object)assval);
                }
            } else {
                fassVal = SubsiDiaryHelper.getLeftFilter(obj, assType);
            }
            String selectFields = "assval " + assType + (i == 0 ? ", hg" : ",hg hg1");
            String entityName = assistDb;
            QFilter fnotZero = new QFilter("assval", "!=", (Object)0);
            if (TYPE_TXT.equals(tuple2.t1)) {
                entityName = assistTxt;
                fnotZero = new QFilter("assval", "!=", (Object)Character.valueOf('0'));
            }
            if (isOnlyQueryeAssist) {
                List<String> flexs;
                if (entityNameFlexsMap.get(entityName) == null) {
                    flexs = new ArrayList<String>();
                    flexs.add(assType);
                    entityNameFlexsMap.put(entityName, flexs);
                } else {
                    flexs = (List)entityNameFlexsMap.get(entityName);
                    flexs.add(assType);
                }
            }
            if (fassVal != null) {
                filter = filter.and(fassVal);
            }
            DataSet assSet = QueryServiceHelper.queryDataSet((String)"SubsiDiaryHelper.assToAssgrp", (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{filter.and(fnotZero)}, null);
            if (assTypeData == null) {
                assTypeData = assSet;
            } else {
                List<String> selField = SubsiDiaryHelper.getSetField(assTypeData);
                List<String> newField = SubsiDiaryHelper.getSel(selField, assType);
                JoinType joinType = preFilter && curFilter ? JoinType.INNER : (preFilter ? JoinType.LEFT : (curFilter ? JoinType.RIGHT : JoinType.FULL));
                assTypeData = assTypeData.join(assSet, joinType).on("hg", "hg1").select(selField.toArray(new String[0]), new String[]{assType, "hg1"}).finish().select(newField.toArray(new String[0]));
                if (dsFilter != null) {
                    assTypeData = assTypeData.filter(dsFilter);
                }
            }
            if (!SubsiDiaryHelper.isExportAll(filterInfo)) {
                dsFilter = SubsiDiaryHelper.getDsFilter(obj, assType);
            }
            preFilter = curFilter || preFilter;
            ++i;
        }
        if (dsFilter != null) {
            assTypeData = assTypeData.filter(SubsiDiaryHelper.getDsFilter(obj));
        }
        if (isOnlyQueryeAssist) {
            assTypeData = SubsiDiaryHelper.acctBalanceHyper(assTypeData, entityNameFlexsMap);
        }
        return assTypeData;
    }

    private static DataSet createNullDataSet(Map<String, Object> obj, Map<String, Tuple2<String, Set<Object>>> assistMap) {
        Map<String, Object> param = obj;
        ArrayList<Field> fields = new ArrayList<Field>(16);
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            Tuple2<String, Set<Object>> tuple2 = assistMap.get(entry.getKey());
            if (TYPE_TXT.equals(tuple2.t1)) {
                fields.add(new Field(entry.getKey(), (DataType)DataType.StringType));
                continue;
            }
            fields.add(new Field(entry.getKey(), (DataType)DataType.LongType));
        }
        fields.add(new Field("hg", (DataType)DataType.LongType));
        int size = param.size();
        Object[] vals = new Object[size + 1];
        for (int i = 0; i < size; ++i) {
            vals[i] = null;
        }
        vals[size] = 0;
        ArrayList<Object[]> list = new ArrayList<Object[]>(1);
        list.add(vals);
        RowMeta meta = new RowMeta(fields.toArray(new Field[0]));
        DataSet subTotal = Algo.create((String)"SubsiDiaryHelper").createDataSet(list.iterator(), meta);
        return subTotal;
    }

    private static boolean isAllNull(Object obj) {
        boolean isZero = true;
        if (obj instanceof Map) {
            Map param = (Map)obj;
            for (Map.Entry entry : param.entrySet()) {
                if ("0".equalsIgnoreCase(entry.getValue().toString()) || "-1".equalsIgnoreCase(entry.getValue().toString()) || "".equalsIgnoreCase(entry.getValue().toString())) continue;
                isZero = false;
                break;
            }
            if (isZero) {
                return true;
            }
        }
        return false;
    }

    private static List<String> getSel(List<String> sel, String assType) {
        ArrayList<String> result = new ArrayList<String>(10);
        for (String field : sel) {
            if (field.equalsIgnoreCase("hg")) continue;
            result.add(field);
        }
        result.add(assType);
        result.add("case when hg is null then hg1 else hg end hg");
        return result;
    }

    public static boolean isExport(FilterInfo filterInfo) {
        FilterItemInfo eInfo;
        List listExps;
        return filterInfo.getFilterItems("exportexcel") != null && (listExps = filterInfo.getFilterItems("exportexcel")).size() == 1 && ("all".equals((eInfo = (FilterItemInfo)listExps.get(listExps.size() - 1)).getValue()) || "single".equals(eInfo.getValue()));
    }

    public static boolean isExportByQuery(FilterInfo filterInfo) {
        List listExps;
        if (filterInfo.getFilterItems("exportexcel") != null && (listExps = filterInfo.getFilterItems("exportexcel")).size() == 1) {
            FilterItemInfo eInfo = (FilterItemInfo)listExps.get(0);
            return "single".equals(eInfo.getValue());
        }
        return false;
    }

    public static boolean isExportAll(FilterInfo filterInfo) {
        FilterItemInfo eInfo;
        List listExps;
        return filterInfo.getFilterItems("exportexcel") != null && (listExps = filterInfo.getFilterItems("exportexcel")).size() == 1 && "all".equals((eInfo = (FilterItemInfo)listExps.get(listExps.size() - 1)).getValue());
    }

    public static boolean isBaseCurrencyByQuery(FilterInfo filterInfo) {
        FilterItemInfo eInfo;
        List listExps;
        return filterInfo.getFilterItems("currency") != null && (listExps = filterInfo.getFilterItems("currency")).size() == 1 && "basecurrency".equals((eInfo = (FilterItemInfo)listExps.get(listExps.size() - 1)).getValue());
    }

    private static QFilter getLeftFilter(Object obj, String key) {
        QFilter filter = null;
        if (obj instanceof DynamicObject) {
            DynamicObject dyo = (DynamicObject)obj;
            filter = new QFilter("assval", "=", dyo.get(key + "_id"));
        } else {
            Map param = (Map)obj;
            if (param.get(key) instanceof Long || param.get(key) instanceof String) {
                if ("0".equalsIgnoreCase(param.get(key).toString()) || "-1".equalsIgnoreCase(param.get(key).toString())) {
                    return null;
                }
                filter = new QFilter("assval", "=", param.get(key));
            } else if (param.get(key) instanceof List || param.get(key) instanceof Set) {
                filter = new QFilter("assval", "in", param.get(key));
            }
        }
        return filter;
    }

    private static String getDsFilter(Object obj, String key) {
        String filter = "1=1";
        if (!(obj instanceof DynamicObject)) {
            Map param = (Map)obj;
            Object val = param.get(key);
            if (val instanceof Long || val instanceof String) {
                filter = "0".equalsIgnoreCase(val.toString()) || "-1".equalsIgnoreCase(val.toString()) || "".equals(val.toString()) ? key + " is null" : (val instanceof String ? key + " = '" + param.get(key) + "'" : key + " = " + param.get(key));
            } else if (param.get(key) instanceof List || param.get(key) instanceof Set) {
                // empty if block
            }
        }
        return filter;
    }

    private static String getDsFilter(Object obj) {
        String filter = "1=1";
        ArrayList<String> list = new ArrayList<String>();
        if (!(obj instanceof DynamicObject)) {
            Map param = (Map)obj;
            for (Map.Entry enrty : param.entrySet()) {
                String key = (String)enrty.getKey();
                Object val = enrty.getValue();
                if (val instanceof Long || val instanceof String) {
                    if ("0".equalsIgnoreCase(val.toString()) || "-1".equalsIgnoreCase(val.toString()) || "".equals(val.toString())) {
                        list.add(key + " is null");
                        continue;
                    }
                    if (val instanceof String) {
                        list.add(key + " = '" + param.get(key) + "'");
                        continue;
                    }
                    list.add(key + " = " + param.get(key));
                    continue;
                }
                if (!(param.get(key) instanceof List) && !(param.get(key) instanceof Set)) continue;
            }
        }
        if (list.isEmpty()) {
            return filter;
        }
        return String.join((CharSequence)" and ", list.toArray(new String[0]));
    }

    public static List<String> getSetField(DataSet dataSet) {
        if (dataSet == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(16);
        RowMeta meta = dataSet.getRowMeta();
        int count = meta.getFieldCount();
        for (int i = 0; i < count; ++i) {
            String alias = meta.getFieldAlias(i);
            list.add(alias);
        }
        return list;
    }

    public static void queryLastVersionAccount(ReportQueryParam param, Row row, Map<Long, SubsidiaryAccount> acctID2MIDMap, QueryParamRpt qpRpt) {
        QFilter idFilter = new QFilter("id", "=", (Object)row.getLong(account));
        String accountNameField = GLUtil.getAcctNameBySysParam(qpRpt.getPorg());
        String selFields = String.format("masterid, id account, dc, %s name, number", accountNameField);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(SubsiDiaryHelper.class.getName() + "#queryLastVersionAccount"), (String)acctKey, (String)selFields, (QFilter[])idFilter.toArray(), null);){
            for (Row dynRow : dataSet) {
                SubsidiaryAccount account = new SubsidiaryAccount();
                account.setId(dynRow.getLong(account));
                account.setMasterid(dynRow.getLong("masterid"));
                account.setName(dynRow.getString("name"));
                account.setDc(dynRow.getInteger("dc"));
                account.setNumber(dynRow.getString("number"));
                acctID2MIDMap.put(account.getId(), account);
            }
            param.getCustomParam().put("acctID2MIDMap", acctID2MIDMap);
        }
    }

    public static void addAcctMID2IDMap(ReportQueryParam param, Row row, Map<Long, SubsidiaryAccount> acctMID2IDMap, QueryParamRpt qpRpt) {
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)qpRpt.getEndPeriod(), (String)"bd_period");
        try (DataSet accSet = ReportUtils.getAccountInfos(row.getLong("org"), (Long)qpRpt.getAccountTable(), period.getDate("enddate"), Collections.singleton(row.getLong(account)));){
            for (Row dyRow : accSet) {
                SubsidiaryAccount account = new SubsidiaryAccount();
                account.setId(dyRow.getLong(account));
                account.setMasterid(dyRow.getLong("masterid"));
                account.setName(dyRow.getString("name"));
                account.setDc(dyRow.getInteger("dc"));
                account.setNumber(dyRow.getString("number"));
                acctMID2IDMap.put(account.getMasterid(), account);
            }
            param.getCustomParam().put("acctMID2IDMap", acctMID2IDMap);
        }
    }
}

