/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.nio.charset.StandardCharsets;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;

public class TipsUtils {
    public static String safeSuffix(String oriTip, String suffix) {
        if (StringUtils.isBlank((CharSequence)oriTip) || oriTip.endsWith(suffix)) {
            return oriTip;
        }
        return oriTip + suffix;
    }

    public static String safeTruncate(String msg, int maxLength, DBRoute dbRoute) {
        if (DB.getDBType((DBRoute)dbRoute) == DBType.Oracle) {
            return TipsUtils.truncateForOracle(msg, maxLength);
        }
        return TipsUtils.truncateForNormal(msg, maxLength);
    }

    private static String truncateForOracle(String input, int maxLength) {
        int i;
        char c;
        int lengthInBytes = 0;
        for (i = 0; lengthInBytes <= maxLength && i < input.length(); lengthInBytes += String.valueOf(c).getBytes(StandardCharsets.UTF_8).length, ++i) {
            c = input.charAt(i);
        }
        if (lengthInBytes > maxLength) {
            --i;
        }
        return input.substring(0, i);
    }

    private static String truncateForNormal(String input, int maxLength) {
        if (input.length() <= maxLength) {
            return input;
        }
        return input.substring(0, maxLength);
    }
}

